/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableCollection;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.CompressedIterators;
import org.apache.accumulo.core.clientImpl.DurabilityImpl;
import org.apache.accumulo.core.clientImpl.ScannerImpl;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.clientImpl.TabletType;
import org.apache.accumulo.core.clientImpl.Translator;
import org.apache.accumulo.core.clientImpl.Translators;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.AbstractId;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.InitialMultiScan;
import org.apache.accumulo.core.dataImpl.thrift.InitialScan;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.dataImpl.thrift.MapFileInfo;
import org.apache.accumulo.core.dataImpl.thrift.MultiScanResult;
import org.apache.accumulo.core.dataImpl.thrift.ScanResult;
import org.apache.accumulo.core.dataImpl.thrift.TCMResult;
import org.apache.accumulo.core.dataImpl.thrift.TCMStatus;
import org.apache.accumulo.core.dataImpl.thrift.TColumn;
import org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation;
import org.apache.accumulo.core.dataImpl.thrift.TConditionalSession;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TMutation;
import org.apache.accumulo.core.dataImpl.thrift.TRange;
import org.apache.accumulo.core.dataImpl.thrift.TRowRange;
import org.apache.accumulo.core.dataImpl.thrift.TSummaries;
import org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest;
import org.apache.accumulo.core.dataImpl.thrift.UpdateErrors;
import org.apache.accumulo.core.iterators.IterationInterruptedException;
import org.apache.accumulo.core.master.thrift.BulkImportState;
import org.apache.accumulo.core.master.thrift.Compacting;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletLoadState;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.replication.thrift.ReplicationServicer;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.spi.scan.ScanDispatcher;
import org.apache.accumulo.core.summary.Gatherer;
import org.apache.accumulo.core.summary.SummaryCollection;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction;
import org.apache.accumulo.core.tabletserver.thrift.ActiveScan;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.tabletserver.thrift.NoSuchScanIDException;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.tabletserver.thrift.TDurability;
import org.apache.accumulo.core.tabletserver.thrift.TSampleNotPresentException;
import org.apache.accumulo.core.tabletserver.thrift.TSamplerConfiguration;
import org.apache.accumulo.core.tabletserver.thrift.TUnloadTabletGoal;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.accumulo.core.util.ComparablePair;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.SimpleThreadPool;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.accumulo.core.util.ratelimit.SharedRateLimiterFactory;
import org.apache.accumulo.fate.util.LoggingRunnable;
import org.apache.accumulo.fate.util.Retry;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.AbstractServer;
import org.apache.accumulo.server.GarbageCollectionLogger;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.TabletLevel;
import org.apache.accumulo.server.client.ClientServiceHandler;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.data.ServerMutation;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.log.SortedLogState;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.server.master.recovery.RecoveryPath;
import org.apache.accumulo.server.master.state.Assignment;
import org.apache.accumulo.server.master.state.DistributedStoreException;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletStateStore;
import org.apache.accumulo.server.master.state.ZooTabletStateStore;
import org.apache.accumulo.server.master.tableOps.UserCompactionConfig;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.replication.ZooKeeperInitialization;
import org.apache.accumulo.server.rpc.ServerAddress;
import org.apache.accumulo.server.rpc.TCredentialsUpdatingWrapper;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.ThriftServerType;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.server.security.delegation.AuthenticationTokenSecretManager;
import org.apache.accumulo.server.security.delegation.ZooAuthenticationKeyWatcher;
import org.apache.accumulo.server.util.FileSystemMonitor;
import org.apache.accumulo.server.util.Halt;
import org.apache.accumulo.server.util.MasterMetadataUtil;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.util.ServerBulkImportStatus;
import org.apache.accumulo.server.util.time.RelativeTime;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.server.zookeeper.DistributedWorkQueue;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.start.classloader.vfs.ContextManager;
import org.apache.accumulo.tserver.BulkFailedCopyProcessor;
import org.apache.accumulo.tserver.BusiestTracker;
import org.apache.accumulo.tserver.ConditionCheckerContext;
import org.apache.accumulo.tserver.ConditionalMutationSet;
import org.apache.accumulo.tserver.HoldTimeoutException;
import org.apache.accumulo.tserver.MinorCompactionReason;
import org.apache.accumulo.tserver.OnlineTablets;
import org.apache.accumulo.tserver.RowLocks;
import org.apache.accumulo.tserver.TConstraintViolationException;
import org.apache.accumulo.tserver.TabletMutations;
import org.apache.accumulo.tserver.TabletServerResourceManager;
import org.apache.accumulo.tserver.TabletStatsKeeper;
import org.apache.accumulo.tserver.TooManyFilesException;
import org.apache.accumulo.tserver.TservConstraintEnv;
import org.apache.accumulo.tserver.WriteTracker;
import org.apache.accumulo.tserver.compaction.MajorCompactionReason;
import org.apache.accumulo.tserver.data.ServerConditionalMutation;
import org.apache.accumulo.tserver.log.DfsLogger;
import org.apache.accumulo.tserver.log.LogSorter;
import org.apache.accumulo.tserver.log.MutationReceiver;
import org.apache.accumulo.tserver.log.TabletServerLogger;
import org.apache.accumulo.tserver.mastermessage.MasterMessage;
import org.apache.accumulo.tserver.mastermessage.SplitReportMessage;
import org.apache.accumulo.tserver.mastermessage.TabletStatusMessage;
import org.apache.accumulo.tserver.metrics.TabletServerMetrics;
import org.apache.accumulo.tserver.metrics.TabletServerMinCMetrics;
import org.apache.accumulo.tserver.metrics.TabletServerScanMetrics;
import org.apache.accumulo.tserver.metrics.TabletServerUpdateMetrics;
import org.apache.accumulo.tserver.replication.ReplicationServicerHandler;
import org.apache.accumulo.tserver.replication.ReplicationWorker;
import org.apache.accumulo.tserver.scan.LookupTask;
import org.apache.accumulo.tserver.scan.NextBatchTask;
import org.apache.accumulo.tserver.scan.ScanRunState;
import org.apache.accumulo.tserver.session.ConditionalSession;
import org.apache.accumulo.tserver.session.MultiScanSession;
import org.apache.accumulo.tserver.session.Session;
import org.apache.accumulo.tserver.session.SessionManager;
import org.apache.accumulo.tserver.session.SingleScanSession;
import org.apache.accumulo.tserver.session.SummarySession;
import org.apache.accumulo.tserver.session.UpdateSession;
import org.apache.accumulo.tserver.tablet.BulkImportCacheCleaner;
import org.apache.accumulo.tserver.tablet.CommitSession;
import org.apache.accumulo.tserver.tablet.CompactionInfo;
import org.apache.accumulo.tserver.tablet.CompactionWatcher;
import org.apache.accumulo.tserver.tablet.Compactor;
import org.apache.accumulo.tserver.tablet.KVEntry;
import org.apache.accumulo.tserver.tablet.ScanBatch;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.accumulo.tserver.tablet.TabletClosedException;
import org.apache.accumulo.tserver.tablet.TabletData;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.thrift.server.TServer;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletServer
extends AbstractServer {
    private static final Logger log = LoggerFactory.getLogger(TabletServer.class);
    private static final long MAX_TIME_TO_WAIT_FOR_SCAN_RESULT_MILLIS = 1000L;
    private static final long RECENTLY_SPLIT_MILLIES = 60000L;
    private static final long TIME_BETWEEN_GC_CHECKS = 5000L;
    private static final long TIME_BETWEEN_LOCATOR_CACHE_CLEARS = 3600000L;
    private final GarbageCollectionLogger gcLogger = new GarbageCollectionLogger();
    private final TransactionWatcher watcher;
    private ZooCache masterLockCache;
    private final TabletServerLogger logger;
    private final TabletServerUpdateMetrics updateMetrics;
    private final TabletServerScanMetrics scanMetrics;
    private final TabletServerMinCMetrics mincMetrics;
    private final LogSorter logSorter;
    private ReplicationWorker replWorker = null;
    private final TabletStatsKeeper statsKeeper;
    private final AtomicInteger logIdGenerator = new AtomicInteger();
    private final AtomicLong flushCounter = new AtomicLong(0L);
    private final AtomicLong syncCounter = new AtomicLong(0L);
    private final VolumeManager fs;
    private final OnlineTablets onlineTablets = new OnlineTablets();
    private final SortedSet<KeyExtent> unopenedTablets = Collections.synchronizedSortedSet(new TreeSet());
    private final SortedSet<KeyExtent> openingTablets = Collections.synchronizedSortedSet(new TreeSet());
    private final Map<KeyExtent, Long> recentlyUnloadedCache = Collections.synchronizedMap(new LRUMap(1000));
    private final TabletServerResourceManager resourceManager;
    private final SecurityOperation security;
    private final BlockingDeque<MasterMessage> masterMessages = new LinkedBlockingDeque<MasterMessage>();
    private Thread majorCompactorThread;
    private HostAndPort clientAddress;
    private volatile boolean serverStopRequested = false;
    private volatile boolean shutdownComplete = false;
    private ZooLock tabletServerLock;
    private TServer server;
    private volatile TServer replServer;
    private DistributedWorkQueue bulkFailedCopyQ;
    private String lockID;
    public static final AtomicLong seekCount = new AtomicLong(0L);
    private final AtomicLong totalMinorCompactions = new AtomicLong(0L);
    private final ServerConfigurationFactory confFactory;
    private final ZooAuthenticationKeyWatcher authKeyWatcher;
    private final WalStateManager walMarker;
    private final SessionManager sessionManager;
    private final WriteTracker writeTracker = new WriteTracker();
    private final RowLocks rowLocks = new RowLocks();
    private final AtomicLong totalQueuedMutationSize = new AtomicLong(0L);
    private final ReentrantLock recoveryLock = new ReentrantLock(true);
    private ThriftClientHandler clientHandler;
    private final ServerBulkImportStatus bulkImportStatus = new ServerBulkImportStatus();
    final ConcurrentHashMap<DfsLogger, EnumSet<TabletLevel>> metadataTableLogs = new ConcurrentHashMap();
    LinkedHashSet<DfsLogger> closedLogs = new LinkedHashSet();
    private static final String MAJC_READ_LIMITER_KEY = "tserv_majc_read";
    private static final String MAJC_WRITE_LIMITER_KEY = "tserv_majc_write";
    private final SharedRateLimiterFactory.RateProvider rateProvider = () -> this.getConfiguration().getAsBytes(Property.TSERV_MAJC_THROUGHPUT);

    public TabletServerScanMetrics getScanMetrics() {
        return this.scanMetrics;
    }

    public TabletServerMinCMetrics getMinCMetrics() {
        return this.mincMetrics;
    }

    public static void main(String[] args) throws Exception {
        try (TabletServer tserver = new TabletServer(new ServerOpts(), args);){
            tserver.runServer();
        }
    }

    TabletServer(ServerOpts opts, String[] args) {
        super("tserver", opts, args);
        ServerContext context = super.getContext();
        context.setupCrypto();
        this.masterLockCache = new ZooCache((ZooReader)context.getZooReaderWriter(), null);
        this.watcher = new TransactionWatcher(context);
        this.confFactory = context.getServerConfFactory();
        this.fs = context.getVolumeManager();
        AccumuloConfiguration aconf = this.getConfiguration();
        log.info("Version 2.0.1");
        log.info("Instance " + this.getInstanceID());
        this.sessionManager = new SessionManager(aconf);
        this.logSorter = new LogSorter((ClientContext)context, this.fs, aconf);
        this.replWorker = new ReplicationWorker(context, this.fs);
        this.statsKeeper = new TabletStatsKeeper();
        final int numBusyTabletsToLog = aconf.getCount(Property.TSERV_LOG_BUSY_TABLETS_COUNT);
        long logBusyTabletsDelay = aconf.getTimeInMillis(Property.TSERV_LOG_BUSY_TABLETS_INTERVAL);
        if (numBusyTabletsToLog > 0) {
            SimpleTimer.getInstance((AccumuloConfiguration)aconf).schedule(new Runnable(){
                private BusiestTracker ingestTracker;
                private BusiestTracker queryTracker;
                {
                    this.ingestTracker = BusiestTracker.newBusiestIngestTracker(numBusyTabletsToLog);
                    this.queryTracker = BusiestTracker.newBusiestQueryTracker(numBusyTabletsToLog);
                }

                @Override
                public void run() {
                    ImmutableCollection tablets = TabletServer.this.onlineTablets.snapshot().values();
                    this.logBusyTablets(this.ingestTracker.computeBusiest((Collection<Tablet>)tablets), "ingest count");
                    this.logBusyTablets(this.queryTracker.computeBusiest((Collection<Tablet>)tablets), "query count");
                }

                private void logBusyTablets(List<ComparablePair<Long, KeyExtent>> busyTablets, String label) {
                    int i = 1;
                    for (Pair pair : busyTablets) {
                        log.debug("{} busiest tablet by {}: {} -- extent: {} ", new Object[]{i, label.toLowerCase(), pair.getFirst(), pair.getSecond()});
                        ++i;
                    }
                }
            }, logBusyTabletsDelay, logBusyTabletsDelay);
        }
        SimpleTimer.getInstance((AccumuloConfiguration)aconf).schedule(() -> {
            long now = System.currentTimeMillis();
            for (Tablet tablet : this.getOnlineTablets().values()) {
                try {
                    tablet.updateRates(now);
                }
                catch (Exception ex) {
                    log.error("Error updating rates for {}", (Object)tablet.getExtent(), (Object)ex);
                }
            }
        }, 5000L, 5000L);
        long walogMaxSize = aconf.getAsBytes(Property.TSERV_WALOG_MAX_SIZE);
        long walogMaxAge = aconf.getTimeInMillis(Property.TSERV_WALOG_MAX_AGE);
        long minBlockSize = context.getHadoopConf().getLong("dfs.namenode.fs-limits.min-block-size", 0L);
        if (minBlockSize != 0L && minBlockSize > walogMaxSize) {
            throw new RuntimeException("Unable to start TabletServer. Logger is set to use blocksize " + walogMaxSize + " but hdfs minimum block size is " + minBlockSize + ". Either increase the " + Property.TSERV_WALOG_MAX_SIZE + " or decrease dfs.namenode.fs-limits.min-block-size in hdfs-site.xml.");
        }
        long toleratedWalCreationFailures = aconf.getCount(Property.TSERV_WALOG_TOLERATED_CREATION_FAILURES);
        long walFailureRetryIncrement = aconf.getTimeInMillis(Property.TSERV_WALOG_TOLERATED_WAIT_INCREMENT);
        long walFailureRetryMax = aconf.getTimeInMillis(Property.TSERV_WALOG_TOLERATED_MAXIMUM_WAIT_DURATION);
        Retry.RetryFactory walCreationRetryFactory = Retry.builder().maxRetries(toleratedWalCreationFailures).retryAfter(walFailureRetryIncrement, TimeUnit.MILLISECONDS).incrementBy(walFailureRetryIncrement, TimeUnit.MILLISECONDS).maxWait(walFailureRetryMax, TimeUnit.MILLISECONDS).backOffFactor(1.5).logInterval(3L, TimeUnit.MINUTES).createFactory();
        Retry.RetryFactory walWritingRetryFactory = Retry.builder().infiniteRetries().retryAfter(walFailureRetryIncrement, TimeUnit.MILLISECONDS).incrementBy(walFailureRetryIncrement, TimeUnit.MILLISECONDS).maxWait(walFailureRetryMax, TimeUnit.MILLISECONDS).backOffFactor(1.5).logInterval(3L, TimeUnit.MINUTES).createFactory();
        this.logger = new TabletServerLogger(this, walogMaxSize, this.syncCounter, this.flushCounter, walCreationRetryFactory, walWritingRetryFactory, walogMaxAge);
        this.resourceManager = new TabletServerResourceManager(context);
        this.security = AuditedSecurityOperation.getInstance((ServerContext)context);
        this.updateMetrics = new TabletServerUpdateMetrics();
        this.scanMetrics = new TabletServerScanMetrics();
        this.mincMetrics = new TabletServerMinCMetrics();
        SimpleTimer.getInstance((AccumuloConfiguration)aconf).schedule(() -> TabletLocator.clearLocators(), TabletServer.jitter(3600000L), TabletServer.jitter(3600000L));
        this.walMarker = new WalStateManager(context);
        context.setSecretManager(new AuthenticationTokenSecretManager(context.getInstanceID(), aconf.getTimeInMillis(Property.GENERAL_DELEGATION_TOKEN_LIFETIME)));
        if (aconf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            log.info("SASL is enabled, creating ZooKeeper watcher for AuthenticationKeys");
            this.authKeyWatcher = new ZooAuthenticationKeyWatcher(context.getSecretManager(), (ZooReader)context.getZooReaderWriter(), context.getZooKeeperRoot() + "/delegation_token_keys");
        } else {
            this.authKeyWatcher = null;
        }
        this.config();
    }

    public String getInstanceID() {
        return this.getContext().getInstanceID();
    }

    public String getVersion() {
        return "2.0.1";
    }

    private static long jitter(long ms) {
        SecureRandom r = new SecureRandom();
        return (long)((1.0 + r.nextDouble() / 10.0) * (double)ms);
    }

    public long updateTotalQueuedMutationSize(long additionalMutationSize) {
        return this.totalQueuedMutationSize.addAndGet(additionalMutationSize);
    }

    public Session getSession(long sessionId) {
        return this.sessionManager.getSession(sessionId);
    }

    public void executeSplit(Tablet tablet) {
        this.resourceManager.executeSplit(tablet.getExtent(), (Runnable)new LoggingRunnable(log, (Runnable)new SplitRunner(tablet)));
    }

    private void splitTablet(Tablet tablet) {
        try {
            TreeMap<KeyExtent, TabletData> tabletInfo = this.splitTablet(tablet, null);
            if (tabletInfo == null) {
                tablet.initiateMajorCompaction(MajorCompactionReason.NORMAL);
            }
        }
        catch (IOException e) {
            this.statsKeeper.updateTime(TabletStatsKeeper.Operation.SPLIT, 0L, true);
            log.error("split failed: {} for tablet {}", new Object[]{e.getMessage(), tablet.getExtent(), e});
        }
        catch (Exception e) {
            this.statsKeeper.updateTime(TabletStatsKeeper.Operation.SPLIT, 0L, true);
            log.error("Unknown error on split:", (Throwable)e);
        }
    }

    private TreeMap<KeyExtent, TabletData> splitTablet(Tablet tablet, byte[] splitPoint) throws IOException {
        long t1 = System.currentTimeMillis();
        TreeMap<KeyExtent, TabletData> tabletInfo = tablet.split(splitPoint);
        if (tabletInfo == null) {
            return null;
        }
        log.info("Starting split: {}", (Object)tablet.getExtent());
        this.statsKeeper.incrementStatusSplit();
        long start = System.currentTimeMillis();
        Tablet[] newTablets = new Tablet[2];
        Map.Entry<KeyExtent, TabletData> first = tabletInfo.firstEntry();
        TabletServerResourceManager.TabletResourceManager newTrm0 = this.resourceManager.createTabletResourceManager(first.getKey(), (AccumuloConfiguration)this.getTableConfiguration(first.getKey()));
        newTablets[0] = new Tablet(this, first.getKey(), newTrm0, first.getValue());
        Map.Entry<KeyExtent, TabletData> last = tabletInfo.lastEntry();
        TabletServerResourceManager.TabletResourceManager newTrm1 = this.resourceManager.createTabletResourceManager(last.getKey(), (AccumuloConfiguration)this.getTableConfiguration(last.getKey()));
        newTablets[1] = new Tablet(this, last.getKey(), newTrm1, last.getValue());
        this.statsKeeper.saveMajorMinorTimes(tablet.getTabletStats());
        this.onlineTablets.split(tablet.getExtent(), newTablets[0], newTablets[1]);
        this.enqueueMasterMessage(new SplitReportMessage(tablet.getExtent(), newTablets[0].getExtent(), new Text("/" + newTablets[0].getLocation().getName()), newTablets[1].getExtent(), new Text("/" + newTablets[1].getLocation().getName())));
        this.statsKeeper.updateTime(TabletStatsKeeper.Operation.SPLIT, start, false);
        long t2 = System.currentTimeMillis();
        log.info("Tablet split: {} size0 {} size1 {} time {}ms", new Object[]{tablet.getExtent(), newTablets[0].estimateTabletSize(), newTablets[1].estimateTabletSize(), t2 - t1});
        return tabletInfo;
    }

    public void enqueueMasterMessage(MasterMessage m) {
        this.masterMessages.addLast(m);
    }

    private void acquireRecoveryMemory(KeyExtent extent) {
        if (!extent.isMeta()) {
            this.recoveryLock.lock();
        }
    }

    private void releaseRecoveryMemory(KeyExtent extent) {
        if (!extent.isMeta()) {
            this.recoveryLock.unlock();
        }
    }

    private HostAndPort startServer(AccumuloConfiguration conf, String address, Property portHint, TProcessor processor, String threadName) throws UnknownHostException {
        Property maxMessageSizeProperty = conf.get(Property.TSERV_MAX_MESSAGE_SIZE) != null ? Property.TSERV_MAX_MESSAGE_SIZE : Property.GENERAL_MAX_MESSAGE_SIZE;
        ServerAddress sp = TServerUtils.startServer((MetricsSystem)this.getMetricsSystem(), (ServerContext)this.getContext(), (String)address, (Property)portHint, (TProcessor)processor, (String)((Object)((Object)this)).getClass().getSimpleName(), (String)threadName, (Property)Property.TSERV_PORTSEARCH, (Property)Property.TSERV_MINTHREADS, (Property)Property.TSERV_THREADCHECK, (Property)maxMessageSizeProperty);
        this.server = sp.server;
        return sp.address;
    }

    private HostAndPort getMasterAddress() {
        try {
            List locations = this.getContext().getMasterLocations();
            if (locations.size() == 0) {
                return null;
            }
            return HostAndPort.fromString((String)((String)locations.get(0)));
        }
        catch (Exception e) {
            log.warn("Failed to obtain master host " + e);
            return null;
        }
    }

    private MasterClientService.Client masterConnection(HostAndPort address) {
        try {
            if (address == null) {
                return null;
            }
            return (MasterClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new MasterClientService.Client.Factory(), (HostAndPort)address, (ClientContext)this.getContext());
        }
        catch (Exception e) {
            log.warn("Issue with masterConnection (" + address + ") " + e, (Throwable)e);
            return null;
        }
    }

    private void returnMasterConnection(MasterClientService.Client client) {
        ThriftUtil.returnClient((TServiceClient)client);
    }

    private HostAndPort startTabletClientService() throws UnknownHostException {
        TabletClientService.Processor processor;
        this.clientHandler = new ThriftClientHandler();
        TabletClientService.Iface rpcProxy = (TabletClientService.Iface)TraceUtil.wrapService((Object)((Object)this.clientHandler));
        if (this.getContext().getThriftServerType() == ThriftServerType.SASL) {
            TabletClientService.Iface tcredProxy = (TabletClientService.Iface)TCredentialsUpdatingWrapper.service((Object)rpcProxy, ThriftClientHandler.class, (AccumuloConfiguration)this.getConfiguration());
            processor = new TabletClientService.Processor(tcredProxy);
        } else {
            processor = new TabletClientService.Processor(rpcProxy);
        }
        HostAndPort address = this.startServer(this.getConfiguration(), this.clientAddress.getHost(), Property.TSERV_CLIENTPORT, (TProcessor)processor, "Thrift Client Server");
        log.info("address = {}", (Object)address);
        return address;
    }

    private void startReplicationService() throws UnknownHostException {
        ReplicationServicerHandler handler = new ReplicationServicerHandler(this);
        ReplicationServicer.Iface rpcProxy = (ReplicationServicer.Iface)TraceUtil.wrapService((Object)handler);
        ReplicationServicer.Iface repl = (ReplicationServicer.Iface)TCredentialsUpdatingWrapper.service((Object)rpcProxy, handler.getClass(), (AccumuloConfiguration)this.getConfiguration());
        ReplicationServicer.Processor processor = new ReplicationServicer.Processor(repl);
        Property maxMessageSizeProperty = this.getConfiguration().get(Property.TSERV_MAX_MESSAGE_SIZE) != null ? Property.TSERV_MAX_MESSAGE_SIZE : Property.GENERAL_MAX_MESSAGE_SIZE;
        ServerAddress sp = TServerUtils.startServer((MetricsSystem)this.getMetricsSystem(), (ServerContext)this.getContext(), (String)this.clientAddress.getHost(), (Property)Property.REPLICATION_RECEIPT_SERVICE_PORT, (TProcessor)processor, (String)"ReplicationServicerHandler", (String)"Replication Servicer", (Property)Property.TSERV_PORTSEARCH, (Property)Property.REPLICATION_MIN_THREADS, (Property)Property.REPLICATION_THREADCHECK, (Property)maxMessageSizeProperty);
        this.replServer = sp.server;
        log.info("Started replication service on {}", (Object)sp.address);
        try {
            this.getContext().getZooReaderWriter().putPersistentData(this.getContext().getZooKeeperRoot() + "/replication/tservers" + "/" + this.clientAddress, sp.address.toString().getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
        }
        catch (Exception e) {
            log.error("Could not advertise replication service port", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ZooLock getLock() {
        return this.tabletServerLock;
    }

    private void announceExistence() {
        ZooReaderWriter zoo = this.getContext().getZooReaderWriter();
        try {
            String zPath = this.getContext().getZooKeeperRoot() + "/tservers" + "/" + this.getClientAddressString();
            try {
                zoo.putPersistentData(zPath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NOAUTH) {
                    log.error("Failed to write to ZooKeeper. Ensure that accumulo.properties, specifically instance.secret, is consistent.");
                }
                throw e;
            }
            this.tabletServerLock = new ZooLock(zoo, zPath);
            ZooLock.LockWatcher lw = new ZooLock.LockWatcher(){

                public void lostLock(ZooLock.LockLossReason reason) {
                    Halt.halt((int)(TabletServer.this.serverStopRequested ? 0 : 1), () -> {
                        if (!TabletServer.this.serverStopRequested) {
                            log.error("Lost tablet server lock (reason = {}), exiting.", (Object)reason);
                        }
                        TabletServer.this.gcLogger.logGCInfo(TabletServer.this.getConfiguration());
                    });
                }

                public void unableToMonitorLockNode(Throwable e) {
                    Halt.halt((int)1, () -> log.error("Lost ability to monitor tablet server lock, exiting.", e));
                }
            };
            byte[] lockContent = new ServerServices(this.getClientAddressString(), ServerServices.Service.TSERV_CLIENT).toString().getBytes(StandardCharsets.UTF_8);
            for (int i = 0; i < 24; ++i) {
                zoo.putPersistentData(zPath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
                if (this.tabletServerLock.tryLock(lw, lockContent)) {
                    log.debug("Obtained tablet server lock {}", (Object)this.tabletServerLock.getLockPath());
                    this.lockID = this.tabletServerLock.getLockID().serialize(this.getContext().getZooKeeperRoot() + "/tservers" + "/");
                    return;
                }
                log.info("Waiting for tablet server lock");
                UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
            String msg = "Too many retries, exiting.";
            log.info(msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.info("Could not obtain tablet server lock, exiting.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SecurityUtil.serverLogin((AccumuloConfiguration)this.getConfiguration());
        try {
            ZooKeeperInitialization.ensureZooKeeperInitialized((ZooReaderWriter)this.getContext().getZooReaderWriter(), (String)this.getContext().getZooKeeperRoot());
        }
        catch (InterruptedException | KeeperException e) {
            log.error("Could not ensure that ZooKeeper is properly initialized", e);
            throw new RuntimeException(e);
        }
        try {
            MetricsSystem metricsSystem = this.getMetricsSystem();
            new TabletServerMetrics(this).register(metricsSystem);
            this.mincMetrics.register(metricsSystem);
            this.scanMetrics.register(metricsSystem);
            this.updateMetrics.register(metricsSystem);
        }
        catch (Exception e) {
            log.error("Error registering metrics", (Throwable)e);
        }
        if (this.authKeyWatcher != null) {
            log.info("Seeding ZooKeeper watcher for authentication keys");
            try {
                this.authKeyWatcher.updateAuthKeys();
            }
            catch (InterruptedException | KeeperException e) {
                log.error("Failed to perform initial check for authentication tokens in ZooKeeper. Delegation token authentication will be unavailable.", e);
            }
        }
        try {
            this.clientAddress = this.startTabletClientService();
        }
        catch (UnknownHostException e1) {
            throw new RuntimeException("Failed to start the tablet client service", e1);
        }
        this.announceExistence();
        try {
            this.walMarker.initWalMarker(this.getTabletSession());
        }
        catch (Exception e) {
            log.error("Unable to create WAL marker node in zookeeper", (Throwable)e);
            throw new RuntimeException(e);
        }
        SimpleThreadPool distWorkQThreadPool = new SimpleThreadPool(this.getConfiguration().getCount(Property.TSERV_WORKQ_THREADS), "distributed work queue");
        this.bulkFailedCopyQ = new DistributedWorkQueue(this.getContext().getZooKeeperRoot() + "/bulk_failed_copyq", this.getConfiguration());
        try {
            this.bulkFailedCopyQ.startProcessing((DistributedWorkQueue.Processor)new BulkFailedCopyProcessor(this.getContext()), (ThreadPoolExecutor)distWorkQThreadPool);
        }
        catch (Exception e1) {
            throw new RuntimeException("Failed to start distributed work queue for copying ", e1);
        }
        try {
            this.logSorter.startWatchingForRecoveryLogs((ThreadPoolExecutor)distWorkQThreadPool);
        }
        catch (Exception ex) {
            log.error("Error setting watches for recoveries");
            throw new RuntimeException(ex);
        }
        AccumuloConfiguration aconf = this.getConfiguration();
        SimpleTimer.getInstance((AccumuloConfiguration)aconf).schedule(() -> {
            if (this.replServer == null && !this.getConfiguration().get(Property.REPLICATION_NAME).isEmpty()) {
                log.info(Property.REPLICATION_NAME.getKey() + " was set, starting repl services.");
                this.setupReplication(aconf);
            }
        }, 0L, 5000L);
        long CLEANUP_BULK_LOADED_CACHE_MILLIS = 900000L;
        SimpleTimer.getInstance((AccumuloConfiguration)aconf).schedule((Runnable)new BulkImportCacheCleaner(this), 900000L, 900000L);
        while (!this.serverStopRequested) {
            try {
                MasterClientService.Client iface;
                block36: {
                    MasterMessage mm = null;
                    iface = null;
                    try {
                        while (mm == null && !this.serverStopRequested) {
                            mm = this.masterMessages.poll(1000L, TimeUnit.MILLISECONDS);
                        }
                        HostAndPort masterHost = this.getMasterAddress();
                        MasterClientService.Client client = iface = this.masterConnection(masterHost);
                        while (!this.serverStopRequested && mm != null && client != null && client.getOutputProtocol() != null && client.getOutputProtocol().getTransport() != null && client.getOutputProtocol().getTransport().isOpen()) {
                            try {
                                mm.send(this.getContext().rpcCreds(), this.getClientAddressString(), (MasterClientService.Iface)iface);
                                mm = null;
                            }
                            catch (TException ex) {
                                log.warn("Error sending message: queuing message again");
                                this.masterMessages.putFirst(mm);
                                mm = null;
                                throw ex;
                            }
                            mm = this.masterMessages.poll();
                        }
                        if (mm == null) break block36;
                    }
                    catch (Throwable throwable) {
                        if (mm != null) {
                            this.masterMessages.putFirst(mm);
                        }
                        this.returnMasterConnection(iface);
                        UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                        throw throwable;
                    }
                    this.masterMessages.putFirst(mm);
                }
                this.returnMasterConnection(iface);
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.info("Interrupt Exception received, shutting down");
                this.serverStopRequested = true;
            }
            catch (Exception e) {
                log.error(this.getClientAddressString() + ": TServerInfo: Exception. Master down?", (Throwable)e);
            }
        }
        TabletServer e = this;
        synchronized (e) {
            while (!this.shutdownComplete) {
                try {
                    ((Object)((Object)this)).wait(1000L);
                }
                catch (InterruptedException e2) {
                    log.error(e2.toString());
                }
            }
        }
        log.debug("Stopping Replication Server");
        TServerUtils.stopTServer((TServer)this.replServer);
        log.debug("Stopping Thrift Servers");
        TServerUtils.stopTServer((TServer)this.server);
        try {
            log.debug("Closing filesystem");
            this.fs.close();
        }
        catch (IOException e2) {
            log.warn("Failed to close filesystem : {}", (Object)e2.getMessage(), (Object)e2);
        }
        this.gcLogger.logGCInfo(this.getConfiguration());
        log.info("TServerInfo: stop requested. exiting ... ");
        try {
            this.tabletServerLock.unlock();
        }
        catch (Exception e3) {
            log.warn("Failed to release tablet server lock", (Throwable)e3);
        }
    }

    private void setupReplication(AccumuloConfiguration aconf) {
        try {
            this.startReplicationService();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to start replication service", e);
        }
        SimpleThreadPool replicationThreadPool = new SimpleThreadPool(this.getConfiguration().getCount(Property.REPLICATION_WORKER_THREADS), "replication task");
        this.replWorker.setExecutor((ThreadPoolExecutor)replicationThreadPool);
        this.replWorker.run();
        Runnable replicationWorkThreadPoolResizer = () -> TabletServer.lambda$setupReplication$3(aconf, (ThreadPoolExecutor)replicationThreadPool);
        SimpleTimer.getInstance((AccumuloConfiguration)aconf).schedule(replicationWorkThreadPoolResizer, 10000L, 30000L);
    }

    private static Pair<Text, KeyExtent> verifyRootTablet(ServerContext context, TServerInstance instance) throws AccumuloException {
        ZooTabletStateStore store = new ZooTabletStateStore(context);
        if (!store.iterator().hasNext()) {
            throw new AccumuloException("Illegal state: location is not set in zookeeper");
        }
        TabletLocationState next = (TabletLocationState)store.iterator().next();
        if (!instance.equals((Object)next.future)) {
            throw new AccumuloException("Future location is not to this server for the root tablet");
        }
        if (next.current != null) {
            throw new AccumuloException("Root tablet already has a location set");
        }
        try {
            return new Pair((Object)new Text(MetadataTableUtil.getRootTabletDir((ServerContext)context)), null);
        }
        catch (IOException e) {
            throw new AccumuloException((Throwable)e);
        }
    }

    public static Pair<Text, KeyExtent> verifyTabletInformation(ServerContext context, KeyExtent extent, TServerInstance instance, SortedMap<Key, Value> tabletsKeyValues, String clientAddress, ZooLock lock) throws DistributedStoreException, AccumuloException {
        Objects.requireNonNull(tabletsKeyValues);
        log.debug("verifying extent {}", (Object)extent);
        if (extent.isRootTablet()) {
            return TabletServer.verifyRootTablet(context, instance);
        }
        TableId tableToVerify = MetadataTable.ID;
        if (extent.isMeta()) {
            tableToVerify = RootTable.ID;
        }
        List<ColumnFQ> columnsToFetch = Arrays.asList(MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN, MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN, MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN, MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN, MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN);
        TreeMap<Key, Value> tkv = new TreeMap<Key, Value>();
        try (ScannerImpl scanner = new ScannerImpl((ClientContext)context, tableToVerify, Authorizations.EMPTY);){
            scanner.setRange(extent.toMetadataRange());
            for (Map.Entry entry : scanner) {
                tkv.put((Key)entry.getKey(), (Value)entry.getValue());
            }
        }
        tabletsKeyValues.clear();
        tabletsKeyValues.putAll(tkv);
        Text metadataEntry = extent.getMetadataEntry();
        Value dir = TabletServer.checkTabletMetadata(extent, instance, tabletsKeyValues, metadataEntry);
        if (dir == null) {
            return null;
        }
        Value oldPrevEndRow = null;
        for (Map.Entry<Key, Value> entry : tabletsKeyValues.entrySet()) {
            if (!MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN.hasColumns(entry.getKey())) continue;
            oldPrevEndRow = entry.getValue();
        }
        if (oldPrevEndRow != null) {
            SortedMap tabletEntries = MetadataTableUtil.getTabletEntries(tabletsKeyValues, columnsToFetch);
            KeyExtent fke = MasterMetadataUtil.fixSplit((ServerContext)context, (Text)metadataEntry, (SortedMap)((SortedMap)tabletEntries.get(metadataEntry)), (ZooLock)lock);
            if (!fke.equals((Object)extent)) {
                return new Pair(null, (Object)fke);
            }
            tabletsKeyValues.clear();
            return TabletServer.verifyTabletInformation(context, fke, instance, tabletsKeyValues, clientAddress, lock);
        }
        return new Pair((Object)new Text(dir.get()), null);
    }

    static Value checkTabletMetadata(KeyExtent extent, TServerInstance instance, SortedMap<Key, Value> tabletsKeyValues, Text metadataEntry) throws AccumuloException {
        TServerInstance future = null;
        Value prevEndRow = null;
        Value dir = null;
        Value time = null;
        for (Map.Entry<Key, Value> entry : tabletsKeyValues.entrySet()) {
            Key key = entry.getKey();
            if (!metadataEntry.equals((Object)key.getRow())) {
                log.info("Unexpected row in tablet metadata {} {}", (Object)metadataEntry, (Object)key.getRow());
                return null;
            }
            Text cf = key.getColumnFamily();
            if (cf.equals((Object)MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME)) {
                if (future != null) {
                    throw new AccumuloException("Tablet has multiple future locations " + extent);
                }
                future = new TServerInstance(entry.getValue(), key.getColumnQualifier());
                continue;
            }
            if (cf.equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME)) {
                log.info("Tablet seems to be already assigned to {}", (Object)new TServerInstance(entry.getValue(), key.getColumnQualifier()));
                return null;
            }
            if (MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(key)) {
                prevEndRow = entry.getValue();
                continue;
            }
            if (MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.hasColumns(key)) {
                dir = entry.getValue();
                continue;
            }
            if (!MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.hasColumns(key)) continue;
            time = entry.getValue();
        }
        if (prevEndRow == null) {
            throw new AccumuloException("Metadata entry does not have prev row (" + metadataEntry + ")");
        }
        KeyExtent ke2 = new KeyExtent(metadataEntry, prevEndRow);
        if (!extent.equals((Object)ke2)) {
            log.info("Tablet prev end row mismatch {} {}", (Object)extent, (Object)ke2.getPrevEndRow());
            return null;
        }
        if (dir == null) {
            throw new AccumuloException("Metadata entry does not have directory (" + metadataEntry + ")");
        }
        if (time == null && !extent.equals((Object)RootTable.OLD_EXTENT)) {
            throw new AccumuloException("Metadata entry does not have time (" + metadataEntry + ")");
        }
        if (future == null) {
            log.info("The master has not assigned {} to {}", (Object)extent, (Object)instance);
            return null;
        }
        if (!instance.equals(future)) {
            log.info("Table {} has been assigned to {} which is not {}", new Object[]{extent, future, instance});
            return null;
        }
        return dir;
    }

    public String getClientAddressString() {
        if (this.clientAddress == null) {
            return null;
        }
        return this.clientAddress.getHost() + ":" + this.clientAddress.getPort();
    }

    public TServerInstance getTabletSession() {
        String address = this.getClientAddressString();
        if (address == null) {
            return null;
        }
        try {
            return new TServerInstance(address, this.tabletServerLock.getSessionId());
        }
        catch (Exception ex) {
            log.warn("Unable to read session from tablet server lock" + ex);
            return null;
        }
    }

    private void config() {
        log.info("Tablet server starting on {}", (Object)this.getHostname());
        this.majorCompactorThread = new Daemon((Runnable)new LoggingRunnable(log, (Runnable)new MajorCompactor(this.getConfiguration())));
        this.majorCompactorThread.setName("Split/MajC initiator");
        this.majorCompactorThread.start();
        this.clientAddress = HostAndPort.fromParts((String)this.getHostname(), (int)0);
        try {
            AccumuloVFSClassLoader.getContextManager().setContextConfig((ContextManager.ContextsConfig)new ContextManager.DefaultContextsConfig(){

                public Map<String, String> getVfsContextClasspathProperties() {
                    return TabletServer.this.getConfiguration().getAllPropertiesWithPrefix(Property.VFS_CONTEXT_CLASSPATH_PROPERTY);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Runnable contextCleaner = () -> {
            Set contextProperties = this.getConfiguration().getAllPropertiesWithPrefix(Property.VFS_CONTEXT_CLASSPATH_PROPERTY).keySet();
            HashSet<String> configuredContexts = new HashSet<String>();
            for (String prop : contextProperties) {
                configuredContexts.add(prop.substring(Property.VFS_CONTEXT_CLASSPATH_PROPERTY.name().length()));
            }
            try {
                AccumuloVFSClassLoader.getContextManager().removeUnusedContexts(configuredContexts);
            }
            catch (IOException e) {
                log.warn("{}", (Object)e.getMessage(), (Object)e);
            }
        };
        AccumuloConfiguration aconf = this.getConfiguration();
        SimpleTimer.getInstance((AccumuloConfiguration)aconf).schedule(contextCleaner, 60000L, 60000L);
        FileSystemMonitor.start((AccumuloConfiguration)aconf, (Property)Property.TSERV_MONITOR_FS);
        Runnable gcDebugTask = () -> this.gcLogger.logGCInfo(this.getConfiguration());
        SimpleTimer.getInstance((AccumuloConfiguration)aconf).schedule(gcDebugTask, 0L, 5000L);
        Runnable constraintTask = () -> {
            for (Tablet tablet : this.getOnlineTablets().values()) {
                tablet.checkConstraints();
            }
        };
        SimpleTimer.getInstance((AccumuloConfiguration)aconf).schedule(constraintTask, 0L, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabletServerStatus getStats(Map<TableId, MapCounter<ScanRunState>> scanCounts) {
        long start = System.currentTimeMillis();
        TabletServerStatus result = new TabletServerStatus();
        HashMap<String, TableInfo> tables = new HashMap<String, TableInfo>();
        this.getOnlineTablets().forEach((ke, tablet) -> {
            String tableId = ke.getTableId().canonical();
            TableInfo table = (TableInfo)tables.get(tableId);
            if (table == null) {
                table = new TableInfo();
                table.minors = new Compacting();
                table.majors = new Compacting();
                tables.put(tableId, table);
            }
            long recs = tablet.getNumEntries();
            ++table.tablets;
            ++table.onlineTablets;
            table.recs += recs;
            table.queryRate += tablet.queryRate();
            table.queryByteRate += tablet.queryByteRate();
            table.ingestRate += tablet.ingestRate();
            table.ingestByteRate += tablet.ingestByteRate();
            table.scanRate += tablet.scanRate();
            long recsInMemory = tablet.getNumEntriesInMemory();
            table.recsInMemory += recsInMemory;
            if (tablet.isMinorCompactionRunning()) {
                ++table.minors.running;
            }
            if (tablet.isMinorCompactionQueued()) {
                ++table.minors.queued;
            }
            if (tablet.isMajorCompactionRunning()) {
                ++table.majors.running;
            }
            if (tablet.isMajorCompactionQueued()) {
                ++table.majors.queued;
            }
        });
        scanCounts.forEach((tableId, mapCounter) -> {
            TableInfo table = (TableInfo)tables.get(tableId.canonical());
            if (table == null) {
                table = new TableInfo();
                tables.put(tableId.canonical(), table);
            }
            if (table.scans == null) {
                table.scans = new Compacting();
            }
            table.scans.queued += mapCounter.getInt((Object)ScanRunState.QUEUED);
            table.scans.running += mapCounter.getInt((Object)ScanRunState.RUNNING);
        });
        ArrayList<KeyExtent> offlineTabletsCopy = new ArrayList<KeyExtent>();
        SortedSet<KeyExtent> sortedSet = this.unopenedTablets;
        synchronized (sortedSet) {
            SortedSet<KeyExtent> sortedSet2 = this.openingTablets;
            synchronized (sortedSet2) {
                offlineTabletsCopy.addAll(this.unopenedTablets);
                offlineTabletsCopy.addAll(this.openingTablets);
            }
        }
        for (KeyExtent extent : offlineTabletsCopy) {
            String tableId2 = extent.getTableId().canonical();
            TableInfo table = (TableInfo)tables.get(tableId2);
            if (table == null) {
                table = new TableInfo();
                tables.put(tableId2, table);
            }
            ++table.tablets;
        }
        result.lastContact = RelativeTime.currentTimeMillis();
        result.tableMap = tables;
        result.osLoad = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
        result.name = this.getClientAddressString();
        result.holdTime = this.resourceManager.holdTime();
        result.lookups = seekCount.get();
        result.indexCacheHits = this.resourceManager.getIndexCache().getStats().hitCount();
        result.indexCacheRequest = this.resourceManager.getIndexCache().getStats().requestCount();
        result.dataCacheHits = this.resourceManager.getDataCache().getStats().hitCount();
        result.dataCacheRequest = this.resourceManager.getDataCache().getStats().requestCount();
        result.logSorts = this.logSorter.getLogSorts();
        result.flushs = this.flushCounter.get();
        result.syncs = this.syncCounter.get();
        result.bulkImports = new ArrayList();
        result.bulkImports.addAll(this.clientHandler.getBulkLoadStatus());
        result.bulkImports.addAll(this.bulkImportStatus.getBulkLoadStatus());
        result.version = this.getVersion();
        result.responseTime = System.currentTimeMillis() - start;
        return result;
    }

    private Durability getMincEventDurability(KeyExtent extent) {
        TableConfiguration conf = extent.isMeta() ? this.confFactory.getTableConfiguration(RootTable.ID) : this.confFactory.getTableConfiguration(MetadataTable.ID);
        return DurabilityImpl.fromString((String)conf.get(Property.TABLE_DURABILITY));
    }

    public void minorCompactionFinished(CommitSession tablet, long walogSeq) throws IOException {
        Durability durability = this.getMincEventDurability(tablet.getExtent());
        this.totalMinorCompactions.incrementAndGet();
        this.logger.minorCompactionFinished(tablet, walogSeq, durability);
        this.markUnusedWALs();
    }

    public void minorCompactionStarted(CommitSession tablet, long lastUpdateSequence, String newMapfileLocation) throws IOException {
        Durability durability = this.getMincEventDurability(tablet.getExtent());
        this.logger.minorCompactionStarted(tablet, lastUpdateSequence, newMapfileLocation, durability);
    }

    public void recover(VolumeManager fs, KeyExtent extent, List<LogEntry> logEntries, Set<String> tabletFiles, MutationReceiver mutationReceiver) throws IOException {
        ArrayList<Path> recoveryLogs = new ArrayList<Path>();
        ArrayList<LogEntry> sorted = new ArrayList<LogEntry>(logEntries);
        Collections.sort(sorted, (e1, e2) -> (int)(e1.timestamp - e2.timestamp));
        for (LogEntry entry : sorted) {
            Path recovery = null;
            Path finished = RecoveryPath.getRecoveryPath((Path)fs.getFullPath(VolumeManager.FileType.WAL, entry.filename));
            finished = SortedLogState.getFinishedMarkerPath((Path)finished);
            log.debug("Looking for " + finished);
            if (fs.exists(finished)) {
                recovery = finished.getParent();
            }
            if (recovery == null) {
                throw new IOException("Unable to find recovery files for extent " + extent + " logEntry: " + entry);
            }
            recoveryLogs.add(recovery);
        }
        this.logger.recover(fs, extent, recoveryLogs, tabletFiles, mutationReceiver);
    }

    public int createLogId() {
        int logId = this.logIdGenerator.incrementAndGet();
        if (logId < 0) {
            throw new IllegalStateException("Log Id rolled");
        }
        return logId;
    }

    public TableConfiguration getTableConfiguration(KeyExtent extent) {
        return this.confFactory.getTableConfiguration(extent.getTableId());
    }

    public DfsLogger.ServerResources getServerConfig() {
        return new DfsLogger.ServerResources(){

            @Override
            public VolumeManager getFileSystem() {
                return TabletServer.this.fs;
            }

            @Override
            public AccumuloConfiguration getConfiguration() {
                return TabletServer.this.getConfiguration();
            }
        };
    }

    public SortedMap<KeyExtent, Tablet> getOnlineTablets() {
        return this.onlineTablets.snapshot();
    }

    public Tablet getOnlineTablet(KeyExtent extent) {
        return (Tablet)this.onlineTablets.snapshot().get((Object)extent);
    }

    public VolumeManager getFileSystem() {
        return this.fs;
    }

    public int getOpeningCount() {
        return this.openingTablets.size();
    }

    public int getUnopenedCount() {
        return this.unopenedTablets.size();
    }

    public long getTotalMinorCompactions() {
        return this.totalMinorCompactions.get();
    }

    public double getHoldTimeMillis() {
        return this.resourceManager.holdTime();
    }

    public SecurityOperation getSecurityOperation() {
        return this.security;
    }

    @VisibleForTesting
    static Set<DfsLogger> findOldestUnreferencedWals(List<DfsLogger> closedLogs, ReferencedRemover referencedRemover) {
        DfsLogger unref;
        DfsLogger closed;
        LinkedHashSet<DfsLogger> unreferenced = new LinkedHashSet<DfsLogger>(closedLogs);
        referencedRemover.removeInUse(unreferenced);
        Iterator<DfsLogger> closedIter = closedLogs.iterator();
        Iterator unrefIter = unreferenced.iterator();
        HashSet<DfsLogger> eligible = new HashSet<DfsLogger>();
        while (closedIter.hasNext() && unrefIter.hasNext() && (closed = closedIter.next()).equals(unref = (DfsLogger)unrefIter.next())) {
            eligible.add(unref);
        }
        return eligible;
    }

    @VisibleForTesting
    static List<DfsLogger> copyClosedLogs(LinkedHashSet<DfsLogger> closedLogs) {
        ArrayList<DfsLogger> closedCopy = new ArrayList<DfsLogger>(closedLogs.size());
        for (DfsLogger dfsLogger : closedLogs) {
            closedCopy.add(dfsLogger);
        }
        return Collections.unmodifiableList(closedCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markUnusedWALs() {
        List<DfsLogger> closedCopy;
        LinkedHashSet<DfsLogger> linkedHashSet = this.closedLogs;
        synchronized (linkedHashSet) {
            closedCopy = TabletServer.copyClosedLogs(this.closedLogs);
        }
        ReferencedRemover refRemover = candidates -> {
            for (Tablet tablet : this.getOnlineTablets().values()) {
                tablet.removeInUseLogs(candidates);
                if (!candidates.isEmpty()) continue;
                break;
            }
        };
        Set<DfsLogger> eligible = TabletServer.findOldestUnreferencedWals(closedCopy, refRemover);
        try {
            TServerInstance session = this.getTabletSession();
            for (DfsLogger candidate : eligible) {
                log.info("Marking " + candidate.getPath() + " as unreferenced");
                this.walMarker.walUnreferenced(session, candidate.getPath());
            }
            LinkedHashSet<DfsLogger> linkedHashSet2 = this.closedLogs;
            synchronized (linkedHashSet2) {
                this.closedLogs.removeAll(eligible);
            }
        }
        catch (WalStateManager.WalMarkerException ex) {
            log.info(ex.toString(), (Throwable)ex);
        }
    }

    public void addNewLogMarker(DfsLogger copy) throws WalStateManager.WalMarkerException {
        log.info("Writing log marker for " + copy.getPath());
        this.walMarker.addNewWalMarker(this.getTabletSession(), copy.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void walogClosed(DfsLogger currentLog) throws WalStateManager.WalMarkerException {
        this.metadataTableLogs.remove(currentLog);
        if (currentLog.getWrites() > 0L) {
            int clSize;
            LinkedHashSet<DfsLogger> linkedHashSet = this.closedLogs;
            synchronized (linkedHashSet) {
                this.closedLogs.add(currentLog);
                clSize = this.closedLogs.size();
            }
            log.info("Marking " + currentLog.getPath() + " as closed. Total closed logs " + clSize);
            this.walMarker.closeWal(this.getTabletSession(), currentLog.getPath());
        } else {
            log.info("Marking " + currentLog.getPath() + " as unreferenced (skipping closed writes == 0)");
            this.walMarker.walUnreferenced(this.getTabletSession(), currentLog.getPath());
        }
    }

    public void updateBulkImportState(List<String> files, BulkImportState state) {
        this.bulkImportStatus.updateBulkImportStatus(files, state);
    }

    public void removeBulkImportState(List<String> files) {
        this.bulkImportStatus.removeBulkImportStatus(files);
    }

    public final RateLimiter getMajorCompactionReadLimiter() {
        return SharedRateLimiterFactory.getInstance().create(MAJC_READ_LIMITER_KEY, this.rateProvider);
    }

    public final RateLimiter getMajorCompactionWriteLimiter() {
        return SharedRateLimiterFactory.getInstance().create(MAJC_WRITE_LIMITER_KEY, this.rateProvider);
    }

    private static /* synthetic */ void lambda$setupReplication$3(AccumuloConfiguration aconf, ThreadPoolExecutor replicationThreadPool) {
        int maxPoolSize = aconf.getCount(Property.REPLICATION_WORKER_THREADS);
        if (replicationThreadPool.getMaximumPoolSize() != maxPoolSize) {
            log.info("Resizing thread pool for sending replication work from {} to {}", (Object)replicationThreadPool.getMaximumPoolSize(), (Object)maxPoolSize);
            replicationThreadPool.setMaximumPoolSize(maxPoolSize);
        }
    }

    @VisibleForTesting
    static interface ReferencedRemover {
        public void removeInUse(Set<DfsLogger> var1);
    }

    protected class AssignmentHandler
    implements Runnable {
        private final KeyExtent extent;
        private final int retryAttempt;

        public AssignmentHandler(KeyExtent extent) {
            this(extent, 0);
        }

        public AssignmentHandler(KeyExtent extent, int retryAttempt) {
            this.extent = extent;
            this.retryAttempt = retryAttempt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TreeMap<Key, Value> tabletsKeyValues;
            Text locationToOpen;
            block46: {
                Set unopenedOverlapping;
                log.info("{}: got assignment from master: {}", (Object)TabletServer.this.clientAddress, (Object)this.extent);
                SortedSet sortedSet = TabletServer.this.unopenedTablets;
                synchronized (sortedSet) {
                    SortedSet sortedSet2 = TabletServer.this.openingTablets;
                    synchronized (sortedSet2) {
                        OnlineTablets onlineTablets = TabletServer.this.onlineTablets;
                        synchronized (onlineTablets) {
                            unopenedOverlapping = KeyExtent.findOverlapping((KeyExtent)this.extent, (SortedSet)TabletServer.this.unopenedTablets);
                            Set openingOverlapping = KeyExtent.findOverlapping((KeyExtent)this.extent, (SortedSet)TabletServer.this.openingTablets);
                            Set onlineOverlapping = KeyExtent.findOverlapping((KeyExtent)this.extent, TabletServer.this.onlineTablets.snapshot());
                            if (openingOverlapping.contains(this.extent) || onlineOverlapping.contains(this.extent)) {
                                return;
                            }
                            if (!unopenedOverlapping.contains(this.extent)) {
                                log.info("assignment {} no longer in the unopened set", (Object)this.extent);
                                return;
                            }
                            if (unopenedOverlapping.size() != 1 || openingOverlapping.size() > 0 || onlineOverlapping.size() > 0) {
                                throw new IllegalStateException("overlaps assigned " + this.extent + " " + !TabletServer.this.unopenedTablets.contains(this.extent) + " " + unopenedOverlapping + " " + openingOverlapping + " " + onlineOverlapping);
                            }
                        }
                        TabletServer.this.unopenedTablets.remove(this.extent);
                        TabletServer.this.openingTablets.add(this.extent);
                    }
                }
                log.debug("Loading extent: {}", (Object)this.extent);
                locationToOpen = null;
                tabletsKeyValues = new TreeMap<Key, Value>();
                try {
                    Pair<Text, KeyExtent> pair = TabletServer.verifyTabletInformation(TabletServer.this.getContext(), this.extent, TabletServer.this.getTabletSession(), tabletsKeyValues, TabletServer.this.getClientAddressString(), TabletServer.this.getLock());
                    if (pair == null) break block46;
                    locationToOpen = (Text)pair.getFirst();
                    if (pair.getSecond() == null) break block46;
                    unopenedOverlapping = TabletServer.this.openingTablets;
                    synchronized (unopenedOverlapping) {
                        TabletServer.this.openingTablets.remove(this.extent);
                        TabletServer.this.openingTablets.notifyAll();
                        if (!KeyExtent.findOverlapping((KeyExtent)this.extent, new TreeSet<KeyExtent>(Arrays.asList((KeyExtent)pair.getSecond()))).contains(pair.getSecond())) {
                            throw new IllegalStateException("Fixed split does not overlap " + this.extent + " " + pair.getSecond());
                        }
                        TabletServer.this.unopenedTablets.add((KeyExtent)pair.getSecond());
                    }
                    new AssignmentHandler((KeyExtent)pair.getSecond()).run();
                    return;
                }
                catch (Exception e) {
                    unopenedOverlapping = TabletServer.this.openingTablets;
                    synchronized (unopenedOverlapping) {
                        TabletServer.this.openingTablets.remove(this.extent);
                        TabletServer.this.openingTablets.notifyAll();
                    }
                    log.warn("Failed to verify tablet " + this.extent, (Throwable)e);
                    TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.LOAD_FAILURE, this.extent));
                    throw new RuntimeException(e);
                }
            }
            if (locationToOpen == null) {
                log.debug("Reporting tablet {} assignment failure: unable to verify Tablet Information", (Object)this.extent);
                SortedSet e = TabletServer.this.openingTablets;
                synchronized (e) {
                    TabletServer.this.openingTablets.remove(this.extent);
                    TabletServer.this.openingTablets.notifyAll();
                }
                TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.LOAD_FAILURE, this.extent));
                return;
            }
            Tablet tablet = null;
            boolean successful = false;
            try {
                TabletServer.this.acquireRecoveryMemory(this.extent);
                TabletServerResourceManager.TabletResourceManager trm = TabletServer.this.resourceManager.createTabletResourceManager(this.extent, (AccumuloConfiguration)TabletServer.this.getTableConfiguration(this.extent));
                TabletData data = this.extent.isRootTablet() ? new TabletData(TabletServer.this.getContext(), TabletServer.this.fs, (AccumuloConfiguration)TabletServer.this.getTableConfiguration(this.extent)) : new TabletData(this.extent, TabletServer.this.fs, tabletsKeyValues.entrySet().iterator());
                tablet = new Tablet(TabletServer.this, this.extent, trm, data);
                if (tablet.getNumEntriesInMemory() > 0L && !tablet.minorCompactNow(MinorCompactionReason.RECOVERY)) {
                    throw new RuntimeException("Minor compaction after recovery fails for " + this.extent);
                }
                Assignment assignment = new Assignment(this.extent, TabletServer.this.getTabletSession());
                TabletStateStore.setLocation((ServerContext)TabletServer.this.getContext(), (Assignment)assignment);
                SortedSet sortedSet = TabletServer.this.openingTablets;
                synchronized (sortedSet) {
                    OnlineTablets onlineTablets = TabletServer.this.onlineTablets;
                    synchronized (onlineTablets) {
                        TabletServer.this.openingTablets.remove(this.extent);
                        TabletServer.this.onlineTablets.put(this.extent, tablet);
                        TabletServer.this.openingTablets.notifyAll();
                        TabletServer.this.recentlyUnloadedCache.remove(tablet.getExtent());
                    }
                }
                tablet = null;
                successful = true;
            }
            catch (Throwable e) {
                log.warn("exception trying to assign tablet {} {}", new Object[]{this.extent, locationToOpen, e});
                if (e.getMessage() != null) {
                    log.warn("{}", (Object)e.getMessage());
                }
                TableId tableId = this.extent.getTableId();
                ProblemReports.getInstance((ServerContext)TabletServer.this.getContext()).report(new ProblemReport(tableId, ProblemType.TABLET_LOAD, this.extent.getUUID().toString(), TabletServer.this.getClientAddressString(), e));
            }
            finally {
                TabletServer.this.releaseRecoveryMemory(this.extent);
            }
            if (!successful) {
                SortedSet e = TabletServer.this.unopenedTablets;
                synchronized (e) {
                    SortedSet sortedSet = TabletServer.this.openingTablets;
                    synchronized (sortedSet) {
                        TabletServer.this.openingTablets.remove(this.extent);
                        TabletServer.this.unopenedTablets.add(this.extent);
                        TabletServer.this.openingTablets.notifyAll();
                    }
                }
                log.warn("failed to open tablet {} reporting failure to master", (Object)this.extent);
                TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.LOAD_FAILURE, this.extent));
                long reschedule = Math.min((1L << Math.min(32, this.retryAttempt)) * 1000L, 600000L);
                log.warn(String.format("rescheduling tablet load in %.2f seconds", (double)reschedule / 1000.0));
                SimpleTimer.getInstance((AccumuloConfiguration)TabletServer.this.getConfiguration()).schedule((Runnable)new TimerTask(){

                    @Override
                    public void run() {
                        log.info("adding tablet {} back to the assignment pool (retry {})", (Object)AssignmentHandler.this.extent, (Object)AssignmentHandler.this.retryAttempt);
                        AssignmentHandler handler = new AssignmentHandler(AssignmentHandler.this.extent, AssignmentHandler.this.retryAttempt + 1);
                        if (AssignmentHandler.this.extent.isMeta()) {
                            if (AssignmentHandler.this.extent.isRootTablet()) {
                                new Daemon((Runnable)new LoggingRunnable(log, (Runnable)handler), "Root tablet assignment retry").start();
                            } else {
                                TabletServer.this.resourceManager.addMetaDataAssignment(AssignmentHandler.this.extent, log, handler);
                            }
                        } else {
                            TabletServer.this.resourceManager.addAssignment(AssignmentHandler.this.extent, log, handler);
                        }
                    }
                }, reschedule);
            } else {
                TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.LOADED, this.extent));
            }
        }
    }

    private class UnloadTabletHandler
    implements Runnable {
        private final KeyExtent extent;
        private final TUnloadTabletGoal goalState;
        private final long requestTimeSkew;

        public UnloadTabletHandler(KeyExtent extent, TUnloadTabletGoal goalState, long requestTime) {
            this.extent = extent;
            this.goalState = goalState;
            this.requestTimeSkew = requestTime - TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Tablet t = null;
            Object object = TabletServer.this.unopenedTablets;
            synchronized (object) {
                if (TabletServer.this.unopenedTablets.contains(this.extent)) {
                    TabletServer.this.unopenedTablets.remove(this.extent);
                    return;
                }
            }
            object = TabletServer.this.openingTablets;
            synchronized (object) {
                while (TabletServer.this.openingTablets.contains(this.extent)) {
                    try {
                        TabletServer.this.openingTablets.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            object = TabletServer.this.onlineTablets;
            synchronized (object) {
                if (TabletServer.this.onlineTablets.snapshot().containsKey((Object)this.extent)) {
                    t = (Tablet)TabletServer.this.onlineTablets.snapshot().get((Object)this.extent);
                }
            }
            if (t == null) {
                if (!TabletServer.this.recentlyUnloadedCache.containsKey(this.extent)) {
                    log.info("told to unload tablet that was not being served {}", (Object)this.extent);
                    TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.UNLOAD_FAILURE_NOT_SERVING, this.extent));
                }
                return;
            }
            try {
                t.close(!this.goalState.equals((Object)TUnloadTabletGoal.DELETED));
            }
            catch (Throwable e) {
                if ((t.isClosing() || t.isClosed()) && e instanceof IllegalStateException) {
                    log.debug("Failed to unload tablet {}... it was already closing or closed : {}", (Object)this.extent, (Object)e.getMessage());
                } else {
                    log.error("Failed to close tablet {}... Aborting migration", (Object)this.extent, (Object)e);
                    TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.UNLOAD_ERROR, this.extent));
                }
                return;
            }
            TabletServer.this.recentlyUnloadedCache.put(this.extent, System.currentTimeMillis());
            TabletServer.this.onlineTablets.remove(this.extent);
            try {
                TServerInstance instance = new TServerInstance(TabletServer.this.clientAddress, TabletServer.this.getLock().getSessionId());
                TabletLocationState tls = null;
                try {
                    tls = new TabletLocationState(this.extent, null, instance, null, null, null, false);
                }
                catch (TabletLocationState.BadLocationStateException e) {
                    log.error("Unexpected error", (Throwable)e);
                }
                if (!this.goalState.equals((Object)TUnloadTabletGoal.SUSPENDED) || this.extent.isRootTablet() || this.extent.isMeta() && !TabletServer.this.getConfiguration().getBoolean(Property.MASTER_METADATA_SUSPENDABLE)) {
                    log.debug("Unassigning {}", (Object)tls);
                    TabletStateStore.unassign((ServerContext)TabletServer.this.getContext(), (TabletLocationState)tls, null);
                } else {
                    log.debug("Suspending " + tls);
                    TabletStateStore.suspend((ServerContext)TabletServer.this.getContext(), (TabletLocationState)tls, null, (long)(this.requestTimeSkew + TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS)));
                }
            }
            catch (DistributedStoreException ex) {
                log.warn("Unable to update storage", (Throwable)ex);
            }
            catch (KeeperException e) {
                log.warn("Unable determine our zookeeper session information", (Throwable)e);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while getting our zookeeper session information", (Throwable)e);
            }
            TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.UNLOADED, this.extent));
            TabletServer.this.statsKeeper.saveMajorMinorTimes(t.getTabletStats());
            log.info("unloaded {}", (Object)this.extent);
        }
    }

    private class MajorCompactor
    implements Runnable {
        public MajorCompactor(AccumuloConfiguration config) {
            CompactionWatcher.startWatching(config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    block7: while (true) {
                        List<DfsLogger> closedCopy;
                        UtilWaitThread.sleepUninterruptibly((long)TabletServer.this.getConfiguration().getTimeInMillis(Property.TSERV_MAJC_DELAY), (TimeUnit)TimeUnit.MILLISECONDS);
                        LinkedHashSet<DfsLogger> linkedHashSet = TabletServer.this.closedLogs;
                        synchronized (linkedHashSet) {
                            closedCopy = TabletServer.copyClosedLogs(TabletServer.this.closedLogs);
                        }
                        Iterator<Map.Entry<KeyExtent, Tablet>> iter = TabletServer.this.getOnlineTablets().entrySet().iterator();
                        while (true) {
                            if (!iter.hasNext()) continue block7;
                            Map.Entry<KeyExtent, Tablet> entry = iter.next();
                            Tablet tablet = entry.getValue();
                            if (tablet.needsSplit()) {
                                TabletServer.this.executeSplit(tablet);
                                continue;
                            }
                            tablet.checkIfMinorCompactionNeededForLogs(closedCopy);
                            Tablet tablet2 = tablet;
                            synchronized (tablet2) {
                                tablet.initiateMajorCompaction(MajorCompactionReason.NORMAL);
                            }
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    log.error("Unexpected exception in {}", (Object)Thread.currentThread().getName(), (Object)t);
                    UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                    continue;
                }
                break;
            }
        }
    }

    private class SplitRunner
    implements Runnable {
        private final Tablet tablet;

        public SplitRunner(Tablet tablet) {
            this.tablet = tablet;
        }

        @Override
        public void run() {
            TabletServer.this.splitTablet(this.tablet);
        }
    }

    private class ThriftClientHandler
    extends ClientServiceHandler
    implements TabletClientService.Iface {
        ThriftClientHandler() {
            super(TabletServer.this.getContext(), TabletServer.this.watcher, TabletServer.this.fs);
            log.debug("{} created", (Object)ThriftClientHandler.class.getName());
        }

        public List<TKeyExtent> bulkImport(TInfo tinfo, TCredentials credentials, long tid, Map<TKeyExtent, Map<String, MapFileInfo>> files, boolean setTime) throws ThriftSecurityException {
            if (!TabletServer.this.security.canPerformSystemActions(credentials)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            try {
                return (List)TabletServer.this.watcher.run("bulkTx", tid, () -> {
                    ArrayList<TKeyExtent> failures = new ArrayList<TKeyExtent>();
                    for (Map.Entry entry : files.entrySet()) {
                        TKeyExtent tke = (TKeyExtent)entry.getKey();
                        Map fileMap = (Map)entry.getValue();
                        HashMap<FileRef, MapFileInfo> fileRefMap = new HashMap<FileRef, MapFileInfo>();
                        for (Map.Entry mapping : fileMap.entrySet()) {
                            Path path = new Path((String)mapping.getKey());
                            FileSystem ns = TabletServer.this.fs.getVolumeByPath(path).getFileSystem();
                            path = ns.makeQualified(path);
                            fileRefMap.put(new FileRef(path.toString(), path), (MapFileInfo)mapping.getValue());
                        }
                        Tablet importTablet = TabletServer.this.getOnlineTablet(new KeyExtent(tke));
                        if (importTablet == null) {
                            failures.add(tke);
                            continue;
                        }
                        try {
                            importTablet.importMapFiles(tid, fileRefMap, setTime);
                        }
                        catch (IOException ioe) {
                            log.info("files {} not imported to {}: {}", new Object[]{fileMap.keySet(), new KeyExtent(tke), ioe.getMessage()});
                            failures.add(tke);
                        }
                    }
                    return failures;
                });
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void loadFiles(TInfo tinfo, TCredentials credentials, long tid, String dir, Map<TKeyExtent, Map<String, MapFileInfo>> tabletImports, boolean setTime) throws ThriftSecurityException {
            if (!TabletServer.this.security.canPerformSystemActions(credentials)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            TabletServer.this.watcher.runQuietly("bulkTx", tid, () -> tabletImports.forEach((tke, fileMap) -> {
                HashMap<FileRef, MapFileInfo> fileRefMap = new HashMap<FileRef, MapFileInfo>();
                for (Map.Entry mapping : fileMap.entrySet()) {
                    Path path = new Path(dir, (String)mapping.getKey());
                    FileSystem ns = TabletServer.this.fs.getVolumeByPath(path).getFileSystem();
                    path = ns.makeQualified(path);
                    fileRefMap.put(new FileRef(path.toString(), path), (MapFileInfo)mapping.getValue());
                }
                Tablet importTablet = TabletServer.this.getOnlineTablet(new KeyExtent(tke));
                if (importTablet != null) {
                    try {
                        importTablet.importMapFiles(tid, fileRefMap, setTime);
                    }
                    catch (IOException ioe) {
                        log.debug("files {} not imported to {}: {}", new Object[]{fileMap.keySet(), new KeyExtent(tke), ioe.getMessage()});
                    }
                }
            }));
        }

        private ScanDispatcher getScanDispatcher(KeyExtent extent) {
            if (extent.isRootTablet() || extent.isMeta()) {
                return null;
            }
            return TabletServer.this.getContext().getServerConfFactory().getTableConfiguration(extent.getTableId()).getScanDispatcher();
        }

        public InitialScan startScan(TInfo tinfo, TCredentials credentials, TKeyExtent textent, TRange range, List<TColumn> columns, int batchSize, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, boolean isolated, long readaheadThreshold, TSamplerConfiguration tSamplerConfig, long batchTimeOut, String contextArg, Map<String, String> executionHints) throws NotServingTabletException, ThriftSecurityException, org.apache.accumulo.core.tabletserver.thrift.TooManyFilesException, TSampleNotPresentException {
            ScanResult scanResult;
            Tablet tablet;
            NamespaceId namespaceId;
            TableId tableId = TableId.of((String)new String(textent.getTable(), StandardCharsets.UTF_8));
            try {
                namespaceId = Tables.getNamespaceId((ClientContext)TabletServer.this.getContext(), (TableId)tableId);
            }
            catch (TableNotFoundException e1) {
                throw new NotServingTabletException(textent);
            }
            if (!TabletServer.this.security.canScan(credentials, tableId, namespaceId, range, columns, ssiList, ssio, authorizations)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            if (!TabletServer.this.security.authenticatedUserHasAuthorizations(credentials, authorizations)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.BAD_AUTHORIZATIONS);
            }
            KeyExtent extent = new KeyExtent(textent);
            if (waitForWrites) {
                TabletServer.this.writeTracker.waitForWrites(TabletType.type((KeyExtent)extent));
            }
            if ((tablet = TabletServer.this.getOnlineTablet(extent)) == null) {
                throw new NotServingTabletException(textent);
            }
            HashSet<Column> columnSet = new HashSet<Column>();
            for (TColumn tcolumn : columns) {
                columnSet.add(new Column(tcolumn));
            }
            SingleScanSession scanSession = new SingleScanSession(credentials, extent, columnSet, ssiList, ssio, new Authorizations(authorizations), readaheadThreshold, batchTimeOut, contextArg, executionHints);
            scanSession.scanner = tablet.createScanner(new Range(range), batchSize, scanSession.columnSet, scanSession.auths, ssiList, ssio, isolated, scanSession.interruptFlag, SamplerConfigurationImpl.fromThrift((TSamplerConfiguration)tSamplerConfig), scanSession.batchTimeOut, scanSession.context);
            long sid = TabletServer.this.sessionManager.createSession(scanSession, true);
            try {
                scanResult = this.continueScan(tinfo, sid, scanSession);
            }
            catch (NoSuchScanIDException e) {
                log.error("The impossible happened", (Throwable)e);
                throw new RuntimeException();
            }
            finally {
                TabletServer.this.sessionManager.unreserveSession(sid);
            }
            return new InitialScan(sid, scanResult);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ScanResult continueScan(TInfo tinfo, long scanID) throws NoSuchScanIDException, NotServingTabletException, org.apache.accumulo.core.tabletserver.thrift.TooManyFilesException, TSampleNotPresentException {
            SingleScanSession scanSession = (SingleScanSession)TabletServer.this.sessionManager.reserveSession(scanID);
            if (scanSession == null) {
                throw new NoSuchScanIDException();
            }
            try {
                ScanResult scanResult = this.continueScan(tinfo, scanID, scanSession);
                return scanResult;
            }
            finally {
                TabletServer.this.sessionManager.unreserveSession(scanSession);
            }
        }

        private ScanResult continueScan(TInfo tinfo, long scanID, SingleScanSession scanSession) throws NoSuchScanIDException, NotServingTabletException, org.apache.accumulo.core.tabletserver.thrift.TooManyFilesException, TSampleNotPresentException {
            ScanBatch bresult;
            if (scanSession.nextBatchTask == null) {
                scanSession.nextBatchTask = new NextBatchTask(TabletServer.this, scanID, scanSession.interruptFlag);
                TabletServer.this.resourceManager.executeReadAhead(scanSession.extent, this.getScanDispatcher(scanSession.extent), scanSession, scanSession.nextBatchTask);
            }
            try {
                bresult = scanSession.nextBatchTask.get(1000L, TimeUnit.MILLISECONDS);
                scanSession.nextBatchTask = null;
            }
            catch (ExecutionException e) {
                TabletServer.this.sessionManager.removeSession(scanID);
                if (e.getCause() instanceof NotServingTabletException) {
                    throw (NotServingTabletException)e.getCause();
                }
                if (e.getCause() instanceof TooManyFilesException) {
                    throw new org.apache.accumulo.core.tabletserver.thrift.TooManyFilesException(scanSession.extent.toThrift());
                }
                if (e.getCause() instanceof SampleNotPresentException) {
                    throw new TSampleNotPresentException(scanSession.extent.toThrift());
                }
                if (e.getCause() instanceof IOException) {
                    UtilWaitThread.sleepUninterruptibly((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
                    List<KVEntry> empty = Collections.emptyList();
                    bresult = new ScanBatch(empty, true);
                    scanSession.nextBatchTask = null;
                }
                throw new RuntimeException(e);
            }
            catch (CancellationException ce) {
                TabletServer.this.sessionManager.removeSession(scanID);
                Tablet tablet = TabletServer.this.getOnlineTablet(scanSession.extent);
                if (tablet == null || tablet.isClosed()) {
                    throw new NotServingTabletException(scanSession.extent.toThrift());
                }
                throw new NoSuchScanIDException();
            }
            catch (TimeoutException e) {
                List param = Collections.emptyList();
                long timeout = TabletServer.this.getConfiguration().getTimeInMillis(Property.TSERV_CLIENT_TIMEOUT);
                TabletServer.this.sessionManager.removeIfNotAccessed(scanID, timeout);
                return new ScanResult(param, true);
            }
            catch (Throwable t) {
                TabletServer.this.sessionManager.removeSession(scanID);
                log.warn("Failed to get next batch", t);
                throw new RuntimeException(t);
            }
            ScanResult scanResult = new ScanResult(Key.compress(bresult.getResults()), bresult.isMore());
            scanSession.entriesReturned += (long)scanResult.results.size();
            ++scanSession.batchCount;
            if (scanResult.more && scanSession.batchCount > scanSession.readaheadThreshold) {
                scanSession.nextBatchTask = new NextBatchTask(TabletServer.this, scanID, scanSession.interruptFlag);
                TabletServer.this.resourceManager.executeReadAhead(scanSession.extent, this.getScanDispatcher(scanSession.extent), scanSession, scanSession.nextBatchTask);
            }
            if (!scanResult.more) {
                this.closeScan(tinfo, scanID);
            }
            return scanResult;
        }

        public void closeScan(TInfo tinfo, long scanID) {
            SingleScanSession ss = (SingleScanSession)TabletServer.this.sessionManager.removeSession(scanID);
            if (ss != null) {
                long t2 = System.currentTimeMillis();
                if (log.isTraceEnabled()) {
                    log.trace(String.format("ScanSess tid %s %s %,d entries in %.2f secs, nbTimes = [%s] ", TServerUtils.clientAddress.get(), ss.extent.getTableId(), ss.entriesReturned, (double)(t2 - ss.startTime) / 1000.0, ss.runStats.toString()));
                }
                TabletServer.this.scanMetrics.addScan(t2 - ss.startTime);
                TabletServer.this.scanMetrics.addResult(ss.entriesReturned);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InitialMultiScan startMultiScan(TInfo tinfo, TCredentials credentials, Map<TKeyExtent, List<TRange>> tbatch, List<TColumn> tcolumns, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, TSamplerConfiguration tSamplerConfig, long batchTimeOut, String contextArg, Map<String, String> executionHints) throws ThriftSecurityException, TSampleNotPresentException {
            MultiScanResult result;
            HashSet<TableId> tables = new HashSet<TableId>();
            for (TKeyExtent keyExtent : tbatch.keySet()) {
                tables.add(TableId.of((String)new String(keyExtent.getTable(), StandardCharsets.UTF_8)));
            }
            if (tables.size() != 1) {
                throw new IllegalArgumentException("Cannot batch scan over multiple tables");
            }
            for (TableId tableId : tables) {
                NamespaceId namespaceId = this.getNamespaceId(credentials, tableId);
                if (TabletServer.this.security.canScan(credentials, tableId, namespaceId, tbatch, tcolumns, ssiList, ssio, authorizations)) continue;
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            try {
                if (!TabletServer.this.security.authenticatedUserHasAuthorizations(credentials, authorizations)) {
                    throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.BAD_AUTHORIZATIONS);
                }
            }
            catch (ThriftSecurityException tse) {
                log.error("{} is not authorized", (Object)credentials.getPrincipal(), (Object)tse);
                throw tse;
            }
            Map batch = Translator.translate(tbatch, (Translator)new Translator.TKeyExtentTranslator(), (Translator)new Translator.ListTranslator((Translator)new Translator.TRangeTranslator()));
            KeyExtent threadPoolExtent = (KeyExtent)batch.keySet().iterator().next();
            if (waitForWrites) {
                TabletServer.this.writeTracker.waitForWrites(TabletType.type(batch.keySet()));
            }
            MultiScanSession mss = new MultiScanSession(credentials, threadPoolExtent, batch, ssiList, ssio, new Authorizations(authorizations), SamplerConfigurationImpl.fromThrift((TSamplerConfiguration)tSamplerConfig), batchTimeOut, contextArg, executionHints);
            mss.numTablets = batch.size();
            for (List ranges : batch.values()) {
                mss.numRanges += ranges.size();
            }
            for (TColumn tcolumn : tcolumns) {
                mss.columnSet.add(new Column(tcolumn));
            }
            long sid = TabletServer.this.sessionManager.createSession(mss, true);
            try {
                result = this.continueMultiScan(sid, mss);
            }
            finally {
                TabletServer.this.sessionManager.unreserveSession(sid);
            }
            return new InitialMultiScan(sid, result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MultiScanResult continueMultiScan(TInfo tinfo, long scanID) throws NoSuchScanIDException, TSampleNotPresentException {
            MultiScanSession session = (MultiScanSession)TabletServer.this.sessionManager.reserveSession(scanID);
            if (session == null) {
                throw new NoSuchScanIDException();
            }
            try {
                MultiScanResult multiScanResult = this.continueMultiScan(scanID, session);
                return multiScanResult;
            }
            finally {
                TabletServer.this.sessionManager.unreserveSession(session);
            }
        }

        private MultiScanResult continueMultiScan(long scanID, MultiScanSession session) throws TSampleNotPresentException {
            if (session.lookupTask == null) {
                session.lookupTask = new LookupTask(TabletServer.this, scanID);
                TabletServer.this.resourceManager.executeReadAhead(session.threadPoolExtent, this.getScanDispatcher(session.threadPoolExtent), session, session.lookupTask);
            }
            try {
                MultiScanResult scanResult = session.lookupTask.get(1000L, TimeUnit.MILLISECONDS);
                session.lookupTask = null;
                return scanResult;
            }
            catch (ExecutionException e) {
                TabletServer.this.sessionManager.removeSession(scanID);
                if (e.getCause() instanceof SampleNotPresentException) {
                    throw new TSampleNotPresentException();
                }
                log.warn("Failed to get multiscan result", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (TimeoutException e1) {
                long timeout = TabletServer.this.getConfiguration().getTimeInMillis(Property.TSERV_CLIENT_TIMEOUT);
                TabletServer.this.sessionManager.removeIfNotAccessed(scanID, timeout);
                List results = Collections.emptyList();
                Map failures = Collections.emptyMap();
                List fullScans = Collections.emptyList();
                return new MultiScanResult(results, failures, fullScans, null, null, false, true);
            }
            catch (Throwable t) {
                TabletServer.this.sessionManager.removeSession(scanID);
                log.warn("Failed to get multiscan result", t);
                throw new RuntimeException(t);
            }
        }

        public void closeMultiScan(TInfo tinfo, long scanID) throws NoSuchScanIDException {
            MultiScanSession session = (MultiScanSession)TabletServer.this.sessionManager.removeSession(scanID);
            if (session == null) {
                throw new NoSuchScanIDException();
            }
            long t2 = System.currentTimeMillis();
            if (log.isTraceEnabled()) {
                log.trace(String.format("MultiScanSess %s %,d entries in %.2f secs (lookup_time:%.2f secs tablets:%,d ranges:%,d) ", TServerUtils.clientAddress.get(), session.numEntries, (double)(t2 - session.startTime) / 1000.0, (double)session.totalLookupTime / 1000.0, session.numTablets, session.numRanges));
            }
        }

        public long startUpdate(TInfo tinfo, TCredentials credentials, TDurability tdurabilty) throws ThriftSecurityException {
            Durability durability = DurabilityImpl.fromThrift((TDurability)tdurabilty);
            TabletServer.this.security.authenticateUser(credentials, credentials);
            TabletServer.this.updateMetrics.addPermissionErrors(0L);
            UpdateSession us = new UpdateSession(new TservConstraintEnv(TabletServer.this.getContext(), TabletServer.this.security, credentials), credentials, durability);
            return TabletServer.this.sessionManager.createSession(us, false);
        }

        private void setUpdateTablet(UpdateSession us, KeyExtent keyExtent) {
            block8: {
                long t1 = System.currentTimeMillis();
                if (us.currentTablet != null && us.currentTablet.getExtent().equals((Object)keyExtent)) {
                    return;
                }
                if (us.currentTablet == null && (us.failures.containsKey(keyExtent) || us.authFailures.containsKey(keyExtent))) {
                    return;
                }
                TableId tableId = null;
                try {
                    boolean sameTable = us.currentTablet != null && us.currentTablet.getExtent().getTableId().equals((Object)keyExtent.getTableId());
                    tableId = keyExtent.getTableId();
                    if (sameTable || TabletServer.this.security.canWrite(us.getCredentials(), tableId, Tables.getNamespaceId((ClientContext)TabletServer.this.getContext(), (TableId)tableId))) {
                        long t2 = System.currentTimeMillis();
                        us.authTimes.addStat(t2 - t1);
                        us.currentTablet = TabletServer.this.getOnlineTablet(keyExtent);
                        if (us.currentTablet != null) {
                            us.queuedMutations.put(us.currentTablet, new ArrayList());
                        } else {
                            us.failures.put(keyExtent, 0L);
                            TabletServer.this.updateMetrics.addUnknownTabletErrors(0L);
                        }
                        break block8;
                    }
                    log.warn("Denying access to table {} for user {}", (Object)keyExtent.getTableId(), (Object)us.getUser());
                    long t2 = System.currentTimeMillis();
                    us.authTimes.addStat(t2 - t1);
                    us.currentTablet = null;
                    us.authFailures.put(keyExtent, SecurityErrorCode.PERMISSION_DENIED);
                    TabletServer.this.updateMetrics.addPermissionErrors(0L);
                    return;
                }
                catch (TableNotFoundException tnfe) {
                    log.error("Table " + tableId + " not found ", (Throwable)tnfe);
                    long t2 = System.currentTimeMillis();
                    us.authTimes.addStat(t2 - t1);
                    us.currentTablet = null;
                    us.authFailures.put(keyExtent, SecurityErrorCode.TABLE_DOESNT_EXIST);
                    TabletServer.this.updateMetrics.addUnknownTabletErrors(0L);
                    return;
                }
                catch (ThriftSecurityException e) {
                    log.error("Denying permission to check user " + us.getUser() + " with user " + e.getUser(), (Throwable)e);
                    long t2 = System.currentTimeMillis();
                    us.authTimes.addStat(t2 - t1);
                    us.currentTablet = null;
                    us.authFailures.put(keyExtent, e.getCode());
                    TabletServer.this.updateMetrics.addPermissionErrors(0L);
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applyUpdates(TInfo tinfo, long updateID, TKeyExtent tkeyExtent, List<TMutation> tmutations) {
            UpdateSession us = (UpdateSession)TabletServer.this.sessionManager.reserveSession(updateID);
            if (us == null) {
                return;
            }
            boolean reserved = true;
            try {
                KeyExtent keyExtent = new KeyExtent(tkeyExtent);
                this.setUpdateTablet(us, keyExtent);
                if (us.currentTablet != null) {
                    long total;
                    long additionalMutationSize = 0L;
                    List<Mutation> mutations = us.queuedMutations.get(us.currentTablet);
                    for (TMutation tmutation : tmutations) {
                        ServerMutation mutation = new ServerMutation(tmutation);
                        mutations.add((Mutation)mutation);
                        additionalMutationSize += mutation.numBytes();
                    }
                    us.queuedMutationSize += additionalMutationSize;
                    long totalQueued = TabletServer.this.updateTotalQueuedMutationSize(additionalMutationSize);
                    if (totalQueued > (total = TabletServer.this.getConfiguration().getAsBytes(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX))) {
                        try {
                            this.flush(us);
                        }
                        catch (HoldTimeoutException hte) {
                            log.debug("HoldTimeoutException during applyUpdates, removing session");
                            TabletServer.this.sessionManager.removeSession(updateID, true);
                            reserved = false;
                        }
                    }
                }
            }
            finally {
                if (reserved) {
                    TabletServer.this.sessionManager.unreserveSession(us);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flush(UpdateSession us) {
            int mutationCount = 0;
            HashMap<CommitSession, List> sendables = new HashMap<CommitSession, List>();
            HashMap<CommitSession, TabletMutations> loggables = new HashMap<CommitSession, TabletMutations>();
            Throwable error = null;
            long pt1 = System.currentTimeMillis();
            boolean containsMetadataTablet = false;
            for (Tablet tablet : us.queuedMutations.keySet()) {
                if (!tablet.getExtent().isMeta()) continue;
                containsMetadataTablet = true;
            }
            if (!containsMetadataTablet && us.queuedMutations.size() > 0) {
                TabletServer.this.resourceManager.waitUntilCommitsAreEnabled();
            }
            try (TraceScope prep = Trace.startSpan((String)"prep");){
                for (Map.Entry<Tablet, List<Mutation>> entry : us.queuedMutations.entrySet()) {
                    Tablet tablet = entry.getKey();
                    Durability durability = DurabilityImpl.resolveDurabilty((Durability)us.durability, (Durability)tablet.getDurability());
                    List<Mutation> mutations2 = entry.getValue();
                    if (mutations2.size() <= 0) continue;
                    try {
                        TabletServer.this.updateMetrics.addMutationArraySize(mutations2.size());
                        CommitSession commitSession2 = tablet.prepareMutationsForCommit(us.cenv, mutations2);
                        if (commitSession2 == null) {
                            if (us.currentTablet == tablet) {
                                us.currentTablet = null;
                            }
                            us.failures.put(tablet.getExtent(), us.successfulCommits.get((Object)tablet));
                            continue;
                        }
                        if (durability != Durability.NONE) {
                            loggables.put(commitSession2, new TabletMutations(commitSession2, mutations2, durability));
                        }
                        sendables.put(commitSession2, mutations2);
                        mutationCount += mutations2.size();
                    }
                    catch (TConstraintViolationException e) {
                        us.violations.add(e.getViolations());
                        TabletServer.this.updateMetrics.addConstraintViolations(0L);
                        if (e.getNonViolators().size() > 0) {
                            CommitSession cs = e.getCommitSession();
                            if (durability != Durability.NONE) {
                                loggables.put(cs, new TabletMutations(cs, e.getNonViolators(), durability));
                            }
                            sendables.put(cs, e.getNonViolators());
                        }
                        mutationCount += mutations2.size();
                    }
                    catch (Throwable t) {
                        error = t;
                        log.error("Unexpected error preparing for commit", error);
                        break;
                    }
                }
            }
            long pt2 = System.currentTimeMillis();
            us.prepareTimes.addStat(pt2 - pt1);
            this.updateAvgPrepTime(pt2 - pt1, us.queuedMutations.size());
            if (error != null) {
                sendables.forEach((commitSession, value) -> commitSession.abortCommit());
                throw new RuntimeException(error);
            }
            try {
                long t2;
                long t1;
                try (TraceScope wal = Trace.startSpan((String)"wal");){
                    while (true) {
                        try {
                            t1 = System.currentTimeMillis();
                            TabletServer.this.logger.logManyTablets(loggables);
                            t2 = System.currentTimeMillis();
                            us.walogTimes.addStat(t2 - t1);
                            this.updateWalogWriteTime(t2 - t1);
                        }
                        catch (IOException | FSError ex) {
                            log.warn("logging mutations failed, retrying");
                            continue;
                        }
                        catch (Throwable t) {
                            log.error("Unknown exception logging mutations, counts for mutations in flight not decremented!", t);
                            throw new RuntimeException(t);
                        }
                        break;
                    }
                }
                try (TraceScope commit = Trace.startSpan((String)"commit");){
                    t1 = System.currentTimeMillis();
                    sendables.forEach((commitSession, mutations) -> {
                        commitSession.commit((List<Mutation>)mutations);
                        KeyExtent extent = commitSession.getExtent();
                        if (us.currentTablet != null && extent == us.currentTablet.getExtent()) {
                            us.successfulCommits.increment((Object)us.currentTablet, (long)us.queuedMutations.get(us.currentTablet).size());
                        }
                    });
                    t2 = System.currentTimeMillis();
                    us.flushTime += t2 - pt1;
                    us.commitTimes.addStat(t2 - t1);
                    this.updateAvgCommitTime(t2 - t1, sendables.size());
                }
            }
            finally {
                us.queuedMutations.clear();
                if (us.currentTablet != null) {
                    us.queuedMutations.put(us.currentTablet, new ArrayList());
                }
                TabletServer.this.updateTotalQueuedMutationSize(-us.queuedMutationSize);
                us.queuedMutationSize = 0L;
            }
            us.totalUpdates += (long)mutationCount;
        }

        private void updateWalogWriteTime(long time) {
            TabletServer.this.updateMetrics.addWalogWriteTime(time);
        }

        private void updateAvgCommitTime(long time, int size) {
            if (size > 0) {
                TabletServer.this.updateMetrics.addCommitTime((long)((double)time / (double)size));
            }
        }

        private void updateAvgPrepTime(long time, int size) {
            if (size > 0) {
                TabletServer.this.updateMetrics.addCommitPrep((long)((double)time / (double)size));
            }
        }

        public UpdateErrors closeUpdate(TInfo tinfo, long updateID) throws NoSuchScanIDException {
            ConstraintViolationSummary first;
            List violations;
            UpdateSession us = (UpdateSession)TabletServer.this.sessionManager.removeSession(updateID);
            if (us == null) {
                throw new NoSuchScanIDException();
            }
            long opid = TabletServer.this.writeTracker.startWrite(us.queuedMutations.keySet());
            try {
                this.flush(us);
            }
            catch (HoldTimeoutException e) {
                log.debug("HoldTimeoutException during closeUpdate, reporting no such session");
                throw new NoSuchScanIDException();
            }
            finally {
                TabletServer.this.writeTracker.finishWrite(opid);
            }
            if (log.isTraceEnabled()) {
                log.trace(String.format("UpSess %s %,d in %.3fs, at=[%s] ft=%.3fs(pt=%.3fs lt=%.3fs ct=%.3fs)", TServerUtils.clientAddress.get(), us.totalUpdates, (double)(System.currentTimeMillis() - us.startTime) / 1000.0, us.authTimes.toString(), (double)us.flushTime / 1000.0, (double)us.prepareTimes.sum() / 1000.0, (double)us.walogTimes.sum() / 1000.0, (double)us.commitTimes.sum() / 1000.0));
            }
            if (us.failures.size() > 0) {
                Map.Entry<KeyExtent, Long> first2 = us.failures.entrySet().iterator().next();
                log.debug(String.format("Failures: %d, first extent %s successful commits: %d", us.failures.size(), first2.getKey().toString(), first2.getValue()));
            }
            if ((violations = us.violations.asList()).size() > 0) {
                first = (ConstraintViolationSummary)us.violations.asList().iterator().next();
                log.debug(String.format("Violations: %d, first %s occurs %d", violations.size(), first.violationDescription, first.numberOfViolatingMutations));
            }
            if (us.authFailures.size() > 0) {
                first = us.authFailures.keySet().iterator().next();
                log.debug(String.format("Authentication Failures: %d, first %s", us.authFailures.size(), first.toString()));
            }
            return new UpdateErrors(Translator.translate(us.failures, (Translator)Translators.KET), Translator.translate((Collection)violations, (Translator)Translators.CVST), Translator.translate(us.authFailures, (Translator)Translators.KET));
        }

        public void update(TInfo tinfo, TCredentials credentials, TKeyExtent tkeyExtent, TMutation tmutation, TDurability tdurability) throws NotServingTabletException, ConstraintViolationException, ThriftSecurityException {
            TableId tableId = TableId.of((String)new String(tkeyExtent.getTable(), StandardCharsets.UTF_8));
            NamespaceId namespaceId = this.getNamespaceId(credentials, tableId);
            if (!TabletServer.this.security.canWrite(credentials, tableId, namespaceId)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            KeyExtent keyExtent = new KeyExtent(tkeyExtent);
            Tablet tablet = TabletServer.this.getOnlineTablet(new KeyExtent(keyExtent));
            if (tablet == null) {
                throw new NotServingTabletException(tkeyExtent);
            }
            Durability tabletDurability = tablet.getDurability();
            if (!keyExtent.isMeta()) {
                try {
                    TabletServer.this.resourceManager.waitUntilCommitsAreEnabled();
                }
                catch (HoldTimeoutException hte) {
                    throw new NotServingTabletException(tkeyExtent);
                }
            }
            long opid = TabletServer.this.writeTracker.startWrite(TabletType.type((KeyExtent)keyExtent));
            try {
                CommitSession cs;
                ServerMutation mutation = new ServerMutation(tmutation);
                List<ServerMutation> mutations = Collections.singletonList(mutation);
                try (TraceScope prep = Trace.startSpan((String)"prep");){
                    cs = tablet.prepareMutationsForCommit(new TservConstraintEnv(TabletServer.this.getContext(), TabletServer.this.security, credentials), mutations);
                }
                if (cs == null) {
                    throw new NotServingTabletException(tkeyExtent);
                }
                Durability durability = DurabilityImpl.resolveDurabilty((Durability)DurabilityImpl.fromThrift((TDurability)tdurability), (Durability)tabletDurability);
                while (durability != Durability.NONE) {
                    try (TraceScope wal = Trace.startSpan((String)"wal");){
                        TabletServer.this.logger.log(cs, (Mutation)mutation, durability);
                        break;
                    }
                    catch (IOException ex) {
                        log.warn("Error writing mutations to log", (Throwable)ex);
                    }
                }
                try (TraceScope commit = Trace.startSpan((String)"commit");){
                    cs.commit(mutations);
                }
            }
            catch (TConstraintViolationException e) {
                throw new ConstraintViolationException(Translator.translate((Collection)e.getViolations().asList(), (Translator)Translators.CVST));
            }
            finally {
                TabletServer.this.writeTracker.finishWrite(opid);
            }
        }

        private NamespaceId getNamespaceId(TCredentials credentials, TableId tableId) throws ThriftSecurityException {
            try {
                return Tables.getNamespaceId((ClientContext)TabletServer.this.getContext(), (TableId)tableId);
            }
            catch (TableNotFoundException e1) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.TABLE_DOESNT_EXIST);
            }
        }

        private void checkConditions(Map<KeyExtent, List<ServerConditionalMutation>> updates, ArrayList<TCMResult> results, ConditionalSession cs, List<String> symbols) throws IOException {
            Iterator<Map.Entry<KeyExtent, List<ServerConditionalMutation>>> iter = updates.entrySet().iterator();
            CompressedIterators compressedIters = new CompressedIterators(symbols);
            ConditionCheckerContext checkerContext = new ConditionCheckerContext(TabletServer.this.getContext(), compressedIters, TabletServer.this.confFactory.getTableConfiguration(cs.tableId));
            while (iter.hasNext()) {
                Map.Entry<KeyExtent, List<ServerConditionalMutation>> entry = iter.next();
                Tablet tablet = TabletServer.this.getOnlineTablet(entry.getKey());
                if (tablet == null || tablet.isClosed()) {
                    for (ServerConditionalMutation scm : entry.getValue()) {
                        results.add(new TCMResult(scm.getID(), TCMStatus.IGNORED));
                    }
                    iter.remove();
                    continue;
                }
                ArrayList<ServerConditionalMutation> okMutations = new ArrayList<ServerConditionalMutation>(entry.getValue().size());
                List<TCMResult> resultsSubList = results.subList(results.size(), results.size());
                ConditionCheckerContext.ConditionChecker checker = checkerContext.newChecker(entry.getValue(), okMutations, resultsSubList);
                try {
                    tablet.checkConditions(checker, cs.auths, cs.interruptFlag);
                    if (okMutations.size() > 0) {
                        entry.setValue(okMutations);
                        continue;
                    }
                    iter.remove();
                }
                catch (IterationInterruptedException | TooManyFilesException | TabletClosedException e) {
                    resultsSubList.clear();
                    for (ServerConditionalMutation scm : entry.getValue()) {
                        results.add(new TCMResult(scm.getID(), TCMStatus.IGNORED));
                    }
                    iter.remove();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void writeConditionalMutations(Map<KeyExtent, List<ServerConditionalMutation>> updates, ArrayList<TCMResult> results, ConditionalSession sess) {
            long t2;
            Set<Map.Entry<KeyExtent, List<ServerConditionalMutation>>> es = updates.entrySet();
            HashMap<CommitSession, List> sendables = new HashMap<CommitSession, List>();
            HashMap<CommitSession, TabletMutations> loggables = new HashMap<CommitSession, TabletMutations>();
            boolean sessionCanceled = sess.interruptFlag.get();
            try (TraceScope prepSpan = Trace.startSpan((String)"prep");){
                long t1 = System.currentTimeMillis();
                for (Map.Entry<KeyExtent, List<ServerConditionalMutation>> entry : es) {
                    CommitSession cs;
                    Tablet tablet = TabletServer.this.getOnlineTablet(entry.getKey());
                    if (tablet == null || tablet.isClosed() || sessionCanceled) {
                        for (ServerConditionalMutation scm : entry.getValue()) {
                            results.add(new TCMResult(scm.getID(), TCMStatus.IGNORED));
                        }
                        continue;
                    }
                    Durability durability = DurabilityImpl.resolveDurabilty((Durability)sess.durability, (Durability)tablet.getDurability());
                    try {
                        List<ServerConditionalMutation> mutations = entry.getValue();
                        if (mutations.size() <= 0) continue;
                        cs = tablet.prepareMutationsForCommit(new TservConstraintEnv(TabletServer.this.getContext(), TabletServer.this.security, sess.credentials), mutations);
                        if (cs == null) {
                            for (ServerConditionalMutation scm : entry.getValue()) {
                                results.add(new TCMResult(scm.getID(), TCMStatus.IGNORED));
                            }
                            continue;
                        }
                        for (ServerConditionalMutation scm : entry.getValue()) {
                            results.add(new TCMResult(scm.getID(), TCMStatus.ACCEPTED));
                        }
                        if (durability != Durability.NONE) {
                            loggables.put(cs, new TabletMutations(cs, mutations, durability));
                        }
                        sendables.put(cs, mutations);
                    }
                    catch (TConstraintViolationException e) {
                        cs = e.getCommitSession();
                        if (e.getNonViolators().size() > 0) {
                            if (durability != Durability.NONE) {
                                loggables.put(cs, new TabletMutations(cs, e.getNonViolators(), durability));
                            }
                            sendables.put(cs, e.getNonViolators());
                            for (Mutation m : e.getNonViolators()) {
                                results.add(new TCMResult(((ServerConditionalMutation)m).getID(), TCMStatus.ACCEPTED));
                            }
                        }
                        for (Mutation m : e.getViolators()) {
                            results.add(new TCMResult(((ServerConditionalMutation)m).getID(), TCMStatus.VIOLATED));
                        }
                    }
                }
                t2 = System.currentTimeMillis();
                this.updateAvgPrepTime(t2 - t1, es.size());
            }
            try (TraceScope walSpan = Trace.startSpan((String)"wal");){
                while (loggables.size() > 0) {
                    try {
                        long t1 = System.currentTimeMillis();
                        TabletServer.this.logger.logManyTablets(loggables);
                        t2 = System.currentTimeMillis();
                        this.updateWalogWriteTime(t2 - t1);
                        break;
                    }
                    catch (IOException | FSError ex) {
                        log.warn("logging mutations failed, retrying");
                    }
                    catch (Throwable t) {
                        log.error("Unknown exception logging mutations, counts for mutations in flight not decremented!", t);
                        throw new RuntimeException(t);
                    }
                }
            }
            try (TraceScope commitSpan = Trace.startSpan((String)"commit");){
                long t1 = System.currentTimeMillis();
                sendables.forEach(CommitSession::commit);
                t2 = System.currentTimeMillis();
                this.updateAvgCommitTime(t2 - t1, sendables.size());
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<KeyExtent, List<ServerConditionalMutation>> conditionalUpdate(ConditionalSession cs, Map<KeyExtent, List<ServerConditionalMutation>> updates, ArrayList<TCMResult> results, List<String> symbols) throws IOException {
            ConditionalMutationSet.sortConditionalMutations(updates);
            HashMap<KeyExtent, List<ServerConditionalMutation>> deferred = new HashMap<KeyExtent, List<ServerConditionalMutation>>();
            ConditionalMutationSet.deferDuplicatesRows(updates, deferred);
            List<RowLocks.RowLock> locks = TabletServer.this.rowLocks.acquireRowlocks(updates, deferred);
            try {
                try (TraceScope checkSpan = Trace.startSpan((String)"Check conditions");){
                    this.checkConditions(updates, results, cs, symbols);
                }
                try (TraceScope updateSpan = Trace.startSpan((String)"apply conditional mutations");){
                    this.writeConditionalMutations(updates, results, cs);
                }
            }
            finally {
                TabletServer.this.rowLocks.releaseRowLocks(locks);
            }
            return deferred;
        }

        public TConditionalSession startConditionalUpdate(TInfo tinfo, TCredentials credentials, List<ByteBuffer> authorizations, String tableIdStr, TDurability tdurabilty, String classLoaderContext) throws ThriftSecurityException, TException {
            TableId tableId = TableId.of((String)tableIdStr);
            Authorizations userauths = null;
            NamespaceId namespaceId = this.getNamespaceId(credentials, tableId);
            if (!TabletServer.this.security.canConditionallyUpdate(credentials, tableId, namespaceId)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            userauths = TabletServer.this.security.getUserAuthorizations(credentials);
            for (ByteBuffer auth : authorizations) {
                if (userauths.contains(ByteBufferUtil.toBytes((ByteBuffer)auth))) continue;
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.BAD_AUTHORIZATIONS);
            }
            ConditionalSession cs = new ConditionalSession(credentials, new Authorizations(authorizations), tableId, DurabilityImpl.fromThrift((TDurability)tdurabilty));
            long sid = TabletServer.this.sessionManager.createSession(cs, false);
            return new TConditionalSession(sid, TabletServer.this.lockID, TabletServer.this.sessionManager.getMaxIdleTime());
        }

        public List<TCMResult> conditionalUpdate(TInfo tinfo, long sessID, Map<TKeyExtent, List<TConditionalMutation>> mutations, List<String> symbols) throws NoSuchScanIDException, TException {
            ConditionalSession cs = (ConditionalSession)TabletServer.this.sessionManager.reserveSession(sessID);
            if (cs == null || cs.interruptFlag.get()) {
                throw new NoSuchScanIDException();
            }
            if (!cs.tableId.equals((Object)MetadataTable.ID) && !cs.tableId.equals((Object)RootTable.ID)) {
                try {
                    TabletServer.this.resourceManager.waitUntilCommitsAreEnabled();
                }
                catch (HoldTimeoutException hte) {
                    log.debug("HoldTimeoutException during conditionalUpdate, reporting no such session");
                    throw new NoSuchScanIDException();
                }
            }
            TableId tid = cs.tableId;
            long opid = TabletServer.this.writeTracker.startWrite(TabletType.type((KeyExtent)new KeyExtent(tid, null, null)));
            try {
                Map updates = Translator.translate(mutations, (Translator)Translators.TKET, (Translator)new Translator.ListTranslator((Translator)ServerConditionalMutation.TCMT));
                for (KeyExtent ke : updates.keySet()) {
                    if (ke.getTableId().equals((Object)tid)) continue;
                    throw new IllegalArgumentException("Unexpected table id " + tid + " != " + ke.getTableId());
                }
                ArrayList<TCMResult> results = new ArrayList<TCMResult>();
                Map<KeyExtent, List<ServerConditionalMutation>> deferred = this.conditionalUpdate(cs, updates, results, symbols);
                while (deferred.size() > 0) {
                    deferred = this.conditionalUpdate(cs, deferred, results, symbols);
                }
                ArrayList<TCMResult> arrayList = results;
                return arrayList;
            }
            catch (IOException ioe) {
                throw new TException((Throwable)ioe);
            }
            finally {
                TabletServer.this.writeTracker.finishWrite(opid);
                TabletServer.this.sessionManager.unreserveSession(sessID);
            }
        }

        public void invalidateConditionalUpdate(TInfo tinfo, long sessID) {
            ConditionalSession cs = (ConditionalSession)TabletServer.this.sessionManager.getSession(sessID);
            if (cs != null) {
                cs.interruptFlag.set(true);
            }
            if ((cs = (ConditionalSession)TabletServer.this.sessionManager.reserveSession(sessID, true)) != null) {
                TabletServer.this.sessionManager.removeSession(sessID, true);
            }
        }

        public void closeConditionalUpdate(TInfo tinfo, long sessID) {
            TabletServer.this.sessionManager.removeSession(sessID, false);
        }

        public void splitTablet(TInfo tinfo, TCredentials credentials, TKeyExtent tkeyExtent, ByteBuffer splitPoint) throws NotServingTabletException, ThriftSecurityException {
            TableId tableId = TableId.of((String)new String(ByteBufferUtil.toBytes((ByteBuffer)tkeyExtent.table)));
            NamespaceId namespaceId = this.getNamespaceId(credentials, tableId);
            if (!TabletServer.this.security.canSplitTablet(credentials, tableId, namespaceId)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            KeyExtent keyExtent = new KeyExtent(tkeyExtent);
            Tablet tablet = TabletServer.this.getOnlineTablet(keyExtent);
            if (tablet == null) {
                throw new NotServingTabletException(tkeyExtent);
            }
            if (keyExtent.getEndRow() == null || !keyExtent.getEndRow().equals((Object)ByteBufferUtil.toText((ByteBuffer)splitPoint))) {
                try {
                    if (TabletServer.this.splitTablet(tablet, ByteBufferUtil.toBytes((ByteBuffer)splitPoint)) == null) {
                        throw new NotServingTabletException(tkeyExtent);
                    }
                }
                catch (IOException e) {
                    log.warn("Failed to split " + keyExtent, (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }

        public TabletServerStatus getTabletServerStatus(TInfo tinfo, TCredentials credentials) {
            return TabletServer.this.getStats(TabletServer.this.sessionManager.getActiveScansPerTable());
        }

        public List<TabletStats> getTabletStats(TInfo tinfo, TCredentials credentials, String tableId) {
            ArrayList<TabletStats> result = new ArrayList<TabletStats>();
            TableId text = TableId.of((String)tableId);
            KeyExtent start = new KeyExtent(text, new Text(), null);
            for (Map.Entry<KeyExtent, Tablet> entry : TabletServer.this.getOnlineTablets().tailMap(start).entrySet()) {
                KeyExtent ke = entry.getKey();
                if (ke.getTableId().compareTo((AbstractId)text) != 0) continue;
                Tablet tablet = entry.getValue();
                TabletStats stats = tablet.getTabletStats();
                stats.extent = ke.toThrift();
                stats.ingestRate = tablet.ingestRate();
                stats.queryRate = tablet.queryRate();
                stats.splitCreationTime = tablet.getSplitCreationTime();
                stats.numEntries = tablet.getNumEntries();
                result.add(stats);
            }
            return result;
        }

        private void checkPermission(TCredentials credentials, String lock, String request) throws ThriftSecurityException {
            try {
                log.trace("Got {} message from user: {}", (Object)request, (Object)credentials.getPrincipal());
                if (!TabletServer.this.security.canPerformSystemActions(credentials)) {
                    log.warn("Got {} message from user: {}", (Object)request, (Object)credentials.getPrincipal());
                    throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
            }
            catch (ThriftSecurityException e) {
                log.warn("Got {} message from unauthenticatable user: {}", (Object)request, (Object)e.getUser());
                if (TabletServer.this.getContext().getCredentials().getToken().getClass().getName().equals(credentials.getTokenClassName())) {
                    log.error("Got message from a service with a mismatched configuration. Please ensure a compatible configuration.", (Throwable)e);
                }
                throw e;
            }
            if (TabletServer.this.tabletServerLock == null || !TabletServer.this.tabletServerLock.wasLockAcquired()) {
                log.debug("Got {} message before my lock was acquired, ignoring...", (Object)request);
                throw new RuntimeException("Lock not acquired");
            }
            if (TabletServer.this.tabletServerLock != null && TabletServer.this.tabletServerLock.wasLockAcquired() && !TabletServer.this.tabletServerLock.isLocked()) {
                Halt.halt((int)1, () -> {
                    log.info("Tablet server no longer holds lock during checkPermission() : {}, exiting", (Object)request);
                    TabletServer.this.gcLogger.logGCInfo(TabletServer.this.getConfiguration());
                });
            }
            if (lock != null) {
                ZooUtil.LockID lid = new ZooUtil.LockID(TabletServer.this.getContext().getZooKeeperRoot() + "/masters/lock", lock);
                try {
                    if (!ZooLock.isLockHeld((ZooCache)TabletServer.this.masterLockCache, (ZooUtil.LockID)lid)) {
                        TabletServer.this.masterLockCache.clear();
                        if (!ZooLock.isLockHeld((ZooCache)TabletServer.this.masterLockCache, (ZooUtil.LockID)lid)) {
                            log.warn("Got {} message from a master that does not hold the current lock {}", (Object)request, (Object)lock);
                            throw new RuntimeException("bad master lock");
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("bad master lock", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadTablet(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent textent) {
            try {
                this.checkPermission(credentials, lock, "loadTablet");
            }
            catch (ThriftSecurityException e) {
                log.error("Caller doesn't have permission to load a tablet", (Throwable)e);
                throw new RuntimeException(e);
            }
            final KeyExtent extent = new KeyExtent(textent);
            SortedSet sortedSet = TabletServer.this.unopenedTablets;
            synchronized (sortedSet) {
                SortedSet sortedSet2 = TabletServer.this.openingTablets;
                synchronized (sortedSet2) {
                    OnlineTablets onlineTablets = TabletServer.this.onlineTablets;
                    synchronized (onlineTablets) {
                        Set unopenedOverlapping = KeyExtent.findOverlapping((KeyExtent)extent, (SortedSet)TabletServer.this.unopenedTablets);
                        Set openingOverlapping = KeyExtent.findOverlapping((KeyExtent)extent, (SortedSet)TabletServer.this.openingTablets);
                        Set onlineOverlapping = KeyExtent.findOverlapping((KeyExtent)extent, TabletServer.this.onlineTablets.snapshot());
                        HashSet all = new HashSet();
                        all.addAll(unopenedOverlapping);
                        all.addAll(openingOverlapping);
                        all.addAll(onlineOverlapping);
                        if (!all.isEmpty()) {
                            for (KeyExtent e2 : onlineOverlapping) {
                                Tablet tablet = TabletServer.this.getOnlineTablet(e2);
                                if (System.currentTimeMillis() - tablet.getSplitCreationTime() >= 60000L) continue;
                                all.remove(e2);
                            }
                            all.remove(extent);
                            if (all.size() > 0) {
                                log.error("Tablet {} overlaps previously assigned {} {} {}", new Object[]{extent, unopenedOverlapping, openingOverlapping, onlineOverlapping + " " + all});
                            }
                            return;
                        }
                        TabletServer.this.unopenedTablets.add(extent);
                    }
                }
            }
            log.info("Loading tablet {}", (Object)extent);
            final AssignmentHandler ah = new AssignmentHandler(extent);
            if (extent.isRootTablet()) {
                new Daemon("Root Tablet Assignment"){

                    public void run() {
                        ah.run();
                        if (TabletServer.this.onlineTablets.snapshot().containsKey((Object)extent)) {
                            log.info("Root tablet loaded: {}", (Object)extent);
                        } else {
                            log.info("Root tablet failed to load");
                        }
                    }
                }.start();
            } else if (extent.isMeta()) {
                TabletServer.this.resourceManager.addMetaDataAssignment(extent, log, ah);
            } else {
                TabletServer.this.resourceManager.addAssignment(extent, log, ah);
            }
        }

        public void unloadTablet(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent textent, TUnloadTabletGoal goal, long requestTime) {
            try {
                this.checkPermission(credentials, lock, "unloadTablet");
            }
            catch (ThriftSecurityException e) {
                log.error("Caller doesn't have permission to unload a tablet", (Throwable)e);
                throw new RuntimeException(e);
            }
            KeyExtent extent = new KeyExtent(textent);
            TabletServer.this.resourceManager.addMigration(extent, (Runnable)new LoggingRunnable(log, (Runnable)new UnloadTabletHandler(extent, goal, requestTime)));
        }

        public void flush(TInfo tinfo, TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow) {
            try {
                this.checkPermission(credentials, lock, "flush");
            }
            catch (ThriftSecurityException e) {
                log.error("Caller doesn't have permission to flush a table", (Throwable)e);
                throw new RuntimeException(e);
            }
            ArrayList<Tablet> tabletsToFlush = new ArrayList<Tablet>();
            KeyExtent ke = new KeyExtent(TableId.of((String)tableId), ByteBufferUtil.toText((ByteBuffer)endRow), ByteBufferUtil.toText((ByteBuffer)startRow));
            for (Tablet tablet : TabletServer.this.getOnlineTablets().values()) {
                if (!ke.overlaps(tablet.getExtent())) continue;
                tabletsToFlush.add(tablet);
            }
            Long flushID = null;
            for (Tablet tablet : tabletsToFlush) {
                if (flushID == null) {
                    try {
                        flushID = tablet.getFlushID();
                    }
                    catch (KeeperException.NoNodeException e) {
                        log.info("Asked to flush table that has no flush id {} {}", (Object)ke, (Object)e.getMessage());
                        return;
                    }
                }
                tablet.flush(flushID);
            }
        }

        public void flushTablet(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent textent) {
            try {
                this.checkPermission(credentials, lock, "flushTablet");
            }
            catch (ThriftSecurityException e) {
                log.error("Caller doesn't have permission to flush a tablet", (Throwable)e);
                throw new RuntimeException(e);
            }
            Tablet tablet = TabletServer.this.getOnlineTablet(new KeyExtent(textent));
            if (tablet != null) {
                log.info("Flushing {}", (Object)tablet.getExtent());
                try {
                    tablet.flush(tablet.getFlushID());
                }
                catch (KeeperException.NoNodeException nne) {
                    log.info("Asked to flush tablet that has no flush id {} {}", (Object)new KeyExtent(textent), (Object)nne.getMessage());
                }
            }
        }

        public void halt(TInfo tinfo, TCredentials credentials, String lock) throws ThriftSecurityException {
            this.checkPermission(credentials, lock, "halt");
            Halt.halt((int)0, () -> {
                log.info("Master requested tablet server halt");
                TabletServer.this.gcLogger.logGCInfo(TabletServer.this.getConfiguration());
                TabletServer.this.serverStopRequested = true;
                try {
                    TabletServer.this.tabletServerLock.unlock();
                }
                catch (Exception e) {
                    log.error("Caught exception unlocking TabletServer lock", (Throwable)e);
                }
            });
        }

        public void fastHalt(TInfo info, TCredentials credentials, String lock) {
            try {
                this.halt(info, credentials, lock);
            }
            catch (Exception e) {
                log.warn("Error halting", (Throwable)e);
            }
        }

        public TabletStats getHistoricalStats(TInfo tinfo, TCredentials credentials) {
            return TabletServer.this.statsKeeper.getTabletStats();
        }

        public List<ActiveScan> getActiveScans(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            try {
                this.checkPermission(credentials, null, "getScans");
            }
            catch (ThriftSecurityException e) {
                log.error("Caller doesn't have permission to get active scans", (Throwable)e);
                throw e;
            }
            return TabletServer.this.sessionManager.getActiveScans();
        }

        public void chop(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent textent) {
            try {
                this.checkPermission(credentials, lock, "chop");
            }
            catch (ThriftSecurityException e) {
                log.error("Caller doesn't have permission to chop extent", (Throwable)e);
                throw new RuntimeException(e);
            }
            KeyExtent ke = new KeyExtent(textent);
            Tablet tablet = TabletServer.this.getOnlineTablet(ke);
            if (tablet != null) {
                tablet.chopFiles();
            }
        }

        public void compact(TInfo tinfo, TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow) {
            try {
                this.checkPermission(credentials, lock, "compact");
            }
            catch (ThriftSecurityException e) {
                log.error("Caller doesn't have permission to compact a table", (Throwable)e);
                throw new RuntimeException(e);
            }
            KeyExtent ke = new KeyExtent(TableId.of((String)tableId), ByteBufferUtil.toText((ByteBuffer)endRow), ByteBufferUtil.toText((ByteBuffer)startRow));
            ArrayList<Tablet> tabletsToCompact = new ArrayList<Tablet>();
            for (Tablet tablet : TabletServer.this.getOnlineTablets().values()) {
                if (!ke.overlaps(tablet.getExtent())) continue;
                tabletsToCompact.add(tablet);
            }
            Pair<Long, UserCompactionConfig> compactionInfo = null;
            for (Tablet tablet : tabletsToCompact) {
                if (compactionInfo == null) {
                    try {
                        compactionInfo = tablet.getCompactionID();
                    }
                    catch (KeeperException.NoNodeException e) {
                        log.info("Asked to compact table with no compaction id {} {}", (Object)ke, (Object)e.getMessage());
                        return;
                    }
                }
                tablet.compactAll((Long)compactionInfo.getFirst(), (UserCompactionConfig)compactionInfo.getSecond());
            }
        }

        public List<ActiveCompaction> getActiveCompactions(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            try {
                this.checkPermission(credentials, null, "getActiveCompactions");
            }
            catch (ThriftSecurityException e) {
                log.error("Caller doesn't have permission to get active compactions", (Throwable)e);
                throw e;
            }
            List<CompactionInfo> compactions = Compactor.getRunningCompactions();
            ArrayList<ActiveCompaction> ret = new ArrayList<ActiveCompaction>(compactions.size());
            for (CompactionInfo compactionInfo : compactions) {
                ret.add(compactionInfo.toThrift());
            }
            return ret;
        }

        public List<String> getActiveLogs(TInfo tinfo, TCredentials credentials) {
            String log = TabletServer.this.logger.getLogFile();
            if (log == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(log);
        }

        public void removeLogs(TInfo tinfo, TCredentials credentials, List<String> filenames) {
            log.warn("Garbage collector is attempting to remove logs through the tablet server");
            log.warn("This is probably because your file Garbage Collector is an older version than your tablet servers.\nRestart your file Garbage Collector.");
        }

        private TSummaries getSummaries(Future<SummaryCollection> future) throws TimeoutException {
            try {
                SummaryCollection sc = future.get(1000L, TimeUnit.MILLISECONDS);
                return sc.toThrift();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private TSummaries handleTimeout(long sessionId) {
            long timeout = TabletServer.this.getConfiguration().getTimeInMillis(Property.TSERV_CLIENT_TIMEOUT);
            TabletServer.this.sessionManager.removeIfNotAccessed(sessionId, timeout);
            return new TSummaries(false, sessionId, -1L, -1L, null);
        }

        private TSummaries startSummaryOperation(TCredentials credentials, Future<SummaryCollection> future) {
            try {
                return this.getSummaries(future);
            }
            catch (TimeoutException e) {
                long sid = TabletServer.this.sessionManager.createSession(new SummarySession(credentials, future), false);
                while (sid == 0L) {
                    TabletServer.this.sessionManager.removeSession(sid);
                    sid = TabletServer.this.sessionManager.createSession(new SummarySession(credentials, future), false);
                }
                return this.handleTimeout(sid);
            }
        }

        public TSummaries startGetSummaries(TInfo tinfo, TCredentials credentials, TSummaryRequest request) throws ThriftSecurityException, ThriftTableOperationException, TException {
            NamespaceId namespaceId;
            TableId tableId = TableId.of((String)request.getTableId());
            try {
                namespaceId = Tables.getNamespaceId((ClientContext)TabletServer.this.getContext(), (TableId)tableId);
            }
            catch (TableNotFoundException e1) {
                throw new ThriftTableOperationException(tableId.canonical(), null, null, TableOperationExceptionType.NOTFOUND, null);
            }
            if (!TabletServer.this.security.canGetSummaries(credentials, tableId, namespaceId)) {
                throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
            }
            ServerConfigurationFactory factory = TabletServer.this.getContext().getServerConfFactory();
            ExecutorService es = TabletServer.this.resourceManager.getSummaryPartitionExecutor();
            Future future = new Gatherer((ClientContext)TabletServer.this.getContext(), request, (AccumuloConfiguration)factory.getTableConfiguration(tableId), TabletServer.this.getContext().getCryptoService()).gather(es);
            return this.startSummaryOperation(credentials, future);
        }

        public TSummaries startGetSummariesForPartition(TInfo tinfo, TCredentials credentials, TSummaryRequest request, int modulus, int remainder) throws ThriftSecurityException, TException {
            if (!TabletServer.this.security.canPerformSystemActions(credentials)) {
                throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
            }
            ServerConfigurationFactory factory = TabletServer.this.getContext().getServerConfFactory();
            ExecutorService spe = TabletServer.this.resourceManager.getSummaryRemoteExecutor();
            Future future = new Gatherer((ClientContext)TabletServer.this.getContext(), request, (AccumuloConfiguration)factory.getTableConfiguration(TableId.of((String)request.getTableId())), TabletServer.this.getContext().getCryptoService()).processPartition(spe, modulus, remainder);
            return this.startSummaryOperation(credentials, future);
        }

        public TSummaries startGetSummariesFromFiles(TInfo tinfo, TCredentials credentials, TSummaryRequest request, Map<String, List<TRowRange>> files) throws ThriftSecurityException, TException {
            if (!TabletServer.this.security.canPerformSystemActions(credentials)) {
                throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
            }
            ExecutorService srp = TabletServer.this.resourceManager.getSummaryRetrievalExecutor();
            TableConfiguration tableCfg = TabletServer.this.confFactory.getTableConfiguration(TableId.of((String)request.getTableId()));
            BlockCache summaryCache = TabletServer.this.resourceManager.getSummaryCache();
            BlockCache indexCache = TabletServer.this.resourceManager.getIndexCache();
            Cache<String, Long> fileLenCache = TabletServer.this.resourceManager.getFileLenCache();
            Gatherer.FileSystemResolver volMgr = p -> TabletServer.this.fs.getVolumeByPath(p).getFileSystem();
            Future future = new Gatherer((ClientContext)TabletServer.this.getContext(), request, (AccumuloConfiguration)tableCfg, TabletServer.this.getContext().getCryptoService()).processFiles(volMgr, files, summaryCache, indexCache, fileLenCache, srp);
            return this.startSummaryOperation(credentials, future);
        }

        public TSummaries contiuneGetSummaries(TInfo tinfo, long sessionId) throws NoSuchScanIDException, TException {
            SummarySession session = (SummarySession)TabletServer.this.sessionManager.getSession(sessionId);
            if (session == null) {
                throw new NoSuchScanIDException();
            }
            Future<SummaryCollection> future = session.getFuture();
            try {
                TSummaries tsums = this.getSummaries(future);
                TabletServer.this.sessionManager.removeSession(sessionId);
                return tsums;
            }
            catch (TimeoutException e) {
                return this.handleTimeout(sessionId);
            }
        }
    }
}

