/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.constraints;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.constraints.Constraint;
import org.apache.accumulo.core.constraints.Violations;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.dataImpl.ComparableBytes;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.tserver.constraints.SystemConstraint;
import org.apache.accumulo.tserver.constraints.UnsatisfiableConstraint;
import org.apache.hadoop.io.BinaryComparable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintChecker {
    private ArrayList<Constraint> constrains;
    private static final Logger log = LoggerFactory.getLogger(ConstraintChecker.class);
    private ClassLoader loader;
    private TableConfiguration conf;
    private AtomicLong lastCheck = new AtomicLong(0L);

    public ConstraintChecker(TableConfiguration conf) {
        this.constrains = new ArrayList();
        this.conf = conf;
        try {
            String context = conf.get(Property.TABLE_CLASSPATH);
            this.loader = context != null && !context.equals("") ? AccumuloVFSClassLoader.getContextManager().getClassLoader(context) : AccumuloVFSClassLoader.getClassLoader();
            for (Map.Entry entry : conf) {
                if (!((String)entry.getKey()).startsWith(Property.TABLE_CONSTRAINT_PREFIX.getKey())) continue;
                String className = (String)entry.getValue();
                Class<Constraint> clazz = this.loader.loadClass(className).asSubclass(Constraint.class);
                log.debug("Loaded constraint {} for {}", (Object)clazz.getName(), (Object)conf.getTableId());
                this.constrains.add(clazz.newInstance());
            }
            this.lastCheck.set(System.currentTimeMillis());
        }
        catch (Throwable e) {
            this.constrains.clear();
            this.loader = null;
            this.constrains.add(new UnsatisfiableConstraint(-1, "Failed to load constraints, not accepting mutations."));
            log.error("Failed to load constraints " + conf.getTableId() + " " + e, e);
        }
    }

    @VisibleForTesting
    ArrayList<Constraint> getConstraints() {
        return this.constrains;
    }

    public boolean classLoaderChanged() {
        if (this.constrains.size() == 0) {
            return false;
        }
        try {
            String context = this.conf.get(Property.TABLE_CLASSPATH);
            ClassLoader currentLoader = context != null && !context.equals("") ? AccumuloVFSClassLoader.getContextManager().getClassLoader(context) : AccumuloVFSClassLoader.getClassLoader();
            return currentLoader != this.loader;
        }
        catch (Exception e) {
            log.debug("Failed to check {}", (Object)e.getMessage());
            return true;
        }
    }

    private static Violations addViolation(Violations violations, ConstraintViolationSummary cvs) {
        if (violations == null) {
            violations = new Violations();
        }
        violations.add(cvs);
        return violations;
    }

    public Violations check(Constraint.Environment env, Mutation m) {
        if (!env.getExtent().contains((BinaryComparable)new ComparableBytes(m.getRow()))) {
            Violations violations = new Violations();
            ConstraintViolationSummary cvs = new ConstraintViolationSummary(SystemConstraint.class.getName(), -1, "Mutation outside of tablet extent", 1L);
            violations.add(cvs);
            return violations;
        }
        Violations violations = null;
        for (Constraint constraint : this.getConstraints()) {
            try {
                List violationCodes = constraint.check(env, m);
                if (violationCodes == null) continue;
                String className = constraint.getClass().getName();
                for (Short vcode : violationCodes) {
                    violations = ConstraintChecker.addViolation(violations, new ConstraintViolationSummary(className, vcode.shortValue(), constraint.getViolationDescription(vcode.shortValue()), 1L));
                }
            }
            catch (Throwable throwable) {
                String msg;
                short vcode;
                log.warn("CONSTRAINT FAILED : {}", (Object)throwable.getMessage(), (Object)throwable);
                if (throwable instanceof NullPointerException) {
                    vcode = -1;
                    msg = "threw NullPointerException";
                } else if (throwable instanceof ArrayIndexOutOfBoundsException) {
                    vcode = -2;
                    msg = "threw ArrayIndexOutOfBoundsException";
                } else if (throwable instanceof NumberFormatException) {
                    vcode = -3;
                    msg = "threw NumberFormatException";
                } else if (throwable instanceof IOException) {
                    vcode = -4;
                    msg = "threw IOException (or subclass of)";
                } else {
                    vcode = -100;
                    msg = "threw some Exception";
                }
                violations = ConstraintChecker.addViolation(violations, new ConstraintViolationSummary(constraint.getClass().getName(), vcode, "CONSTRAINT FAILED : " + msg, 1L));
            }
        }
        return violations;
    }
}

