/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.metrics;

import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.metrics.TServerMetrics;
import org.apache.accumulo.tserver.metrics.TabletServerMetricsUtil;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

public class TabletServerMetrics
extends TServerMetrics {
    private final TabletServerMetricsUtil util;
    private final MutableGaugeLong entries;
    private final MutableGaugeLong entriesInMemory;
    private final MutableGaugeLong activeMajcs;
    private final MutableGaugeLong queuedMajcs;
    private final MutableGaugeLong activeMincs;
    private final MutableGaugeLong queuedMincs;
    private final MutableGaugeLong onlineTablets;
    private final MutableGaugeLong openingTablets;
    private final MutableGaugeLong unopenedTablets;
    private final MutableGaugeLong queries;
    private final MutableGaugeLong totalMincs;

    public TabletServerMetrics(TabletServer tserver) {
        super("general");
        this.util = new TabletServerMetricsUtil(tserver);
        MetricsRegistry registry = super.getRegistry();
        this.entries = registry.newGauge("entries", "Number of entries", 0L);
        this.entriesInMemory = registry.newGauge("entriesInMem", "Number of entries in memory", 0L);
        this.activeMajcs = registry.newGauge("activeMajCs", "Number of active major compactions", 0L);
        this.queuedMajcs = registry.newGauge("queuedMajCs", "Number of queued major compactions", 0L);
        this.activeMincs = registry.newGauge("activeMinCs", "Number of active minor compactions", 0L);
        this.queuedMincs = registry.newGauge("queuedMinCs", "Number of queued minor compactions", 0L);
        this.onlineTablets = registry.newGauge("onlineTablets", "Number of online tablets", 0L);
        this.openingTablets = registry.newGauge("openingTablets", "Number of opening tablets", 0L);
        this.unopenedTablets = registry.newGauge("unopenedTablets", "Number of unopened tablets", 0L);
        this.queries = registry.newGauge("queries", "Number of queries", 0L);
        this.totalMincs = registry.newGauge("totalMinCs", "Total number of minor compactions performed", 0L);
    }

    protected void prepareMetrics() {
        this.entries.set(this.util.getEntries());
        this.entriesInMemory.set(this.util.getEntriesInMemory());
        this.activeMajcs.set((long)this.util.getMajorCompactions());
        this.queuedMajcs.set((long)this.util.getMajorCompactionsQueued());
        this.activeMincs.set((long)this.util.getMinorCompactions());
        this.queuedMincs.set((long)this.util.getMinorCompactionsQueued());
        this.onlineTablets.set((long)this.util.getOnlineCount());
        this.openingTablets.set((long)this.util.getOpeningCount());
        this.unopenedTablets.set((long)this.util.getUnopenedCount());
        this.queries.set(this.util.getQueries());
        this.totalMincs.set(this.util.getTotalMinorCompactions());
    }

    protected void getMoreMetrics(MetricsRecordBuilder builder, boolean all) {
        builder.addGauge(Interns.info((String)"filesPerTablet", (String)"Number of files per tablet"), this.util.getAverageFilesPerTablet());
        builder.addGauge(Interns.info((String)"holdTime", (String)"Time commits held"), this.util.getHoldTime());
        builder.addGauge(Interns.info((String)"ingestRate", (String)"Ingest rate (entries/sec)"), this.util.getIngest());
        builder.addGauge(Interns.info((String)"ingestByteRate", (String)"Ingest rate (bytes/sec)"), this.util.getIngestByteRate());
        builder.addGauge(Interns.info((String)"queryRate", (String)"Query rate (entries/sec)"), this.util.getQueryRate());
        builder.addGauge(Interns.info((String)"queryByteRate", (String)"Query rate (bytes/sec)"), this.util.getQueryByteRate());
        builder.addGauge(Interns.info((String)"scannedRate", (String)"Scanned rate"), this.util.getScannedRate());
    }
}

