/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.metrics;

import org.apache.accumulo.tserver.metrics.TServerMetrics;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableStat;

public class TabletServerUpdateMetrics
extends TServerMetrics {
    private final MutableCounterLong permissionErrorsCounter;
    private final MutableCounterLong unknownTabletErrorsCounter;
    private final MutableCounterLong constraintViolationsCounter;
    private final MutableStat commitPrepStat;
    private final MutableStat walogWriteTimeStat;
    private final MutableStat commitTimeStat;
    private final MutableStat mutationArraySizeStat;

    public TabletServerUpdateMetrics() {
        super("Updates");
        MetricsRegistry registry = super.getRegistry();
        this.permissionErrorsCounter = registry.newCounter("permissionErrors", "Permission Errors", 0L);
        this.unknownTabletErrorsCounter = registry.newCounter("unknownTabletErrors", "Unknown Tablet Errors", 0L);
        this.constraintViolationsCounter = registry.newCounter("constraintViolations", "Table Constraint Violations", 0L);
        this.commitPrepStat = registry.newStat("commitPrep", "preparing to commit mutations", "Ops", "Time", true);
        this.walogWriteTimeStat = registry.newStat("waLogWriteTime", "writing mutations to WAL", "Ops", "Time", true);
        this.commitTimeStat = registry.newStat("commitTime", "committing mutations", "Ops", "Time", true);
        this.mutationArraySizeStat = registry.newStat("mutationArraysSize", "mutation array", "ops", "Size", true);
    }

    public void addPermissionErrors(long value) {
        this.permissionErrorsCounter.incr(value);
    }

    public void addUnknownTabletErrors(long value) {
        this.unknownTabletErrorsCounter.incr(value);
    }

    public void addMutationArraySize(long value) {
        this.mutationArraySizeStat.add(value);
    }

    public void addCommitPrep(long value) {
        this.commitPrepStat.add(value);
    }

    public void addConstraintViolations(long value) {
        this.constraintViolationsCounter.incr(value);
    }

    public void addWalogWriteTime(long value) {
        this.walogWriteTimeStat.add(value);
    }

    public void addCommitTime(long value) {
        this.commitTimeStat.add(value);
    }
}

