/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.metrics;

import com.google.common.collect.Sets;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.spi.compaction.CompactionExecutorId;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.tserver.compactions.CompactionManager;

public class CompactionExecutorsMetrics
implements MetricsProducer {
    private volatile Supplier<Collection<CompactionManager.ExtCompMetric>> externalMetricsSupplier;
    private volatile List<CeMetrics> ceMetricsList = List.of();
    private final Map<CompactionExecutorId, CeMetrics> ceMetricsMap = new HashMap<CompactionExecutorId, CeMetrics>();
    private final Map<CompactionExecutorId, ExMetrics> exCeMetricsMap = new HashMap<CompactionExecutorId, ExMetrics>();
    private MeterRegistry registry = null;

    public CompactionExecutorsMetrics() {
        this.startUpdateThread();
    }

    protected void startUpdateThread() {
        ScheduledThreadPoolExecutor scheduler = ThreadPools.getServerThreadPools().createScheduledExecutorService(1, "compactionExecutorsMetricsPoller", false);
        Runtime.getRuntime().addShutdownHook(new Thread(scheduler::shutdownNow));
        long minimumRefreshDelay = TimeUnit.SECONDS.toMillis(5L);
        ThreadPools.watchNonCriticalScheduledTask(scheduler.scheduleAtFixedRate(this::update, minimumRefreshDelay, minimumRefreshDelay, TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CeMetrics addExecutor(CompactionExecutorId ceid, IntSupplier runningSupplier, IntSupplier queuedSupplier) {
        Map<CompactionExecutorId, CeMetrics> map = this.ceMetricsMap;
        synchronized (map) {
            CeMetrics cem = this.ceMetricsMap.computeIfAbsent(ceid, id -> {
                CeMetrics m = new CeMetrics();
                if (this.registry != null) {
                    m.queued = (AtomicInteger)this.registry.gauge("accumulo.tserver.compactions.majc.queued", (Iterable)Tags.of((String)"id", (String)ceid.canonical()), (Number)new AtomicInteger(0));
                    m.running = (AtomicInteger)this.registry.gauge("accumulo.tserver.compactions.majc.running", (Iterable)Tags.of((String)"id", (String)ceid.canonical()), (Number)new AtomicInteger(0));
                }
                return m;
            });
            cem.runningSupplier = runningSupplier;
            cem.queuedSupplier = queuedSupplier;
            this.ceMetricsList = List.copyOf(this.ceMetricsMap.values());
            return cem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        if (this.externalMetricsSupplier != null) {
            HashSet seenIds = new HashSet();
            Map<CompactionExecutorId, ExMetrics> map = this.exCeMetricsMap;
            synchronized (map) {
                this.externalMetricsSupplier.get().forEach(ecm -> {
                    seenIds.add(ecm.ceid);
                    ExMetrics exm = this.exCeMetricsMap.computeIfAbsent(ecm.ceid, id -> {
                        ExMetrics m = new ExMetrics();
                        if (this.registry != null) {
                            m.queued = (AtomicInteger)this.registry.gauge("accumulo.tserver.compactions.majc.queued", (Iterable)Tags.of((String)"id", (String)ecm.ceid.canonical()), (Number)new AtomicInteger(0));
                            m.running = (AtomicInteger)this.registry.gauge("accumulo.tserver.compactions.majc.running", (Iterable)Tags.of((String)"id", (String)ecm.ceid.canonical()), (Number)new AtomicInteger(0));
                        }
                        return m;
                    });
                    exm.queued.set(ecm.queued);
                    exm.running.set(ecm.running);
                });
                Sets.difference(this.exCeMetricsMap.keySet(), seenIds).forEach(unusedId -> {
                    ExMetrics exm = this.exCeMetricsMap.get(unusedId);
                    exm.queued.set(0);
                    exm.running.set(0);
                });
            }
        }
        this.ceMetricsList.forEach(cem -> {
            cem.running.set(cem.runningSupplier.getAsInt());
            cem.queued.set(cem.queuedSupplier.getAsInt());
        });
    }

    public void setExternalMetricsSupplier(Supplier<Collection<CompactionManager.ExtCompMetric>> ems) {
        this.externalMetricsSupplier = ems;
    }

    public void registerMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    private static class ExMetrics {
        AtomicInteger queued;
        AtomicInteger running;

        private ExMetrics() {
        }
    }

    public static class CeMetrics
    implements AutoCloseable {
        private AtomicInteger queued;
        private AtomicInteger running;
        private IntSupplier runningSupplier;
        private IntSupplier queuedSupplier;

        @Override
        public void close() {
            this.runningSupplier = () -> 0;
            this.queuedSupplier = () -> 0;
            this.running.set(0);
            this.queued.set(0);
        }
    }
}

