/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.replication;

import com.google.protobuf.GeneratedMessageV3;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.crypto.CryptoEnvironmentImpl;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.replication.thrift.ReplicationCoordinator;
import org.apache.accumulo.core.replication.thrift.ReplicationServicer;
import org.apache.accumulo.core.replication.thrift.WalEdits;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.singletons.SingletonReservation;
import org.apache.accumulo.core.spi.crypto.CryptoEnvironment;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.replication.ReplicaSystem;
import org.apache.accumulo.server.replication.ReplicaSystemHelper;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.tserver.log.DfsLogger;
import org.apache.accumulo.tserver.logger.LogFileKey;
import org.apache.accumulo.tserver.logger.LogFileValue;
import org.apache.accumulo.tserver.replication.ReplicationStats;
import org.apache.accumulo.tserver.replication.WalClientExecReturn;
import org.apache.accumulo.tserver.replication.WalReplication;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AccumuloReplicaSystem
implements ReplicaSystem {
    private static final Logger log = LoggerFactory.getLogger(AccumuloReplicaSystem.class);
    private static final String RFILE_SUFFIX = ".rf";
    private String instanceName;
    private String zookeepers;
    private AccumuloConfiguration conf;
    private ServerContext context;

    protected void setConf(AccumuloConfiguration conf) {
        this.conf = conf;
    }

    public static String buildConfiguration(String instanceName, String zookeepers) {
        return instanceName + "," + zookeepers;
    }

    public void configure(ServerContext context, String configuration) {
        Objects.requireNonNull(configuration);
        int index = configuration.indexOf(44);
        if (index == -1) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            throw new IllegalArgumentException("Expected comma in configuration string");
        }
        this.instanceName = configuration.substring(0, index);
        this.zookeepers = configuration.substring(index + 1);
        this.conf = context.getConfiguration();
        this.context = context;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path provided by admin")
    public Replication.Status replicate(Path p, Replication.Status status, ReplicationTarget target, ReplicaSystemHelper helper) {
        String password;
        File keytab;
        AccumuloConfiguration localConf = this.conf;
        log.debug("Replication RPC timeout is {}", (Object)localConf.get(Property.REPLICATION_RPC_TIMEOUT));
        String principal = this.getPrincipal(localConf, target);
        if (localConf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            String keytabPath = this.getKeytab(localConf, target);
            keytab = new File(keytabPath);
            if (!keytab.exists() || !keytab.isFile()) {
                log.error("{} is not a regular file. Cannot login to replicate", (Object)keytabPath);
                return status;
            }
            password = null;
        } else {
            keytab = null;
            password = this.getPassword(localConf, target);
        }
        if (keytab != null) {
            try {
                UserGroupInformation accumuloUgi = UserGroupInformation.getCurrentUser();
                UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytab.getAbsolutePath());
                return (Replication.Status)ugi.doAs(() -> {
                    KerberosToken token;
                    try {
                        token = new KerberosToken(principal, keytab);
                    }
                    catch (IOException e) {
                        log.error("Failed to create KerberosToken", (Throwable)e);
                        return status;
                    }
                    ClientContext peerContext = this.getContextForPeer(localConf, target, principal, (AuthenticationToken)token);
                    return this._replicate(p, status, target, helper, localConf, peerContext, accumuloUgi);
                });
            }
            catch (IOException e) {
                log.error("Failed to perform local login", (Throwable)e);
                return status;
            }
        }
        PasswordToken token = new PasswordToken((CharSequence)password);
        ClientContext peerContext = this.getContextForPeer(localConf, target, principal, (AuthenticationToken)token);
        return this._replicate(p, status, target, helper, localConf, peerContext, null);
    }

    /*
     * Exception decompiling
     */
    private Replication.Status _replicate(Path p, Replication.Status status, ReplicationTarget target, ReplicaSystemHelper helper, AccumuloConfiguration localConf, ClientContext peerContext, UserGroupInformation accumuloUgi) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 46[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Replication.Status replicateRFiles(ClientContext peerContext, HostAndPort peerTserver, ReplicationTarget target, Path p, Replication.Status status, long timeout) throws TTransportException, AccumuloException, AccumuloSecurityException {
        Replication.Status lastStatus = status;
        Replication.Status currentStatus = status;
        while (true) {
            ReplicationStats replResult = AccumuloReplicaSystem.executeServicerWithReturn(peerContext, peerTserver, new RFileClientExecReturn(), timeout);
            long newBegin = currentStatus.getBegin() + replResult.entriesConsumed;
            if (newBegin < 0L) {
                newBegin = Long.MAX_VALUE;
            }
            currentStatus = Replication.Status.newBuilder((Replication.Status)currentStatus).setBegin(newBegin).build();
            log.debug("Sent batch for replication of {} to {}, with new Status {}", new Object[]{p, target, ProtobufUtil.toString((GeneratedMessageV3)currentStatus)});
            if (currentStatus.equals((Object)lastStatus)) {
                log.debug("Did not replicate any new data for {} to {}, (state was {})", new Object[]{p, target, ProtobufUtil.toString((GeneratedMessageV3)lastStatus)});
                return status;
            }
            if (!StatusUtil.isWorkRequired((Replication.Status)currentStatus)) break;
            lastStatus = currentStatus;
        }
        return currentStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Replication.Status replicateLogs(ClientContext peerContext, HostAndPort peerTserver, ReplicationTarget target, Path p, Replication.Status status, long sizeLimit, String remoteTableId, TCredentials tcreds, ReplicaSystemHelper helper, UserGroupInformation accumuloUgi, long timeout) throws TTransportException, AccumuloException, AccumuloSecurityException {
        log.debug("Replication WAL to peer tserver");
        try {
            FSDataInputStream fsinput = this.context.getVolumeManager().open(p);
            try {
                DataInputStream input = this.getWalStream(p, fsinput);
                try {
                    Set<Integer> tids;
                    log.debug("Skipping unwanted data in WAL");
                    Span span = TraceUtil.startSpan(this.getClass(), (String)"replicateLogs::Consume WAL prefix");
                    try (Scope scope = span.makeCurrent();){
                        span.setAttribute("file", p.toString());
                        tids = this.consumeWalPrefix(target, input, status);
                    }
                    catch (IOException e) {
                        log.warn("Unexpected error consuming file.");
                        TraceUtil.setException((Span)span, (Throwable)e, (boolean)false);
                        Replication.Status status2 = status;
                        if (input != null) {
                            input.close();
                        }
                        if (fsinput == null) return status2;
                        fsinput.close();
                        return status2;
                    }
                    catch (RuntimeException e) {
                        TraceUtil.setException((Span)span, (Throwable)e, (boolean)true);
                        throw e;
                    }
                    finally {
                        span.end();
                    }
                    log.debug("Sending batches of data to peer tserver");
                    Replication.Status lastStatus = status;
                    Replication.Status currentStatus = status;
                    AtomicReference exceptionRef = new AtomicReference();
                    while (true) {
                        ReplicationStats replResult;
                        Span span2 = TraceUtil.startSpan(this.getClass(), (String)"replicateLogs::Replicate WAL batch");
                        try (Scope scope = span2.makeCurrent();){
                            span2.setAttribute("Batch size (bytes)", Long.toString(sizeLimit));
                            span2.setAttribute("File", p.toString());
                            span2.setAttribute("Peer instance name", peerContext.getInstanceName());
                            span2.setAttribute("Peer tserver", peerTserver.toString());
                            span2.setAttribute("Remote table ID", remoteTableId);
                            replResult = AccumuloReplicaSystem.executeServicerWithReturn(peerContext, peerTserver, new WalClientExecReturn(this, target, input, p, currentStatus, sizeLimit, remoteTableId, tcreds, tids), timeout);
                        }
                        catch (RuntimeException e) {
                            log.error("Caught exception replicating data to {} at {}", new Object[]{peerContext.getInstanceName(), peerTserver, e});
                            TraceUtil.setException((Span)span2, (Throwable)e, (boolean)true);
                            throw e;
                        }
                        finally {
                            span2.end();
                        }
                        long newBegin = currentStatus.getBegin() + replResult.entriesConsumed;
                        if (newBegin < 0L) {
                            newBegin = Long.MAX_VALUE;
                        }
                        currentStatus = Replication.Status.newBuilder((Replication.Status)currentStatus).setBegin(newBegin).build();
                        log.debug("Sent batch for replication of {} to {}, with new Status {}", new Object[]{p, target, ProtobufUtil.toString((GeneratedMessageV3)currentStatus)});
                        if (currentStatus.equals((Object)lastStatus)) {
                            log.debug("Did not replicate any new data for {} to {}, (state was {})", new Object[]{p, target, ProtobufUtil.toString((GeneratedMessageV3)lastStatus)});
                            Replication.Status status3 = status;
                            return status3;
                        }
                        Span span3 = TraceUtil.startSpan(this.getClass(), (String)"replicateLogs::Update replication table");
                        try (Scope scope = span3.makeCurrent();){
                            if (accumuloUgi != null) {
                                Replication.Status copy = currentStatus;
                                accumuloUgi.doAs(() -> {
                                    try {
                                        helper.recordNewStatus(p, copy, target);
                                    }
                                    catch (RuntimeException | AccumuloException | TableNotFoundException e) {
                                        exceptionRef.set(e);
                                    }
                                    return null;
                                });
                                Exception e = (Exception)exceptionRef.get();
                                if (e != null) {
                                    if (e instanceof TableNotFoundException) {
                                        throw (TableNotFoundException)((Object)e);
                                    }
                                    if (e instanceof AccumuloSecurityException) {
                                        throw (AccumuloSecurityException)((Object)e);
                                    }
                                    if (!(e instanceof AccumuloException)) throw new RuntimeException("Received unexpected exception", e);
                                    throw (AccumuloException)((Object)e);
                                }
                            } else {
                                helper.recordNewStatus(p, currentStatus, target);
                            }
                        }
                        catch (TableNotFoundException e) {
                            log.error("Tried to update status in replication table for {} as {}, but the table did not exist", new Object[]{p, ProtobufUtil.toString((GeneratedMessageV3)currentStatus), e});
                            TraceUtil.setException((Span)span3, (Throwable)e, (boolean)true);
                            throw new RuntimeException("Replication table did not exist, will retry", e);
                        }
                        catch (RuntimeException e) {
                            TraceUtil.setException((Span)span3, (Throwable)e, (boolean)true);
                            throw e;
                        }
                        finally {
                            span3.end();
                        }
                        log.debug("Recorded updated status for {}: {}", (Object)p, (Object)ProtobufUtil.toString((GeneratedMessageV3)currentStatus));
                        if (!StatusUtil.isWorkRequired((Replication.Status)currentStatus)) break;
                        lastStatus = currentStatus;
                    }
                    Replication.Status status4 = currentStatus;
                    return status4;
                }
                finally {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable lastStatus) {
                            Throwable span;
                            span.addSuppressed(lastStatus);
                        }
                    }
                }
            }
            finally {
                if (fsinput != null) {
                    try {
                        fsinput.close();
                    }
                    catch (Throwable span) {
                        Throwable input;
                        input.addSuppressed(span);
                    }
                }
            }
        }
        catch (DfsLogger.LogHeaderIncompleteException e) {
            log.warn("Could not read header from {}, assuming that there is no data present in the WAL, therefore replication is complete", (Object)p);
            Replication.Status newStatus = status.getInfiniteEnd() ? Replication.Status.newBuilder((Replication.Status)status).setBegin(Long.MAX_VALUE).build() : Replication.Status.newBuilder((Replication.Status)status).setBegin(status.getEnd()).build();
            Span span4 = TraceUtil.startSpan(this.getClass(), (String)"replicateLogs::Update replication table");
            try (Scope scope = span4.makeCurrent();){
                helper.recordNewStatus(p, newStatus, target);
                return newStatus;
            }
            catch (TableNotFoundException tnfe) {
                log.error("Tried to update status in replication table for {} as {}, but the table did not exist", new Object[]{p, ProtobufUtil.toString((GeneratedMessageV3)newStatus), e});
                TraceUtil.setException((Span)span4, (Throwable)e, (boolean)true);
                throw new RuntimeException("Replication table did not exist, will retry", e);
            }
            catch (RuntimeException ex) {
                TraceUtil.setException((Span)span4, (Throwable)e, (boolean)true);
                throw ex;
            }
            finally {
                span4.end();
            }
        }
        catch (IOException e) {
            log.error("Could not create stream for WAL", (Throwable)e);
            return status;
        }
    }

    protected String getPassword(AccumuloConfiguration localConf, ReplicationTarget target) {
        Objects.requireNonNull(localConf);
        Objects.requireNonNull(target);
        Map peerPasswords = localConf.getAllPropertiesWithPrefix(Property.REPLICATION_PEER_PASSWORD);
        String password = (String)peerPasswords.get(Property.REPLICATION_PEER_PASSWORD.getKey() + target.getPeerName());
        if (password == null) {
            throw new IllegalArgumentException("Cannot get password for " + target.getPeerName());
        }
        return password;
    }

    protected String getKeytab(AccumuloConfiguration localConf, ReplicationTarget target) {
        Objects.requireNonNull(localConf);
        Objects.requireNonNull(target);
        Map peerKeytabs = localConf.getAllPropertiesWithPrefix(Property.REPLICATION_PEER_KEYTAB);
        String keytab = (String)peerKeytabs.get(Property.REPLICATION_PEER_KEYTAB.getKey() + target.getPeerName());
        if (keytab == null) {
            throw new IllegalArgumentException("Cannot get keytab for " + target.getPeerName());
        }
        return keytab;
    }

    protected String getPrincipal(AccumuloConfiguration localConf, ReplicationTarget target) {
        Objects.requireNonNull(localConf);
        Objects.requireNonNull(target);
        String peerName = target.getPeerName();
        String userKey = Property.REPLICATION_PEER_USER.getKey() + peerName;
        Map peerUsers = localConf.getAllPropertiesWithPrefix(Property.REPLICATION_PEER_USER);
        String user = (String)peerUsers.get(userKey);
        if (user == null) {
            throw new IllegalArgumentException("Cannot get user for " + target.getPeerName());
        }
        return user;
    }

    protected ClientContext getContextForPeer(AccumuloConfiguration localConf, ReplicationTarget target, String principal, AuthenticationToken token) {
        Objects.requireNonNull(localConf);
        Objects.requireNonNull(target);
        Objects.requireNonNull(principal);
        Objects.requireNonNull(token);
        Properties properties = new Properties();
        properties.setProperty(ClientProperty.INSTANCE_NAME.getKey(), this.instanceName);
        properties.setProperty(ClientProperty.INSTANCE_ZOOKEEPERS.getKey(), this.zookeepers);
        properties.setProperty(ClientProperty.AUTH_PRINCIPAL.getKey(), principal);
        ClientProperty.setAuthenticationToken((Properties)properties, (AuthenticationToken)token);
        return new ClientContext(SingletonReservation.noop(), ClientInfo.from((Properties)properties, (AuthenticationToken)token), localConf, Threads.UEH);
    }

    protected Set<Integer> consumeWalPrefix(ReplicationTarget target, DataInputStream wal, Replication.Status status) throws IOException {
        LogFileKey key = new LogFileKey();
        LogFileValue value = new LogFileValue();
        HashSet<Integer> desiredTids = new HashSet<Integer>();
        block3: for (long i = 0L; i < status.getBegin(); ++i) {
            key.readFields(wal);
            value.readFields(wal);
            switch (key.event) {
                case DEFINE_TABLET: {
                    if (!target.getSourceTableId().equals((Object)key.tablet.tableId())) continue block3;
                    desiredTids.add(key.tabletId);
                    continue block3;
                }
            }
        }
        return desiredTids;
    }

    public DataInputStream getWalStream(Path p, FSDataInputStream input) throws DfsLogger.LogHeaderIncompleteException, IOException {
        Span span = TraceUtil.startSpan(this.getClass(), (String)"getWalStream::Read WAL header");
        try {
            DataInputStream dataInputStream;
            block11: {
                Scope scope = span.makeCurrent();
                try {
                    span.setAttribute("file", p.toString());
                    CryptoEnvironmentImpl env = new CryptoEnvironmentImpl(CryptoEnvironment.Scope.WAL);
                    dataInputStream = DfsLogger.getDecryptingStream(input, this.context.getCryptoFactory().getService((CryptoEnvironment)env, this.conf.getAllCryptoProperties()));
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        TraceUtil.setException((Span)span, (Throwable)e, (boolean)true);
                        throw e;
                    }
                }
                scope.close();
            }
            return dataInputStream;
        }
        finally {
            span.end();
        }
    }

    protected WalReplication getWalEdits(ReplicationTarget target, DataInputStream wal, Path p, Replication.Status status, long sizeLimit, Set<Integer> desiredTids) {
        WalEdits edits = new WalEdits();
        edits.edits = new ArrayList();
        long size = 0L;
        long entriesConsumed = 0L;
        long numUpdates = 0L;
        LogFileKey key = new LogFileKey();
        LogFileValue value = new LogFileValue();
        block19: while (size < sizeLimit) {
            try {
                key.readFields(wal);
                value.readFields(wal);
            }
            catch (EOFException e) {
                log.debug("Caught EOFException reading {}", (Object)p, (Object)e);
                if (!status.getInfiniteEnd() || !status.getClosed()) break;
                log.debug("{} is closed and has unknown length, assuming entire file has been consumed", (Object)p);
                entriesConsumed = Long.MAX_VALUE;
                break;
            }
            catch (IOException e) {
                log.debug("Unexpected IOException reading {}", (Object)p, (Object)e);
                throw new UncheckedIOException(e);
            }
            ++entriesConsumed;
            switch (key.event) {
                case DEFINE_TABLET: {
                    if (!target.getSourceTableId().equals((Object)key.tablet.tableId())) continue block19;
                    desiredTids.add(key.tabletId);
                    continue block19;
                }
                case MUTATION: 
                case MANY_MUTATIONS: {
                    byte[] data;
                    if (!desiredTids.contains(key.tabletId)) continue block19;
                    try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                         DataOutputStream out = new DataOutputStream(baos);){
                        key.write(out);
                        numUpdates += this.writeValueAvoidingReplicationCycles(out, value, target);
                        out.flush();
                        data = baos.toByteArray();
                    }
                    catch (IOException e) {
                        log.debug("Unexpected IOException writing to a byte array output stream", (Throwable)e);
                        throw new UncheckedIOException(e);
                    }
                    size += (long)data.length;
                    edits.addToEdits(ByteBuffer.wrap(data));
                    continue block19;
                }
            }
            log.trace("Ignoring WAL entry which doesn't contain mutations, should not have received such entries");
        }
        return new WalReplication(edits, size, entriesConsumed, numUpdates);
    }

    protected long writeValueAvoidingReplicationCycles(DataOutputStream out, LogFileValue value, ReplicationTarget target) throws IOException {
        String name;
        int mutationsToSend = 0;
        for (Mutation m : value.mutations) {
            if (m.getReplicationSources().contains(target.getPeerName())) continue;
            ++mutationsToSend;
        }
        int mutationsRemoved = value.mutations.size() - mutationsToSend;
        if (mutationsRemoved > 0) {
            log.debug("Removing {} mutations from WAL entry as they have already been replicated to {}", (Object)mutationsRemoved, (Object)target.getPeerName());
        }
        if ((name = this.conf.get(Property.REPLICATION_NAME)).isBlank()) {
            throw new IllegalArgumentException("Local system has no replication name configured");
        }
        out.writeInt(mutationsToSend);
        for (Mutation m : value.mutations) {
            if (m.getReplicationSources().contains(target.getPeerName())) continue;
            m.addReplicationSource(name);
            m.write((DataOutput)out);
        }
        return mutationsToSend;
    }

    private static <T> T executeServicerWithReturn(ClientContext context, HostAndPort tserver, ThriftClientTypes.Exec<T, ReplicationServicer.Client> exec, long timeout) throws AccumuloException, AccumuloSecurityException {
        ReplicationServicer.Client client = null;
        try {
            client = (ReplicationServicer.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.REPLICATION_SERVICER, (HostAndPort)tserver, (ClientContext)context, (long)timeout);
            Object object = exec.execute((Object)client);
            return (T)object;
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)e);
        }
        catch (TException e) {
            throw new AccumuloException((Throwable)e);
        }
        finally {
            if (client != null) {
                ThriftUtil.close((TServiceClient)client, (ClientContext)context);
            }
        }
    }

    private static /* synthetic */ String lambda$_replicate$1(String remoteTableId, ClientContext peerContext, ReplicationCoordinator.Client client) throws TException {
        return client.getServicerAddress(remoteTableId, peerContext.rpcCreds());
    }

    @Deprecated
    protected static class RFileClientExecReturn
    implements ThriftClientTypes.Exec<ReplicationStats, ReplicationServicer.Client> {
        protected RFileClientExecReturn() {
        }

        public ReplicationStats execute(ReplicationServicer.Client client) {
            return new ReplicationStats(0L, 0L, 0L);
        }
    }
}

