/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.session;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.thrift.MultiScanResult;
import org.apache.accumulo.core.tabletserver.thrift.ActiveScan;
import org.apache.accumulo.core.tabletserver.thrift.ScanState;
import org.apache.accumulo.core.tabletserver.thrift.ScanType;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.core.util.Retry;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.tserver.scan.ScanParameters;
import org.apache.accumulo.tserver.scan.ScanRunState;
import org.apache.accumulo.tserver.scan.ScanTask;
import org.apache.accumulo.tserver.session.MultiScanSession;
import org.apache.accumulo.tserver.session.Session;
import org.apache.accumulo.tserver.session.SingleScanSession;
import org.apache.accumulo.tserver.session.UpdateSession;
import org.apache.accumulo.tserver.tablet.ScanBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    private static final Logger log = LoggerFactory.getLogger(SessionManager.class);
    private static final SecureRandom random = new SecureRandom();
    private final ConcurrentMap<Long, Session> sessions = new ConcurrentHashMap<Long, Session>();
    private final long maxIdle;
    private final long maxUpdateIdle;
    private final BlockingQueue<Session> deferredCleanupQueue = new ArrayBlockingQueue<Session>(5000);
    private final Long expiredSessionMarker = -1L;
    private final AccumuloConfiguration aconf;
    private final ServerContext ctx;

    public SessionManager(ServerContext context) {
        this.ctx = context;
        this.aconf = context.getConfiguration();
        this.maxUpdateIdle = this.aconf.getTimeInMillis(Property.TSERV_UPDATE_SESSION_MAXIDLE);
        this.maxIdle = this.aconf.getTimeInMillis(Property.TSERV_SESSION_MAXIDLE);
        Runnable r = () -> this.sweep(this.maxIdle, this.maxUpdateIdle);
        ThreadPools.watchCriticalScheduledTask(context.getScheduledExecutor().scheduleWithFixedDelay(r, 0L, Math.max(this.maxIdle / 2L, 1000L), TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createSession(Session session, boolean reserve) {
        long sid = random.nextLong();
        Session session2 = session;
        synchronized (session2) {
            Preconditions.checkArgument((session.state == Session.State.NEW ? 1 : 0) != 0);
            session.state = reserve ? Session.State.RESERVED : Session.State.UNRESERVED;
            session.startTime = session.lastAccessTime = System.currentTimeMillis();
        }
        while (this.sessions.putIfAbsent(sid, session) != null) {
            sid = random.nextLong();
        }
        return sid;
    }

    public long getMaxIdleTime() {
        return this.maxIdle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session reserveSession(long sessionId) {
        Session session = (Session)this.sessions.get(sessionId);
        if (session != null) {
            Session session2 = session;
            synchronized (session2) {
                if (session.state == Session.State.RESERVED) {
                    throw new IllegalStateException("Attempted to reserved session that is already reserved " + sessionId);
                }
                if (session.state == Session.State.REMOVED) {
                    return null;
                }
                session.state = Session.State.RESERVED;
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session reserveSession(long sessionId, boolean wait) {
        Session session = (Session)this.sessions.get(sessionId);
        if (session != null) {
            Session session2 = session;
            synchronized (session2) {
                if (session.state == Session.State.REMOVED) {
                    return null;
                }
                while (wait && session.state == Session.State.RESERVED) {
                    try {
                        session.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException();
                    }
                }
                if (session.state == Session.State.RESERVED) {
                    throw new IllegalStateException("Attempted to reserved session that is already reserved " + sessionId);
                }
                if (session.state == Session.State.REMOVED) {
                    return null;
                }
                session.state = Session.State.RESERVED;
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unreserveSession(Session session) {
        Session session2 = session;
        synchronized (session2) {
            if (session.state == Session.State.REMOVED) {
                return;
            }
            if (session.state != Session.State.RESERVED) {
                throw new IllegalStateException("Cannon unreserve, state: " + session.state);
            }
            session.notifyAll();
            session.state = Session.State.UNRESERVED;
            session.lastAccessTime = System.currentTimeMillis();
        }
    }

    public void unreserveSession(long sessionId) {
        Session session = this.getSession(sessionId);
        if (session != null) {
            this.unreserveSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(long sessionId) {
        Session session = (Session)this.sessions.get(sessionId);
        if (session != null) {
            Session session2 = session;
            synchronized (session2) {
                if (session.state == Session.State.REMOVED) {
                    return null;
                }
                session.lastAccessTime = System.currentTimeMillis();
            }
        }
        return session;
    }

    public Session removeSession(long sessionId) {
        return this.removeSession(sessionId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session removeSession(long sessionId, boolean unreserve) {
        Session session = (Session)this.sessions.remove(sessionId);
        if (session != null) {
            boolean doCleanup = false;
            Session session2 = session;
            synchronized (session2) {
                if (session.state != Session.State.REMOVED) {
                    if (unreserve) {
                        this.unreserveSession(session);
                    }
                    doCleanup = true;
                    session.state = Session.State.REMOVED;
                }
            }
            if (doCleanup) {
                this.cleanup(session);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeIfNotReserved(long sessionId) {
        Session session = (Session)this.sessions.get(sessionId);
        if (session == null) {
            return true;
        }
        boolean removed = false;
        Session session2 = session;
        synchronized (session2) {
            if (session.state == Session.State.RESERVED) {
                return false;
            }
            session.state = Session.State.REMOVED;
            removed = true;
        }
        if (removed) {
            this.sessions.remove(sessionId);
        }
        return removed;
    }

    static void cleanup(BlockingQueue<Session> deferredCleanupQueue, Session session) {
        if (!session.cleanup()) {
            Retry retry = Retry.builder().infiniteRetries().retryAfter(25L, TimeUnit.MILLISECONDS).incrementBy(25L, TimeUnit.MILLISECONDS).maxWait(5L, TimeUnit.SECONDS).backOffFactor(1.5).logInterval(1L, TimeUnit.MINUTES).createRetry();
            while (!deferredCleanupQueue.offer(session) && !session.cleanup()) {
                try {
                    retry.waitForNextAttempt(log, "Unable to cleanup session or defer cleanup " + session);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                retry.logRetry(log, "Unable to cleanup session or defer cleanup " + session);
            }
            retry.logCompletion(log, "Cleaned up session or deferred cleanup " + session);
        }
    }

    private void cleanup(Session session) {
        SessionManager.cleanup(this.deferredCleanupQueue, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sweep(long maxIdle, long maxUpdateIdle) {
        LinkedList<Session> sessionsToCleanup = new LinkedList<Session>();
        Iterator iter = this.sessions.values().iterator();
        while (iter.hasNext()) {
            Session session;
            Session session2 = session = (Session)iter.next();
            synchronized (session2) {
                if (session.state == Session.State.UNRESERVED) {
                    long idleTime;
                    long configuredIdle = maxIdle;
                    if (session instanceof UpdateSession) {
                        configuredIdle = maxUpdateIdle;
                    }
                    if ((idleTime = System.currentTimeMillis() - session.lastAccessTime) > configuredIdle) {
                        log.info("Closing idle session from user={}, client={}, idle={}ms", new Object[]{session.getUser(), session.client, idleTime});
                        iter.remove();
                        sessionsToCleanup.add(session);
                        session.state = Session.State.REMOVED;
                    }
                }
            }
        }
        this.deferredCleanupQueue.drainTo(sessionsToCleanup);
        sessionsToCleanup.removeIf(Session::cleanup);
        sessionsToCleanup.forEach(this::cleanup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIfNotAccessed(final long sessionId, final long delay) {
        Session session = (Session)this.sessions.get(sessionId);
        if (session != null) {
            long tmp;
            Session session2 = session;
            synchronized (session2) {
                tmp = session.lastAccessTime;
            }
            final long removeTime = tmp;
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Session session2 = (Session)SessionManager.this.sessions.get(sessionId);
                    if (session2 != null) {
                        boolean shouldRemove = false;
                        Session session = session2;
                        synchronized (session) {
                            if (session2.lastAccessTime == removeTime && session2.state == Session.State.UNRESERVED) {
                                session2.state = Session.State.REMOVED;
                                shouldRemove = true;
                            }
                        }
                        if (shouldRemove) {
                            log.info("Closing not accessed session from user=" + session2.getUser() + ", client=" + session2.client + ", duration=" + delay + "ms");
                            SessionManager.this.sessions.remove(sessionId);
                            SessionManager.this.cleanup(session2);
                        }
                    }
                }
            };
            ScheduledFuture<?> future = this.ctx.getScheduledExecutor().schedule(r, delay, TimeUnit.MILLISECONDS);
            ThreadPools.watchNonCriticalScheduledTask(future);
        }
    }

    public Map<TableId, MapCounter<ScanRunState>> getActiveScansPerTable() {
        HashMap<TableId, MapCounter<ScanRunState>> counts = new HashMap<TableId, MapCounter<ScanRunState>>();
        HashSet<Map.Entry> copiedIdleSessions = new HashSet<Map.Entry>();
        for (Session session : this.deferredCleanupQueue) {
            copiedIdleSessions.add(Maps.immutableEntry((Object)this.expiredSessionMarker, (Object)session));
        }
        List.of(this.sessions.entrySet(), copiedIdleSessions).forEach(set -> set.forEach(entry -> {
            ScanRunState srs;
            Session session = (Session)entry.getValue();
            ScanTask<ScanBatch> nbt = null;
            TableId tableID = null;
            if (session instanceof SingleScanSession) {
                SingleScanSession ss = (SingleScanSession)session;
                nbt = ss.nextBatchTask;
                tableID = ss.extent.tableId();
            } else if (session instanceof MultiScanSession) {
                MultiScanSession mss = (MultiScanSession)session;
                nbt = mss.lookupTask;
                tableID = mss.threadPoolExtent.tableId();
            }
            if (nbt != null && (srs = nbt.getScanRunState()) != ScanRunState.FINISHED) {
                counts.computeIfAbsent(tableID, unusedKey -> new MapCounter()).increment((Object)srs, 1L);
            }
        }));
        return counts;
    }

    public List<ActiveScan> getActiveScans() {
        ArrayList<ActiveScan> activeScans = new ArrayList<ActiveScan>();
        long ct = System.currentTimeMillis();
        HashSet<Map.Entry> copiedIdleSessions = new HashSet<Map.Entry>();
        for (Session session : this.deferredCleanupQueue) {
            copiedIdleSessions.add(Maps.immutableEntry((Object)this.expiredSessionMarker, (Object)session));
        }
        List.of(this.sessions.entrySet(), copiedIdleSessions).forEach(s -> s.forEach(entry -> {
            Session session = (Session)entry.getValue();
            if (session instanceof SingleScanSession) {
                SingleScanSession ss = (SingleScanSession)session;
                ScanState state = ScanState.RUNNING;
                ScanTask<ScanBatch> nbt = ss.nextBatchTask;
                if (nbt == null) {
                    state = ScanState.IDLE;
                } else {
                    switch (nbt.getScanRunState()) {
                        case QUEUED: {
                            state = ScanState.QUEUED;
                            break;
                        }
                        case FINISHED: {
                            state = ScanState.IDLE;
                            break;
                        }
                    }
                }
                ScanParameters params = ss.scanParams;
                ActiveScan activeScan = new ActiveScan(ss.client, ss.getUser(), ss.extent.tableId().canonical(), ct - ss.startTime, ct - ss.lastAccessTime, ScanType.SINGLE, state, ss.extent.toThrift(), params.getColumnSet().stream().map(Column::toThrift).collect(Collectors.toList()), params.getSsiList(), params.getSsio(), params.getAuthorizations().getAuthorizationsBB(), params.getClassLoaderContext());
                activeScan.setScanId(((Long)entry.getKey()).longValue());
                activeScans.add(activeScan);
            } else if (session instanceof MultiScanSession) {
                MultiScanSession mss = (MultiScanSession)session;
                ScanState state = ScanState.RUNNING;
                ScanTask<MultiScanResult> nbt = mss.lookupTask;
                if (nbt == null) {
                    state = ScanState.IDLE;
                } else {
                    switch (nbt.getScanRunState()) {
                        case QUEUED: {
                            state = ScanState.QUEUED;
                            break;
                        }
                        case FINISHED: {
                            state = ScanState.IDLE;
                            break;
                        }
                    }
                }
                ScanParameters params = mss.scanParams;
                activeScans.add(new ActiveScan(mss.client, mss.getUser(), mss.threadPoolExtent.tableId().canonical(), ct - mss.startTime, ct - mss.lastAccessTime, ScanType.BATCH, state, mss.threadPoolExtent.toThrift(), params.getColumnSet().stream().map(Column::toThrift).collect(Collectors.toList()), params.getSsiList(), params.getSsio(), params.getAuthorizations().getAuthorizationsBB(), params.getClassLoaderContext()));
            }
        }));
        return activeScans;
    }
}

