/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.compaction.CompactableFile;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.logging.TabletLogger;
import org.apache.accumulo.core.manager.thrift.TabletLoadState;
import org.apache.accumulo.core.metadata.CompactableFileImpl;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionMetadata;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;
import org.apache.accumulo.core.spi.compaction.CompactionDispatch;
import org.apache.accumulo.core.spi.compaction.CompactionDispatcher;
import org.apache.accumulo.core.spi.compaction.CompactionJob;
import org.apache.accumulo.core.spi.compaction.CompactionKind;
import org.apache.accumulo.core.spi.compaction.CompactionServiceId;
import org.apache.accumulo.core.spi.compaction.CompactionServices;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.compaction.CompactionExecutorIdImpl;
import org.apache.accumulo.core.util.compaction.CompactionJobImpl;
import org.apache.accumulo.core.util.compaction.CompactionServicesConfig;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServiceEnvironmentImpl;
import org.apache.accumulo.server.compaction.CompactionStats;
import org.apache.accumulo.server.compaction.FileCompactor;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.tserver.TabletStatsKeeper;
import org.apache.accumulo.tserver.compactions.Compactable;
import org.apache.accumulo.tserver.compactions.CompactionManager;
import org.apache.accumulo.tserver.compactions.ExternalCompactionJob;
import org.apache.accumulo.tserver.managermessage.TabletStatusMessage;
import org.apache.accumulo.tserver.tablet.CompactableUtils;
import org.apache.accumulo.tserver.tablet.MajCEnv;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactableImpl
implements Compactable {
    private static final Logger log = LoggerFactory.getLogger(CompactableImpl.class);
    private final Tablet tablet;
    private final FileManager fileMgr;
    private final Set<CompactionJob> runningJobs = new HashSet<CompactionJob>();
    private volatile boolean compactionRunning = false;
    private final Supplier<Set<CompactionServiceId>> servicesInUse;
    private final Set<CompactionServiceId> servicesUsed = new ConcurrentSkipListSet<CompactionServiceId>();
    private CompactionHelper chelper = null;
    private Long compactionId;
    private CompactionConfig compactionConfig;
    private final CompactionManager manager;
    AtomicLong lastSeenCompactionCancelId = new AtomicLong(Long.MIN_VALUE);
    private volatile boolean closed = false;
    private final Map<ExternalCompactionId, ExternalCompactionInfo> externalCompactions = new ConcurrentHashMap<ExternalCompactionId, ExternalCompactionInfo>();
    private final Set<ExternalCompactionId> externalCompactionsCommitting = new HashSet<ExternalCompactionId>();

    public CompactableImpl(final Tablet tablet, CompactionManager manager, Map<ExternalCompactionId, ExternalCompactionMetadata> extCompactions) {
        this.tablet = tablet;
        this.manager = manager;
        SortedMap<StoredTabletFile, DataFileValue> dataFileSizes = tablet.getDatafileManager().getDatafileSizes();
        HashMap<ExternalCompactionId, String> extCompactionsToRemove = new HashMap<ExternalCompactionId, String>();
        com.google.common.base.Supplier tabletCompactionId = Suppliers.memoize(() -> {
            try {
                return Optional.of(tablet.getCompactionID());
            }
            catch (KeeperException.NoNodeException nne) {
                return Optional.empty();
            }
        });
        Optional<SelectedInfo> extSelInfo = CompactableImpl.processExternalMetadata(extCompactions, () -> CompactableImpl.lambda$new$1((Supplier)tabletCompactionId), dataFileSizes.keySet(), extCompactionsToRemove);
        if (extSelInfo.isPresent()) {
            if (extSelInfo.orElseThrow().selectKind == CompactionKind.USER) {
                this.chelper = CompactableUtils.getHelper(extSelInfo.orElseThrow().selectKind, tablet, (Long)((Pair)((Optional)tabletCompactionId.get()).orElseThrow()).getFirst(), (CompactionConfig)((Pair)((Optional)tabletCompactionId.get()).orElseThrow()).getSecond());
                this.compactionConfig = (CompactionConfig)((Pair)((Optional)tabletCompactionId.get()).orElseThrow()).getSecond();
                this.compactionId = (Long)((Pair)((Optional)tabletCompactionId.get()).orElseThrow()).getFirst();
            } else if (extSelInfo.orElseThrow().selectKind == CompactionKind.SELECTOR) {
                this.chelper = CompactableUtils.getHelper(extSelInfo.orElseThrow().selectKind, tablet, null, null);
            }
        }
        extCompactionsToRemove.forEach((ecid, reason) -> log.warn("Removing external compaction {} for {} because {} meta: {}", new Object[]{ecid, tablet.getExtent(), reason, ((ExternalCompactionMetadata)extCompactions.get(ecid)).toJson()}));
        if (!extCompactionsToRemove.isEmpty()) {
            Ample.TabletMutator tabletMutator = tablet.getContext().getAmple().mutateTablet(tablet.getExtent());
            extCompactionsToRemove.keySet().forEach(arg_0 -> ((Ample.TabletMutator)tabletMutator).deleteExternalCompaction(arg_0));
            tabletMutator.mutate();
        }
        ArrayList extCompactingFiles = new ArrayList();
        extCompactions.forEach((ecid, ecMeta) -> {
            if (!extCompactionsToRemove.containsKey(ecid)) {
                extCompactingFiles.addAll(ecMeta.getJobFiles());
                Collection files = ecMeta.getJobFiles().stream().map(f -> new CompactableFileImpl(f, (DataFileValue)dataFileSizes.get(f))).collect(Collectors.toList());
                CompactionJobImpl job = new CompactionJobImpl(ecMeta.getPriority(), ecMeta.getCompactionExecutorId(), files, ecMeta.getKind(), Optional.empty());
                this.addJob((CompactionJob)job);
                ExternalCompactionInfo ecInfo = new ExternalCompactionInfo();
                ecInfo.job = job;
                ecInfo.meta = ecMeta;
                this.externalCompactions.put((ExternalCompactionId)ecid, ecInfo);
                log.debug("Loaded tablet {} has existing external compaction {} {}", new Object[]{this.getExtent(), ecid, ecMeta});
                manager.registerExternalCompaction((ExternalCompactionId)ecid, this.getExtent(), ecMeta.getCompactionExecutorId());
            }
        });
        if (extCompactions.values().stream().map(ecMeta -> ecMeta.getKind()).anyMatch(kind -> kind == CompactionKind.CHOP)) {
            this.initiateChop();
        }
        this.servicesInUse = Suppliers.memoizeWithExpiration(() -> {
            HashSet<CompactionServiceId> servicesIds = new HashSet<CompactionServiceId>();
            for (CompactionKind kind : CompactionKind.values()) {
                servicesIds.add(this.getConfiguredService(kind));
            }
            return Set.copyOf(servicesIds);
        }, (long)2L, (TimeUnit)TimeUnit.SECONDS);
        AccumuloConfiguration.Deriver selectionExpirationNanosDeriver = tablet.getTableConfiguration().newDeriver(conf -> Duration.ofMillis(conf.getTimeInMillis(Property.TABLE_COMPACTION_SELECTION_EXPIRATION)));
        this.fileMgr = new FileManager(tablet.getExtent(), extCompactingFiles, extSelInfo, selectionExpirationNanosDeriver){

            @Override
            protected boolean noneRunning(CompactionKind kind) {
                return CompactableImpl.this.noneRunning(kind);
            }

            @Override
            protected long getNanoTime() {
                return System.nanoTime();
            }

            @Override
            protected long getLastCompactId() {
                return tablet.getLastCompactId();
            }
        };
    }

    private synchronized boolean addJob(CompactionJob job) {
        if (this.runningJobs.add(job)) {
            this.compactionRunning = true;
            return true;
        }
        return false;
    }

    private synchronized boolean removeJob(CompactionJob job) {
        boolean removed = this.runningJobs.remove(job);
        this.compactionRunning = !this.runningJobs.isEmpty();
        return removed;
    }

    private synchronized boolean noneRunning(CompactionKind kind) {
        return this.runningJobs.stream().noneMatch(job -> job.getKind() == kind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initiateChop() {
        FileManager.ChopSelector chopSelector;
        Set<StoredTabletFile> allFiles = this.tablet.getDatafiles().keySet();
        CompactableImpl compactableImpl = this;
        synchronized (compactableImpl) {
            if (this.fileMgr.getChopStatus() != ChopSelectionStatus.NOT_ACTIVE) {
                return;
            }
            chopSelector = this.fileMgr.initiateChop(allFiles);
        }
        Set<StoredTabletFile> unchoppedFiles = this.selectChopFiles(chopSelector.getFilesToExamine());
        CompactableImpl compactableImpl2 = this;
        synchronized (compactableImpl2) {
            chopSelector.selectChopFiles(unchoppedFiles);
        }
        this.checkifChopComplete(this.tablet.getDatafiles().keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkifChopComplete(Set<StoredTabletFile> allFiles) {
        boolean completed;
        CompactableImpl compactableImpl = this;
        synchronized (compactableImpl) {
            if (this.closed) {
                return;
            }
            completed = this.fileMgr.finishChop(allFiles);
        }
        if (completed) {
            try {
                this.markChopped();
            }
            finally {
                compactableImpl = this;
                synchronized (compactableImpl) {
                    this.fileMgr.finishMarkingChop();
                    this.notifyAll();
                }
            }
            TabletLogger.selected((KeyExtent)this.getExtent(), (CompactionKind)CompactionKind.CHOP, Set.of());
        }
    }

    private void markChopped() {
        MetadataTableUtil.chopped((ServerContext)this.tablet.getTabletServer().getContext(), (KeyExtent)this.getExtent(), (ServiceLock)this.tablet.getTabletServer().getLock());
        this.tablet.getTabletServer().enqueueManagerMessage(new TabletStatusMessage(TabletLoadState.CHOPPED, this.getExtent()));
    }

    private Set<StoredTabletFile> selectChopFiles(Set<StoredTabletFile> chopCandidates) {
        try {
            Map<StoredTabletFile, Pair<Key, Key>> firstAndLastKeys = CompactableUtils.getFirstAndLastKeys(this.tablet, chopCandidates);
            return CompactableUtils.findChopFiles(this.getExtent(), firstAndLastKeys, chopCandidates);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void filesAdded(boolean chopped, Collection<StoredTabletFile> files) {
        if (chopped) {
            CompactableImpl compactableImpl = this;
            synchronized (compactableImpl) {
                this.fileMgr.addChoppedFiles(files);
            }
        }
        this.manager.compactableChanged(this);
    }

    void initiateUserCompaction(long compactionId, CompactionConfig compactionConfig) {
        this.checkIfUserCompactionCanceled();
        this.initiateSelection(CompactionKind.USER, compactionId, compactionConfig);
    }

    private void initiateSelection(CompactionKind kind) {
        if (kind != CompactionKind.SELECTOR) {
            return;
        }
        this.initiateSelection(CompactionKind.SELECTOR, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfUserCompactionCanceled() {
        CompactableImpl compactableImpl = this;
        synchronized (compactableImpl) {
            if (this.closed) {
                return;
            }
            if (!this.fileMgr.isSelected(CompactionKind.USER)) {
                return;
            }
        }
        long cancelId = this.tablet.getCompactionCancelID();
        this.lastSeenCompactionCancelId.getAndUpdate(prev -> Long.max(prev, cancelId));
        CompactableImpl compactableImpl2 = this;
        synchronized (compactableImpl2) {
            if (cancelId >= this.compactionId) {
                this.fileMgr.userCompactionCanceled();
            }
        }
    }

    static Optional<SelectedInfo> processExternalMetadata(Map<ExternalCompactionId, ExternalCompactionMetadata> extCompactions, Supplier<Optional<Long>> tabletCompactionId, Set<StoredTabletFile> tabletFiles, Map<ExternalCompactionId, String> externalCompactionsToRemove) {
        HashSet seen = new HashSet();
        boolean overlap = false;
        for (Map.Entry<ExternalCompactionId, ExternalCompactionMetadata> entry : extCompactions.entrySet()) {
            ExternalCompactionMetadata ecMeta = entry.getValue();
            if (!tabletFiles.containsAll(ecMeta.getJobFiles())) {
                externalCompactionsToRemove.putIfAbsent(entry.getKey(), "Has files outside of tablet files");
            } else if (!Collections.disjoint(seen, ecMeta.getJobFiles())) {
                overlap = true;
            }
            seen.addAll(ecMeta.getJobFiles());
        }
        if (overlap) {
            extCompactions.keySet().forEach(ecid -> externalCompactionsToRemove.putIfAbsent((ExternalCompactionId)ecid, "Some external compaction files overlap"));
            return Optional.empty();
        }
        CompactionKind extKind = null;
        boolean unexpectedExternal = false;
        Sets.SetView tmpSelectedFiles = null;
        Boolean initiallySelAll = null;
        Long cid = null;
        Boolean propDel = null;
        int count = 0;
        ArrayList<String> reasons = new ArrayList<String>();
        for (Map.Entry<ExternalCompactionId, ExternalCompactionMetadata> entry : extCompactions.entrySet()) {
            ExternalCompactionMetadata ecMeta = entry.getValue();
            if (ecMeta.getKind() != CompactionKind.USER && ecMeta.getKind() != CompactionKind.SELECTOR) continue;
            ++count;
            if (extKind != null && extKind != ecMeta.getKind()) {
                reasons.add("Saw USER and SELECTOR");
                unexpectedExternal = true;
                break;
            }
            extKind = ecMeta.getKind();
            if (tmpSelectedFiles == null) {
                tmpSelectedFiles = Sets.union((Set)ecMeta.getJobFiles(), (Set)ecMeta.getNextFiles());
            } else if (!Sets.union((Set)ecMeta.getJobFiles(), (Set)ecMeta.getNextFiles()).equals((Object)tmpSelectedFiles)) {
                reasons.add("Selected set of files differs");
                unexpectedExternal = true;
                break;
            }
            if (initiallySelAll == null) {
                initiallySelAll = ecMeta.getInitiallySelecteAll();
            } else if (initiallySelAll.booleanValue() != ecMeta.getInitiallySelecteAll()) {
                unexpectedExternal = true;
                reasons.add("Disagreement on selectedAll");
                break;
            }
            if (ecMeta.getKind() == CompactionKind.USER) {
                if (ecMeta.getCompactionId() == null) {
                    unexpectedExternal = true;
                    reasons.add("Missing compactionId");
                    break;
                }
                if (cid == null) {
                    cid = ecMeta.getCompactionId();
                } else if (!cid.equals(ecMeta.getCompactionId())) {
                    unexpectedExternal = true;
                    reasons.add("Disagreement on compactionId");
                    break;
                }
            } else if (ecMeta.getCompactionId() != null) {
                unexpectedExternal = true;
                reasons.add("Unexpected compactionId");
                break;
            }
            if (propDel == null) {
                propDel = ecMeta.getPropagateDeletes();
                continue;
            }
            if (propDel.booleanValue() == ecMeta.getPropagateDeletes()) continue;
            unexpectedExternal = true;
            reasons.add("Disagreement on propagateDeletes");
            break;
        }
        if (propDel != null && !propDel.booleanValue() && count > 1) {
            unexpectedExternal = true;
            reasons.add("Concurrent compactions not propagatingDeletes");
        }
        if (extKind == CompactionKind.USER) {
            Optional<Long> compactionId = tabletCompactionId.get();
            if (compactionId.isEmpty()) {
                unexpectedExternal = true;
                reasons.add("No compaction id in zookeeper");
            } else if (!compactionId.orElseThrow().equals(cid)) {
                unexpectedExternal = true;
                reasons.add("Compaction id mismatch with zookeeper");
            }
        }
        if (unexpectedExternal) {
            String reason = reasons.toString();
            extCompactions.entrySet().stream().filter(e -> {
                CompactionKind kind = ((ExternalCompactionMetadata)e.getValue()).getKind();
                return kind == CompactionKind.SELECTOR || kind == CompactionKind.USER;
            }).map(Map.Entry::getKey).forEach(ecid -> externalCompactionsToRemove.putIfAbsent((ExternalCompactionId)ecid, reason));
            return Optional.empty();
        }
        if (extKind != null) {
            return Optional.of(new SelectedInfo(initiallySelAll, (Set<StoredTabletFile>)tmpSelectedFiles, extKind));
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateSelection(CompactionKind kind, Long compactionId, CompactionConfig compactionConfig) {
        Preconditions.checkArgument((kind == CompactionKind.USER || kind == CompactionKind.SELECTOR ? 1 : 0) != 0);
        CompactionHelper localHelper = CompactableUtils.getHelper(kind, this.tablet, compactionId, compactionConfig);
        if (localHelper == null) {
            return;
        }
        CompactableImpl compactableImpl = this;
        synchronized (compactableImpl) {
            if (this.closed) {
                log.trace("Selection of files was not initiated {} because closed", (Object)this.getExtent());
                return;
            }
            if (!this.fileMgr.initiateSelection(kind, compactionId)) {
                if (kind == CompactionKind.USER) {
                    log.trace("Selection of files was not initiated {} compactionId:{} selectStatus:{} selectedFiles:{}", new Object[]{this.getExtent(), this.compactionId, this.fileMgr.selectStatus, this.fileMgr.selectedFiles.size()});
                }
                return;
            }
            this.chelper = localHelper;
            this.compactionId = compactionId;
            this.compactionConfig = compactionConfig;
            log.trace("Selected compaction status changed {} {} {} {}", new Object[]{this.getExtent(), this.fileMgr.getSelectionStatus(), compactionId, compactionConfig});
        }
        this.selectFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectFiles() {
        block26: {
            CompactionHelper localHelper;
            CompactableImpl compactableImpl = this;
            synchronized (compactableImpl) {
                if (this.closed || !this.fileMgr.beginSelection()) {
                    return;
                }
                localHelper = this.chelper;
            }
            try {
                SortedMap<StoredTabletFile, DataFileValue> allFiles = this.tablet.getDatafiles();
                Set<StoredTabletFile> selectingFiles = localHelper.selectFiles(allFiles);
                if (selectingFiles.isEmpty()) {
                    CompactableImpl compactableImpl2 = this;
                    synchronized (compactableImpl2) {
                        this.fileMgr.cancelSelection();
                        break block26;
                    }
                }
                boolean allSelected = allFiles.keySet().equals(Sets.union(selectingFiles, localHelper.getFilesToDrop()));
                CompactableImpl compactableImpl3 = this;
                synchronized (compactableImpl3) {
                    this.fileMgr.finishSelection(selectingFiles, allSelected);
                }
                this.manager.compactableChanged(this);
            }
            catch (Exception e) {
                log.error("Failed to select user compaction files {}", (Object)this.getExtent(), (Object)e);
            }
            finally {
                CompactableImpl compactableImpl4 = this;
                synchronized (compactableImpl4) {
                    if (this.fileMgr.getSelectionStatus() == FileSelectionStatus.SELECTING) {
                        this.fileMgr.cancelSelection();
                    }
                }
            }
        }
    }

    static Collection<String> asFileNames(Set<StoredTabletFile> files) {
        return Collections2.transform(files, TabletFile::getFileName);
    }

    @Override
    public TableId getTableId() {
        return this.getExtent().tableId();
    }

    @Override
    public KeyExtent getExtent() {
        return this.tablet.getExtent();
    }

    private boolean isCompactionStratConfigured() {
        String strategyClass = this.tablet.getTableConfiguration().get(Property.TABLE_COMPACTION_STRATEGY);
        return this.tablet.getTableConfiguration().isPropertySet(Property.TABLE_COMPACTION_STRATEGY) && strategyClass != null && !strategyClass.isBlank();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Compactable.Files> getFiles(CompactionServiceId service, CompactionKind kind) {
        if (!service.equals((Object)this.getConfiguredService(kind))) {
            return Optional.empty();
        }
        this.servicesUsed.add(service);
        SortedMap<StoredTabletFile, DataFileValue> files = this.tablet.getDatafiles();
        this.initiateSelection(kind);
        if (kind == CompactionKind.USER) {
            this.checkIfUserCompactionCanceled();
        }
        CompactableImpl compactableImpl = this;
        synchronized (compactableImpl) {
            if (this.closed) {
                return Optional.empty();
            }
            Set<CompactionJob> runningJobsCopy = Set.copyOf(this.runningJobs);
            Set<StoredTabletFile> candidates = this.fileMgr.getCandidates(Collections.unmodifiableSet(files.keySet()), kind, this.isCompactionStratConfigured());
            if (candidates.isEmpty()) {
                return Optional.empty();
            }
            if (kind == CompactionKind.USER) {
                Map hints = this.compactionConfig.getExecutionHints();
                return Optional.of(new Compactable.Files(files, candidates, runningJobsCopy, hints));
            }
            return Optional.of(new Compactable.Files(files, candidates, runningJobsCopy));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<CompactionInfo> reserveFilesForCompaction(CompactionServiceId service, CompactionJob job) {
        CompactionInfo cInfo = new CompactionInfo();
        cInfo.jobFiles = job.getFiles().stream().map(cf -> ((CompactableFileImpl)cf).getStoredTabletFile()).collect(Collectors.toSet());
        if (job.getKind() == CompactionKind.USER) {
            this.checkIfUserCompactionCanceled();
        }
        CompactableImpl compactableImpl = this;
        synchronized (compactableImpl) {
            if (this.closed) {
                return Optional.empty();
            }
            if (this.runningJobs.contains(job)) {
                return Optional.empty();
            }
            if (!service.equals((Object)this.getConfiguredService(job.getKind()))) {
                return Optional.empty();
            }
            if (!this.fileMgr.reserveFiles(job, cInfo.jobFiles)) {
                return Optional.empty();
            }
            if (!this.addJob(job)) {
                throw new AssertionError();
            }
            switch (job.getKind()) {
                case SELECTOR: 
                case USER: {
                    SelectedInfo si = this.fileMgr.getReservedInfo();
                    if (job.getKind() == si.selectKind && si.initiallySelectedAll && cInfo.jobFiles.containsAll(si.selectedFiles)) {
                        cInfo.propagateDeletes = false;
                    }
                    cInfo.selectedFiles = si.selectedFiles;
                    cInfo.initiallySelectedAll = si.initiallySelectedAll;
                    break;
                }
                default: {
                    if (((CompactionJobImpl)job).selectedAll()) {
                        cInfo.propagateDeletes = false;
                    }
                    cInfo.selectedFiles = Set.of();
                }
            }
            if (job.getKind() == CompactionKind.USER) {
                cInfo.iters = this.compactionConfig.getIterators();
                cInfo.checkCompactionId = this.compactionId;
                cInfo.localCompactionCfg = this.compactionConfig;
            }
            cInfo.localHelper = this.chelper;
        }
        if (!this.tablet.getDatafiles().keySet().containsAll(cInfo.jobFiles)) {
            this.completeCompaction(job, cInfo.jobFiles, Optional.empty(), true);
            return Optional.empty();
        }
        return Optional.of(cInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeCompaction(CompactionJob job, Set<StoredTabletFile> jobFiles, Optional<StoredTabletFile> metaFile, boolean successful) {
        CompactableImpl compactableImpl = this;
        synchronized (compactableImpl) {
            Preconditions.checkState((boolean)this.removeJob(job));
            this.fileMgr.completed(job, jobFiles, metaFile, successful);
            if (!this.compactionRunning) {
                this.notifyAll();
            }
        }
        this.checkifChopComplete(this.tablet.getDatafiles().keySet());
        this.selectFiles();
    }

    /*
     * Loose catch block
     */
    @Override
    public void compact(CompactionServiceId service, CompactionJob job, BooleanSupplier keepRunning, RateLimiter readLimiter, RateLimiter writeLimiter, long queuedTime) {
        Optional<CompactionInfo> ocInfo = this.reserveFilesForCompaction(service, job);
        if (ocInfo.isEmpty()) {
            return;
        }
        CompactionInfo cInfo = ocInfo.orElseThrow();
        Optional<StoredTabletFile> newFile = Optional.empty();
        long startTime = System.currentTimeMillis();
        CompactionKind kind = job.getKind();
        CompactionStats stats = new CompactionStats();
        boolean successful = false;
        try {
            TabletLogger.compacting((KeyExtent)this.getExtent(), (CompactionJob)job, (CompactionConfig)cInfo.localCompactionCfg);
            this.tablet.incrementStatusMajor();
            CompactionCheck check = new CompactionCheck(service, kind, keepRunning, cInfo.checkCompactionId);
            TabletFile tmpFileName = this.tablet.getNextMapFilenameForMajc(cInfo.propagateDeletes);
            MajCEnv compactEnv = new MajCEnv(kind, check, readLimiter, writeLimiter, cInfo.propagateDeletes);
            SortedMap<StoredTabletFile, DataFileValue> allFiles = this.tablet.getDatafiles();
            HashMap<StoredTabletFile, DataFileValue> compactFiles = new HashMap<StoredTabletFile, DataFileValue>();
            cInfo.jobFiles.forEach(file -> compactFiles.put((StoredTabletFile)file, (DataFileValue)allFiles.get(file)));
            stats = CompactableUtils.compact(this.tablet, job, cInfo, compactEnv, compactFiles, tmpFileName);
            newFile = CompactableUtils.bringOnline(this.tablet.getDatafileManager(), cInfo, stats, compactFiles, allFiles, kind, tmpFileName);
            TabletLogger.compacted((KeyExtent)this.getExtent(), (CompactionJob)job, (TabletFile)newFile.orElse(null));
            successful = true;
            this.completeCompaction(job, cInfo.jobFiles, newFile, successful);
        }
        catch (FileCompactor.CompactionCanceledException cce) {
            log.debug("Compaction canceled {} ", (Object)this.getExtent());
            this.completeCompaction(job, cInfo.jobFiles, newFile, successful);
            this.tablet.updateTimer(TabletStatsKeeper.Operation.MAJOR, queuedTime, startTime, stats.getEntriesRead(), newFile == null);
        }
        catch (Exception e) {
            newFile = Optional.empty();
            throw new RuntimeException(e);
            {
                catch (Throwable throwable) {
                    this.completeCompaction(job, cInfo.jobFiles, newFile, successful);
                    this.tablet.updateTimer(TabletStatsKeeper.Operation.MAJOR, queuedTime, startTime, stats.getEntriesRead(), newFile == null);
                    throw throwable;
                }
            }
        }
        this.tablet.updateTimer(TabletStatsKeeper.Operation.MAJOR, queuedTime, startTime, stats.getEntriesRead(), newFile == null);
    }

    @Override
    public ExternalCompactionJob reserveExternalCompaction(CompactionServiceId service, CompactionJob job, String compactorId, ExternalCompactionId externalCompactionId) {
        Preconditions.checkState((!this.tablet.getExtent().isMeta() ? 1 : 0) != 0);
        Optional<CompactionInfo> ocInfo = this.reserveFilesForCompaction(service, job);
        if (ocInfo.isEmpty()) {
            return null;
        }
        CompactionInfo cInfo = ocInfo.orElseThrow();
        try {
            Map<String, String> overrides = CompactableUtils.getOverrides(job.getKind(), this.tablet, cInfo.localHelper, job.getFiles());
            TabletFile compactTmpName = this.tablet.getNextMapFilenameForMajc(cInfo.propagateDeletes);
            ExternalCompactionInfo ecInfo = new ExternalCompactionInfo();
            ecInfo.meta = new ExternalCompactionMetadata(cInfo.jobFiles, (Set)Sets.difference(cInfo.selectedFiles, cInfo.jobFiles), compactTmpName, compactorId, job.getKind(), job.getPriority(), job.getExecutor(), cInfo.propagateDeletes, cInfo.initiallySelectedAll, cInfo.checkCompactionId);
            this.tablet.getContext().getAmple().mutateTablet(this.getExtent()).putExternalCompaction(externalCompactionId, ecInfo.meta).mutate();
            ecInfo.job = job;
            this.externalCompactions.put(externalCompactionId, ecInfo);
            SortedMap<StoredTabletFile, DataFileValue> allFiles = this.tablet.getDatafiles();
            HashMap<StoredTabletFile, DataFileValue> compactFiles = new HashMap<StoredTabletFile, DataFileValue>();
            cInfo.jobFiles.forEach(file -> compactFiles.put((StoredTabletFile)file, (DataFileValue)allFiles.get(file)));
            TabletLogger.compacting((KeyExtent)this.getExtent(), (CompactionJob)job, (CompactionConfig)cInfo.localCompactionCfg);
            return new ExternalCompactionJob(compactFiles, cInfo.propagateDeletes, compactTmpName, this.getExtent(), externalCompactionId, job.getKind(), cInfo.iters, cInfo.checkCompactionId, overrides);
        }
        catch (Exception e) {
            this.externalCompactions.remove(externalCompactionId);
            this.completeCompaction(job, cInfo.jobFiles, Optional.empty(), false);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitExternalCompaction(ExternalCompactionId extCompactionId, long fileSize, long entries) {
        CompactableImpl compactableImpl = this;
        synchronized (compactableImpl) {
            if (this.closed) {
                return;
            }
            if (!this.externalCompactionsCommitting.add(extCompactionId)) {
                return;
            }
        }
        try {
            ExternalCompactionInfo ecInfo = this.externalCompactions.get(extCompactionId);
            if (ecInfo != null) {
                log.debug("Attempting to commit external compaction {}", (Object)extCompactionId);
                Optional<StoredTabletFile> metaFile = Optional.empty();
                boolean successful = false;
                try {
                    metaFile = this.tablet.getDatafileManager().bringMajorCompactionOnline(ecInfo.meta.getJobFiles(), ecInfo.meta.getCompactTmpName(), ecInfo.meta.getCompactionId(), (Set<StoredTabletFile>)Sets.union((Set)ecInfo.meta.getJobFiles(), (Set)ecInfo.meta.getNextFiles()), new DataFileValue(fileSize, entries), Optional.of(extCompactionId));
                    TabletLogger.compacted((KeyExtent)this.getExtent(), (CompactionJob)ecInfo.job, (TabletFile)metaFile.orElse(null));
                    successful = true;
                }
                catch (Exception e) {
                    metaFile = Optional.empty();
                    log.error("Error committing external compaction: id: {}, extent: {}", new Object[]{extCompactionId, this.getExtent(), e});
                    throw new RuntimeException(e);
                }
                finally {
                    this.completeCompaction(ecInfo.job, ecInfo.meta.getJobFiles(), metaFile, successful);
                    this.externalCompactions.remove(extCompactionId);
                    log.debug("Completed commit of external compaction {}", (Object)extCompactionId);
                }
            } else {
                log.debug("Ignoring request to commit external compaction that is unknown {}", (Object)extCompactionId);
            }
            this.tablet.getContext().getAmple().deleteExternalCompactionFinalStates(List.of(extCompactionId));
        }
        finally {
            compactableImpl = this;
            synchronized (compactableImpl) {
                Preconditions.checkState((boolean)this.externalCompactionsCommitting.remove(extCompactionId));
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void externalCompactionFailed(ExternalCompactionId ecid) {
        CompactableImpl compactableImpl = this;
        synchronized (compactableImpl) {
            if (this.closed) {
                return;
            }
            if (!this.externalCompactionsCommitting.add(ecid)) {
                return;
            }
        }
        try {
            ExternalCompactionInfo ecInfo = this.externalCompactions.get(ecid);
            if (ecInfo != null) {
                this.tablet.getContext().getAmple().mutateTablet(this.getExtent()).deleteExternalCompaction(ecid).mutate();
                this.completeCompaction(ecInfo.job, ecInfo.meta.getJobFiles(), Optional.empty(), false);
                this.externalCompactions.remove(ecid);
                log.debug("Processed external compaction failure: id: {}, extent: {}", (Object)ecid, (Object)this.getExtent());
            } else {
                log.debug("Ignoring request to fail external compaction that is unknown {}", (Object)ecid);
            }
            this.tablet.getContext().getAmple().deleteExternalCompactionFinalStates(List.of(ecid));
        }
        finally {
            compactableImpl = this;
            synchronized (compactableImpl) {
                Preconditions.checkState((boolean)this.externalCompactionsCommitting.remove(ecid));
                this.notifyAll();
            }
        }
    }

    @Override
    public boolean isActive(ExternalCompactionId ecid) {
        return this.externalCompactions.containsKey(ecid);
    }

    @Override
    public void getExternalCompactionIds(Consumer<ExternalCompactionId> idConsumer) {
        this.externalCompactions.forEach((ecid, eci) -> idConsumer.accept((ExternalCompactionId)ecid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompactionServiceId getConfiguredService(final CompactionKind kind) {
        Map debugHints = null;
        try {
            Map hints;
            CompactionDispatcher dispatcher = this.tablet.getTableConfiguration().getCompactionDispatcher();
            if (dispatcher == null) {
                log.error("Failed to dispatch compaction, no dispatcher. extent:{} kind:{} hints:{}, falling back to {} service. Unable to instantiate dispatcher plugin. Check server log.", new Object[]{this.getExtent(), kind, debugHints, CompactionServicesConfig.DEFAULT_SERVICE});
                return CompactionServicesConfig.DEFAULT_SERVICE;
            }
            Map tmpHints = Map.of();
            if (kind == CompactionKind.USER) {
                CompactableImpl compactableImpl = this;
                synchronized (compactableImpl) {
                    if (this.fileMgr.getSelectionStatus() != FileSelectionStatus.NOT_ACTIVE && this.fileMgr.getSelectionStatus() != FileSelectionStatus.CANCELED && this.fileMgr.getSelectionKind() == CompactionKind.USER) {
                        tmpHints = this.compactionConfig.getExecutionHints();
                    }
                }
            }
            debugHints = hints = tmpHints;
            CompactionDispatch dispatch = dispatcher.dispatch(new CompactionDispatcher.DispatchParameters(){
                private final ServiceEnvironment senv;
                {
                    this.senv = new ServiceEnvironmentImpl(CompactableImpl.this.tablet.getContext());
                }

                public ServiceEnvironment getServiceEnv() {
                    return this.senv;
                }

                public Map<String, String> getExecutionHints() {
                    return hints;
                }

                public CompactionKind getCompactionKind() {
                    return kind;
                }

                public CompactionServices getCompactionServices() {
                    return CompactableImpl.this.manager.getServices();
                }
            });
            return dispatch.getService();
        }
        catch (RuntimeException e) {
            log.error("Failed to dispatch compaction due to exception. extent:{} kind:{} hints:{}, falling back to {} service.", new Object[]{this.getExtent(), kind, debugHints, CompactionServicesConfig.DEFAULT_SERVICE, e});
            return CompactionServicesConfig.DEFAULT_SERVICE;
        }
    }

    @Override
    public double getCompactionRatio() {
        return this.tablet.getTableConfiguration().getFraction(Property.TABLE_MAJC_RATIO);
    }

    public boolean isMajorCompactionRunning() {
        return this.compactionRunning;
    }

    public boolean isMajorCompactionQueued() {
        return this.manager.isCompactionQueued(this.getExtent(), this.servicesInUse.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        CompactableImpl compactableImpl = this;
        synchronized (compactableImpl) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Predicate<CompactionJob> jobsToWaitFor = job -> !((CompactionExecutorIdImpl)job.getExecutor()).isExternalId();
            while (this.runningJobs.stream().anyMatch(jobsToWaitFor) || !this.externalCompactionsCommitting.isEmpty() || this.fileMgr.chopStatus == ChopSelectionStatus.MARKING || this.fileMgr.selectStatus == FileSelectionStatus.SELECTING) {
                log.debug("Closing {} is waiting on {} running compactions, {} committing external compactions, chop marking {}, file selection {}", new Object[]{this.getExtent(), this.runningJobs.stream().filter(jobsToWaitFor).count(), this.externalCompactionsCommitting.size(), this.fileMgr.chopStatus == ChopSelectionStatus.MARKING, this.fileMgr.selectStatus == FileSelectionStatus.SELECTING});
                try {
                    this.wait(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
        }
        this.manager.compactableClosed(this.getExtent(), this.servicesUsed, this.externalCompactions.keySet());
    }

    private static /* synthetic */ Optional lambda$new$1(Supplier tabletCompactionId) {
        return ((Optional)tabletCompactionId.get()).map(Pair::getFirst);
    }

    public static interface CompactionHelper {
        public Set<StoredTabletFile> selectFiles(SortedMap<StoredTabletFile, DataFileValue> var1);

        public Set<StoredTabletFile> getFilesToDrop();

        public Map<String, String> getConfigOverrides(Set<CompactableFile> var1);
    }

    static class SelectedInfo {
        final boolean initiallySelectedAll;
        final Set<StoredTabletFile> selectedFiles;
        final CompactionKind selectKind;

        public SelectedInfo(boolean initiallySelectedAll, Set<StoredTabletFile> selectedFiles, CompactionKind selectKind) {
            this.initiallySelectedAll = initiallySelectedAll;
            this.selectedFiles = Set.copyOf(selectedFiles);
            this.selectKind = selectKind;
        }
    }

    static abstract class FileManager {
        FileSelectionStatus selectStatus = FileSelectionStatus.NOT_ACTIVE;
        private long selectedTimeNanos;
        private Duration selectedExpirationDuration;
        private CompactionKind selectKind = null;
        private boolean initiallySelectedAll = false;
        private final Set<StoredTabletFile> selectedFiles = new HashSet<StoredTabletFile>();
        protected Set<StoredTabletFile> allCompactingFiles = new HashSet<StoredTabletFile>();
        private final Set<StoredTabletFile> choppedFiles = new HashSet<StoredTabletFile>();
        private ChopSelectionStatus chopStatus = ChopSelectionStatus.NOT_ACTIVE;
        private final Set<StoredTabletFile> allFilesWhenChopStarted = new HashSet<StoredTabletFile>();
        private final KeyExtent extent;
        private final AccumuloConfiguration.Deriver<Duration> selectionExpirationDeriver;

        public FileManager(KeyExtent extent, Collection<StoredTabletFile> extCompactingFiles, Optional<SelectedInfo> extSelInfo, AccumuloConfiguration.Deriver<Duration> selectionExpirationDeriver) {
            this.extent = extent;
            this.selectionExpirationDeriver = selectionExpirationDeriver;
            this.allCompactingFiles.addAll(extCompactingFiles);
            if (extSelInfo.isPresent()) {
                this.selectedFiles.addAll(extSelInfo.orElseThrow().selectedFiles);
                this.selectKind = extSelInfo.orElseThrow().selectKind;
                this.initiallySelectedAll = extSelInfo.orElseThrow().initiallySelectedAll;
                this.selectStatus = FileSelectionStatus.RESERVED;
                log.debug("Selected compaction status initialized from external compactions {} {} {} {}", new Object[]{this.getExtent(), this.selectStatus, this.initiallySelectedAll, CompactableImpl.asFileNames(this.selectedFiles)});
            }
        }

        FileSelectionStatus getSelectionStatus() {
            return this.selectStatus;
        }

        CompactionKind getSelectionKind() {
            return this.selectKind;
        }

        @VisibleForTesting
        Set<StoredTabletFile> getSelectedFiles() {
            return Set.copyOf(this.selectedFiles);
        }

        SelectedInfo getReservedInfo() {
            Preconditions.checkState((this.selectStatus == FileSelectionStatus.RESERVED ? 1 : 0) != 0);
            return new SelectedInfo(this.initiallySelectedAll, this.selectedFiles, this.selectKind);
        }

        protected abstract boolean noneRunning(CompactionKind var1);

        protected abstract long getNanoTime();

        protected abstract long getLastCompactId();

        boolean initiateSelection(CompactionKind kind, Long compactionId) {
            Preconditions.checkArgument((kind == CompactionKind.SELECTOR && compactionId == null || kind == CompactionKind.USER && compactionId != null ? 1 : 0) != 0, (String)"Unexpected kind and/or compaction id: %s %s", (Object)kind, (Object)compactionId);
            if (this.selectStatus == FileSelectionStatus.NOT_ACTIVE || kind == CompactionKind.USER && this.selectKind == CompactionKind.SELECTOR && this.noneRunning(CompactionKind.SELECTOR) && this.selectStatus != FileSelectionStatus.SELECTING) {
                if (kind == CompactionKind.USER && this.getLastCompactId() >= compactionId) {
                    return false;
                }
                this.selectStatus = FileSelectionStatus.NEW;
                this.selectKind = kind;
                this.selectedFiles.clear();
                this.initiallySelectedAll = false;
                return true;
            }
            return false;
        }

        boolean beginSelection() {
            if (this.selectStatus == FileSelectionStatus.NEW && this.allCompactingFiles.isEmpty()) {
                this.selectStatus = FileSelectionStatus.SELECTING;
                log.trace("Selected compaction status changed {} {}", (Object)this.getExtent(), (Object)this.selectStatus);
                return true;
            }
            return false;
        }

        void finishSelection(Set<StoredTabletFile> selected, boolean allSelected) {
            Preconditions.checkArgument((!selected.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((this.selectStatus == FileSelectionStatus.SELECTING ? 1 : 0) != 0);
            this.selectStatus = FileSelectionStatus.SELECTED;
            this.selectedTimeNanos = this.getNanoTime();
            this.selectedExpirationDuration = (Duration)this.selectionExpirationDeriver.derive();
            this.selectedFiles.clear();
            this.selectedFiles.addAll(selected);
            this.initiallySelectedAll = allSelected;
            log.trace("Selected compaction status changed {} {} {} {}", new Object[]{this.getExtent(), this.selectStatus, this.initiallySelectedAll, CompactableImpl.asFileNames(this.selectedFiles)});
            TabletLogger.selected((KeyExtent)this.getExtent(), (CompactionKind)this.selectKind, this.selectedFiles);
        }

        void cancelSelection() {
            Preconditions.checkState((this.selectStatus == FileSelectionStatus.SELECTING ? 1 : 0) != 0);
            this.selectStatus = FileSelectionStatus.NOT_ACTIVE;
            log.trace("Selected compaction status changed {} {}", (Object)this.getExtent(), (Object)this.selectStatus);
        }

        boolean isSelected(CompactionKind kind) {
            return (this.selectStatus == FileSelectionStatus.SELECTED || this.selectStatus == FileSelectionStatus.RESERVED) && kind == this.selectKind;
        }

        ChopSelectionStatus getChopStatus() {
            return this.chopStatus;
        }

        ChopSelector initiateChop(Set<StoredTabletFile> allFiles) {
            Preconditions.checkState((this.chopStatus == ChopSelectionStatus.NOT_ACTIVE ? 1 : 0) != 0);
            HashSet<StoredTabletFile> filesToExamine = new HashSet<StoredTabletFile>(allFiles);
            this.chopStatus = ChopSelectionStatus.SELECTING;
            filesToExamine.removeAll(this.choppedFiles);
            filesToExamine.removeAll(this.allCompactingFiles);
            return new ChopSelector(allFiles, filesToExamine);
        }

        boolean finishChop(Set<StoredTabletFile> allFiles) {
            boolean completed = false;
            if (this.chopStatus == ChopSelectionStatus.SELECTED && this.getFilesToChop(allFiles).isEmpty()) {
                this.chopStatus = ChopSelectionStatus.MARKING;
                completed = true;
            }
            this.choppedFiles.retainAll(allFiles);
            return completed;
        }

        void finishMarkingChop() {
            Preconditions.checkState((this.chopStatus == ChopSelectionStatus.MARKING ? 1 : 0) != 0);
            this.chopStatus = ChopSelectionStatus.NOT_ACTIVE;
        }

        void addChoppedFiles(Collection<StoredTabletFile> files) {
            this.choppedFiles.addAll(files);
        }

        void userCompactionCanceled() {
            if (this.isSelected(CompactionKind.USER)) {
                if (this.noneRunning(CompactionKind.USER)) {
                    this.selectStatus = FileSelectionStatus.NOT_ACTIVE;
                    log.trace("Selected compaction status changed {} {}", (Object)this.getExtent(), (Object)this.selectStatus);
                } else {
                    this.selectStatus = FileSelectionStatus.CANCELED;
                    log.trace("Selected compaction status changed {} {}", (Object)this.getExtent(), (Object)this.selectStatus);
                }
            }
        }

        private Set<StoredTabletFile> getFilesToChop(Set<StoredTabletFile> allFiles) {
            Preconditions.checkState((this.chopStatus == ChopSelectionStatus.SELECTED ? 1 : 0) != 0);
            HashSet<StoredTabletFile> copy = new HashSet<StoredTabletFile>(this.allFilesWhenChopStarted);
            copy.retainAll(allFiles);
            copy.removeAll(this.choppedFiles);
            return copy;
        }

        Set<StoredTabletFile> getCandidates(Set<StoredTabletFile> currFiles, CompactionKind kind, boolean isCompactionStratConfigured) {
            if (!currFiles.containsAll(this.allCompactingFiles)) {
                log.trace("Ignoring because compacting not a subset {}", (Object)this.getExtent());
                return Set.of();
            }
            switch (kind) {
                case SYSTEM: {
                    if (isCompactionStratConfigured) {
                        return Set.of();
                    }
                    return this.handleSystemCompaction(currFiles);
                }
                case SELECTOR: 
                case USER: {
                    return this.handleUserSelectorCompaction(currFiles, kind);
                }
                case CHOP: {
                    return this.handleChopCompaction(currFiles);
                }
            }
            throw new AssertionError();
        }

        private Set<StoredTabletFile> handleChopCompaction(Set<StoredTabletFile> currFiles) {
            switch (this.chopStatus) {
                case NOT_ACTIVE: 
                case SELECTING: 
                case MARKING: {
                    return Set.of();
                }
                case SELECTED: {
                    if (this.selectStatus == FileSelectionStatus.NEW || this.selectStatus == FileSelectionStatus.SELECTING) {
                        return Set.of();
                    }
                    Set<StoredTabletFile> filesToChop = this.getFilesToChop(currFiles);
                    filesToChop.removeAll(this.allCompactingFiles);
                    if (this.selectStatus == FileSelectionStatus.SELECTED || this.selectStatus == FileSelectionStatus.RESERVED) {
                        filesToChop.removeAll(this.selectedFiles);
                    }
                    return Collections.unmodifiableSet(filesToChop);
                }
            }
            throw new AssertionError();
        }

        private Set<StoredTabletFile> handleUserSelectorCompaction(Set<StoredTabletFile> currFiles, CompactionKind kind) {
            switch (this.selectStatus) {
                case NOT_ACTIVE: 
                case NEW: 
                case SELECTING: 
                case CANCELED: {
                    return Set.of();
                }
                case SELECTED: 
                case RESERVED: {
                    if (this.selectKind == kind) {
                        Sets.SetView candidates = Sets.difference(this.selectedFiles, this.allCompactingFiles);
                        if (!currFiles.containsAll((Collection<?>)candidates)) {
                            log.debug("Selected files not in all files {} {} {}", new Object[]{Sets.difference((Set)candidates, currFiles), candidates, currFiles});
                            return Set.of();
                        }
                        return Set.copyOf(candidates);
                    }
                    return Set.of();
                }
            }
            throw new AssertionError();
        }

        private Set<StoredTabletFile> handleSystemCompaction(Set<StoredTabletFile> currFiles) {
            switch (this.selectStatus) {
                case NOT_ACTIVE: 
                case CANCELED: {
                    return Set.copyOf(Sets.difference(currFiles, this.allCompactingFiles));
                }
                case NEW: 
                case SELECTING: {
                    return Set.of();
                }
                case SELECTED: {
                    HashSet<StoredTabletFile> candidates = new HashSet<StoredTabletFile>(currFiles);
                    candidates.removeAll(this.allCompactingFiles);
                    if (this.getNanoTime() - this.selectedTimeNanos < this.selectedExpirationDuration.toNanos()) {
                        candidates.removeAll(this.selectedFiles);
                    }
                    return Collections.unmodifiableSet(candidates);
                }
                case RESERVED: {
                    HashSet<StoredTabletFile> candidates = new HashSet<StoredTabletFile>(currFiles);
                    candidates.removeAll(this.allCompactingFiles);
                    candidates.removeAll(this.selectedFiles);
                    return Collections.unmodifiableSet(candidates);
                }
            }
            throw new AssertionError();
        }

        boolean reserveFiles(CompactionJob job, Set<StoredTabletFile> jobFiles) {
            Preconditions.checkArgument((!jobFiles.isEmpty() ? 1 : 0) != 0);
            if (this.selectStatus == FileSelectionStatus.SELECTED && this.getNanoTime() - this.selectedTimeNanos > this.selectedExpirationDuration.toNanos() && job.getKind() != this.selectKind && !Collections.disjoint(this.selectedFiles, jobFiles)) {
                Preconditions.checkState((boolean)this.noneRunning(this.selectKind));
                this.selectStatus = FileSelectionStatus.NOT_ACTIVE;
                log.trace("Selected compaction status changed {} {} because selection expired.", (Object)this.getExtent(), (Object)this.selectStatus);
            }
            switch (this.selectStatus) {
                case NEW: 
                case SELECTING: {
                    log.trace("Ignoring compaction because files are being selected for user compaction {} {}", (Object)this.getExtent(), (Object)job);
                    return false;
                }
                case SELECTED: 
                case RESERVED: {
                    if (job.getKind() == CompactionKind.USER || job.getKind() == CompactionKind.SELECTOR) {
                        if (this.selectKind == job.getKind()) {
                            if (this.selectedFiles.containsAll(jobFiles)) break;
                            log.trace("Ignoring {} compaction that does not contain selected files {} {} {}", new Object[]{job.getKind(), this.getExtent(), CompactableImpl.asFileNames(this.selectedFiles), CompactableImpl.asFileNames(jobFiles)});
                            return false;
                        }
                        log.trace("Ingoing {} compaction because not selected kind {}", (Object)job.getKind(), (Object)this.getExtent());
                        return false;
                    }
                    if (Collections.disjoint(this.selectedFiles, jobFiles)) break;
                    log.trace("Ingoing compaction that overlaps with selected files {} {} {}", new Object[]{this.getExtent(), job.getKind(), CompactableImpl.asFileNames((Set<StoredTabletFile>)Sets.intersection(this.selectedFiles, jobFiles))});
                    return false;
                }
                case NOT_ACTIVE: 
                case CANCELED: {
                    if (job.getKind() != CompactionKind.USER && job.getKind() != CompactionKind.SELECTOR) break;
                    log.trace("Ignoring {} compaction because selectStatus is {} for {}", new Object[]{job.getKind(), this.selectStatus, this.getExtent()});
                    return false;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (Collections.disjoint(this.allCompactingFiles, jobFiles)) {
                if (this.selectStatus == FileSelectionStatus.SELECTED && job.getKind() == this.selectKind) {
                    this.selectStatus = FileSelectionStatus.RESERVED;
                    log.trace("Selected compaction status changed {} {}", (Object)this.getExtent(), (Object)this.selectStatus);
                }
                this.allCompactingFiles.addAll(jobFiles);
                return true;
            }
            return false;
        }

        private KeyExtent getExtent() {
            return this.extent;
        }

        void completed(CompactionJob job, Set<StoredTabletFile> jobFiles, Optional<StoredTabletFile> newFile, boolean successful) {
            Preconditions.checkArgument((!jobFiles.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((boolean)this.allCompactingFiles.removeAll(jobFiles));
            if (newFile.isPresent()) {
                this.choppedFiles.add(newFile.orElseThrow());
            }
            if (successful && (job.getKind() == CompactionKind.USER || job.getKind() == CompactionKind.SELECTOR)) {
                this.selectedCompactionCompleted(job, jobFiles, newFile);
            }
        }

        private void selectedCompactionCompleted(CompactionJob job, Set<StoredTabletFile> jobFiles, Optional<StoredTabletFile> newFile) {
            Preconditions.checkArgument((job.getKind() == CompactionKind.USER || job.getKind() == CompactionKind.SELECTOR ? 1 : 0) != 0);
            Preconditions.checkState((boolean)this.selectedFiles.containsAll(jobFiles));
            Preconditions.checkState(((this.selectStatus == FileSelectionStatus.RESERVED || this.selectStatus == FileSelectionStatus.CANCELED) && this.selectKind == job.getKind() ? 1 : 0) != 0);
            this.selectedFiles.removeAll(jobFiles);
            if (this.selectedFiles.isEmpty() || this.selectStatus == FileSelectionStatus.CANCELED && this.noneRunning(this.selectKind)) {
                this.selectStatus = FileSelectionStatus.NOT_ACTIVE;
                log.trace("Selected compaction status changed {} {}", (Object)this.getExtent(), (Object)this.selectStatus);
            } else if (this.selectStatus == FileSelectionStatus.RESERVED) {
                if (newFile.isPresent()) {
                    this.selectedFiles.add(newFile.orElseThrow());
                }
                log.trace("Compacted subset of selected files {} {} -> {}", new Object[]{this.getExtent(), CompactableImpl.asFileNames(jobFiles), newFile.orElse(null)});
            } else {
                log.debug("Canceled selected compaction completed {} but others still running ", (Object)this.getExtent());
            }
            TabletLogger.selected((KeyExtent)this.getExtent(), (CompactionKind)this.selectKind, this.selectedFiles);
        }

        class ChopSelector {
            private final Set<StoredTabletFile> allFiles;
            private final Set<StoredTabletFile> filesToExamine;

            private ChopSelector(Set<StoredTabletFile> allFiles, Set<StoredTabletFile> filesToExamine) {
                this.allFiles = allFiles;
                this.filesToExamine = filesToExamine;
            }

            void selectChopFiles(Set<StoredTabletFile> unchoppedFiles) {
                Preconditions.checkState((FileManager.this.chopStatus == ChopSelectionStatus.SELECTING ? 1 : 0) != 0);
                FileManager.this.choppedFiles.addAll((Collection<StoredTabletFile>)Sets.difference(this.filesToExamine, unchoppedFiles));
                FileManager.this.chopStatus = ChopSelectionStatus.SELECTED;
                FileManager.this.allFilesWhenChopStarted.clear();
                FileManager.this.allFilesWhenChopStarted.addAll(this.allFiles);
                Set<StoredTabletFile> filesToChop = FileManager.this.getFilesToChop(this.allFiles);
                if (!filesToChop.isEmpty()) {
                    TabletLogger.selected((KeyExtent)FileManager.this.getExtent(), (CompactionKind)CompactionKind.CHOP, filesToChop);
                }
            }

            Set<StoredTabletFile> getFilesToExamine() {
                return Collections.unmodifiableSet(this.filesToExamine);
            }
        }
    }

    static enum ChopSelectionStatus {
        SELECTING,
        SELECTED,
        NOT_ACTIVE,
        MARKING;

    }

    static enum FileSelectionStatus {
        NEW,
        SELECTING,
        SELECTED,
        RESERVED,
        NOT_ACTIVE,
        CANCELED;

    }

    static class CompactionInfo {
        Set<StoredTabletFile> jobFiles;
        Long checkCompactionId = null;
        boolean propagateDeletes = true;
        CompactionHelper localHelper;
        List<IteratorSetting> iters = List.of();
        CompactionConfig localCompactionCfg;
        boolean initiallySelectedAll;
        Set<StoredTabletFile> selectedFiles;

        CompactionInfo() {
        }
    }

    class CompactionCheck {
        private final Supplier<Boolean> expensiveCheck = Suppliers.memoizeWithExpiration(() -> service.equals((Object)CompactableImpl.this.getConfiguredService(kind)) && keepRunning.getAsBoolean(), (long)3L, (TimeUnit)TimeUnit.SECONDS);
        private final Supplier<Boolean> inexpensiveCheck = Suppliers.memoizeWithExpiration(() -> {
            if (CompactableImpl.this.closed || kind == CompactionKind.USER && CompactableImpl.this.lastSeenCompactionCancelId.get() >= compactionId) {
                return false;
            }
            return true;
        }, (long)50L, (TimeUnit)TimeUnit.MILLISECONDS);

        public CompactionCheck(CompactionServiceId service, CompactionKind kind, BooleanSupplier keepRunning, Long compactionId) {
        }

        public boolean isCompactionEnabled() {
            return this.inexpensiveCheck.get() != false && this.expensiveCheck.get() != false;
        }
    }

    private static class ExternalCompactionInfo {
        ExternalCompactionMetadata meta;
        CompactionJob job;

        private ExternalCompactionInfo() {
        }
    }
}

