/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.scan;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.spi.scan.ScanDispatch;

public final class ScanParameters {
    private final Authorizations authorizations;
    private final Set<Column> columnSet;
    private final List<IterInfo> ssiList;
    private final Map<String, Map<String, String>> ssio;
    private final int maxEntries;
    private final boolean isolated;
    private final SamplerConfiguration samplerConfig;
    private final long batchTimeOut;
    private final String classLoaderContext;
    private volatile ScanDispatch dispatch;

    public ScanParameters(int maxEntries, Authorizations authorizations, Set<Column> columnSet, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, boolean isolated, SamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext) {
        this.maxEntries = maxEntries;
        this.authorizations = authorizations;
        this.columnSet = columnSet;
        this.ssiList = ssiList;
        this.ssio = ssio;
        this.isolated = isolated;
        this.samplerConfig = samplerConfig;
        this.batchTimeOut = batchTimeOut;
        this.classLoaderContext = classLoaderContext;
    }

    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    public Set<Column> getColumnSet() {
        return this.columnSet;
    }

    public List<IterInfo> getSsiList() {
        return this.ssiList;
    }

    public Map<String, Map<String, String>> getSsio() {
        return this.ssio;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public SamplerConfigurationImpl getSamplerConfigurationImpl() {
        if (this.samplerConfig == null) {
            return null;
        }
        return new SamplerConfigurationImpl(this.samplerConfig);
    }

    public long getBatchTimeOut() {
        return this.batchTimeOut;
    }

    public String getClassLoaderContext() {
        return this.classLoaderContext;
    }

    public void setScanDispatch(ScanDispatch dispatch) {
        this.dispatch = dispatch;
    }

    public ScanDispatch getScanDispatch() {
        return this.dispatch;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append("auths=").append(this.authorizations);
        buf.append(", batchTimeOut=").append(this.batchTimeOut);
        buf.append(", context=").append(this.classLoaderContext);
        buf.append(", columns=").append(this.columnSet);
        buf.append(", isolated=").append(this.isolated);
        buf.append(", maxEntries=").append(this.maxEntries);
        buf.append(", num=").append(this.maxEntries);
        buf.append(", samplerConfig=").append(this.samplerConfig);
        buf.append("]");
        return buf.toString();
    }
}

