/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.session;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.MultiScanResult;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.spi.scan.ScanInfo;
import org.apache.accumulo.tserver.scan.ScanParameters;
import org.apache.accumulo.tserver.scan.ScanTask;
import org.apache.accumulo.tserver.session.ScanSession;

public class MultiScanSession
extends ScanSession {
    public final KeyExtent threadPoolExtent;
    public final Map<KeyExtent, List<Range>> queries;
    public final Set<KeyExtent> exents;
    public int numRanges;
    public int numTablets;
    public int numEntries;
    public long totalLookupTime;
    public volatile ScanTask<MultiScanResult> lookupTask;

    public MultiScanSession(TCredentials credentials, KeyExtent threadPoolExtent, Map<KeyExtent, List<Range>> queries, ScanParameters scanParams, Map<String, String> executionHints, ScanSession.TabletResolver tabletResolver) {
        super(credentials, scanParams, executionHints, tabletResolver);
        this.queries = queries;
        this.threadPoolExtent = threadPoolExtent;
        this.exents = Set.copyOf(queries.keySet());
    }

    public ScanInfo.Type getScanType() {
        return ScanInfo.Type.MULTI;
    }

    public TableId getTableId() {
        return this.threadPoolExtent.tableId();
    }

    @Override
    public boolean cleanup() {
        if (this.lookupTask != null) {
            this.lookupTask.cancel(true);
        }
        return super.cleanup();
    }
}

