/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQDispatcher;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.ActiveMQMessageProducer;
import org.apache.activemq.ActiveMQMessageTransformation;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.ActiveMQQueueBrowser;
import org.apache.activemq.ActiveMQQueueReceiver;
import org.apache.activemq.ActiveMQQueueSender;
import org.apache.activemq.ActiveMQSessionExecutor;
import org.apache.activemq.ActiveMQTopicPublisher;
import org.apache.activemq.ActiveMQTopicSubscriber;
import org.apache.activemq.BlobMessage;
import org.apache.activemq.CustomDestination;
import org.apache.activemq.MessageDispatchChannel;
import org.apache.activemq.MessageTransformer;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.TransactionContext;
import org.apache.activemq.blob.BlobTransferPolicy;
import org.apache.activemq.blob.BlobUploader;
import org.apache.activemq.command.ActiveMQBlobMessage;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQStreamMessage;
import org.apache.activemq.command.ActiveMQTempDestination;
import org.apache.activemq.command.ActiveMQTempQueue;
import org.apache.activemq.command.ActiveMQTempTopic;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.management.JMSSessionStatsImpl;
import org.apache.activemq.management.StatsCapable;
import org.apache.activemq.management.StatsImpl;
import org.apache.activemq.thread.Scheduler;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.usage.MemoryUsage;
import org.apache.activemq.util.Callback;
import org.apache.activemq.util.LongSequenceGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQSession
implements Session,
QueueSession,
TopicSession,
StatsCapable,
ActiveMQDispatcher {
    private static final Log LOG = LogFactory.getLog(ActiveMQSession.class);
    protected int acknowledgementMode;
    protected final ActiveMQConnection connection;
    protected final SessionInfo info;
    protected final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    protected final LongSequenceGenerator producerIdGenerator = new LongSequenceGenerator();
    protected final LongSequenceGenerator deliveryIdGenerator = new LongSequenceGenerator();
    protected final ActiveMQSessionExecutor executor = new ActiveMQSessionExecutor(this);
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected final CopyOnWriteArrayList<ActiveMQMessageConsumer> consumers = new CopyOnWriteArrayList();
    protected final CopyOnWriteArrayList<ActiveMQMessageProducer> producers = new CopyOnWriteArrayList();
    protected boolean closed;
    protected boolean asyncDispatch;
    protected boolean sessionAsyncDispatch;
    protected final boolean debug;
    protected Object sendMutex = new Object();
    private MessageListener messageListener;
    private JMSSessionStatsImpl stats;
    private TransactionContext transactionContext;
    private DeliveryListener deliveryListener;
    private MessageTransformer transformer;
    private BlobTransferPolicy blobTransferPolicy;

    protected ActiveMQSession(ActiveMQConnection connection, SessionId sessionId, int acknowledgeMode, boolean asyncDispatch, boolean sessionAsyncDispatch) throws JMSException {
        this.debug = LOG.isDebugEnabled();
        this.connection = connection;
        this.acknowledgementMode = acknowledgeMode;
        this.asyncDispatch = asyncDispatch;
        this.sessionAsyncDispatch = sessionAsyncDispatch;
        this.info = new SessionInfo(connection.getConnectionInfo(), sessionId.getValue());
        this.setTransactionContext(new TransactionContext(connection));
        connection.addSession(this);
        this.stats = new JMSSessionStatsImpl(this.producers, this.consumers);
        this.connection.asyncSendPacket(this.info);
        this.setTransformer(connection.getTransformer());
        this.setBlobTransferPolicy(connection.getBlobTransferPolicy());
        if (connection.isStarted()) {
            this.start();
        }
    }

    protected ActiveMQSession(ActiveMQConnection connection, SessionId sessionId, int acknowledgeMode, boolean asyncDispatch) throws JMSException {
        this(connection, sessionId, acknowledgeMode, asyncDispatch, true);
    }

    public void setTransactionContext(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public StatsImpl getStats() {
        return this.stats;
    }

    public JMSSessionStatsImpl getSessionStats() {
        return this.stats;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        ActiveMQBytesMessage message = new ActiveMQBytesMessage();
        this.configureMessage(message);
        return message;
    }

    public MapMessage createMapMessage() throws JMSException {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        this.configureMessage(message);
        return message;
    }

    public Message createMessage() throws JMSException {
        ActiveMQMessage message = new ActiveMQMessage();
        this.configureMessage(message);
        return message;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        ActiveMQObjectMessage message = new ActiveMQObjectMessage();
        this.configureMessage(message);
        return message;
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        ActiveMQObjectMessage message = new ActiveMQObjectMessage();
        this.configureMessage(message);
        message.setObject(object);
        return message;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        this.configureMessage(message);
        return message;
    }

    public TextMessage createTextMessage() throws JMSException {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        this.configureMessage(message);
        return message;
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText(text);
        this.configureMessage(message);
        return message;
    }

    public BlobMessage createBlobMessage(URL url) throws JMSException {
        return this.createBlobMessage(url, false);
    }

    public BlobMessage createBlobMessage(URL url, boolean deletedByBroker) throws JMSException {
        ActiveMQBlobMessage message = new ActiveMQBlobMessage();
        this.configureMessage(message);
        message.setURL(url);
        message.setDeletedByBroker(deletedByBroker);
        return message;
    }

    public BlobMessage createBlobMessage(File file) throws JMSException {
        ActiveMQBlobMessage message = new ActiveMQBlobMessage();
        this.configureMessage(message);
        message.setBlobUploader(new BlobUploader(this.getBlobTransferPolicy(), file));
        message.setDeletedByBroker(true);
        message.setName(file.getName());
        return message;
    }

    public BlobMessage createBlobMessage(InputStream in) throws JMSException {
        ActiveMQBlobMessage message = new ActiveMQBlobMessage();
        this.configureMessage(message);
        message.setBlobUploader(new BlobUploader(this.getBlobTransferPolicy(), in));
        message.setDeletedByBroker(true);
        return message;
    }

    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.acknowledgementMode == 0 || this.transactionContext.isInXATransaction();
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkClosed();
        return this.acknowledgementMode;
    }

    public void commit() throws JMSException {
        this.checkClosed();
        if (!this.getTransacted()) {
            throw new IllegalStateException("Not a transacted session");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.getSessionId() + " Transaction Commit"));
        }
        this.transactionContext.commit();
    }

    public void rollback() throws JMSException {
        this.checkClosed();
        if (!this.getTransacted()) {
            throw new IllegalStateException("Not a transacted session");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.getSessionId() + " Transaction Rollback"));
        }
        this.transactionContext.rollback();
    }

    public void close() throws JMSException {
        if (!this.closed) {
            this.dispose();
            this.connection.asyncSendPacket(this.info.createRemoveCommand());
        }
    }

    void clearMessagesInProgress() {
        this.executor.clearMessagesInProgress();
        for (ActiveMQMessageConsumer consumer : this.consumers) {
            consumer.clearMessagesInProgress();
        }
    }

    void deliverAcks() {
        for (ActiveMQMessageConsumer consumer : this.consumers) {
            consumer.deliverAcks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() throws JMSException {
        if (!this.closed) {
            try {
                this.executor.stop();
                for (ActiveMQMessageConsumer consumer : this.consumers) {
                    consumer.dispose();
                }
                this.consumers.clear();
                for (ActiveMQMessageProducer producer : this.producers) {
                    producer.dispose();
                }
                this.producers.clear();
                try {
                    if (this.getTransactionContext().isInLocalTransaction()) {
                        this.rollback();
                    }
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            finally {
                this.connection.removeSession(this);
                this.transactionContext = null;
                this.closed = true;
            }
        }
    }

    protected void configureMessage(ActiveMQMessage message) throws IllegalStateException {
        this.checkClosed();
        message.setConnection(this.connection);
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The Session is closed");
        }
    }

    public void recover() throws JMSException {
        this.checkClosed();
        if (this.getTransacted()) {
            throw new IllegalStateException("This session is transacted");
        }
        for (ActiveMQMessageConsumer c : this.consumers) {
            c.rollback();
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.messageListener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
        this.messageListener = listener;
        if (listener != null) {
            this.executor.setDispatchedBySessionPool(true);
        }
    }

    public void run() {
        MessageDispatch messageDispatch;
        while ((messageDispatch = this.executor.dequeueNoWait()) != null) {
            final MessageDispatch md = messageDispatch;
            ActiveMQMessage message = (ActiveMQMessage)md.getMessage();
            if (message.isExpired() || this.connection.isDuplicate(this, message)) continue;
            if (this.isClientAcknowledge()) {
                message.setAcknowledgeCallback(new Callback(){

                    public void execute() throws Exception {
                    }
                });
            }
            if (this.deliveryListener != null) {
                this.deliveryListener.beforeDelivery(this, message);
            }
            md.setDeliverySequenceId(this.getNextDeliveryId());
            try {
                this.messageListener.onMessage(message);
            }
            catch (Throwable e) {
                LOG.error((Object)"error dispatching message: ", e);
                this.connection.onAsyncException(e);
            }
            try {
                MessageAck ack = new MessageAck(md, 2, 1);
                ack.setFirstMessageId(md.getMessage().getMessageId());
                this.doStartTransaction();
                ack.setTransactionId(this.getTransactionContext().getTransactionId());
                if (ack.getTransactionId() != null) {
                    this.getTransactionContext().addSynchronization(new Synchronization(){

                        public void afterRollback() throws Exception {
                            md.getMessage().onMessageRolledBack();
                            ActiveMQSession.this.connection.rollbackDuplicate(ActiveMQSession.this, md.getMessage());
                            RedeliveryPolicy redeliveryPolicy = ActiveMQSession.this.connection.getRedeliveryPolicy();
                            int redeliveryCounter = md.getMessage().getRedeliveryCounter();
                            if (redeliveryPolicy.getMaximumRedeliveries() != -1 && redeliveryCounter > redeliveryPolicy.getMaximumRedeliveries()) {
                                MessageAck ack = new MessageAck(md, 1, 1);
                                ack.setFirstMessageId(md.getMessage().getMessageId());
                                ActiveMQSession.this.asyncSendPacket(ack);
                            } else {
                                MessageAck ack = new MessageAck(md, 3, 1);
                                ack.setFirstMessageId(md.getMessage().getMessageId());
                                ActiveMQSession.this.asyncSendPacket(ack);
                                long redeliveryDelay = 0L;
                                for (int i = 0; i < redeliveryCounter; ++i) {
                                    redeliveryDelay = redeliveryPolicy.getRedeliveryDelay(redeliveryDelay);
                                }
                                Scheduler.executeAfterDelay(new Runnable(){

                                    public void run() {
                                        ((ActiveMQDispatcher)md.getConsumer()).dispatch(md);
                                    }
                                }, redeliveryDelay);
                            }
                        }
                    });
                }
                this.asyncSendPacket(ack);
            }
            catch (Throwable e) {
                this.connection.onAsyncException(e);
            }
            if (this.deliveryListener == null) continue;
            this.deliveryListener.afterDelivery(this, message);
        }
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.checkClosed();
        if (destination instanceof CustomDestination) {
            CustomDestination customDestination = (CustomDestination)destination;
            return customDestination.createProducer(this);
        }
        return new ActiveMQMessageProducer(this, this.getNextProducerId(), ActiveMQMessageTransformation.transformDestination(destination));
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, (String)null);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false);
    }

    public MessageConsumer createConsumer(Destination destination, MessageListener messageListener) throws JMSException {
        return this.createConsumer(destination, null, messageListener);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, MessageListener messageListener) throws JMSException {
        return this.createConsumer(destination, messageSelector, false, messageListener);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        return this.createConsumer(destination, messageSelector, noLocal, null);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal, MessageListener messageListener) throws JMSException {
        this.checkClosed();
        if (destination instanceof CustomDestination) {
            CustomDestination customDestination = (CustomDestination)destination;
            return customDestination.createConsumer(this, messageSelector, noLocal);
        }
        ActiveMQPrefetchPolicy prefetchPolicy = this.connection.getPrefetchPolicy();
        int prefetch = 0;
        prefetch = destination instanceof Topic ? prefetchPolicy.getTopicPrefetch() : prefetchPolicy.getQueuePrefetch();
        ActiveMQDestination activemqDestination = ActiveMQMessageTransformation.transformDestination(destination);
        return new ActiveMQMessageConsumer(this, this.getNextConsumerId(), activemqDestination, null, messageSelector, prefetch, prefetchPolicy.getMaximumPendingMessageLimit(), noLocal, false, this.asyncDispatch, messageListener);
    }

    public Queue createQueue(String queueName) throws JMSException {
        this.checkClosed();
        if (queueName.startsWith("ID:")) {
            return new ActiveMQTempQueue(queueName);
        }
        return new ActiveMQQueue(queueName);
    }

    public Topic createTopic(String topicName) throws JMSException {
        this.checkClosed();
        if (topicName.startsWith("ID:")) {
            return new ActiveMQTempTopic(topicName);
        }
        return new ActiveMQTopic(topicName);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        this.checkClosed();
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.checkClosed();
        if (topic instanceof CustomDestination) {
            CustomDestination customDestination = (CustomDestination)((Object)topic);
            return customDestination.createDurableSubscriber(this, name, messageSelector, noLocal);
        }
        this.connection.checkClientIDWasManuallySpecified();
        ActiveMQPrefetchPolicy prefetchPolicy = this.connection.getPrefetchPolicy();
        int prefetch = this.isAutoAcknowledge() && this.connection.isOptimizedMessageDispatch() ? prefetchPolicy.getOptimizeDurableTopicPrefetch() : prefetchPolicy.getDurableTopicPrefetch();
        int maxPrendingLimit = prefetchPolicy.getMaximumPendingMessageLimit();
        return new ActiveMQTopicSubscriber(this, this.getNextConsumerId(), ActiveMQMessageTransformation.transformDestination(topic), name, messageSelector, prefetch, maxPrendingLimit, noLocal, false, this.asyncDispatch);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.checkClosed();
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        this.checkClosed();
        return new ActiveMQQueueBrowser(this, this.getNextConsumerId(), ActiveMQMessageTransformation.transformDestination(queue), messageSelector, this.asyncDispatch);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkClosed();
        return (TemporaryQueue)((Object)this.connection.createTempDestination(false));
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkClosed();
        return (TemporaryTopic)((Object)this.connection.createTempDestination(true));
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.checkClosed();
        return this.createReceiver(queue, null);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.checkClosed();
        if (queue instanceof CustomDestination) {
            CustomDestination customDestination = (CustomDestination)((Object)queue);
            return customDestination.createReceiver(this, messageSelector);
        }
        ActiveMQPrefetchPolicy prefetchPolicy = this.connection.getPrefetchPolicy();
        return new ActiveMQQueueReceiver(this, this.getNextConsumerId(), ActiveMQMessageTransformation.transformDestination(queue), messageSelector, prefetchPolicy.getQueuePrefetch(), prefetchPolicy.getMaximumPendingMessageLimit(), this.asyncDispatch);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.checkClosed();
        if (queue instanceof CustomDestination) {
            CustomDestination customDestination = (CustomDestination)((Object)queue);
            return customDestination.createSender(this);
        }
        return new ActiveMQQueueSender(this, ActiveMQMessageTransformation.transformDestination(queue));
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkClosed();
        return this.createSubscriber(topic, null, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.checkClosed();
        if (topic instanceof CustomDestination) {
            CustomDestination customDestination = (CustomDestination)((Object)topic);
            return customDestination.createSubscriber(this, messageSelector, noLocal);
        }
        ActiveMQPrefetchPolicy prefetchPolicy = this.connection.getPrefetchPolicy();
        return new ActiveMQTopicSubscriber(this, this.getNextConsumerId(), ActiveMQMessageTransformation.transformDestination(topic), null, messageSelector, prefetchPolicy.getTopicPrefetch(), prefetchPolicy.getMaximumPendingMessageLimit(), noLocal, false, this.asyncDispatch);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.checkClosed();
        if (topic instanceof CustomDestination) {
            CustomDestination customDestination = (CustomDestination)((Object)topic);
            return customDestination.createPublisher(this);
        }
        return new ActiveMQTopicPublisher(this, ActiveMQMessageTransformation.transformDestination(topic));
    }

    public void unsubscribe(String name) throws JMSException {
        this.checkClosed();
        this.connection.unsubscribe(name);
    }

    public void dispatch(MessageDispatch messageDispatch) {
        try {
            this.executor.execute(messageDispatch);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.connection.onAsyncException(e);
        }
    }

    public void acknowledge() throws JMSException {
        for (ActiveMQMessageConsumer c : this.consumers) {
            c.acknowledge();
        }
    }

    protected void addConsumer(ActiveMQMessageConsumer consumer) throws JMSException {
        this.consumers.add(consumer);
        if (consumer.isDurableSubscriber()) {
            this.stats.onCreateDurableSubscriber();
        }
        this.connection.addDispatcher(consumer.getConsumerId(), this);
    }

    protected void removeConsumer(ActiveMQMessageConsumer consumer) {
        this.connection.removeDispatcher(consumer.getConsumerId());
        if (consumer.isDurableSubscriber()) {
            this.stats.onRemoveDurableSubscriber();
        }
        this.consumers.remove(consumer);
        this.connection.removeDispatcher(consumer);
    }

    protected void addProducer(ActiveMQMessageProducer producer) throws JMSException {
        this.producers.add(producer);
        this.connection.addProducer(producer.getProducerInfo().getProducerId(), producer);
    }

    protected void removeProducer(ActiveMQMessageProducer producer) {
        this.connection.removeProducer(producer.getProducerInfo().getProducerId());
        this.producers.remove(producer);
    }

    protected void start() throws JMSException {
        this.started.set(true);
        for (ActiveMQMessageConsumer c : this.consumers) {
            c.start();
        }
        this.executor.start();
    }

    protected void stop() throws JMSException {
        for (ActiveMQMessageConsumer c : this.consumers) {
            c.stop();
        }
        this.started.set(false);
        this.executor.stop();
    }

    protected SessionId getSessionId() {
        return this.info.getSessionId();
    }

    protected ConsumerId getNextConsumerId() {
        return new ConsumerId(this.info.getSessionId(), this.consumerIdGenerator.getNextSequenceId());
    }

    protected ProducerId getNextProducerId() {
        return new ProducerId(this.info.getSessionId(), this.producerIdGenerator.getNextSequenceId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(ActiveMQMessageProducer producer, ActiveMQDestination destination, Message message, int deliveryMode, int priority, long timeToLive, MemoryUsage producerWindow) throws JMSException {
        this.checkClosed();
        if (destination.isTemporary() && this.connection.isDeleted(destination)) {
            throw new JMSException("Cannot publish to a deleted Destination: " + destination);
        }
        Object object = this.sendMutex;
        synchronized (object) {
            this.doStartTransaction();
            TransactionId txid = this.transactionContext.getTransactionId();
            long sequenceNumber = producer.getMessageSequence();
            ActiveMQMessage msg = ActiveMQMessageTransformation.transformMessage(message, this.connection);
            if (msg == message) {
                msg.setMessageId(new MessageId(producer.getProducerInfo().getProducerId(), sequenceNumber));
            } else {
                msg.setMessageId(new MessageId(producer.getProducerInfo().getProducerId(), sequenceNumber));
                message.setJMSMessageID(msg.getMessageId().toString());
            }
            msg.setJMSDestination(destination);
            msg.setJMSDeliveryMode(deliveryMode);
            long expiration = 0L;
            if (!producer.getDisableMessageTimestamp()) {
                long timeStamp = System.currentTimeMillis();
                msg.setJMSTimestamp(timeStamp);
                if (timeToLive > 0L) {
                    expiration = timeToLive + timeStamp;
                }
            }
            msg.setJMSExpiration(expiration);
            msg.setJMSPriority(priority);
            msg.setJMSRedelivered(false);
            msg.setTransactionId(txid);
            if (this.connection.isCopyMessageOnSend()) {
                msg = (ActiveMQMessage)msg.copy();
            }
            msg.setConnection(this.connection);
            msg.onSend();
            msg.setProducerId(msg.getMessageId().getProducerId());
            if (this.debug) {
                LOG.debug((Object)(this.getSessionId() + " sending message: " + msg));
            }
            if (!(this.connection.isAlwaysSyncSend() || msg.isPersistent() && !this.connection.isUseAsyncSend() && txid == null)) {
                this.connection.asyncSendPacket(msg);
                if (producerWindow != null) {
                    int size = msg.getSize();
                    producerWindow.increaseUsage(size);
                }
            } else {
                this.connection.syncSendPacket(msg);
            }
        }
    }

    protected void doStartTransaction() throws JMSException {
        if (this.getTransacted() && !this.transactionContext.isInXATransaction()) {
            this.transactionContext.begin();
        }
    }

    public boolean hasUncomsumedMessages() {
        return this.executor.hasUncomsumedMessages();
    }

    public boolean isTransacted() {
        return this.acknowledgementMode == 0;
    }

    protected boolean isClientAcknowledge() {
        return this.acknowledgementMode == 2;
    }

    public boolean isAutoAcknowledge() {
        return this.acknowledgementMode == 1;
    }

    public boolean isDupsOkAcknowledge() {
        return this.acknowledgementMode == 3;
    }

    public DeliveryListener getDeliveryListener() {
        return this.deliveryListener;
    }

    public void setDeliveryListener(DeliveryListener deliveryListener) {
        this.deliveryListener = deliveryListener;
    }

    protected SessionInfo getSessionInfo() throws JMSException {
        SessionInfo info = new SessionInfo(this.connection.getConnectionInfo(), this.getSessionId().getValue());
        return info;
    }

    public void asyncSendPacket(Command command) throws JMSException {
        this.connection.asyncSendPacket(command);
    }

    public Response syncSendPacket(Command command) throws JMSException {
        return this.connection.syncSendPacket(command);
    }

    public long getNextDeliveryId() {
        return this.deliveryIdGenerator.getNextSequenceId();
    }

    public void redispatch(ActiveMQDispatcher dispatcher, MessageDispatchChannel unconsumedMessages) throws JMSException {
        List<MessageDispatch> c = unconsumedMessages.removeAll();
        for (MessageDispatch md : c) {
            this.connection.rollbackDuplicate(dispatcher, md.getMessage());
        }
        Collections.reverse(c);
        for (MessageDispatch md : c) {
            this.executor.executeFirst(md);
        }
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public boolean isAsyncDispatch() {
        return this.asyncDispatch;
    }

    public void setAsyncDispatch(boolean asyncDispatch) {
        this.asyncDispatch = asyncDispatch;
    }

    public boolean isSessionAsyncDispatch() {
        return this.sessionAsyncDispatch;
    }

    public void setSessionAsyncDispatch(boolean sessionAsyncDispatch) {
        this.sessionAsyncDispatch = sessionAsyncDispatch;
    }

    public MessageTransformer getTransformer() {
        return this.transformer;
    }

    public ActiveMQConnection getConnection() {
        return this.connection;
    }

    public void setTransformer(MessageTransformer transformer) {
        this.transformer = transformer;
    }

    public BlobTransferPolicy getBlobTransferPolicy() {
        return this.blobTransferPolicy;
    }

    public void setBlobTransferPolicy(BlobTransferPolicy blobTransferPolicy) {
        this.blobTransferPolicy = blobTransferPolicy;
    }

    public List getUnconsumedMessages() {
        return this.executor.getUnconsumedMessages();
    }

    public String toString() {
        return "ActiveMQSession {id=" + this.info.getSessionId() + ",started=" + this.started.get() + "}";
    }

    public void checkMessageListener() throws JMSException {
        if (this.messageListener != null) {
            throw new IllegalStateException("Cannot synchronously receive a message when a MessageListener is set");
        }
        for (ActiveMQMessageConsumer consumer : this.consumers) {
            if (consumer.getMessageListener() == null) continue;
            throw new IllegalStateException("Cannot synchronously receive a message when a MessageListener is set");
        }
    }

    protected void setOptimizeAcknowledge(boolean value) {
        for (ActiveMQMessageConsumer c : this.consumers) {
            c.setOptimizeAcknowledge(value);
        }
    }

    protected void setPrefetchSize(ConsumerId id, int prefetch) {
        for (ActiveMQMessageConsumer c : this.consumers) {
            if (!c.getConsumerId().equals(id)) continue;
            c.setPrefetchSize(prefetch);
            break;
        }
    }

    protected void close(ConsumerId id) {
        for (ActiveMQMessageConsumer c : this.consumers) {
            if (!c.getConsumerId().equals(id)) continue;
            try {
                c.close();
            }
            catch (JMSException e) {
                LOG.warn((Object)"Exception closing consumer", (Throwable)e);
            }
            LOG.warn((Object)"Closed consumer on Command");
            break;
        }
    }

    public boolean isInUse(ActiveMQTempDestination destination) {
        for (ActiveMQMessageConsumer c : this.consumers) {
            if (!c.isInUse(destination)) continue;
            return true;
        }
        return false;
    }

    public static interface DeliveryListener {
        public void beforeDelivery(ActiveMQSession var1, Message var2);

        public void afterDelivery(ActiveMQSession var1, Message var2);
    }
}

