/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.QueueMessageReference;
import org.apache.activemq.broker.region.cursors.AbstractPendingMessageCursor;
import org.apache.activemq.command.Message;
import org.apache.activemq.kaha.CommandMarshaller;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.usage.Usage;
import org.apache.activemq.usage.UsageListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePendingMessageCursor
extends AbstractPendingMessageCursor
implements UsageListener {
    private static final AtomicLong NAME_COUNT = new AtomicLong();
    private Store store;
    private String name;
    private LinkedList<MessageReference> memoryList = new LinkedList();
    private ListContainer<MessageReference> diskList;
    private Iterator iter;
    private Destination regionDestination;
    private boolean iterating;
    private boolean flushRequired;
    private AtomicBoolean started = new AtomicBoolean();
    private MessageReference last = null;

    public FilePendingMessageCursor(String name, Store store) {
        this.name = NAME_COUNT.incrementAndGet() + "_" + name;
        this.store = store;
    }

    @Override
    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            super.start();
            if (this.systemUsage != null) {
                this.systemUsage.getMemoryUsage().addUsageListener(this);
            }
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            super.stop();
            if (this.systemUsage != null) {
                this.systemUsage.getMemoryUsage().removeUsageListener(this);
            }
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        if (this.memoryList.isEmpty() && this.isDiskListEmpty()) {
            return true;
        }
        Iterator iterator = this.memoryList.iterator();
        while (iterator.hasNext()) {
            MessageReference node = (MessageReference)iterator.next();
            if (node == QueueMessageReference.NULL_MESSAGE) continue;
            if (!node.isDropped()) {
                return false;
            }
            iterator.remove();
        }
        return this.isDiskListEmpty();
    }

    @Override
    public synchronized void reset() {
        this.iterating = true;
        this.last = null;
        this.iter = this.isDiskListEmpty() ? this.memoryList.iterator() : this.getDiskList().listIterator();
    }

    @Override
    public synchronized void release() {
        this.iterating = false;
        if (this.flushRequired) {
            this.flushRequired = false;
            this.flushToDisk();
        }
    }

    @Override
    public synchronized void destroy() throws Exception {
        this.stop();
        for (Message message : this.memoryList) {
            message.decrementReferenceCount();
        }
        this.memoryList.clear();
        if (!this.isDiskListEmpty()) {
            this.getDiskList().clear();
        }
    }

    @Override
    public synchronized LinkedList<MessageReference> pageInList(int maxItems) {
        int count;
        LinkedList<MessageReference> result = new LinkedList<MessageReference>();
        Iterator i = this.memoryList.iterator();
        for (count = 0; i.hasNext() && count < maxItems; ++count) {
            result.add((MessageReference)i.next());
        }
        if (count < maxItems && !this.isDiskListEmpty()) {
            i = this.getDiskList().iterator();
            while (i.hasNext() && count < maxItems) {
                Message message = (Message)i.next();
                message.setRegionDestination(this.regionDestination);
                message.setMemoryUsage(this.getSystemUsage().getMemoryUsage());
                message.incrementReferenceCount();
                result.add(message);
                ++count;
            }
        }
        return result;
    }

    @Override
    public synchronized void addMessageLast(MessageReference node) {
        try {
            this.regionDestination = node.getMessage().getRegionDestination();
            if (this.isSpaceInMemoryList()) {
                this.memoryList.add(node);
                node.incrementReferenceCount();
            } else {
                this.flushToDisk();
                node.decrementReferenceCount();
                this.systemUsage.getTempUsage().waitForSpace();
                this.getDiskList().addLast(node);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void addMessageFirst(MessageReference node) {
        try {
            this.regionDestination = node.getMessage().getRegionDestination();
            if (this.isSpaceInMemoryList()) {
                this.memoryList.addFirst(node);
                node.incrementReferenceCount();
            } else {
                this.flushToDisk();
                this.systemUsage.getTempUsage().waitForSpace();
                node.decrementReferenceCount();
                this.getDiskList().addFirst(node);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public synchronized MessageReference next() {
        Message message = (Message)this.iter.next();
        this.last = message;
        if (!this.isDiskListEmpty()) {
            message.setRegionDestination(this.regionDestination);
            message.setMemoryUsage(this.getSystemUsage().getMemoryUsage());
            message.incrementReferenceCount();
        }
        return message;
    }

    @Override
    public synchronized void remove() {
        this.iter.remove();
        if (this.last != null) {
            this.last.decrementReferenceCount();
        }
    }

    @Override
    public synchronized void remove(MessageReference node) {
        if (this.memoryList.remove(node)) {
            node.decrementReferenceCount();
        }
        if (!this.isDiskListEmpty()) {
            this.getDiskList().remove(node);
        }
    }

    @Override
    public synchronized int size() {
        return this.memoryList.size() + (this.isDiskListEmpty() ? 0 : this.getDiskList().size());
    }

    @Override
    public synchronized void clear() {
        this.memoryList.clear();
        if (!this.isDiskListEmpty()) {
            this.getDiskList().clear();
        }
        this.last = null;
    }

    @Override
    public synchronized boolean isFull() {
        return false;
    }

    @Override
    public boolean hasMessagesBufferedToDeliver() {
        return !this.isEmpty();
    }

    @Override
    public void setSystemUsage(SystemUsage usageManager) {
        super.setSystemUsage(usageManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUsageChanged(Usage usage, int oldPercentUsage, int newPercentUsage) {
        if (newPercentUsage >= this.getMemoryUsageHighWaterMark()) {
            FilePendingMessageCursor filePendingMessageCursor = this;
            synchronized (filePendingMessageCursor) {
                this.flushRequired = true;
                if (!this.iterating) {
                    this.flushToDisk();
                    this.flushRequired = false;
                }
            }
        }
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    protected boolean isSpaceInMemoryList() {
        return this.hasSpace() && this.isDiskListEmpty();
    }

    protected synchronized void flushToDisk() {
        if (!this.memoryList.isEmpty()) {
            while (!this.memoryList.isEmpty()) {
                MessageReference node = this.memoryList.removeFirst();
                node.decrementReferenceCount();
                this.getDiskList().addLast(node);
            }
            this.memoryList.clear();
        }
    }

    protected boolean isDiskListEmpty() {
        return this.diskList == null || this.diskList.isEmpty();
    }

    protected ListContainer<MessageReference> getDiskList() {
        if (this.diskList == null) {
            try {
                this.diskList = this.store.getListContainer(this.name, "TopicSubscription", true);
                this.diskList.setMarshaller(new CommandMarshaller(new OpenWireFormat()));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.diskList;
    }
}

