/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.command.DiscoveryEvent;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.NetworkBridge;
import org.apache.activemq.network.NetworkBridgeFactory;
import org.apache.activemq.network.NetworkBridgeListener;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.DiscoveryAgentFactory;
import org.apache.activemq.transport.discovery.DiscoveryListener;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiscoveryNetworkConnector
extends NetworkConnector
implements DiscoveryListener {
    private static final Log LOG = LogFactory.getLog(DiscoveryNetworkConnector.class);
    private DiscoveryAgent discoveryAgent;
    private ConcurrentHashMap<URI, NetworkBridge> bridges = new ConcurrentHashMap();

    public DiscoveryNetworkConnector() {
    }

    public DiscoveryNetworkConnector(URI discoveryURI) throws IOException {
        this.setUri(discoveryURI);
    }

    public void setUri(URI discoveryURI) throws IOException {
        this.setDiscoveryAgent(DiscoveryAgentFactory.createDiscoveryAgent(discoveryURI));
    }

    public void onServiceAdd(DiscoveryEvent event) {
        String localURIName = this.localURI.getScheme() + "://" + this.localURI.getHost();
        if (this.serviceSupport.isStopped() || this.serviceSupport.isStopping()) {
            return;
        }
        String url = event.getServiceName();
        if (url != null) {
            Transport localTransport;
            Transport remoteTransport;
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                LOG.warn((Object)("Could not connect to remote URI: " + url + " due to bad URI syntax: " + e), (Throwable)e);
                return;
            }
            if (this.bridges.containsKey(uri) || this.localURI.equals(uri) || this.connectionFilter != null && !this.connectionFilter.connectTo(uri)) {
                return;
            }
            URI connectUri = uri;
            LOG.info((Object)("Establishing network connection between from " + localURIName + " to " + connectUri));
            try {
                remoteTransport = TransportFactory.connect(connectUri);
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not connect to remote URI: " + localURIName + ": " + e.getMessage()));
                LOG.debug((Object)("Connection failure exception: " + e), (Throwable)e);
                return;
            }
            try {
                localTransport = this.createLocalTransport();
            }
            catch (Exception e) {
                ServiceSupport.dispose(remoteTransport);
                LOG.warn((Object)("Could not connect to local URI: " + localURIName + ": " + e.getMessage()));
                LOG.debug((Object)("Connection failure exception: " + e), (Throwable)e);
                return;
            }
            NetworkBridge bridge = this.createBridge(localTransport, remoteTransport, event);
            this.bridges.put(uri, bridge);
            try {
                bridge.start();
            }
            catch (Exception e) {
                ServiceSupport.dispose(localTransport);
                ServiceSupport.dispose(remoteTransport);
                LOG.warn((Object)("Could not start network bridge between: " + localURIName + " and: " + uri + " due to: " + e));
                LOG.debug((Object)("Start failure exception: " + e), (Throwable)e);
                try {
                    this.discoveryAgent.serviceFailed(event);
                }
                catch (IOException e1) {
                    // empty catch block
                }
                return;
            }
        }
    }

    public void onServiceRemove(DiscoveryEvent event) {
        String url = event.getServiceName();
        if (url != null) {
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                LOG.warn((Object)("Could not connect to remote URI: " + url + " due to bad URI syntax: " + e), (Throwable)e);
                return;
            }
            NetworkBridge bridge = this.bridges.remove(uri);
            if (bridge == null) {
                return;
            }
            ServiceSupport.dispose(bridge);
        }
    }

    public DiscoveryAgent getDiscoveryAgent() {
        return this.discoveryAgent;
    }

    public void setDiscoveryAgent(DiscoveryAgent discoveryAgent) {
        this.discoveryAgent = discoveryAgent;
        if (discoveryAgent != null) {
            this.discoveryAgent.setDiscoveryListener(this);
        }
    }

    protected void handleStart() throws Exception {
        if (this.discoveryAgent == null) {
            throw new IllegalStateException("You must configure the 'discoveryAgent' property");
        }
        this.discoveryAgent.start();
        super.handleStart();
    }

    protected void handleStop(ServiceStopper stopper) throws Exception {
        for (NetworkBridge bridge : this.bridges.values()) {
            try {
                bridge.stop();
            }
            catch (Exception e) {
                stopper.onException(this, e);
            }
        }
        try {
            this.discoveryAgent.stop();
        }
        catch (Exception e) {
            stopper.onException(this, e);
        }
        super.handleStop(stopper);
    }

    protected NetworkBridge createBridge(Transport localTransport, Transport remoteTransport, final DiscoveryEvent event) {
        NetworkBridgeListener listener = new NetworkBridgeListener(){

            public void bridgeFailed() {
                if (!DiscoveryNetworkConnector.this.serviceSupport.isStopped()) {
                    try {
                        DiscoveryNetworkConnector.this.discoveryAgent.serviceFailed(event);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            public void onStart(NetworkBridge bridge) {
                DiscoveryNetworkConnector.this.registerNetworkBridgeMBean(bridge);
            }

            public void onStop(NetworkBridge bridge) {
                DiscoveryNetworkConnector.this.unregisterNetworkBridgeMBean(bridge);
            }
        };
        DemandForwardingBridge result = NetworkBridgeFactory.createBridge(this, localTransport, remoteTransport, listener);
        return this.configureBridge(result);
    }

    public String getName() {
        return this.discoveryAgent.toString();
    }
}

