/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.pool.PooledSession;
import org.apache.activemq.pool.SessionKey;
import org.apache.activemq.pool.SessionPool;
import org.apache.activemq.transport.TransportListener;
import org.apache.commons.pool.ObjectPoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPool {
    private TransactionManager transactionManager;
    private ActiveMQConnection connection;
    private Map<SessionKey, SessionPool> cache;
    private AtomicBoolean started = new AtomicBoolean(false);
    private int referenceCount;
    private ObjectPoolFactory poolFactory;
    private long lastUsed = System.currentTimeMillis();
    private boolean hasFailed;
    private boolean hasExpired;
    private int idleTimeout = 30000;

    public ConnectionPool(ActiveMQConnection connection, ObjectPoolFactory poolFactory, TransactionManager transactionManager) {
        this(connection, new HashMap<SessionKey, SessionPool>(), poolFactory, transactionManager);
        connection.addTransportListener(new TransportListener(){

            public void onCommand(Object command) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onException(IOException error) {
                ConnectionPool connectionPool = ConnectionPool.this;
                synchronized (connectionPool) {
                    ConnectionPool.this.hasFailed = true;
                }
            }

            public void transportInterupted() {
            }

            public void transportResumed() {
            }
        });
    }

    public ConnectionPool(ActiveMQConnection connection, Map<SessionKey, SessionPool> cache, ObjectPoolFactory poolFactory, TransactionManager transactionManager) {
        this.connection = connection;
        this.cache = cache;
        this.poolFactory = poolFactory;
        this.transactionManager = transactionManager;
    }

    public void start() throws JMSException {
        if (this.started.compareAndSet(false, true)) {
            this.connection.start();
        }
    }

    public synchronized ActiveMQConnection getConnection() {
        return this.connection;
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        try {
            SessionKey key;
            SessionPool pool;
            boolean isXa;
            boolean bl = isXa = this.transactionManager != null && this.transactionManager.getStatus() != 6;
            if (isXa) {
                transacted = true;
                ackMode = 0;
            }
            if ((pool = this.cache.get(key = new SessionKey(transacted, ackMode))) == null) {
                pool = new SessionPool(this, key, this.poolFactory.createPool());
                this.cache.put(key, pool);
            }
            PooledSession session = pool.borrowSession();
            if (isXa) {
                session.setIgnoreClose(true);
                this.transactionManager.getTransaction().registerSynchronization((javax.transaction.Synchronization)new Synchronization(session));
                this.incrementReferenceCount();
                this.transactionManager.getTransaction().enlistResource(this.createXaResource(session));
            }
            return session;
        }
        catch (RollbackException e) {
            JMSException jmsException = new JMSException("Rollback Exception");
            jmsException.initCause(e);
            throw jmsException;
        }
        catch (SystemException e) {
            JMSException jmsException = new JMSException("System Exception");
            jmsException.initCause(e);
            throw jmsException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.connection != null) {
            try {
                Iterator<SessionPool> i = this.cache.values().iterator();
                while (i.hasNext()) {
                    SessionPool pool = i.next();
                    i.remove();
                    try {
                        pool.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    public synchronized void incrementReferenceCount() {
        ++this.referenceCount;
        this.lastUsed = System.currentTimeMillis();
    }

    public synchronized void decrementReferenceCount() {
        --this.referenceCount;
        this.lastUsed = System.currentTimeMillis();
        if (this.referenceCount == 0) {
            this.expiredCheck();
        }
    }

    public synchronized boolean expiredCheck() {
        if (this.connection == null) {
            return true;
        }
        if (this.hasExpired) {
            if (this.referenceCount == 0) {
                this.close();
            }
            return true;
        }
        if (this.hasFailed || this.idleTimeout > 0 && System.currentTimeMillis() > this.lastUsed + (long)this.idleTimeout) {
            this.hasExpired = true;
            if (this.referenceCount == 0) {
                this.close();
            }
            return true;
        }
        return false;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    protected XAResource createXaResource(PooledSession session) throws JMSException {
        return session.getSession().getTransactionContext();
    }

    protected class Synchronization
    implements javax.transaction.Synchronization {
        private final PooledSession session;

        protected Synchronization(PooledSession session) {
            this.session = session;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            try {
                this.session.setIgnoreClose(false);
                this.session.close();
                ConnectionPool.this.decrementReferenceCount();
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

