/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import java.io.Serializable;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQMessageProducer;
import org.apache.activemq.ActiveMQQueueSender;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.ActiveMQTopicPublisher;
import org.apache.activemq.AlreadyClosedException;
import org.apache.activemq.pool.PooledProducer;
import org.apache.activemq.pool.PooledQueueSender;
import org.apache.activemq.pool.PooledTopicPublisher;
import org.apache.activemq.pool.SessionPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PooledSession
implements TopicSession,
QueueSession {
    private static final transient Log LOG = LogFactory.getLog(PooledSession.class);
    private ActiveMQSession session;
    private SessionPool sessionPool;
    private ActiveMQMessageProducer messageProducer;
    private ActiveMQQueueSender queueSender;
    private ActiveMQTopicPublisher topicPublisher;
    private boolean transactional = true;
    private boolean ignoreClose;
    private final CopyOnWriteArrayList<MessageConsumer> consumers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<QueueBrowser> browsers = new CopyOnWriteArrayList();

    public PooledSession(ActiveMQSession aSession, SessionPool sessionPool) {
        this.session = aSession;
        this.sessionPool = sessionPool;
        this.transactional = this.session.isTransacted();
    }

    protected boolean isIgnoreClose() {
        return this.ignoreClose;
    }

    protected void setIgnoreClose(boolean ignoreClose) {
        this.ignoreClose = ignoreClose;
    }

    public void close() throws JMSException {
        if (!this.ignoreClose) {
            this.getSession().setMessageListener(null);
            for (MessageConsumer consumer : this.consumers) {
                consumer.close();
            }
            this.consumers.clear();
            for (QueueBrowser browser : this.browsers) {
                browser.close();
            }
            this.browsers.clear();
            if (this.transactional) {
                try {
                    this.getSession().rollback();
                }
                catch (JMSException e) {
                    LOG.warn((Object)("Caught exception trying rollback() when putting session back into the pool: " + e), (Throwable)e);
                    try {
                        this.session.close();
                    }
                    catch (JMSException e1) {
                        LOG.trace((Object)("Ignoring exception as discarding session: " + e1), (Throwable)e1);
                    }
                    this.session = null;
                    return;
                }
            }
            this.sessionPool.returnSession(this);
        }
    }

    public void commit() throws JMSException {
        this.getSession().commit();
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.getSession().createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.getSession().createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.getSession().createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.getSession().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return this.getSession().createObjectMessage(serializable);
    }

    public Queue createQueue(String s) throws JMSException {
        return this.getSession().createQueue(s);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.getSession().createStreamMessage();
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.getSession().createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.getSession().createTemporaryTopic();
    }

    public void unsubscribe(String s) throws JMSException {
        this.getSession().unsubscribe(s);
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.getSession().createTextMessage();
    }

    public TextMessage createTextMessage(String s) throws JMSException {
        return this.getSession().createTextMessage(s);
    }

    public Topic createTopic(String s) throws JMSException {
        return this.getSession().createTopic(s);
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.getSession().getAcknowledgeMode();
    }

    public boolean getTransacted() throws JMSException {
        return this.getSession().getTransacted();
    }

    public void recover() throws JMSException {
        this.getSession().recover();
    }

    public void rollback() throws JMSException {
        this.getSession().rollback();
    }

    public void run() {
        if (this.session != null) {
            this.session.run();
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.addQueueBrowser(this.getSession().createBrowser(queue));
    }

    public QueueBrowser createBrowser(Queue queue, String selector) throws JMSException {
        return this.addQueueBrowser(this.getSession().createBrowser(queue, selector));
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.addConsumer(this.getSession().createConsumer(destination));
    }

    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        return this.addConsumer(this.getSession().createConsumer(destination, selector));
    }

    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        return this.addConsumer(this.getSession().createConsumer(destination, selector, noLocal));
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String selector) throws JMSException {
        return this.addTopicSubscriber(this.getSession().createDurableSubscriber(topic, selector));
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        return this.addTopicSubscriber(this.getSession().createDurableSubscriber(topic, name, selector, noLocal));
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.getSession().getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.getSession().setMessageListener(messageListener);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.addTopicSubscriber(this.getSession().createSubscriber(topic));
    }

    public TopicSubscriber createSubscriber(Topic topic, String selector, boolean local) throws JMSException {
        return this.addTopicSubscriber(this.getSession().createSubscriber(topic, selector, local));
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.addQueueReceiver(this.getSession().createReceiver(queue));
    }

    public QueueReceiver createReceiver(Queue queue, String selector) throws JMSException {
        return this.addQueueReceiver(this.getSession().createReceiver(queue, selector));
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return new PooledProducer(this.getMessageProducer(), destination);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return new PooledQueueSender(this.getQueueSender(), (Destination)queue);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return new PooledTopicPublisher(this.getTopicPublisher(), (Destination)topic);
    }

    protected ActiveMQSession getSession() throws AlreadyClosedException {
        if (this.session == null) {
            throw new AlreadyClosedException("The session has already been closed");
        }
        return this.session;
    }

    public ActiveMQMessageProducer getMessageProducer() throws JMSException {
        if (this.messageProducer == null) {
            this.messageProducer = (ActiveMQMessageProducer)this.getSession().createProducer(null);
        }
        return this.messageProducer;
    }

    public ActiveMQQueueSender getQueueSender() throws JMSException {
        if (this.queueSender == null) {
            this.queueSender = (ActiveMQQueueSender)this.getSession().createSender(null);
        }
        return this.queueSender;
    }

    public ActiveMQTopicPublisher getTopicPublisher() throws JMSException {
        if (this.topicPublisher == null) {
            this.topicPublisher = (ActiveMQTopicPublisher)this.getSession().createPublisher(null);
        }
        return this.topicPublisher;
    }

    private QueueBrowser addQueueBrowser(QueueBrowser browser) {
        this.browsers.add(browser);
        return browser;
    }

    private MessageConsumer addConsumer(MessageConsumer consumer) {
        this.consumers.add(consumer);
        return consumer;
    }

    private TopicSubscriber addTopicSubscriber(TopicSubscriber subscriber) {
        this.consumers.add(subscriber);
        return subscriber;
    }

    private QueueReceiver addQueueReceiver(QueueReceiver receiver) {
        this.consumers.add(receiver);
        return receiver;
    }

    public String toString() {
        return "PooledSession { " + this.session + " }";
    }
}

