/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.ReferenceStore;
import org.apache.activemq.store.TopicReferenceStore;
import org.apache.activemq.store.kahadaptor.ConsumerMessageRef;
import org.apache.activemq.store.kahadaptor.ConsumerMessageRefMarshaller;
import org.apache.activemq.store.kahadaptor.KahaReferenceStore;
import org.apache.activemq.store.kahadaptor.KahaReferenceStoreAdapter;
import org.apache.activemq.store.kahadaptor.ReferenceRecord;
import org.apache.activemq.store.kahadaptor.TopicSubAck;
import org.apache.activemq.store.kahadaptor.TopicSubContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KahaTopicReferenceStore
extends KahaReferenceStore
implements TopicReferenceStore {
    protected ListContainer<TopicSubAck> ackContainer;
    protected Map<String, TopicSubContainer> subscriberMessages = new ConcurrentHashMap<String, TopicSubContainer>();
    private Map<String, SubscriptionInfo> subscriberContainer;
    private Store store;
    private static final String TOPIC_SUB_NAME = "tsn";

    public KahaTopicReferenceStore(Store store, KahaReferenceStoreAdapter adapter, MapContainer<MessageId, ReferenceRecord> messageContainer, ListContainer<TopicSubAck> ackContainer, MapContainer<String, SubscriptionInfo> subsContainer, ActiveMQDestination destination) throws IOException {
        super(adapter, messageContainer, destination);
        this.store = store;
        this.ackContainer = ackContainer;
        this.subscriberContainer = subsContainer;
        for (SubscriptionInfo info : this.subscriberContainer.values()) {
            this.addSubscriberMessageContainer(info.getClientId(), info.getSubscriptionName());
        }
    }

    @Override
    protected MessageId getMessageId(Object object) {
        return new MessageId(((ReferenceRecord)object).getMessageId());
    }

    @Override
    public synchronized void addMessage(ConnectionContext context, Message message) throws IOException {
        throw new RuntimeException("Use addMessageReference instead");
    }

    @Override
    public synchronized Message getMessage(MessageId identity) throws IOException {
        throw new RuntimeException("Use addMessageReference instead");
    }

    @Override
    public void addMessageReference(ConnectionContext context, MessageId messageId, ReferenceStore.ReferenceData data) {
        ReferenceRecord record = new ReferenceRecord(messageId.toString(), data);
        int subscriberCount = this.subscriberMessages.size();
        if (subscriberCount > 0) {
            StoreEntry messageEntry = this.messageContainer.place(messageId, record);
            this.addInterest(record);
            TopicSubAck tsa = new TopicSubAck();
            tsa.setCount(subscriberCount);
            tsa.setMessageEntry(messageEntry);
            StoreEntry ackEntry = this.ackContainer.placeLast(tsa);
            for (TopicSubContainer container : this.subscriberMessages.values()) {
                ConsumerMessageRef ref = new ConsumerMessageRef();
                ref.setAckEntry(ackEntry);
                ref.setMessageEntry(messageEntry);
                ref.setMessageId(messageId);
                container.add(ref);
            }
        }
    }

    @Override
    public ReferenceStore.ReferenceData getMessageReference(MessageId identity) throws IOException {
        ReferenceRecord result = (ReferenceRecord)this.messageContainer.get(identity);
        if (result == null) {
            return null;
        }
        return result.getData();
    }

    @Override
    public void addReferenceFileIdsInUse() {
        StoreEntry entry = this.ackContainer.getFirst();
        while (entry != null) {
            TopicSubAck subAck = this.ackContainer.get(entry);
            if (subAck.getCount() > 0) {
                ReferenceRecord rr = (ReferenceRecord)this.messageContainer.getValue(subAck.getMessageEntry());
                this.addInterest(rr);
            }
            entry = this.ackContainer.getNext(entry);
        }
    }

    protected MapContainer addSubscriberMessageContainer(String clientId, String subscriptionName) throws IOException {
        MapContainer container = this.store.getMapContainer(this.getSubscriptionContainerName(this.getSubscriptionKey(clientId, subscriptionName)));
        container.setKeyMarshaller(Store.MESSAGEID_MARSHALLER);
        ConsumerMessageRefMarshaller marshaller = new ConsumerMessageRefMarshaller();
        container.setValueMarshaller(marshaller);
        TopicSubContainer tsc = new TopicSubContainer(container);
        this.subscriberMessages.put(this.getSubscriptionKey(clientId, subscriptionName), tsc);
        return container;
    }

    @Override
    public synchronized boolean acknowledgeReference(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId) throws IOException {
        boolean removeMessage = false;
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        TopicSubContainer container = this.subscriberMessages.get(key);
        if (container != null) {
            ConsumerMessageRef ref = null;
            ref = container.remove(messageId);
            if (ref != null) {
                TopicSubAck tsa = this.ackContainer.get(ref.getAckEntry());
                if (tsa != null && tsa.decrementCount() <= 0) {
                    StoreEntry entry = ref.getAckEntry();
                    entry = this.ackContainer.refresh(entry);
                    this.ackContainer.remove(entry);
                    ReferenceRecord rr = (ReferenceRecord)this.messageContainer.get(messageId);
                    if (rr != null) {
                        entry = tsa.getMessageEntry();
                        entry = this.messageContainer.refresh(entry);
                        this.messageContainer.remove(entry);
                        this.removeInterest(rr);
                        removeMessage = true;
                    }
                }
            } else {
                removeMessage = true;
            }
        }
        return removeMessage;
    }

    @Override
    public synchronized void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId) throws IOException {
        TopicSubAck tsa;
        ConsumerMessageRef ref;
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        TopicSubContainer container = this.subscriberMessages.get(key);
        if (container != null && (ref = container.remove(messageId)) != null && (tsa = this.ackContainer.get(ref.getAckEntry())) != null) {
            if (tsa.decrementCount() <= 0) {
                StoreEntry entry = ref.getAckEntry();
                entry = this.ackContainer.refresh(entry);
                this.ackContainer.remove(entry);
                ReferenceRecord rr = (ReferenceRecord)this.messageContainer.get(messageId);
                if (rr != null) {
                    entry = tsa.getMessageEntry();
                    entry = this.messageContainer.refresh(entry);
                    this.messageContainer.remove(entry);
                    this.removeInterest(rr);
                }
            } else {
                this.ackContainer.update(ref.getAckEntry(), tsa);
            }
        }
    }

    @Override
    public synchronized void addSubsciption(SubscriptionInfo info, boolean retroactive) throws IOException {
        String key = this.getSubscriptionKey(info.getClientId(), info.getSubscriptionName());
        if (!this.subscriberContainer.containsKey(key)) {
            this.subscriberContainer.put(key, info);
            this.adapter.addSubscriberState(info);
        }
        this.addSubscriberMessageContainer(info.getClientId(), info.getSubscriptionName());
        if (retroactive) {
            // empty if block
        }
    }

    @Override
    public synchronized void deleteSubscription(String clientId, String subscriptionName) throws IOException {
        SubscriptionInfo info = this.lookupSubscription(clientId, subscriptionName);
        if (info != null) {
            this.adapter.removeSubscriberState(info);
        }
        this.removeSubscriberMessageContainer(clientId, subscriptionName);
    }

    @Override
    public SubscriptionInfo[] getAllSubscriptions() throws IOException {
        SubscriptionInfo[] result = this.subscriberContainer.values().toArray(new SubscriptionInfo[this.subscriberContainer.size()]);
        return result;
    }

    @Override
    public int getMessageCount(String clientId, String subscriberName) throws IOException {
        String key = this.getSubscriptionKey(clientId, subscriberName);
        TopicSubContainer container = this.subscriberMessages.get(key);
        return container != null ? container.size() : 0;
    }

    @Override
    public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
        return this.subscriberContainer.get(this.getSubscriptionKey(clientId, subscriptionName));
    }

    @Override
    public synchronized void recoverNextMessages(String clientId, String subscriptionName, int maxReturned, MessageRecoveryListener listener) throws Exception {
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        TopicSubContainer container = this.subscriberMessages.get(key);
        if (container != null) {
            int count = 0;
            StoreEntry entry = container.getBatchEntry();
            if (entry == null) {
                entry = container.getEntry();
            } else if ((entry = container.refreshEntry(entry)) != null) {
                entry = container.getNextEntry(entry);
            }
            if (entry != null) {
                do {
                    ConsumerMessageRef consumerRef;
                    ReferenceRecord msg;
                    if ((msg = (ReferenceRecord)this.messageContainer.getValue((consumerRef = container.get(entry)).getMessageEntry())) != null) {
                        if (!this.recoverReference(listener, msg)) break;
                        ++count;
                        container.setBatchEntry(msg.getMessageId(), entry);
                        continue;
                    }
                    container.reset();
                } while ((entry = container.getNextEntry(entry)) != null && count < maxReturned && listener.hasSpace());
            }
        }
    }

    @Override
    public void recoverSubscription(String clientId, String subscriptionName, MessageRecoveryListener listener) throws Exception {
        block1: {
            ConsumerMessageRef ref;
            ReferenceRecord msg;
            String key = this.getSubscriptionKey(clientId, subscriptionName);
            TopicSubContainer container = this.subscriberMessages.get(key);
            if (container == null) break block1;
            Iterator i = container.iterator();
            while (i.hasNext() && ((msg = (ReferenceRecord)this.messageContainer.get((ref = (ConsumerMessageRef)i.next()).getMessageEntry())) == null || this.recoverReference(listener, msg))) {
            }
        }
    }

    @Override
    public synchronized void resetBatching(String clientId, String subscriptionName) {
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        TopicSubContainer topicSubContainer = this.subscriberMessages.get(key);
        if (topicSubContainer != null) {
            topicSubContainer.reset();
        }
    }

    protected void removeSubscriberMessageContainer(String clientId, String subscriptionName) throws IOException {
        String subscriberKey = this.getSubscriptionKey(clientId, subscriptionName);
        String containerName = this.getSubscriptionContainerName(subscriberKey);
        this.subscriberContainer.remove(subscriberKey);
        TopicSubContainer container = this.subscriberMessages.remove(subscriberKey);
        Iterator i = container.iterator();
        while (i.hasNext()) {
            TopicSubAck tsa;
            ConsumerMessageRef ref = (ConsumerMessageRef)i.next();
            if (ref == null || (tsa = this.ackContainer.get(ref.getAckEntry())) == null) continue;
            if (tsa.decrementCount() <= 0) {
                this.ackContainer.remove(ref.getAckEntry());
                this.messageContainer.remove(tsa.getMessageEntry());
                continue;
            }
            this.ackContainer.update(ref.getAckEntry(), tsa);
        }
        this.store.deleteMapContainer(containerName);
    }

    protected String getSubscriptionKey(String clientId, String subscriberName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(clientId).append(":");
        String name = subscriberName != null ? subscriberName : "NOT_SET";
        return buffer.append(name).toString();
    }

    private String getSubscriptionContainerName(String subscriptionKey) {
        StringBuffer buffer = new StringBuffer(subscriptionKey);
        return buffer.append(":").append(this.destination.getQualifiedName()).append(TOPIC_SUB_NAME).toString();
    }
}

