/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.state.ProducerState;

public final class BrokerSupport {
    private BrokerSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resend(ConnectionContext context, Message message, ActiveMQDestination deadLetterDestination) throws Exception {
        if (message.getOriginalDestination() != null) {
            message.setOriginalDestination(message.getDestination());
        }
        if (message.getOriginalTransactionId() != null) {
            message.setOriginalTransactionId(message.getTransactionId());
        }
        message.setDestination(deadLetterDestination);
        message.setTransactionId(null);
        boolean originalFlowControl = context.isProducerFlowControl();
        try {
            context.setProducerFlowControl(false);
            ProducerInfo info = new ProducerInfo();
            ProducerState state = new ProducerState(info);
            ProducerBrokerExchange producerExchange = new ProducerBrokerExchange();
            producerExchange.setProducerState(state);
            producerExchange.setMutable(true);
            producerExchange.setConnectionContext(context);
            context.getBroker().send(producerExchange, message);
        }
        finally {
            context.setProducerFlowControl(originalFlowControl);
        }
    }
}

