/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.BrokerRestartTestSupport;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DataArrayResponse;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.command.XATransactionId;

public class XARecoveryBrokerTest
extends BrokerRestartTestSupport {
    public void testPreparedTransactionRecoveredOnRestart() throws Exception {
        int i;
        ActiveMQDestination destination = this.createDestination();
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        connection.send(producerInfo);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send(consumerInfo);
        for (int i2 = 0; i2 < 4; ++i2) {
            XATransactionId txid = this.createXATransaction(sessionInfo);
            connection.send(this.createBeginTransaction(connectionInfo, txid));
            Message message = this.createMessage(producerInfo, destination);
            message.setPersistent(true);
            message.setTransactionId(txid);
            connection.send(message);
            connection.send(this.createPrepareTransaction(connectionInfo, txid));
        }
        this.assertNoMessagesLeft(connection);
        connection.request(this.closeConnectionInfo(connectionInfo));
        this.restartBroker();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send(consumerInfo);
        this.assertNoMessagesLeft(connection);
        Response response = connection.request(new TransactionInfo(connectionInfo.getConnectionId(), null, 5));
        XARecoveryBrokerTest.assertNotNull((Object)response);
        DataArrayResponse dar = (DataArrayResponse)response;
        XARecoveryBrokerTest.assertEquals((int)4, (int)dar.getData().length);
        for (i = 0; i < dar.getData().length; ++i) {
            connection.send(this.createCommitTransaction2Phase(connectionInfo, (TransactionId)dar.getData()[i]));
        }
        for (i = 0; i < 4; ++i) {
            Message m = this.receiveMessage(connection);
            XARecoveryBrokerTest.assertNotNull((Object)m);
        }
        this.assertNoMessagesLeft(connection);
    }

    public void testQueuePersistentCommitedMessagesNotLostOnRestart() throws Exception {
        ActiveMQDestination destination = this.createDestination();
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        connection.send(producerInfo);
        XATransactionId txid = this.createXATransaction(sessionInfo);
        connection.send(this.createBeginTransaction(connectionInfo, txid));
        for (int i = 0; i < 4; ++i) {
            Message message = this.createMessage(producerInfo, destination);
            message.setPersistent(true);
            message.setTransactionId(txid);
            connection.send(message);
        }
        connection.send(this.createCommitTransaction1Phase(connectionInfo, txid));
        connection.request(this.closeConnectionInfo(connectionInfo));
        this.restartBroker();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send(consumerInfo);
        for (int i = 0; i < 4; ++i) {
            Message m = this.receiveMessage(connection);
            XARecoveryBrokerTest.assertNotNull((Object)m);
        }
        this.assertNoMessagesLeft(connection);
    }

    public void testQueuePersistentCommitedAcksNotLostOnRestart() throws Exception {
        ActiveMQDestination destination = this.createDestination();
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        connection.send(producerInfo);
        for (int i = 0; i < 4; ++i) {
            Message message = this.createMessage(producerInfo, destination);
            message.setPersistent(true);
            connection.send(message);
        }
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send(consumerInfo);
        XATransactionId txid = this.createXATransaction(sessionInfo);
        connection.send(this.createBeginTransaction(connectionInfo, txid));
        for (int i = 0; i < 4; ++i) {
            Message m = this.receiveMessage(connection);
            XARecoveryBrokerTest.assertNotNull((Object)m);
            MessageAck ack = this.createAck(consumerInfo, m, 1, (byte)2);
            ack.setTransactionId(txid);
            connection.send(ack);
        }
        connection.request(this.createCommitTransaction1Phase(connectionInfo, txid));
        this.restartBroker();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send(consumerInfo);
        this.assertNoMessagesLeft(connection);
        Message m = this.receiveMessage(connection);
        XARecoveryBrokerTest.assertNull((Object)m);
    }

    public void testQueuePersistentUncommittedAcksLostOnRestart() throws Exception {
        Message m;
        int i;
        ActiveMQDestination destination = this.createDestination();
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        connection.send(producerInfo);
        for (int i2 = 0; i2 < 4; ++i2) {
            Message message = this.createMessage(producerInfo, destination);
            message.setPersistent(true);
            connection.send(message);
        }
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send(consumerInfo);
        XATransactionId txid = this.createXATransaction(sessionInfo);
        connection.send(this.createBeginTransaction(connectionInfo, txid));
        for (i = 0; i < 4; ++i) {
            m = this.receiveMessage(connection);
            XARecoveryBrokerTest.assertNotNull((Object)m);
            MessageAck ack = this.createAck(consumerInfo, m, 1, (byte)2);
            ack.setTransactionId(txid);
            connection.send(ack);
        }
        this.restartBroker();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send(consumerInfo);
        for (i = 0; i < 4; ++i) {
            m = this.receiveMessage(connection);
            XARecoveryBrokerTest.assertNotNull((Object)m);
        }
        this.assertNoMessagesLeft(connection);
    }

    public static Test suite() {
        return XARecoveryBrokerTest.suite(XARecoveryBrokerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)XARecoveryBrokerTest.suite());
    }

    protected ActiveMQDestination createDestination() {
        return new ActiveMQQueue(((Object)((Object)this)).getClass().getName() + "." + this.getName());
    }
}

