/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import java.util.Date;
import java.util.List;
import javax.jms.Destination;
import javax.jms.Message;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsExchange;
import org.apache.camel.component.mock.AssertionClause;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQJmsHeaderRouteTest
extends ContextTestSupport {
    private static final transient Log LOG = LogFactory.getLog(ActiveMQJmsHeaderRouteTest.class);
    protected Object expectedBody = "<time>" + new Date() + "</time>";
    protected ActiveMQQueue replyQueue = new ActiveMQQueue("test.reply.queue");
    protected String correlationID = "ABC-123";
    protected String messageType = ((Object)((Object)this)).getClass().getName();

    public void testForwardingAMessageAcrossJMSKeepingCustomJMSHeaders() throws Exception {
        MockEndpoint resultEndpoint = (MockEndpoint)this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedBodiesReceived(new Object[]{this.expectedBody});
        AssertionClause firstMessageExpectations = resultEndpoint.message(0);
        firstMessageExpectations.header("cheese").isEqualTo((Object)123);
        firstMessageExpectations.header("JMSReplyTo").isEqualTo((Object)this.replyQueue);
        firstMessageExpectations.header("JMSCorrelationID").isEqualTo((Object)this.correlationID);
        firstMessageExpectations.header("JMSType").isEqualTo((Object)this.messageType);
        this.template.sendBodyAndHeader("activemq:test.a", this.expectedBody, "cheese", (Object)123);
        resultEndpoint.assertIsSatisfied();
        List list = resultEndpoint.getReceivedExchanges();
        Exchange exchange = (Exchange)list.get(0);
        Object replyTo = exchange.getIn().getHeader("JMSReplyTo");
        LOG.info("Reply to is: " + replyTo);
        Destination destination = (Destination)this.assertIsInstanceOf(Destination.class, replyTo);
        ActiveMQJmsHeaderRouteTest.assertEquals((String)"ReplyTo", (String)this.replyQueue.toString(), (String)destination.toString());
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext camelContext = super.createCamelContext();
        camelContext.addComponent("activemq", (Component)ActiveMQComponent.activeMQComponent("vm://localhost?broker.persistent=false"));
        return camelContext;
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("activemq:test.a").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        JmsExchange jmsExchange = (JmsExchange)ActiveMQJmsHeaderRouteTest.this.assertIsInstanceOf(JmsExchange.class, exchange);
                        Message inMessage = jmsExchange.getInMessage();
                        inMessage.setJMSReplyTo(ActiveMQJmsHeaderRouteTest.this.replyQueue);
                        inMessage.setJMSCorrelationID(ActiveMQJmsHeaderRouteTest.this.correlationID);
                        inMessage.setJMSType(ActiveMQJmsHeaderRouteTest.this.messageType);
                    }
                }).to("activemq:test.b");
                this.from("activemq:test.b").to("mock:result");
            }
        };
    }
}

