/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.kaha.impl.DataManager;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.RedoStoreIndexItem;
import org.apache.activemq.kaha.impl.index.StoreIndexReader;
import org.apache.activemq.kaha.impl.index.StoreIndexWriter;
import org.apache.activemq.util.IOHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class IndexManager {
    public static final String NAME_PREFIX = "index-";
    private static final Log LOG = LogFactory.getLog(IndexManager.class);
    private final String name;
    private File directory;
    private File file;
    private RandomAccessFile indexFile;
    private StoreIndexReader reader;
    private StoreIndexWriter writer;
    private DataManager redoLog;
    private String mode;
    private long length;
    private IndexItem firstFree;
    private IndexItem lastFree;
    private boolean dirty;
    private final AtomicLong storeSize;

    public IndexManager(File directory, String name, String mode, DataManager redoLog, AtomicLong storeSize) throws IOException {
        this.directory = directory;
        this.name = name;
        this.mode = mode;
        this.redoLog = redoLog;
        this.storeSize = storeSize;
        this.initialize();
    }

    public synchronized boolean isEmpty() {
        return this.lastFree == null && this.length == 0L;
    }

    public synchronized IndexItem getIndex(long offset) throws IOException {
        return this.reader.readItem(offset);
    }

    public synchronized IndexItem refreshIndex(IndexItem item) throws IOException {
        this.reader.updateIndexes(item);
        return item;
    }

    public synchronized void freeIndex(IndexItem item) throws IOException {
        item.reset();
        item.setActive(false);
        if (this.lastFree == null) {
            this.firstFree = item;
            this.lastFree = item;
        } else {
            this.lastFree.setNextItem(item.getOffset());
        }
        this.writer.updateIndexes(item);
        this.dirty = true;
    }

    public synchronized void storeIndex(IndexItem index) throws IOException {
        this.writer.storeItem(index);
        this.dirty = true;
    }

    public synchronized void updateIndexes(IndexItem index) throws IOException {
        try {
            this.writer.updateIndexes(index);
        }
        catch (Throwable e) {
            LOG.error(this.name + " error updating indexes ", e);
        }
        this.dirty = true;
    }

    public synchronized void redo(RedoStoreIndexItem redo) throws IOException {
        this.writer.redoStoreItem(redo);
        this.dirty = true;
    }

    public synchronized IndexItem createNewIndex() throws IOException {
        IndexItem result = this.getNextFreeIndex();
        if (result == null) {
            result = new IndexItem();
            result.setOffset(this.length);
            this.length += 51L;
            this.storeSize.addAndGet(51L);
        }
        return result;
    }

    public synchronized void close() throws IOException {
        if (this.indexFile != null) {
            this.indexFile.close();
            this.indexFile = null;
        }
    }

    public synchronized void force() throws IOException {
        if (this.indexFile != null && this.dirty) {
            this.indexFile.getFD().sync();
            this.dirty = false;
        }
    }

    public synchronized boolean delete() throws IOException {
        this.firstFree = null;
        this.lastFree = null;
        if (this.indexFile != null) {
            this.indexFile.close();
            this.indexFile = null;
        }
        return this.file.delete();
    }

    private synchronized IndexItem getNextFreeIndex() throws IOException {
        IndexItem result = null;
        if (this.firstFree != null) {
            if (this.firstFree.equals(this.lastFree)) {
                result = this.firstFree;
                this.firstFree = null;
                this.lastFree = null;
            } else {
                result = this.firstFree;
                this.firstFree = this.getIndex(this.firstFree.getNextItem());
                if (this.firstFree == null) {
                    this.lastFree = null;
                }
            }
            result.reset();
        }
        return result;
    }

    synchronized long getLength() {
        return this.length;
    }

    public final long size() {
        return this.length;
    }

    public synchronized void setLength(long value) {
        this.length = value;
        this.storeSize.addAndGet(this.length);
    }

    public synchronized FileLock getLock() throws IOException {
        return this.indexFile.getChannel().tryLock();
    }

    public String toString() {
        return "IndexManager:(index-" + this.name + ")";
    }

    protected void initialize() throws IOException {
        this.file = new File(this.directory, NAME_PREFIX + IOHelper.toFileSystemSafeName(this.name));
        this.file.getParentFile().mkdirs();
        this.indexFile = new RandomAccessFile(this.file, this.mode);
        this.reader = new StoreIndexReader(this.indexFile);
        this.writer = new StoreIndexWriter(this.indexFile, this.name, this.redoLog);
        long offset = 0L;
        while (offset + 51L <= this.indexFile.length()) {
            IndexItem index = this.reader.readItem(offset);
            if (!index.isActive()) {
                index.reset();
                if (this.lastFree != null) {
                    this.lastFree.setNextItem(index.getOffset());
                    this.updateIndexes(this.lastFree);
                    this.lastFree = index;
                } else {
                    this.lastFree = index;
                    this.firstFree = index;
                }
            }
            offset += 51L;
        }
        this.length = offset;
        this.storeSize.addAndGet(this.length);
    }
}

