/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

public class PerfRate {
    protected int totalCount;
    protected int count;
    protected long startTime = System.currentTimeMillis();

    public int getCount() {
        return this.totalCount;
    }

    public synchronized void increment() {
        ++this.totalCount;
        ++this.count;
    }

    public int getRate() {
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - this.startTime;
        int result = (int)((long)(this.count * 1000) / totalTime);
        return result;
    }

    public synchronized PerfRate cloneAndReset() {
        PerfRate rc = new PerfRate();
        rc.totalCount = this.totalCount;
        rc.count = this.count;
        rc.startTime = this.startTime;
        this.count = 0;
        this.startTime = System.currentTimeMillis();
        return rc;
    }

    public void reset() {
        this.count = 0;
        this.startTime = System.currentTimeMillis();
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }
}

