/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.vm;

import java.net.URI;
import java.net.URISyntaxException;
import junit.textui.TestRunner;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerTestSupport;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.util.IOExceptionSupport;

public class VMTransportEmbeddedBrokerTest
extends BrokerTestSupport {
    public static void main(String[] args) {
        TestRunner.run(VMTransportEmbeddedBrokerTest.class);
    }

    public void testConsumerPrefetchAtOne() throws Exception {
        VMTransportEmbeddedBrokerTest.assertNull((Object)BrokerRegistry.getInstance().lookup("localhost"));
        StubConnection connection = this.createConnection();
        VMTransportEmbeddedBrokerTest.assertNotNull((Object)BrokerRegistry.getInstance().lookup("localhost"));
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        connection.send(producerInfo);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        consumerInfo.setPrefetchSize(1);
        connection.send(consumerInfo);
        connection.send(this.createMessage(producerInfo, destination, 1));
        connection.send(this.createMessage(producerInfo, destination, 1));
        Message m = this.receiveMessage(connection);
        VMTransportEmbeddedBrokerTest.assertNotNull((Object)m);
        this.assertNoMessagesLeft(connection);
        VMTransportEmbeddedBrokerTest.assertNotNull((Object)BrokerRegistry.getInstance().lookup("localhost"));
        connection.stop();
        VMTransportEmbeddedBrokerTest.assertNull((Object)BrokerRegistry.getInstance().lookup("localhost"));
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    protected StubConnection createConnection() throws Exception {
        try {
            Transport transport = TransportFactory.connect(new URI("vm://localhost?broker.persistent=false"));
            StubConnection connection = new StubConnection(transport);
            return connection;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }
}

