/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms.pool;

import java.io.Serializable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;
import org.apache.activemq.jms.pool.PooledMessageConsumer;
import org.apache.activemq.jms.pool.PooledProducer;
import org.apache.activemq.jms.pool.PooledQueueSender;
import org.apache.activemq.jms.pool.PooledSessionEventListener;
import org.apache.activemq.jms.pool.PooledTopicPublisher;
import org.apache.activemq.jms.pool.SessionKey;
import org.apache.commons.pool.KeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledSession
implements Session,
TopicSession,
QueueSession,
XASession {
    private static final transient Logger LOG = LoggerFactory.getLogger(PooledSession.class);
    private final SessionKey key;
    private final KeyedObjectPool<SessionKey, Session> sessionPool;
    private final CopyOnWriteArrayList<MessageConsumer> consumers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<QueueBrowser> browsers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<PooledSessionEventListener> sessionEventListeners = new CopyOnWriteArrayList();
    private final AtomicBoolean closed = new AtomicBoolean();
    private MessageProducer producer;
    private TopicPublisher publisher;
    private QueueSender sender;
    private Session session;
    private boolean transactional = true;
    private boolean ignoreClose;
    private boolean isXa;
    private boolean useAnonymousProducers = true;

    public PooledSession(SessionKey key, Session session, KeyedObjectPool<SessionKey, Session> sessionPool, boolean transactional, boolean anonymous) {
        this.key = key;
        this.session = session;
        this.sessionPool = sessionPool;
        this.transactional = transactional;
        this.useAnonymousProducers = anonymous;
    }

    public void addSessionEventListener(PooledSessionEventListener listener) {
        if (!this.sessionEventListeners.contains(listener)) {
            this.sessionEventListeners.add(listener);
        }
    }

    protected boolean isIgnoreClose() {
        return this.ignoreClose;
    }

    protected void setIgnoreClose(boolean ignoreClose) {
        this.ignoreClose = ignoreClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JMSException {
        if (this.ignoreClose) {
            return;
        }
        if (this.closed.compareAndSet(false, true)) {
            boolean invalidate = false;
            try {
                this.getInternalSession().setMessageListener(null);
                for (MessageConsumer consumer : this.consumers) {
                    consumer.close();
                }
                for (QueueBrowser browser : this.browsers) {
                    browser.close();
                }
                if (this.transactional && !this.isXa) {
                    try {
                        this.getInternalSession().rollback();
                    }
                    catch (JMSException e) {
                        invalidate = true;
                        LOG.warn("Caught exception trying rollback() when putting session back into the pool, will invalidate. " + e, e);
                    }
                }
            }
            catch (JMSException ex) {
                invalidate = true;
                LOG.warn("Caught exception trying close() when putting session back into the pool, will invalidate. " + ex, ex);
            }
            finally {
                this.consumers.clear();
                this.browsers.clear();
                for (PooledSessionEventListener listener : this.sessionEventListeners) {
                    listener.onSessionClosed(this);
                }
                this.sessionEventListeners.clear();
            }
            if (invalidate) {
                if (this.session != null) {
                    try {
                        this.session.close();
                    }
                    catch (JMSException e1) {
                        LOG.trace("Ignoring exception on close as discarding session: " + e1, e1);
                    }
                }
                try {
                    this.sessionPool.invalidateObject((Object)this.key, (Object)this.session);
                }
                catch (Exception e) {
                    LOG.trace("Ignoring exception on invalidateObject as discarding session: " + e, e);
                }
            } else {
                try {
                    this.sessionPool.returnObject((Object)this.key, (Object)this.session);
                }
                catch (Exception e) {
                    IllegalStateException illegalStateException = new IllegalStateException(e.toString());
                    illegalStateException.initCause(e);
                    throw illegalStateException;
                }
            }
            this.session = null;
        }
    }

    @Override
    public void commit() throws JMSException {
        this.getInternalSession().commit();
    }

    @Override
    public BytesMessage createBytesMessage() throws JMSException {
        return this.getInternalSession().createBytesMessage();
    }

    @Override
    public MapMessage createMapMessage() throws JMSException {
        return this.getInternalSession().createMapMessage();
    }

    @Override
    public Message createMessage() throws JMSException {
        return this.getInternalSession().createMessage();
    }

    @Override
    public ObjectMessage createObjectMessage() throws JMSException {
        return this.getInternalSession().createObjectMessage();
    }

    @Override
    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return this.getInternalSession().createObjectMessage(serializable);
    }

    @Override
    public Queue createQueue(String s) throws JMSException {
        return this.getInternalSession().createQueue(s);
    }

    @Override
    public StreamMessage createStreamMessage() throws JMSException {
        return this.getInternalSession().createStreamMessage();
    }

    @Override
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        TemporaryQueue result = this.getInternalSession().createTemporaryQueue();
        for (PooledSessionEventListener listener : this.sessionEventListeners) {
            listener.onTemporaryQueueCreate(result);
        }
        return result;
    }

    @Override
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        TemporaryTopic result = this.getInternalSession().createTemporaryTopic();
        for (PooledSessionEventListener listener : this.sessionEventListeners) {
            listener.onTemporaryTopicCreate(result);
        }
        return result;
    }

    @Override
    public void unsubscribe(String s) throws JMSException {
        this.getInternalSession().unsubscribe(s);
    }

    @Override
    public TextMessage createTextMessage() throws JMSException {
        return this.getInternalSession().createTextMessage();
    }

    @Override
    public TextMessage createTextMessage(String s) throws JMSException {
        return this.getInternalSession().createTextMessage(s);
    }

    @Override
    public Topic createTopic(String s) throws JMSException {
        return this.getInternalSession().createTopic(s);
    }

    @Override
    public int getAcknowledgeMode() throws JMSException {
        return this.getInternalSession().getAcknowledgeMode();
    }

    @Override
    public boolean getTransacted() throws JMSException {
        return this.getInternalSession().getTransacted();
    }

    @Override
    public void recover() throws JMSException {
        this.getInternalSession().recover();
    }

    @Override
    public void rollback() throws JMSException {
        this.getInternalSession().rollback();
    }

    @Override
    public XAResource getXAResource() {
        if (this.session instanceof XASession) {
            return ((XASession)this.session).getXAResource();
        }
        return null;
    }

    @Override
    public Session getSession() {
        return this;
    }

    @Override
    public void run() {
        if (this.session != null) {
            this.session.run();
        }
    }

    @Override
    public QueueBrowser createBrowser(Queue queue2) throws JMSException {
        return this.addQueueBrowser(this.getInternalSession().createBrowser(queue2));
    }

    @Override
    public QueueBrowser createBrowser(Queue queue2, String selector) throws JMSException {
        return this.addQueueBrowser(this.getInternalSession().createBrowser(queue2, selector));
    }

    @Override
    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.addConsumer(this.getInternalSession().createConsumer(destination));
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        return this.addConsumer(this.getInternalSession().createConsumer(destination, selector));
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        return this.addConsumer(this.getInternalSession().createConsumer(destination, selector, noLocal));
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String selector) throws JMSException {
        return this.addTopicSubscriber(this.getInternalSession().createDurableSubscriber(topic, selector));
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        return this.addTopicSubscriber(this.getInternalSession().createDurableSubscriber(topic, name, selector, noLocal));
    }

    @Override
    public MessageListener getMessageListener() throws JMSException {
        return this.getInternalSession().getMessageListener();
    }

    @Override
    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.getInternalSession().setMessageListener(messageListener);
    }

    @Override
    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.addTopicSubscriber(((TopicSession)this.getInternalSession()).createSubscriber(topic));
    }

    @Override
    public TopicSubscriber createSubscriber(Topic topic, String selector, boolean local) throws JMSException {
        return this.addTopicSubscriber(((TopicSession)this.getInternalSession()).createSubscriber(topic, selector, local));
    }

    @Override
    public QueueReceiver createReceiver(Queue queue2) throws JMSException {
        return this.addQueueReceiver(((QueueSession)this.getInternalSession()).createReceiver(queue2));
    }

    @Override
    public QueueReceiver createReceiver(Queue queue2, String selector) throws JMSException {
        return this.addQueueReceiver(((QueueSession)this.getInternalSession()).createReceiver(queue2, selector));
    }

    @Override
    public MessageProducer createProducer(Destination destination) throws JMSException {
        return new PooledProducer(this.getMessageProducer(destination), destination);
    }

    @Override
    public QueueSender createSender(Queue queue2) throws JMSException {
        return new PooledQueueSender(this.getQueueSender(queue2), (Destination)queue2);
    }

    @Override
    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return new PooledTopicPublisher(this.getTopicPublisher(topic), (Destination)topic);
    }

    public Session getInternalSession() throws java.lang.IllegalStateException {
        if (this.session == null) {
            throw new java.lang.IllegalStateException("The session has already been closed");
        }
        return this.session;
    }

    public MessageProducer getMessageProducer() throws JMSException {
        return this.getMessageProducer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProducer getMessageProducer(Destination destination) throws JMSException {
        MessageProducer result = null;
        if (this.useAnonymousProducers) {
            if (this.producer == null) {
                PooledSession pooledSession = this;
                synchronized (pooledSession) {
                    if (this.producer == null) {
                        this.producer = this.getInternalSession().createProducer(null);
                    }
                }
            }
            result = this.producer;
        } else {
            result = this.getInternalSession().createProducer(destination);
        }
        return result;
    }

    public QueueSender getQueueSender() throws JMSException {
        return this.getQueueSender(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueSender getQueueSender(Queue destination) throws JMSException {
        QueueSender result = null;
        if (this.useAnonymousProducers) {
            if (this.sender == null) {
                PooledSession pooledSession = this;
                synchronized (pooledSession) {
                    if (this.sender == null) {
                        this.sender = ((QueueSession)this.getInternalSession()).createSender(null);
                    }
                }
            }
            result = this.sender;
        } else {
            result = ((QueueSession)this.getInternalSession()).createSender(destination);
        }
        return result;
    }

    public TopicPublisher getTopicPublisher() throws JMSException {
        return this.getTopicPublisher(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicPublisher getTopicPublisher(Topic destination) throws JMSException {
        TopicPublisher result = null;
        if (this.useAnonymousProducers) {
            if (this.publisher == null) {
                PooledSession pooledSession = this;
                synchronized (pooledSession) {
                    if (this.publisher == null) {
                        this.publisher = ((TopicSession)this.getInternalSession()).createPublisher(null);
                    }
                }
            }
            result = this.publisher;
        } else {
            result = ((TopicSession)this.getInternalSession()).createPublisher(destination);
        }
        return result;
    }

    private QueueBrowser addQueueBrowser(QueueBrowser browser) {
        this.browsers.add(browser);
        return browser;
    }

    private MessageConsumer addConsumer(MessageConsumer consumer) {
        this.consumers.add(consumer);
        return new PooledMessageConsumer(this, consumer);
    }

    private TopicSubscriber addTopicSubscriber(TopicSubscriber subscriber) {
        this.consumers.add(subscriber);
        return subscriber;
    }

    private QueueReceiver addQueueReceiver(QueueReceiver receiver) {
        this.consumers.add(receiver);
        return receiver;
    }

    public void setIsXa(boolean isXa) {
        this.isXa = isXa;
    }

    public String toString() {
        return "PooledSession { " + this.session + " }";
    }

    protected void onConsumerClose(MessageConsumer consumer) {
        this.consumers.remove(consumer);
    }
}

