/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.disk.page;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Page<T> {
    public static final int PAGE_HEADER_SIZE = 21;
    public static final byte PAGE_FREE_TYPE = 0;
    public static final byte PAGE_PART_TYPE = 1;
    public static final byte PAGE_END_TYPE = 2;
    long pageId;
    byte type = 0;
    long txId;
    int checksum;
    long next;
    T data;

    public Page() {
    }

    public Page(long pageId) {
        this.pageId = pageId;
    }

    public Page<T> copy(Page<T> other) {
        this.pageId = other.pageId;
        this.txId = other.txId;
        this.type = other.type;
        this.next = other.next;
        this.data = other.data;
        return this;
    }

    Page<T> copy() {
        return new Page<T>().copy(this);
    }

    void makeFree(long txId) {
        this.type = 0;
        this.txId = txId;
        this.data = null;
        this.next = 0L;
    }

    public void makePagePart(long next, long txId) {
        this.type = 1;
        this.next = next;
        this.txId = txId;
    }

    public void makePageEnd(long size2, long txId) {
        this.type = (byte)2;
        this.next = size2;
        this.txId = txId;
    }

    void write(DataOutput os) throws IOException {
        os.writeByte(this.type);
        os.writeLong(this.txId);
        os.writeLong(this.next);
        os.writeInt(this.checksum);
    }

    void read(DataInput is) throws IOException {
        this.type = is.readByte();
        this.txId = is.readLong();
        this.next = is.readLong();
        this.checksum = is.readInt();
    }

    public long getPageId() {
        return this.pageId;
    }

    public long getTxId() {
        return this.txId;
    }

    public T get() {
        return this.data;
    }

    public void set(T data) {
        this.data = data;
    }

    public short getType() {
        return this.type;
    }

    public long getNext() {
        return this.next;
    }

    public String toString() {
        return "[Page:" + this.getPageId() + ", type: " + this.type + "]";
    }

    public int getChecksum() {
        return this.checksum;
    }

    public void setChecksum(int checksum) {
        this.checksum = checksum;
    }
}

