/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.rest.DeleteVerbDefinition;
import org.apache.camel.model.rest.GetVerbDefinition;
import org.apache.camel.model.rest.HeadVerbDefinition;
import org.apache.camel.model.rest.PostVerbDefinition;
import org.apache.camel.model.rest.PutVerbDefinition;
import org.apache.camel.model.rest.RestBindingDefinition;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

@Metadata(label="rest")
@XmlRootElement(name="rest")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestDefinition
extends OptionalIdentifiedDefinition<RestDefinition> {
    @XmlAttribute
    private String path;
    @XmlAttribute
    private String consumes;
    @XmlAttribute
    private String produces;
    @XmlAttribute
    @Metadata(defaultValue="auto")
    private RestBindingMode bindingMode;
    @XmlAttribute
    private Boolean skipBindingOnErrorCode;
    @XmlAttribute
    private Boolean enableCORS;
    @XmlElementRef
    private List<VerbDefinition> verbs = new ArrayList<VerbDefinition>();

    @Override
    public String getLabel() {
        return "rest";
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getConsumes() {
        return this.consumes;
    }

    public void setConsumes(String consumes) {
        this.consumes = consumes;
    }

    public String getProduces() {
        return this.produces;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    public RestBindingMode getBindingMode() {
        return this.bindingMode;
    }

    public void setBindingMode(RestBindingMode bindingMode) {
        this.bindingMode = bindingMode;
    }

    public List<VerbDefinition> getVerbs() {
        return this.verbs;
    }

    public void setVerbs(List<VerbDefinition> verbs) {
        this.verbs = verbs;
    }

    public Boolean getSkipBindingOnErrorCode() {
        return this.skipBindingOnErrorCode;
    }

    public void setSkipBindingOnErrorCode(Boolean skipBindingOnErrorCode) {
        this.skipBindingOnErrorCode = skipBindingOnErrorCode;
    }

    public Boolean getEnableCORS() {
        return this.enableCORS;
    }

    public void setEnableCORS(Boolean enableCORS) {
        this.enableCORS = enableCORS;
    }

    public RestDefinition path(String path) {
        this.setPath(path);
        return this;
    }

    public RestDefinition get() {
        return this.addVerb("get", null);
    }

    public RestDefinition get(String uri) {
        return this.addVerb("get", uri);
    }

    public RestDefinition post() {
        return this.addVerb("post", null);
    }

    public RestDefinition post(String uri) {
        return this.addVerb("post", uri);
    }

    public RestDefinition put() {
        return this.addVerb("put", null);
    }

    public RestDefinition put(String uri) {
        return this.addVerb("put", uri);
    }

    public RestDefinition delete() {
        return this.addVerb("delete", null);
    }

    public RestDefinition delete(String uri) {
        return this.addVerb("delete", uri);
    }

    public RestDefinition head() {
        return this.addVerb("head", null);
    }

    public RestDefinition head(String uri) {
        return this.addVerb("head", uri);
    }

    public RestDefinition verb(String verb) {
        return this.addVerb(verb, null);
    }

    public RestDefinition verb(String verb, String uri) {
        return this.addVerb(verb, uri);
    }

    @Override
    public RestDefinition id(String id) {
        if (this.getVerbs().isEmpty()) {
            super.id(id);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.id(id);
        }
        return this;
    }

    @Override
    public RestDefinition description(String text) {
        if (this.getVerbs().isEmpty()) {
            super.description(text);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.description(text);
        }
        return this;
    }

    @Override
    public RestDefinition description(String id, String text, String lang) {
        if (this.getVerbs().isEmpty()) {
            super.description(id, text, lang);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.description(id, text, lang);
        }
        return this;
    }

    public RestDefinition consumes(String mediaType) {
        if (this.getVerbs().isEmpty()) {
            this.consumes = mediaType;
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setConsumes(mediaType);
        }
        return this;
    }

    public RestDefinition produces(String mediaType) {
        if (this.getVerbs().isEmpty()) {
            this.produces = mediaType;
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setProduces(mediaType);
        }
        return this;
    }

    public RestDefinition type(Class<?> classType) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setType(classType.getCanonicalName());
        return this;
    }

    public RestDefinition typeList(Class<?> classType) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setType(classType.getCanonicalName() + "[]");
        return this;
    }

    public RestDefinition outType(Class<?> classType) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setOutType(classType.getCanonicalName());
        return this;
    }

    public RestDefinition outTypeList(Class<?> classType) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setOutType(classType.getCanonicalName() + "[]");
        return this;
    }

    public RestDefinition bindingMode(RestBindingMode mode) {
        if (this.getVerbs().isEmpty()) {
            this.bindingMode = mode;
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setBindingMode(mode);
        }
        return this;
    }

    public RestDefinition skipBindingOnErrorCode(boolean skipBindingOnErrorCode) {
        if (this.getVerbs().isEmpty()) {
            this.skipBindingOnErrorCode = skipBindingOnErrorCode;
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setSkipBindingOnErrorCode(skipBindingOnErrorCode);
        }
        return this;
    }

    public RestDefinition enableCORS(boolean enableCORS) {
        if (this.getVerbs().isEmpty()) {
            this.enableCORS = enableCORS;
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setEnableCORS(enableCORS);
        }
        return this;
    }

    public RestDefinition to(String uri) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        ToDefinition to = new ToDefinition(uri);
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setTo(to);
        return this;
    }

    public RouteDefinition route() {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        RouteDefinition route = new RouteDefinition();
        route.setRestDefinition(this);
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setRoute(route);
        return route;
    }

    private RestDefinition addVerb(String verb, String uri) {
        VerbDefinition answer;
        if ("get".equals(verb)) {
            answer = new GetVerbDefinition();
        } else if ("post".equals(verb)) {
            answer = new PostVerbDefinition();
        } else if ("delete".equals(verb)) {
            answer = new DeleteVerbDefinition();
        } else if ("head".equals(verb)) {
            answer = new HeadVerbDefinition();
        } else if ("put".equals(verb)) {
            answer = new PutVerbDefinition();
        } else {
            answer = new VerbDefinition();
            answer.setMethod(verb);
        }
        answer.setRest(this);
        answer.setUri(uri);
        this.getVerbs().add(answer);
        return this;
    }

    public List<RouteDefinition> asRouteDefinition(CamelContext camelContext) {
        ArrayList<RouteDefinition> answer = new ArrayList<RouteDefinition>();
        for (VerbDefinition verb : this.getVerbs()) {
            String description;
            String id;
            String outType;
            RouteDefinition route = verb.getRoute();
            if (route == null) {
                route = new RouteDefinition();
                route.getOutputs().add(verb.getTo());
            }
            RestBindingDefinition binding = new RestBindingDefinition();
            binding.setType(verb.getType());
            binding.setOutType(verb.getOutType());
            if (verb.getConsumes() != null) {
                binding.setConsumes(verb.getConsumes());
            } else {
                binding.setConsumes(this.getConsumes());
            }
            if (verb.getProduces() != null) {
                binding.setProduces(verb.getProduces());
            } else {
                binding.setProduces(this.getProduces());
            }
            if (verb.getBindingMode() != null) {
                binding.setBindingMode(verb.getBindingMode());
            } else {
                binding.setBindingMode(this.getBindingMode());
            }
            if (verb.getSkipBindingOnErrorCode() != null) {
                binding.setSkipBindingOnErrorCode(verb.getSkipBindingOnErrorCode());
            } else {
                binding.setSkipBindingOnErrorCode(this.getSkipBindingOnErrorCode());
            }
            if (verb.getEnableCORS() != null) {
                binding.setEnableCORS(verb.getEnableCORS());
            } else {
                binding.setEnableCORS(this.getEnableCORS());
            }
            route.getOutputs().add(0, binding);
            String from = "rest:" + verb.asVerb() + ":" + this.buildUri(verb);
            HashMap<String, Object> options = new HashMap<String, Object>();
            if (verb.getConsumes() != null) {
                options.put("consumes", verb.getConsumes());
            } else if (this.getConsumes() != null) {
                options.put("consumes", this.getConsumes());
            }
            if (verb.getProduces() != null) {
                options.put("produces", verb.getProduces());
            } else if (this.getProduces() != null) {
                options.put("produces", this.getProduces());
            }
            String inType = binding.getType();
            if (inType != null) {
                options.put("inType", inType);
            }
            if ((outType = binding.getOutType()) != null) {
                options.put("outType", outType);
            }
            if (!route.hasCustomIdAssigned() && (id = verb.getId()) != null) {
                route.setId(id);
            }
            String routeId = route.idOrCreate(camelContext.getNodeIdFactory());
            options.put("routeId", routeId);
            String string = description = verb.getTo() != null ? verb.getTo().getDescriptionText() : route.getDescriptionText();
            if (description == null) {
                description = verb.getDescriptionText();
            }
            if (description == null) {
                description = this.getDescriptionText();
            }
            if (description != null) {
                options.put("description", description);
            }
            if (!options.isEmpty()) {
                String query;
                try {
                    query = URISupport.createQueryString(options);
                }
                catch (URISyntaxException e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
                from = from + "?" + query;
            }
            route.fromRest(from);
            route.setRestDefinition(this);
            answer.add(route);
        }
        return answer;
    }

    private String buildUri(VerbDefinition verb) {
        if (this.path != null && verb.getUri() != null) {
            return this.path + ":" + verb.getUri();
        }
        if (this.path != null) {
            return this.path;
        }
        if (verb.getUri() != null) {
            return verb.getUri();
        }
        return "";
    }
}

