/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Container {
    public void manage(CamelContext var1);

    public static final class Instance {
        private static final Logger LOG = LoggerFactory.getLogger(Container.class);
        private static Container container;
        private static final Set<CamelContext> CONTEXTS;

        private Instance() {
        }

        public static Container get() {
            return container;
        }

        public static void set(Container container) {
            Instance.container = container;
            if (container == null) {
                CONTEXTS.clear();
            } else if (!CONTEXTS.isEmpty()) {
                for (CamelContext context : CONTEXTS) {
                    Instance.manageCamelContext(container, context);
                }
                CONTEXTS.clear();
            }
        }

        public static void manage(CamelContext camelContext) {
            Container cnt = container;
            if (cnt != null) {
                Instance.manageCamelContext(cnt, camelContext);
            } else {
                CONTEXTS.add(camelContext);
            }
        }

        private static void manageCamelContext(Container container, CamelContext context) {
            try {
                container.manage(context);
            }
            catch (Throwable t) {
                LOG.warn("Error during manage CamelContext " + context.getName() + ". This exception is ignored.", t);
            }
        }

        public static void unmanage(CamelContext camelContext) {
            CONTEXTS.remove(camelContext);
        }

        static {
            CONTEXTS = new LinkedHashSet<CamelContext>();
        }
    }
}

