/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.AbstractStaxContentHandler;
import org.springframework.util.xml.SimpleNamespaceContext;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

class StaxStreamContentHandler
extends AbstractStaxContentHandler {
    private final XMLStreamWriter streamWriter;

    StaxStreamContentHandler(XMLStreamWriter streamWriter) {
        Assert.notNull(streamWriter, "'streamWriter' must not be null");
        this.streamWriter = streamWriter;
    }

    public void setDocumentLocator(Locator locator) {
    }

    protected void charactersInternal(char[] ch, int start2, int length) throws XMLStreamException {
        this.streamWriter.writeCharacters(ch, start2, length);
    }

    protected void endDocumentInternal() throws XMLStreamException {
        this.streamWriter.writeEndDocument();
    }

    protected void endElementInternal(QName name, SimpleNamespaceContext namespaceContext) throws XMLStreamException {
        this.streamWriter.writeEndElement();
    }

    protected void ignorableWhitespaceInternal(char[] ch, int start2, int length) throws XMLStreamException {
        this.streamWriter.writeCharacters(ch, start2, length);
    }

    protected void processingInstructionInternal(String target, String data) throws XMLStreamException {
        this.streamWriter.writeProcessingInstruction(target, data);
    }

    protected void skippedEntityInternal(String name) {
    }

    protected void startDocumentInternal() throws XMLStreamException {
        this.streamWriter.writeStartDocument();
    }

    protected void startElementInternal(QName name, Attributes attributes, SimpleNamespaceContext namespaceContext) throws XMLStreamException {
        this.streamWriter.writeStartElement(name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
        if (namespaceContext != null) {
            String defaultNamespaceUri = namespaceContext.getNamespaceURI("");
            if (StringUtils.hasLength(defaultNamespaceUri)) {
                this.streamWriter.writeNamespace("", defaultNamespaceUri);
                this.streamWriter.setDefaultNamespace(defaultNamespaceUri);
            }
            Iterator<String> iterator = namespaceContext.getBoundPrefixes();
            while (iterator.hasNext()) {
                String prefix = iterator.next();
                this.streamWriter.writeNamespace(prefix, namespaceContext.getNamespaceURI(prefix));
                this.streamWriter.setPrefix(prefix, namespaceContext.getNamespaceURI(prefix));
            }
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            QName attrName = this.toQName(attributes.getURI(i), attributes.getQName(i));
            if ("xmlns".equals(attrName.getLocalPart()) || "xmlns".equals(attrName.getPrefix())) continue;
            this.streamWriter.writeAttribute(attrName.getPrefix(), attrName.getNamespaceURI(), attrName.getLocalPart(), attributes.getValue(i));
        }
    }
}

