/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.activemq.console.command.AbstractJmxCommand;
import org.apache.activemq.console.util.JmxMBeansUtil;

public class ShutdownCommand
extends AbstractJmxCommand {
    protected String[] helpFile = new String[]{"Task Usage: Main stop [stop-options] [broker-name1] [broker-name2] ...", "Description: Stops a running broker.", "", "Stop Options:", "    --jmxurl <url>             Set the JMX URL to connect to.", "    --pid <pid>                   Set the pid to connect to (only on Sun JVM).", "    --jmxuser <user>           Set the JMX user used for authenticating.", "    --jmxpassword <password>   Set the JMX password used for authenticating.", "    --jmxlocal                 Use the local JMX server instead of a remote one.", "    --all                      Stop all brokers.", "    --version                  Display the version information.", "    -h,-?,--help               Display the stop broker help information.", "", "Broker Names:", "    Name of the brokers that will be stopped.", "    If omitted, it is assumed that there is only one broker running, and it will be stopped.", "    Use -all to stop all running brokers.", ""};
    private boolean isStopAllBrokers;

    @Override
    public String getName() {
        return "stop";
    }

    @Override
    public String getOneLineDescription() {
        return "Stops a running broker specified by the broker name.";
    }

    protected void runTask(List brokerNames) throws Exception {
        try {
            Collection mbeans;
            if (this.isStopAllBrokers) {
                mbeans = JmxMBeansUtil.getAllBrokers(this.createJmxConnection());
                brokerNames.clear();
            } else if (brokerNames.isEmpty()) {
                mbeans = JmxMBeansUtil.getAllBrokers(this.createJmxConnection());
                if (mbeans.isEmpty()) {
                    this.context.printInfo("There are no brokers to stop.");
                    return;
                }
                if (mbeans.size() > 1) {
                    this.context.printInfo("There are multiple brokers to stop. Please select the broker(s) to stop or use --all to stop all brokers.");
                    return;
                }
                Object firstBroker = mbeans.iterator().next();
                mbeans.clear();
                mbeans.add(firstBroker);
            } else {
                mbeans = new HashSet();
                while (!brokerNames.isEmpty()) {
                    String brokerName = (String)brokerNames.remove(0);
                    List matchedBrokers = JmxMBeansUtil.getBrokersByName(this.createJmxConnection(), brokerName);
                    if (matchedBrokers.isEmpty()) {
                        this.context.printInfo(brokerName + " did not match any running brokers.");
                        continue;
                    }
                    mbeans.addAll(matchedBrokers);
                }
            }
            this.stopBrokers(this.createJmxConnection(), mbeans);
        }
        catch (Exception e) {
            this.context.printException(new RuntimeException("Failed to execute stop task. Reason: " + e));
            throw new Exception(e);
        }
    }

    protected void stopBrokers(MBeanServerConnection jmxConnection, Collection brokerBeans) throws Exception {
        Iterator i = brokerBeans.iterator();
        while (i.hasNext()) {
            ObjectName brokerObjName = ((ObjectInstance)i.next()).getObjectName();
            String brokerName = brokerObjName.getKeyProperty("brokerName");
            this.context.print("Stopping broker: " + brokerName);
            try {
                jmxConnection.invoke(brokerObjName, "terminateJVM", new Object[]{0}, new String[]{"int"});
                this.context.print("Succesfully stopped broker: " + brokerName);
            }
            catch (Exception exception) {}
        }
        this.closeJmxConnection();
    }

    @Override
    protected void handleOption(String token, List<String> tokens) throws Exception {
        if (token.equals("--all")) {
            this.isStopAllBrokers = true;
        } else {
            super.handleOption(token, tokens);
        }
    }

    @Override
    protected void printHelp() {
        this.context.printHelp(this.helpFile);
    }
}

