/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import javax.net.ssl.SSLContext;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.transport.SocketConnectorFactory;
import org.apache.activemq.transport.https.Krb5AndCertsSslSocketConnector;
import org.apache.activemq.util.IntrospectionSupport;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SecureSocketConnectorFactory
extends SocketConnectorFactory {
    private String keyPassword = System.getProperty("javax.net.ssl.keyPassword");
    private String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
    private String keyStore = System.getProperty("javax.net.ssl.keyStore");
    private String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
    private String trustStore = System.getProperty("javax.net.ssl.trustStore");
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private String keyStoreType;
    private String secureRandomCertficateAlgorithm;
    private String trustCertificateAlgorithm;
    private String keyCertificateAlgorithm;
    private String protocol;
    private String auth;
    private SslContext context;
    private SslContextFactory contextFactory;

    public SecureSocketConnectorFactory() {
    }

    public SecureSocketConnectorFactory(SslContext context) {
        this.context = context;
    }

    public SecureSocketConnectorFactory(SslContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    @Override
    public Connector createConnector(Server server) throws Exception {
        SslContextFactory factory;
        SSLContext sslContext;
        if (this.getTransportOptions() != null) {
            IntrospectionSupport.setProperties(this, this.getTransportOptions());
        }
        SSLContext sSLContext = sslContext = this.context == null ? null : this.context.getSSLContext();
        if (this.contextFactory == null) {
            factory = new SslContextFactory();
            if (this.context != null) {
                factory.setSslContext(sslContext);
            } else {
                if (this.keyStore != null) {
                    factory.setKeyStorePath(this.keyStore);
                }
                if (this.keyStorePassword != null) {
                    factory.setKeyStorePassword(this.keyStorePassword);
                }
                if (this.keyPassword == null && this.keyStorePassword != null) {
                    factory.setKeyStorePassword(this.keyStorePassword);
                }
                if (this.keyStoreType != null) {
                    factory.setKeyStoreType(this.keyStoreType);
                }
                if (this.secureRandomCertficateAlgorithm != null) {
                    factory.setSecureRandomAlgorithm(this.secureRandomCertficateAlgorithm);
                }
                if (this.keyCertificateAlgorithm != null) {
                    factory.setSslKeyManagerFactoryAlgorithm(this.keyCertificateAlgorithm);
                }
                if (this.trustCertificateAlgorithm != null) {
                    factory.setTrustManagerFactoryAlgorithm(this.trustCertificateAlgorithm);
                }
                if (this.protocol != null) {
                    factory.setProtocol(this.protocol);
                }
                if (this.trustStore != null) {
                    this.setTrustStore(factory, this.trustStore);
                }
                if (this.trustStorePassword != null) {
                    factory.setTrustStorePassword(this.trustStorePassword);
                }
            }
            factory.setNeedClientAuth(this.needClientAuth);
            factory.setWantClientAuth(this.wantClientAuth);
        } else {
            factory = this.contextFactory;
        }
        if ("KRB".equals(this.auth) || "BOTH".equals(this.auth) && Server.getVersion().startsWith("8")) {
            return new Krb5AndCertsSslSocketConnector(factory, this.auth);
        }
        try {
            Class<?> cls = Class.forName("org.eclipse.jetty.server.ssl.SslSelectChannelConnector", true, Server.class.getClassLoader());
            return (Connector)cls.getConstructor(SslContextFactory.class).newInstance(factory);
        }
        catch (Throwable t) {
            Class<?> c = Class.forName("org.eclipse.jetty.server.ServerConnector", true, Server.class.getClassLoader());
            Connector connector = (Connector)c.getConstructor(Server.class, SslContextFactory.class).newInstance(server, factory);
            Server.class.getMethod("setStopTimeout", Long.TYPE).invoke((Object)server, 500);
            connector.getClass().getMethod("setStopTimeout", Long.TYPE).invoke((Object)connector, 500);
            return connector;
        }
    }

    private void setTrustStore(SslContextFactory factory, String trustStore2) throws Exception {
        String mname = Server.getVersion().startsWith("8") ? "setTrustStore" : "setTrustStorePath";
        factory.getClass().getMethod(mname, String.class).invoke((Object)factory, trustStore2);
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getSecureRandomCertficateAlgorithm() {
        return this.secureRandomCertficateAlgorithm;
    }

    public void setSecureRandomCertficateAlgorithm(String secureRandomCertficateAlgorithm) {
        this.secureRandomCertficateAlgorithm = secureRandomCertficateAlgorithm;
    }

    public String getKeyCertificateAlgorithm() {
        return this.keyCertificateAlgorithm;
    }

    public void setKeyCertificateAlgorithm(String keyCertificateAlgorithm) {
        this.keyCertificateAlgorithm = keyCertificateAlgorithm;
    }

    public String getTrustCertificateAlgorithm() {
        return this.trustCertificateAlgorithm;
    }

    public void setTrustCertificateAlgorithm(String trustCertificateAlgorithm) {
        this.trustCertificateAlgorithm = trustCertificateAlgorithm;
    }

    public String getAuth() {
        return this.auth;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }
}

