/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.loadbalancer.LoadBalancerSupport;
import org.apache.camel.util.AsyncProcessorConverterHelper;

public class CircuitBreakerLoadBalancer
extends LoadBalancerSupport
implements Traceable,
CamelContextAware {
    private static final int STATE_CLOSED = 0;
    private static final int STATE_HALF_OPEN = 1;
    private static final int STATE_OPEN = 2;
    private final List<Class<?>> exceptions;
    private CamelContext camelContext;
    private int threshold;
    private long halfOpenAfter;
    private long lastFailure;
    private AtomicInteger failures = new AtomicInteger();
    private AtomicInteger state = new AtomicInteger(0);

    public CircuitBreakerLoadBalancer(List<Class<?>> exceptions) {
        this.exceptions = exceptions;
    }

    public CircuitBreakerLoadBalancer() {
        this.exceptions = null;
    }

    public void setHalfOpenAfter(long halfOpenAfter) {
        this.halfOpenAfter = halfOpenAfter;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public List<Class<?>> getExceptions() {
        return this.exceptions;
    }

    protected boolean hasFailed(Exchange exchange) {
        boolean answer = false;
        if (exchange.getException() != null) {
            if (this.exceptions == null || this.exceptions.isEmpty()) {
                answer = true;
            } else {
                for (Class<?> exception : this.exceptions) {
                    if (exchange.getException(exception) == null) continue;
                    answer = true;
                    break;
                }
            }
        }
        return answer;
    }

    @Override
    public boolean isRunAllowed() {
        boolean forceShutdown = this.camelContext.getShutdownStrategy().forceShutdown(this);
        if (forceShutdown) {
            this.log.trace("Run not allowed as ShutdownStrategy is forcing shutting down");
        }
        return !forceShutdown && super.isRunAllowed();
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isRunAllowed()) {
            this.log.trace("Run not allowed, will reject executing exchange: {}", (Object)exchange);
            if (exchange.getException() == null) {
                exchange.setException(new RejectedExecutionException("Run is not allowed"));
            }
            callback.done(true);
            return true;
        }
        return this.calculateState(exchange, callback);
    }

    private boolean calculateState(Exchange exchange, AsyncCallback callback) {
        boolean output = false;
        if (this.state.get() == 1) {
            output = this.failures.get() == 0 ? this.closeCircuit(exchange, callback) : this.openCircuit(exchange, callback);
        } else if (this.state.get() == 2) {
            output = this.failures.get() >= this.threshold && System.currentTimeMillis() - this.lastFailure < this.halfOpenAfter ? this.openCircuit(exchange, callback) : this.halfOpenCircuit(exchange, callback);
        } else if (this.state.get() == 0) {
            output = this.failures.get() >= this.threshold && System.currentTimeMillis() - this.lastFailure < this.halfOpenAfter ? this.openCircuit(exchange, callback) : (this.failures.get() >= this.threshold && System.currentTimeMillis() - this.lastFailure >= this.halfOpenAfter ? this.halfOpenCircuit(exchange, callback) : this.closeCircuit(exchange, callback));
        } else {
            throw new IllegalStateException("Unrecognised circuitBreaker state " + this.state.get());
        }
        return output;
    }

    private boolean openCircuit(Exchange exchange, AsyncCallback callback) {
        boolean output = this.rejectExchange(exchange, callback);
        this.state.set(2);
        this.logState();
        return output;
    }

    private boolean halfOpenCircuit(Exchange exchange, AsyncCallback callback) {
        boolean output = this.executeProcessor(exchange, callback);
        this.state.set(1);
        this.logState();
        return output;
    }

    private boolean closeCircuit(Exchange exchange, AsyncCallback callback) {
        boolean output = this.executeProcessor(exchange, callback);
        this.state.set(0);
        this.logState();
        return output;
    }

    private void logState() {
        this.log.debug("State {}, failures {}, closed since {}", this.state.get(), this.failures.get(), System.currentTimeMillis() - this.lastFailure);
    }

    private boolean executeProcessor(Exchange exchange, AsyncCallback callback) {
        Processor processor = this.getProcessors().get(0);
        if (processor == null) {
            throw new IllegalStateException("No processors could be chosen to process CircuitBreaker");
        }
        AsyncProcessor albp = AsyncProcessorConverterHelper.convert(processor);
        boolean sync = albp.process(exchange, new CircuitBreakerCallback(exchange, callback));
        if (sync) {
            boolean failed = this.hasFailed(exchange);
            if (!failed) {
                this.failures.set(0);
            } else {
                this.failures.incrementAndGet();
                this.lastFailure = System.currentTimeMillis();
            }
        } else {
            this.log.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)exchange.getExchangeId());
            return false;
        }
        this.log.trace("Processing exchangeId: {} is continued being processed synchronously", (Object)exchange.getExchangeId());
        callback.done(true);
        return true;
    }

    private boolean rejectExchange(Exchange exchange, AsyncCallback callback) {
        exchange.setException(new RejectedExecutionException("CircuitBreaker Open: failures: " + this.failures + ", lastFailure: " + this.lastFailure));
        callback.done(true);
        return true;
    }

    public String toString() {
        return "CircuitBreakerLoadBalancer[" + this.getProcessors() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "circuitbreaker";
    }

    class CircuitBreakerCallback
    implements AsyncCallback {
        private final AsyncCallback callback;
        private final Exchange exchange;

        CircuitBreakerCallback(Exchange exchange, AsyncCallback callback) {
            this.callback = callback;
            this.exchange = exchange;
        }

        @Override
        public void done(boolean doneSync) {
            if (!doneSync) {
                boolean failed = CircuitBreakerLoadBalancer.this.hasFailed(this.exchange);
                if (!failed) {
                    CircuitBreakerLoadBalancer.this.failures.set(0);
                } else {
                    CircuitBreakerLoadBalancer.this.failures.incrementAndGet();
                    CircuitBreakerLoadBalancer.this.lastFailure = System.currentTimeMillis();
                }
            }
            this.callback.done(doneSync);
        }
    }
}

