/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.PipelineDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.view.NodeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class GraphSupport {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Map<Object, NodeData> nodeMap = new HashMap<Object, NodeData>();
    private String imagePrefix = "http://camel.apache.org/images/eip/";

    protected String getLabel(List<ExpressionDefinition> expressions) {
        CollectionStringBuffer buffer = new CollectionStringBuffer();
        for (ExpressionDefinition expression : expressions) {
            buffer.append(this.getLabel(expression));
        }
        return buffer.toString();
    }

    protected String getLabel(ExpressionDefinition expression) {
        if (expression != null) {
            return expression.getLabel();
        }
        return "";
    }

    protected NodeData getNodeData(Object node) {
        Object key = node;
        if (node instanceof FromDefinition) {
            FromDefinition fromType = (FromDefinition)node;
            key = fromType.getUriOrRef();
        } else if (node instanceof ToDefinition) {
            ToDefinition toType = (ToDefinition)node;
            key = toType.getUriOrRef();
        }
        NodeData answer = null;
        if (key != null) {
            answer = this.nodeMap.get(key);
        }
        if (answer == null) {
            String id = "node" + (this.nodeMap.size() + 1);
            answer = new NodeData(id, node, this.imagePrefix);
            this.nodeMap.put(key, answer);
        }
        return answer;
    }

    protected Map<String, List<RouteDefinition>> createRouteGroupMap(List<RouteDefinition> routes) {
        HashMap<String, List<RouteDefinition>> map = new HashMap<String, List<RouteDefinition>>();
        for (RouteDefinition route : routes) {
            this.addRouteToMap(map, route);
        }
        return map;
    }

    protected void addRouteToMap(Map<String, List<RouteDefinition>> map, RouteDefinition route) {
        List<RouteDefinition> list;
        String group = route.getGroup();
        if (group == null) {
            group = "Camel Routes";
        }
        if ((list = map.get(group)) == null) {
            list = new ArrayList<RouteDefinition>();
            map.put(group, list);
        }
        list.add(route);
    }

    protected boolean isMulticastNode(ProcessorDefinition<?> node) {
        return node instanceof MulticastDefinition || node instanceof ChoiceDefinition;
    }

    protected boolean isPipeline(ProcessorDefinition<?> node) {
        if (node instanceof MulticastDefinition) {
            return false;
        }
        if (node instanceof PipelineDefinition) {
            return true;
        }
        if (node.getOutputs().size() > 1) {
            for (ProcessorDefinition<?> type : node.getOutputs()) {
                if (type instanceof ToDefinition) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getImagePrefix() {
        return this.imagePrefix;
    }

    public void setImagePrefix(String imagePrefix) {
        this.imagePrefix = imagePrefix;
    }
}

