/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.activemq.transport.amqp.AmqpHeader;
import org.apache.activemq.transport.amqp.AmqpWireFormat;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.fusesource.hawtbuf.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpFrameParser {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpFrameParser.class);
    private static final byte AMQP_FRAME_SIZE_BYTES = 4;
    private static final byte AMQP_HEADER_BYTES = 8;
    private final AMQPFrameSink frameSink;
    private FrameParser currentParser;
    private AmqpWireFormat wireFormat;
    private final FrameParser headerReader = new FrameParser(){
        private final Buffer header = new Buffer(8);

        @Override
        public void parse(ByteBuffer incoming) throws IOException {
            int length = Math.min(incoming.remaining(), this.header.length - this.header.offset);
            incoming.get(this.header.data, this.header.offset, length);
            this.header.offset += length;
            if (this.header.offset == 8) {
                this.header.reset();
                AmqpHeader amqpHeader = new AmqpHeader(this.header.deepCopy(), false);
                AmqpFrameParser.this.currentParser = AmqpFrameParser.this.initializeFrameLengthParser();
                AmqpFrameParser.this.frameSink.onFrame(amqpHeader);
                if (incoming.hasRemaining()) {
                    AmqpFrameParser.this.currentParser.parse(incoming);
                }
            }
        }

        @Override
        public void reset(int nextExpectedReadSize) {
            this.header.reset();
        }
    };
    private final FrameParser frameSizeReader = new FrameParser(){
        private int frameSize;
        private int multiplier;

        @Override
        public void parse(ByteBuffer incoming) throws IOException {
            while (incoming.hasRemaining()) {
                this.frameSize += (incoming.get() & 0xFF) << --this.multiplier * 8;
                if (this.multiplier != 0) continue;
                LOG.trace("Next incoming frame length: {}", (Object)this.frameSize);
                AmqpFrameParser.this.validateFrameSize(this.frameSize);
                AmqpFrameParser.this.currentParser = AmqpFrameParser.this.initializeContentReader(this.frameSize);
                if (!incoming.hasRemaining()) continue;
                AmqpFrameParser.this.currentParser.parse(incoming);
                return;
            }
        }

        @Override
        public void reset(int nextExpectedReadSize) {
            this.multiplier = 4;
            this.frameSize = 0;
        }
    };
    private final FrameParser contentReader = new FrameParser(){
        private Buffer frame;

        @Override
        public void parse(ByteBuffer incoming) throws IOException {
            int length = Math.min(incoming.remaining(), this.frame.getLength() - this.frame.offset);
            incoming.get(this.frame.data, this.frame.offset, length);
            this.frame.offset += length;
            if (this.frame.offset == this.frame.length) {
                LOG.trace("Contents of size {} have been read", (Object)this.frame.length);
                this.frame.reset();
                AmqpFrameParser.this.frameSink.onFrame(this.frame);
                if (AmqpFrameParser.this.currentParser == this) {
                    AmqpFrameParser.this.currentParser = AmqpFrameParser.this.initializeFrameLengthParser();
                }
                if (incoming.hasRemaining()) {
                    AmqpFrameParser.this.currentParser.parse(incoming);
                }
            }
        }

        @Override
        public void reset(int nextExpectedReadSize) {
            this.frame = new Buffer(nextExpectedReadSize);
            this.frame.bigEndianEditor().writeInt(nextExpectedReadSize);
            this.frame.length = this.frame.data.length;
        }
    };

    public AmqpFrameParser(AMQPFrameSink sink) {
        this.frameSink = sink;
    }

    public AmqpFrameParser(final TcpTransport transport) {
        this.frameSink = new AMQPFrameSink(){

            @Override
            public void onFrame(Object frame) {
                transport.doConsume(frame);
            }
        };
    }

    public void parse(ByteBuffer incoming) throws Exception {
        if (incoming == null || !incoming.hasRemaining()) {
            return;
        }
        if (this.currentParser == null) {
            this.currentParser = this.initializeHeaderParser();
        }
        this.currentParser.parse(incoming);
    }

    public void reset() {
        this.currentParser = this.initializeHeaderParser();
    }

    private void validateFrameSize(int frameSize) throws IOException {
        long maxFrameSize = Long.MAX_VALUE;
        if (this.wireFormat != null) {
            maxFrameSize = this.wireFormat.getMaxFrameSize();
        }
        if ((long)frameSize > maxFrameSize) {
            throw new IOException("Frame size of " + frameSize + " larger than max allowed " + maxFrameSize);
        }
    }

    public void setWireFormat(AmqpWireFormat wireFormat) {
        this.wireFormat = wireFormat;
        if (wireFormat != null) {
            wireFormat.setProtocolResetListener(new AmqpWireFormat.ResetListener(){

                @Override
                public void onProtocolReset() {
                    AmqpFrameParser.this.reset();
                }
            });
        }
    }

    public AmqpWireFormat getWireFormat() {
        return this.wireFormat;
    }

    private FrameParser initializeHeaderParser() {
        this.headerReader.reset(8);
        return this.headerReader;
    }

    private FrameParser initializeFrameLengthParser() {
        this.frameSizeReader.reset(4);
        return this.frameSizeReader;
    }

    private FrameParser initializeContentReader(int contentLength) {
        this.contentReader.reset(contentLength);
        return this.contentReader;
    }

    private static interface FrameParser {
        public void parse(ByteBuffer var1) throws IOException;

        public void reset(int var1);
    }

    public static interface AMQPFrameSink {
        public void onFrame(Object var1);
    }
}

