/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.Attachments;
import org.apache.camel.Body;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeException;
import org.apache.camel.ExchangeProperty;
import org.apache.camel.Expression;
import org.apache.camel.Handler;
import org.apache.camel.Header;
import org.apache.camel.Headers;
import org.apache.camel.Message;
import org.apache.camel.OutHeaders;
import org.apache.camel.Properties;
import org.apache.camel.Property;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.component.bean.AnnotationExpressionFactory;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.component.bean.BeanHelper;
import org.apache.camel.component.bean.BeanInfoCacheKey;
import org.apache.camel.component.bean.DefaultParameterMappingStrategy;
import org.apache.camel.component.bean.MethodInfo;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.bean.ParameterInfo;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.language.LanguageAnnotation;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringQuoteHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInfo {
    private static final Logger LOG = LoggerFactory.getLogger(BeanInfo.class);
    private static final String CGLIB_CLASS_SEPARATOR = "$$";
    private static final List<Method> EXCLUDED_METHODS = new ArrayList<Method>();
    private final CamelContext camelContext;
    private final BeanComponent component;
    private final Class<?> type;
    private final ParameterMappingStrategy strategy;
    private final MethodInfo defaultMethod;
    private Map<String, List<MethodInfo>> operations = new HashMap<String, List<MethodInfo>>();
    private List<MethodInfo> operationsWithBody = new ArrayList<MethodInfo>();
    private List<MethodInfo> operationsWithNoBody = new ArrayList<MethodInfo>();
    private List<MethodInfo> operationsWithCustomAnnotation = new ArrayList<MethodInfo>();
    private List<MethodInfo> operationsWithHandlerAnnotation = new ArrayList<MethodInfo>();
    private Map<Method, MethodInfo> methodMap = new HashMap<Method, MethodInfo>();

    public BeanInfo(CamelContext camelContext, Class<?> type) {
        this(camelContext, type, BeanInfo.createParameterMappingStrategy(camelContext));
    }

    public BeanInfo(CamelContext camelContext, Method explicitMethod) {
        this(camelContext, explicitMethod.getDeclaringClass(), explicitMethod, BeanInfo.createParameterMappingStrategy(camelContext));
    }

    public BeanInfo(CamelContext camelContext, Class<?> type, ParameterMappingStrategy strategy) {
        this(camelContext, type, null, strategy);
    }

    public BeanInfo(CamelContext camelContext, Class<?> type, Method explicitMethod, ParameterMappingStrategy strategy) {
        List<MethodInfo> methods;
        this.camelContext = camelContext;
        this.type = type;
        this.strategy = strategy;
        this.component = camelContext.getComponent("bean", BeanComponent.class);
        BeanInfoCacheKey key = new BeanInfoCacheKey(type, explicitMethod);
        BeanInfo beanInfo = this.component.getBeanInfoFromCache(key);
        if (beanInfo != null) {
            this.defaultMethod = beanInfo.defaultMethod;
            this.operations = beanInfo.operations;
            this.operationsWithBody = beanInfo.operationsWithBody;
            this.operationsWithNoBody = beanInfo.operationsWithNoBody;
            this.operationsWithCustomAnnotation = beanInfo.operationsWithCustomAnnotation;
            this.operationsWithHandlerAnnotation = beanInfo.operationsWithHandlerAnnotation;
            this.methodMap = beanInfo.methodMap;
            return;
        }
        if (explicitMethod != null) {
            if (!this.isValidMethod(type, explicitMethod)) {
                throw new IllegalArgumentException("The method " + explicitMethod + " is not valid (for example the method must be public)");
            }
            this.introspect(this.getType(), explicitMethod);
        } else {
            this.introspect(this.getType());
        }
        MethodInfo method = null;
        if (this.operations.size() == 1 && (methods = this.operations.values().iterator().next()).size() == 1) {
            method = methods.get(0);
        }
        this.defaultMethod = method;
        this.operations = Collections.unmodifiableMap(this.operations);
        this.operationsWithBody = Collections.unmodifiableList(this.operationsWithBody);
        this.operationsWithNoBody = Collections.unmodifiableList(this.operationsWithNoBody);
        this.operationsWithCustomAnnotation = Collections.unmodifiableList(this.operationsWithCustomAnnotation);
        this.operationsWithHandlerAnnotation = Collections.unmodifiableList(this.operationsWithHandlerAnnotation);
        this.methodMap = Collections.unmodifiableMap(this.methodMap);
        this.component.addBeanInfoToCache(key, this);
    }

    public Class<?> getType() {
        return this.type;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public static ParameterMappingStrategy createParameterMappingStrategy(CamelContext camelContext) {
        Registry registry = camelContext.getRegistry();
        ParameterMappingStrategy answer = registry.lookupByNameAndType("CamelBeanParameterMappingStrategy", ParameterMappingStrategy.class);
        if (answer == null) {
            answer = new DefaultParameterMappingStrategy();
        }
        return answer;
    }

    public MethodInvocation createInvocation(Object pojo, Exchange exchange) throws AmbiguousMethodCallException, MethodNotFoundException {
        return this.createInvocation(pojo, exchange, null);
    }

    private MethodInvocation createInvocation(Object pojo, Exchange exchange, Method explicitMethod) throws AmbiguousMethodCallException, MethodNotFoundException {
        MethodInfo methodInfo = null;
        if (explicitMethod != null) {
            for (List<MethodInfo> infos : this.operations.values()) {
                for (MethodInfo info : infos) {
                    if (!explicitMethod.equals(info.getMethod())) continue;
                    return info.createMethodInvocation(pojo, exchange);
                }
            }
            throw new MethodNotFoundException(exchange, pojo, explicitMethod.getName());
        }
        String methodName = exchange.getIn().getHeader("CamelBeanMethodName", String.class);
        if (methodName != null) {
            String name = methodName;
            if (methodName.contains("(")) {
                name = ObjectHelper.before(methodName, "(");
            }
            boolean emptyParameters = methodName.endsWith("()");
            if ("class".equals(name) || "getClass".equals(name)) {
                try {
                    Method method = pojo.getClass().getMethod("getClass", new Class[0]);
                    methodInfo = new MethodInfo(exchange.getContext(), pojo.getClass(), method, Collections.emptyList(), Collections.emptyList(), false, false);
                }
                catch (NoSuchMethodException e) {
                    throw new MethodNotFoundException(exchange, pojo, "getClass");
                }
            } else if ("length".equals(name) && pojo.getClass().isArray()) {
                try {
                    Method method = ObjectHelper.class.getMethod("arrayLength", Object[].class);
                    ParameterInfo pi = new ParameterInfo(0, Object[].class, null, ExpressionBuilder.mandatoryBodyExpression(Object[].class, true));
                    ArrayList<ParameterInfo> lpi = new ArrayList<ParameterInfo>(1);
                    lpi.add(pi);
                    methodInfo = new MethodInfo(exchange.getContext(), pojo.getClass(), method, lpi, lpi, false, false);
                    exchange.getIn().setBody(pojo);
                }
                catch (NoSuchMethodException e) {
                    throw new MethodNotFoundException(exchange, pojo, "getClass");
                }
            } else {
                List<MethodInfo> methods = this.getOperations(name);
                if (methods != null && methods.size() == 1) {
                    methodInfo = methods.get(0);
                    if (emptyParameters && methodInfo.hasParameters()) {
                        throw new MethodNotFoundException(exchange, pojo, methodName, "(with no parameters)");
                    }
                } else if (methods != null) {
                    methodInfo = this.chooseMethod(pojo, exchange, methodName);
                    if (emptyParameters && (methodInfo == null || methodInfo.hasParameters())) {
                        throw new MethodNotFoundException(exchange, pojo, methodName, "(with no parameters)");
                    }
                    if (methodInfo == null || !name.equals(methodInfo.getMethod().getName())) {
                        throw new AmbiguousMethodCallException(exchange, methods);
                    }
                } else {
                    throw new MethodNotFoundException(exchange, pojo, methodName);
                }
            }
        }
        if (methodInfo == null) {
            methodInfo = this.chooseMethod(pojo, exchange, null);
        }
        if (methodInfo == null) {
            methodInfo = this.defaultMethod;
        }
        if (methodInfo != null) {
            LOG.trace("Chosen method to invoke: {} on bean: {}", (Object)methodInfo, pojo);
            return methodInfo.createMethodInvocation(pojo, exchange);
        }
        LOG.debug("Cannot find suitable method to invoke on bean: {}", pojo);
        return null;
    }

    private void introspect(Class<?> clazz) {
        boolean javaClass;
        List<Method> methods;
        clazz = BeanInfo.getTargetClass(clazz);
        ObjectHelper.notNull(clazz, "clazz", this);
        LOG.trace("Introspecting class: {}", (Object)clazz);
        if (Modifier.isPublic(clazz.getModifiers())) {
            LOG.trace("Preferring class methods as class: {} is public accessible", (Object)clazz);
            methods = new ArrayList<Method>(Arrays.asList(clazz.getDeclaredMethods()));
        } else {
            LOG.trace("Preferring interface methods as class: {} is not public accessible", (Object)clazz);
            methods = BeanInfo.getInterfaceMethods(clazz);
            List<Method> extraMethods = Arrays.asList(clazz.getDeclaredMethods());
            methods.addAll(extraMethods);
        }
        HashSet<Method> overrides = new HashSet<Method>();
        boolean bl = javaClass = clazz.getName().startsWith("java.") || clazz.getName().startsWith("javax.");
        if (!javaClass) {
            for (Method source : methods) {
                if (source.isBridge()) continue;
                for (Method target : methods) {
                    if (ObjectHelper.isOverridingMethod(source, target, true) || !ObjectHelper.isOverridingMethod(source, target, false)) continue;
                    overrides.add(target);
                }
            }
            methods.removeAll(overrides);
            overrides.clear();
        }
        if (Modifier.isPublic(clazz.getModifiers())) {
            List<Method> extraMethods = BeanInfo.getInterfaceMethods(clazz);
            for (Method target : extraMethods) {
                for (Method source : methods) {
                    if (!ObjectHelper.isOverridingMethod(source, target, false)) continue;
                    overrides.add(target);
                }
            }
            extraMethods.removeAll(overrides);
            methods.addAll(extraMethods);
        }
        for (Method method : methods) {
            boolean valid = this.isValidMethod(clazz, method);
            LOG.trace("Method: {} is valid: {}", (Object)method, (Object)valid);
            if (!valid) continue;
            this.introspect(clazz, method);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && !superclass.equals(Object.class)) {
            this.introspect(superclass);
        }
    }

    private MethodInfo introspect(Class<?> clazz, Method method) {
        LOG.trace("Introspecting class: {}, method: {}", (Object)clazz, (Object)method);
        String opName = method.getName();
        MethodInfo methodInfo = this.createMethodInfo(clazz, method);
        MethodInfo existingMethodInfo = this.overridesExistingMethod(methodInfo);
        if (existingMethodInfo != null) {
            LOG.trace("This method is already overridden in a subclass, so the method from the sub class is preferred: {}", (Object)existingMethodInfo);
            return existingMethodInfo;
        }
        LOG.trace("Adding operation: {} for method: {}", (Object)opName, (Object)methodInfo);
        if (this.hasMethod(opName)) {
            List<MethodInfo> existing = this.getOperations(opName);
            existing.add(methodInfo);
        } else {
            ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
            methods.add(methodInfo);
            this.operations.put(opName, methods);
        }
        if (methodInfo.hasCustomAnnotation()) {
            this.operationsWithCustomAnnotation.add(methodInfo);
        } else if (methodInfo.hasBodyParameter()) {
            this.operationsWithBody.add(methodInfo);
        } else {
            this.operationsWithNoBody.add(methodInfo);
        }
        if (methodInfo.hasHandlerAnnotation()) {
            this.operationsWithHandlerAnnotation.add(methodInfo);
        }
        this.methodMap.put(method, methodInfo);
        return methodInfo;
    }

    public MethodInfo getMethodInfo(Method method) {
        Class<?> superclass;
        MethodInfo answer = this.methodMap.get(method);
        if (answer == null) {
            for (Method source : this.methodMap.keySet()) {
                if (!ObjectHelper.isOverridingMethod(source, method, false)) continue;
                answer = this.methodMap.get(source);
                break;
            }
        }
        if (answer == null && this.type != Object.class && (superclass = this.type.getSuperclass()) != null && superclass != Object.class) {
            BeanInfo superBeanInfo = new BeanInfo(this.camelContext, superclass, this.strategy);
            return superBeanInfo.getMethodInfo(method);
        }
        return answer;
    }

    protected MethodInfo createMethodInfo(Class<?> clazz, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        List<Annotation>[] parametersAnnotations = this.collectParameterAnnotations(clazz, method);
        ArrayList<ParameterInfo> parameters = new ArrayList<ParameterInfo>();
        ArrayList<ParameterInfo> bodyParameters = new ArrayList<ParameterInfo>();
        boolean hasCustomAnnotation = false;
        boolean hasHandlerAnnotation = ObjectHelper.hasAnnotation(method.getAnnotations(), Handler.class);
        int size2 = parameterTypes.length;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating MethodInfo for class: {} method: {} having {} parameters", clazz, method, size2);
        }
        for (int i = 0; i < size2; ++i) {
            Class<?> parameterType = parameterTypes[i];
            Annotation[] parameterAnnotations = parametersAnnotations[i].toArray(new Annotation[parametersAnnotations[i].size()]);
            Expression expression = this.createParameterUnmarshalExpression(clazz, method, parameterType, parameterAnnotations);
            hasCustomAnnotation |= expression != null;
            ParameterInfo parameterInfo = new ParameterInfo(i, parameterType, parameterAnnotations, expression);
            LOG.trace("Parameter #{}: {}", (Object)i, (Object)parameterInfo);
            parameters.add(parameterInfo);
            if (expression == null) {
                boolean bodyAnnotation = ObjectHelper.hasAnnotation(parameterAnnotations, Body.class);
                LOG.trace("Parameter #{} has @Body annotation", (Object)i);
                hasCustomAnnotation |= bodyAnnotation;
                if (bodyParameters.isEmpty()) {
                    expression = Exchange.class.isAssignableFrom(parameterType) ? ExpressionBuilder.exchangeExpression() : ExpressionBuilder.mandatoryBodyExpression(parameterType, true);
                    LOG.trace("Parameter #{} is the body parameter using expression {}", (Object)i, (Object)expression);
                    parameterInfo.setExpression(expression);
                    bodyParameters.add(parameterInfo);
                }
            }
            LOG.trace("Parameter #{} has parameter info: ", (Object)i, (Object)parameterInfo);
        }
        return new MethodInfo(this.camelContext, clazz, method, parameters, bodyParameters, hasCustomAnnotation, hasHandlerAnnotation);
    }

    protected List<Annotation>[] collectParameterAnnotations(Class<?> c, Method m) {
        List[] annotations = new List[m.getParameterTypes().length];
        for (int i = 0; i < annotations.length; ++i) {
            annotations[i] = new ArrayList();
        }
        this.collectParameterAnnotations(c, m, annotations);
        return annotations;
    }

    protected void collectParameterAnnotations(Class<?> c, Method m, List<Annotation>[] a) {
        try {
            Annotation[][] pa = c.getDeclaredMethod(m.getName(), m.getParameterTypes()).getParameterAnnotations();
            for (int i = 0; i < pa.length; ++i) {
                a[i].addAll(Arrays.asList(pa[i]));
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        for (Class<?> i : c.getInterfaces()) {
            this.collectParameterAnnotations(i, m, a);
        }
        if (!c.isInterface() && c.getSuperclass() != null) {
            this.collectParameterAnnotations(c.getSuperclass(), m, a);
        }
    }

    protected MethodInfo chooseMethod(Object pojo, Exchange exchange, String name) throws AmbiguousMethodCallException {
        boolean noParameters;
        ArrayList<MethodInfo> localOperationsWithBody = new ArrayList<MethodInfo>(this.operationsWithBody);
        ArrayList<MethodInfo> localOperationsWithNoBody = new ArrayList<MethodInfo>(this.operationsWithNoBody);
        ArrayList<MethodInfo> localOperationsWithCustomAnnotation = new ArrayList<MethodInfo>(this.operationsWithCustomAnnotation);
        ArrayList<MethodInfo> localOperationsWithHandlerAnnotation = new ArrayList<MethodInfo>(this.operationsWithHandlerAnnotation);
        this.removeAllAbstractMethods(localOperationsWithBody);
        this.removeAllAbstractMethods(localOperationsWithNoBody);
        this.removeAllAbstractMethods(localOperationsWithCustomAnnotation);
        this.removeAllAbstractMethods(localOperationsWithHandlerAnnotation);
        if (name != null) {
            this.removeNonMatchingMethods(localOperationsWithHandlerAnnotation, name);
            this.removeNonMatchingMethods(localOperationsWithCustomAnnotation, name);
            this.removeNonMatchingMethods(localOperationsWithBody, name);
            this.removeNonMatchingMethods(localOperationsWithNoBody, name);
        } else {
            BeanInfo.removeAllSetterOrGetterMethods(localOperationsWithHandlerAnnotation);
            BeanInfo.removeAllSetterOrGetterMethods(localOperationsWithCustomAnnotation);
            BeanInfo.removeAllSetterOrGetterMethods(localOperationsWithBody);
            BeanInfo.removeAllSetterOrGetterMethods(localOperationsWithNoBody);
        }
        if (localOperationsWithHandlerAnnotation.size() > 1) {
            throw new AmbiguousMethodCallException(exchange, localOperationsWithHandlerAnnotation);
        }
        if (localOperationsWithHandlerAnnotation.size() == 1) {
            return (MethodInfo)localOperationsWithHandlerAnnotation.get(0);
        }
        if (localOperationsWithCustomAnnotation.size() == 1) {
            return (MethodInfo)localOperationsWithCustomAnnotation.get(0);
        }
        boolean bl = noParameters = name != null && name.endsWith("()");
        if (noParameters && localOperationsWithNoBody.size() == 1) {
            return (MethodInfo)localOperationsWithNoBody.get(0);
        }
        if (!noParameters && localOperationsWithBody.size() == 1 && localOperationsWithCustomAnnotation.isEmpty()) {
            return (MethodInfo)localOperationsWithBody.get(0);
        }
        ArrayList<MethodInfo> possibleOperations = new ArrayList<MethodInfo>();
        possibleOperations.addAll(localOperationsWithBody);
        possibleOperations.addAll(localOperationsWithCustomAnnotation);
        if (!possibleOperations.isEmpty()) {
            String parameters;
            MethodInfo answer = this.chooseMethodWithMatchingBody(exchange, possibleOperations, localOperationsWithCustomAnnotation);
            if (answer == null && name != null && (parameters = ObjectHelper.between(name, "(", ")")) != null) {
                answer = this.chooseMethodWithMatchingParameters(exchange, parameters, possibleOperations);
            }
            if (answer == null && possibleOperations.size() > 1) {
                answer = this.getSingleCovariantMethod(possibleOperations);
            }
            if (answer == null) {
                throw new AmbiguousMethodCallException(exchange, possibleOperations);
            }
            return answer;
        }
        return null;
    }

    private MethodInfo chooseMethodWithMatchingParameters(Exchange exchange, String parameters, Collection<MethodInfo> operationList) throws AmbiguousMethodCallException {
        Iterator<Object> it = ObjectHelper.createIterator(parameters);
        int count = 0;
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        ArrayList<MethodInfo> operations = new ArrayList<MethodInfo>();
        for (MethodInfo info : operationList) {
            if (info.getParameters().size() != count) continue;
            operations.add(info);
        }
        if (operations.isEmpty()) {
            return null;
        }
        if (operations.size() == 1) {
            return (MethodInfo)operations.get(0);
        }
        ArrayList<MethodInfo> candidates = new ArrayList<MethodInfo>();
        for (MethodInfo info : operations) {
            it = ObjectHelper.createIterator(parameters);
            int index = 0;
            boolean matches = true;
            while (it.hasNext()) {
                String parameter = (String)it.next();
                Class<?> parameterType = BeanHelper.getValidParameterType(parameter);
                Class<?> expectedType = info.getParameters().get(index).getType();
                if (parameterType != null && expectedType != null && !parameterType.isAssignableFrom(expectedType)) {
                    matches = false;
                    break;
                }
                ++index;
            }
            if (!matches) continue;
            candidates.add(info);
        }
        if (candidates.size() > 1) {
            MethodInfo answer = this.getSingleCovariantMethod(candidates);
            if (answer == null) {
                throw new AmbiguousMethodCallException(exchange, candidates);
            }
            return answer;
        }
        return candidates.size() == 1 ? (MethodInfo)candidates.get(0) : null;
    }

    private MethodInfo getSingleCovariantMethod(Collection<MethodInfo> candidates) {
        MethodInfo firstCandidate = candidates.iterator().next();
        for (MethodInfo candidate : candidates) {
            if (firstCandidate.isCovariantWith(candidate)) continue;
            return null;
        }
        return firstCandidate;
    }

    private MethodInfo chooseMethodWithMatchingBody(Exchange exchange, Collection<MethodInfo> operationList, List<MethodInfo> operationsWithCustomAnnotation) throws AmbiguousMethodCallException {
        Message in = exchange.getIn();
        Object body = in.getBody();
        if (body != null) {
            Class<?> bodyType = body.getClass();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Matching for method with a single parameter that matches type: {}", (Object)bodyType.getCanonicalName());
            }
            ArrayList<MethodInfo> possibles = new ArrayList<MethodInfo>();
            ArrayList<MethodInfo> possiblesWithException = new ArrayList<MethodInfo>();
            for (MethodInfo methodInfo : operationList) {
                boolean out = exchange.getPattern().isOutCapable();
                if (out && methodInfo.isReturnTypeVoid() || !methodInfo.bodyParameterMatches(bodyType)) continue;
                LOG.trace("Found a possible method: {}", (Object)methodInfo);
                if (methodInfo.hasExceptionParameter()) {
                    possiblesWithException.add(methodInfo);
                    continue;
                }
                possibles.add(methodInfo);
            }
            return this.chooseBestPossibleMethodInfo(exchange, operationList, body, possibles, possiblesWithException, operationsWithCustomAnnotation);
        }
        return null;
    }

    private MethodInfo chooseBestPossibleMethodInfo(Exchange exchange, Collection<MethodInfo> operationList, Object body, List<MethodInfo> possibles, List<MethodInfo> possiblesWithException, List<MethodInfo> possibleWithCustomAnnotation) throws AmbiguousMethodCallException {
        Exception exception = ExpressionBuilder.exchangeExceptionExpression().evaluate(exchange, Exception.class);
        if (exception != null && possiblesWithException.size() == 1) {
            LOG.trace("Exchange has exception set so we prefer method that also has exception as parameter");
            return possiblesWithException.get(0);
        }
        if (possibles.size() == 1) {
            return possibles.get(0);
        }
        if (possibles.isEmpty()) {
            LOG.trace("No possible methods so now trying to convert body to parameter types");
            Object newBody = null;
            MethodInfo matched = null;
            int matchCounter = 0;
            for (MethodInfo methodInfo : operationList) {
                if (methodInfo.getBodyParameterType() == null) continue;
                if (methodInfo.getBodyParameterType().isInstance(body)) {
                    return methodInfo;
                }
                Object value = exchange.getContext().getTypeConverter().tryConvertTo(methodInfo.getBodyParameterType(), exchange, body);
                if (value == null) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Converted body from: {} to: {}", (Object)body.getClass().getCanonicalName(), (Object)methodInfo.getBodyParameterType().getCanonicalName());
                }
                ++matchCounter;
                newBody = value;
                matched = methodInfo;
            }
            if (matchCounter > 1) {
                throw new AmbiguousMethodCallException(exchange, Arrays.asList(matched, matched));
            }
            if (matched != null) {
                LOG.trace("Setting converted body: {}", body);
                Message in = exchange.getIn();
                in.setBody(newBody);
                return matched;
            }
        } else {
            if (possibleWithCustomAnnotation.size() == 1) {
                MethodInfo answer = possibleWithCustomAnnotation.get(0);
                LOG.trace("There are only one method with annotations so we choose it: {}", (Object)answer);
                return answer;
            }
            MethodInfo chosen = this.chooseMethodWithCustomAnnotations(exchange, possibles);
            if (chosen != null) {
                return chosen;
            }
            chosen = this.getSingleCovariantMethod(possibles);
            if (chosen != null) {
                return chosen;
            }
            throw new AmbiguousMethodCallException(exchange, possibles);
        }
        return null;
    }

    protected boolean isValidMethod(Class<?> clazz, Method method) {
        for (Method excluded : EXCLUDED_METHODS) {
            if (!ObjectHelper.isOverridingMethod(excluded, method)) continue;
            return false;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        return (method.getReturnType() == null || !Exchange.class.isAssignableFrom(method.getReturnType())) && !method.isBridge();
    }

    private MethodInfo overridesExistingMethod(MethodInfo methodInfo) {
        for (MethodInfo info : this.methodMap.values()) {
            Method target;
            Method source = info.getMethod();
            boolean override = ObjectHelper.isOverridingMethod(source, target = methodInfo.getMethod());
            if (!override) continue;
            return info;
        }
        return null;
    }

    private MethodInfo chooseMethodWithCustomAnnotations(Exchange exchange, Collection<MethodInfo> possibles) throws AmbiguousMethodCallException {
        MethodInfo chosen = null;
        for (MethodInfo possible : possibles) {
            if (!possible.hasCustomAnnotation()) continue;
            if (chosen != null) {
                chosen = null;
                break;
            }
            chosen = possible;
        }
        return chosen;
    }

    private Expression createParameterUnmarshalExpression(Class<?> clazz, Method method, Class<?> parameterType, Annotation[] parameterAnnotation) {
        for (Annotation annotation : parameterAnnotation) {
            Expression answer = this.createParameterUnmarshalExpressionForAnnotation(clazz, method, parameterType, annotation);
            if (answer == null) continue;
            return answer;
        }
        return this.strategy.getDefaultParameterTypeExpression(parameterType);
    }

    private Expression createParameterUnmarshalExpressionForAnnotation(Class<?> clazz, Method method, Class<?> parameterType, Annotation annotation) {
        if (annotation instanceof Attachments) {
            return ExpressionBuilder.attachmentsExpression();
        }
        if (annotation instanceof Property) {
            Property propertyAnnotation = (Property)annotation;
            return ExpressionBuilder.exchangePropertyExpression(propertyAnnotation.value());
        }
        if (annotation instanceof ExchangeProperty) {
            ExchangeProperty propertyAnnotation = (ExchangeProperty)annotation;
            return ExpressionBuilder.exchangePropertyExpression(propertyAnnotation.value());
        }
        if (annotation instanceof Properties) {
            return ExpressionBuilder.propertiesExpression();
        }
        if (annotation instanceof Header) {
            Header headerAnnotation = (Header)annotation;
            return ExpressionBuilder.headerExpression(headerAnnotation.value());
        }
        if (annotation instanceof Headers) {
            return ExpressionBuilder.headersExpression();
        }
        if (annotation instanceof OutHeaders) {
            return ExpressionBuilder.outHeadersExpression();
        }
        if (annotation instanceof ExchangeException) {
            return ExpressionBuilder.exchangeExceptionExpression(CastUtils.cast(parameterType, Exception.class));
        }
        LanguageAnnotation languageAnnotation = annotation.annotationType().getAnnotation(LanguageAnnotation.class);
        if (languageAnnotation != null) {
            Class<?> type = languageAnnotation.factory();
            Object object = this.camelContext.getInjector().newInstance(type);
            if (object instanceof AnnotationExpressionFactory) {
                AnnotationExpressionFactory expressionFactory = (AnnotationExpressionFactory)object;
                return expressionFactory.createExpression(this.camelContext, annotation, languageAnnotation, parameterType);
            }
            LOG.warn("Ignoring bad annotation: " + languageAnnotation + "on method: " + method + " which declares a factory: " + type.getName() + " which does not implement " + AnnotationExpressionFactory.class.getName());
        }
        return null;
    }

    private static List<Method> getInterfaceMethods(Class<?> clazz) {
        ArrayList<Method> answer = new ArrayList<Method>();
        while (clazz != null && !clazz.equals(Object.class)) {
            for (Class<?> interfaceClazz : clazz.getInterfaces()) {
                for (Method interfaceMethod : interfaceClazz.getDeclaredMethods()) {
                    answer.add(interfaceMethod);
                }
            }
            clazz = clazz.getSuperclass();
        }
        return answer;
    }

    private static void removeAllSetterOrGetterMethods(List<MethodInfo> methods) {
        Iterator<MethodInfo> it = methods.iterator();
        while (it.hasNext()) {
            MethodInfo info = it.next();
            if (IntrospectionSupport.isGetter(info.getMethod())) {
                it.remove();
                continue;
            }
            if (!IntrospectionSupport.isSetter(info.getMethod())) continue;
            it.remove();
        }
    }

    private void removeNonMatchingMethods(List<MethodInfo> methods, String name) {
        Iterator<MethodInfo> it = methods.iterator();
        while (it.hasNext()) {
            MethodInfo info = it.next();
            if (this.matchMethod(info.getMethod(), name)) continue;
            it.remove();
        }
    }

    private void removeAllAbstractMethods(List<MethodInfo> methods) {
        Iterator<MethodInfo> it = methods.iterator();
        while (it.hasNext()) {
            MethodInfo info = it.next();
            if (!Modifier.isAbstract(info.getMethod().getModifiers())) continue;
            it.remove();
        }
    }

    private boolean matchMethod(Method method, String methodName) {
        if (methodName == null) {
            return true;
        }
        if (methodName.contains("(") && !methodName.endsWith(")")) {
            throw new IllegalArgumentException("Name must have both starting and ending parenthesis, was: " + methodName);
        }
        String name = methodName;
        if (name.contains("(")) {
            name = ObjectHelper.before(name, "(");
        }
        if (!name.equals(method.getName())) {
            return false;
        }
        boolean noParameters = methodName.endsWith("()");
        if (noParameters) {
            return method.getParameterTypes().length == 0;
        }
        String types = ObjectHelper.between(methodName, "(", ")");
        if (ObjectHelper.isNotEmpty(types)) {
            String[] parameters = StringQuoteHelper.splitSafeQuote(types, ',');
            Iterator<Object> it = ObjectHelper.createIterator(parameters);
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                if (it.hasNext()) {
                    Boolean assignable;
                    Class<?> parameterType = method.getParameterTypes()[i];
                    String qualifyType = (String)it.next();
                    if (ObjectHelper.isEmpty(qualifyType) || "*".equals(qualifyType = qualifyType.trim()) || BeanHelper.isValidParameterValue(qualifyType) || (assignable = BeanHelper.isAssignableToExpectedType(this.getCamelContext().getClassResolver(), qualifyType, parameterType)) == null || assignable.booleanValue()) continue;
                    return false;
                }
                return false;
            }
            if (it.hasNext()) {
                return false;
            }
        }
        return true;
    }

    private static Class<?> getTargetClass(Class<?> clazz) {
        Class<?> superClass;
        if (clazz != null && clazz.getName().contains(CGLIB_CLASS_SEPARATOR) && (superClass = clazz.getSuperclass()) != null && !Object.class.equals(superClass)) {
            return superClass;
        }
        return clazz;
    }

    public boolean hasMethod(String methodName) {
        return this.getOperations(methodName) != null;
    }

    public boolean hasStaticMethod(String methodName) {
        List<MethodInfo> methods = this.getOperations(methodName);
        if (methods == null || methods.isEmpty()) {
            return false;
        }
        for (MethodInfo method : methods) {
            if (!method.isStaticMethod()) continue;
            return true;
        }
        return false;
    }

    public List<MethodInfo> getMethods() {
        if (this.operations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (Collection collection : this.operations.values()) {
            methods.addAll(collection);
        }
        Collections.sort(methods, new Comparator<MethodInfo>(){

            @Override
            public int compare(MethodInfo o1, MethodInfo o2) {
                return o1.getMethod().getName().compareTo(o2.getMethod().getName());
            }
        });
        return methods;
    }

    private List<MethodInfo> getOperations(String methodName) {
        List<MethodInfo> answer;
        if (methodName.contains("(")) {
            methodName = ObjectHelper.before(methodName, "(");
        }
        if ((answer = this.operations.get(methodName)) != null) {
            return answer;
        }
        for (Method method : this.methodMap.keySet()) {
            String shorthandMethodName;
            if (!IntrospectionSupport.isGetter(method) || !methodName.equals(shorthandMethodName = IntrospectionSupport.getGetterShorthandName(method))) continue;
            return this.operations.get(method.getName());
        }
        return null;
    }

    static {
        EXCLUDED_METHODS.addAll(Arrays.asList(Object.class.getMethods()));
        EXCLUDED_METHODS.addAll(Arrays.asList(Proxy.class.getMethods()));
        try {
            EXCLUDED_METHODS.remove(Object.class.getMethod("toString", new Class[0]));
            EXCLUDED_METHODS.remove(Proxy.class.getMethod("toString", new Class[0]));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

