/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.management.event.ExchangeSendingEvent;
import org.apache.camel.management.event.RouteAddedEvent;
import org.apache.camel.management.event.RouteRemovedEvent;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.util.LRUCache;

public class DefaultRuntimeEndpointRegistry
extends EventNotifierSupport
implements RuntimeEndpointRegistry {
    private Map<String, Set<String>> inputs;
    private Map<String, Map<String, String>> outputs;
    private int limit = 1000;
    private boolean enabled = true;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public List<String> getAllEndpoints(boolean includeInputs) {
        ArrayList answer = new ArrayList();
        if (includeInputs) {
            for (Map.Entry<String, Object> entry : this.inputs.entrySet()) {
                answer.addAll((Collection)entry.getValue());
            }
        }
        for (Map.Entry<String, Object> entry : this.outputs.entrySet()) {
            answer.addAll(((Map)entry.getValue()).keySet());
        }
        return Collections.unmodifiableList(answer);
    }

    @Override
    public List<String> getEndpointsPerRoute(String routeId, boolean includeInputs) {
        Object uris;
        ArrayList answer = new ArrayList();
        if (includeInputs && (uris = this.inputs.get(routeId)) != null) {
            answer.addAll(uris);
        }
        if ((uris = this.outputs.get(routeId)) != null) {
            answer.addAll(uris.keySet());
        }
        return Collections.unmodifiableList(answer);
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public void reset() {
        this.inputs.clear();
        this.outputs.clear();
    }

    @Override
    public int size() {
        int total = this.inputs.values().size();
        return total += this.outputs.values().size();
    }

    @Override
    protected void doStart() throws Exception {
        if (this.inputs == null) {
            this.inputs = new HashMap<String, Set<String>>();
        }
        if (this.outputs == null) {
            this.outputs = new HashMap<String, Map<String, String>>();
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.reset();
    }

    @Override
    public void notify(EventObject event) throws Exception {
        if (event instanceof RouteAddedEvent) {
            RouteAddedEvent rse = (RouteAddedEvent)event;
            Endpoint endpoint = rse.getRoute().getEndpoint();
            String routeId = rse.getRoute().getId();
            HashSet<String> uris = new HashSet<String>();
            uris.add(endpoint.getEndpointUri());
            this.inputs.put(routeId, uris);
            this.outputs.put(routeId, new LRUCache(this.limit));
        } else if (event instanceof RouteRemovedEvent) {
            RouteRemovedEvent rse = (RouteRemovedEvent)event;
            String routeId = rse.getRoute().getId();
            this.inputs.remove(routeId);
            this.outputs.remove(routeId);
        } else {
            ExchangeSendingEvent ese = (ExchangeSendingEvent)event;
            Endpoint endpoint = ese.getEndpoint();
            String routeId = this.getRouteId(ese.getExchange());
            String uri = endpoint.getEndpointUri();
            Map<String, String> uris = this.outputs.get(routeId);
            if (uris != null && !uris.containsKey(uri)) {
                uris.put(uri, uri);
            }
        }
    }

    private String getRouteId(Exchange exchange) {
        RouteContext rc;
        String answer = null;
        UnitOfWork uow = exchange.getUnitOfWork();
        RouteContext routeContext = rc = uow != null ? uow.getRouteContext() : null;
        if (rc != null) {
            answer = rc.getRoute().getId();
        }
        if (answer == null) {
            answer = exchange.getFromRouteId();
        }
        return answer;
    }

    @Override
    public boolean isEnabled(EventObject event) {
        return this.enabled && event instanceof ExchangeSendingEvent || event instanceof RouteAddedEvent || event instanceof RouteRemovedEvent;
    }
}

