/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.Throttler;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;

@Metadata(label="eip,routing")
@XmlRootElement(name="throttle")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ThrottleDefinition
extends ExpressionNode
implements ExecutorServiceAwareDefinition<ThrottleDefinition> {
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    @Metadata(defaultValue="1000")
    private Long timePeriodMillis;
    @XmlAttribute
    private Boolean asyncDelayed;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private Boolean callerRunsWhenRejected;
    @XmlAttribute
    private Boolean rejectExecution;

    public ThrottleDefinition() {
    }

    public ThrottleDefinition(Expression maximumRequestsPerPeriod) {
        super(maximumRequestsPerPeriod);
    }

    public String toString() {
        return "Throttle[" + this.description() + " -> " + this.getOutputs() + "]";
    }

    protected String description() {
        return this.getExpression() + " request per " + this.getTimePeriodMillis() + " millis";
    }

    @Override
    public String getLabel() {
        return "throttle[" + this.description() + "]";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = this.createChildProcessor(routeContext, true);
        boolean async = this.getAsyncDelayed() != null && this.getAsyncDelayed() != false;
        boolean shutdownThreadPool = ProcessorDefinitionHelper.willCreateNewThreadPool(routeContext, this, async);
        ScheduledExecutorService threadPool = ProcessorDefinitionHelper.getConfiguredScheduledExecutorService(routeContext, "Throttle", this, async);
        long period = this.getTimePeriodMillis() != null ? this.getTimePeriodMillis() : 1000L;
        Expression maxRequestsExpression = this.createMaxRequestsPerPeriodExpression(routeContext);
        if (maxRequestsExpression == null) {
            throw new IllegalArgumentException("MaxRequestsPerPeriod expression must be provided on " + this);
        }
        boolean reject = this.getRejectExecution() != null && this.getRejectExecution() != false;
        Throttler answer = new Throttler(routeContext.getCamelContext(), childProcessor, maxRequestsExpression, period, threadPool, shutdownThreadPool, reject);
        answer.setAsyncDelayed(async);
        if (this.getCallerRunsWhenRejected() == null) {
            answer.setCallerRunsWhenRejected(true);
        } else {
            answer.setCallerRunsWhenRejected(this.getCallerRunsWhenRejected());
        }
        return answer;
    }

    private Expression createMaxRequestsPerPeriodExpression(RouteContext routeContext) {
        ExpressionDefinition expr = this.getExpression();
        if (expr != null) {
            return expr.createExpression(routeContext);
        }
        return null;
    }

    public ThrottleDefinition timePeriodMillis(long timePeriodMillis) {
        this.setTimePeriodMillis(timePeriodMillis);
        return this;
    }

    public ThrottleDefinition maximumRequestsPerPeriod(Long maximumRequestsPerPeriod) {
        this.setExpression(ExpressionNodeHelper.toExpressionDefinition(ExpressionBuilder.constantExpression(maximumRequestsPerPeriod)));
        return this;
    }

    public ThrottleDefinition callerRunsWhenRejected(boolean callerRunsWhenRejected) {
        this.setCallerRunsWhenRejected(callerRunsWhenRejected);
        return this;
    }

    public ThrottleDefinition asyncDelayed() {
        this.setAsyncDelayed(true);
        return this;
    }

    public ThrottleDefinition rejectExecution(boolean rejectExecution) {
        this.setRejectExecution(rejectExecution);
        return this;
    }

    @Override
    public ThrottleDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public ThrottleDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public Long getTimePeriodMillis() {
        return this.timePeriodMillis;
    }

    public void setTimePeriodMillis(Long timePeriodMillis) {
        this.timePeriodMillis = timePeriodMillis;
    }

    public Boolean getAsyncDelayed() {
        return this.asyncDelayed;
    }

    public void setAsyncDelayed(Boolean asyncDelayed) {
        this.asyncDelayed = asyncDelayed;
    }

    public Boolean getCallerRunsWhenRejected() {
        return this.callerRunsWhenRejected;
    }

    public void setCallerRunsWhenRejected(Boolean callerRunsWhenRejected) {
        this.callerRunsWhenRejected = callerRunsWhenRejected;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    @Override
    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Boolean getRejectExecution() {
        return this.rejectExecution;
    }

    public void setRejectExecution(Boolean rejectExecution) {
        this.rejectExecution = rejectExecution;
    }
}

