/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringQuoteHelper;

public final class StringHelper {
    private StringHelper() {
    }

    public static String sanitize(String s) {
        return s.replace(':', '-').replace('_', '-').replace('.', '-').replace('/', '-').replace('\\', '-');
    }

    public static int countChar(String s, char ch) {
        if (ObjectHelper.isEmpty(s)) {
            return 0;
        }
        int matches = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (ch != c) continue;
            ++matches;
        }
        return matches;
    }

    public static String removeQuotes(String s) {
        if (ObjectHelper.isEmpty(s)) {
            return s;
        }
        s = StringHelper.replaceAll(s, "'", "");
        s = StringHelper.replaceAll(s, "\"", "");
        return s;
    }

    public static String removeLeadingAndEndingQuotes(String s) {
        if (ObjectHelper.isEmpty(s)) {
            return s;
        }
        String copy = s.trim();
        if (copy.startsWith("'") && copy.endsWith("'")) {
            return copy.substring(1, copy.length() - 1);
        }
        if (copy.startsWith("\"") && copy.endsWith("\"")) {
            return copy.substring(1, copy.length() - 1);
        }
        return s;
    }

    public static boolean isQuoted(String s) {
        if (ObjectHelper.isEmpty(s)) {
            return false;
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return true;
        }
        return s.startsWith("\"") && s.endsWith("\"");
    }

    public static String xmlEncode(String text) {
        if (text == null) {
            return "";
        }
        text = StringHelper.replaceAll(text, "&", "&amp;");
        text = StringHelper.replaceAll(text, "\"", "&quot;");
        text = StringHelper.replaceAll(text, "<", "&lt;");
        text = StringHelper.replaceAll(text, ">", "&gt;");
        return text;
    }

    public static boolean hasUpperCase(String text) {
        if (text == null) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (!Character.isUpperCase(ch)) continue;
            return true;
        }
        return false;
    }

    public static boolean isClassName(String text) {
        String lastToken;
        String[] split;
        boolean result = false;
        if (text != null && (split = text.split("\\.")).length > 0 && (lastToken = split[split.length - 1]).length() > 0) {
            result = Character.isUpperCase(lastToken.charAt(0));
        }
        return result;
    }

    public static boolean hasStartToken(String expression, String language) {
        if (expression == null) {
            return false;
        }
        if ("simple".equalsIgnoreCase(language) && expression.indexOf("${") >= 0) {
            return true;
        }
        return language != null && expression.indexOf("$" + language + "{") >= 0;
    }

    public static String replaceAll(String input, String from, String to) {
        if (ObjectHelper.isEmpty(input)) {
            return input;
        }
        if (from == null) {
            throw new IllegalArgumentException("from cannot be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("to cannot be null");
        }
        if (!input.contains(from)) {
            return input;
        }
        int len = from.length();
        int max = input.length();
        StringBuilder sb = new StringBuilder(max);
        int i = 0;
        while (i < max) {
            String token;
            if (i + len <= max && from.equals(token = input.substring(i, i + len))) {
                sb.append(to);
                i += len;
                continue;
            }
            sb.append(input.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    public static String toJson(String name, String value, boolean isMap) {
        if (isMap) {
            return "{ " + StringQuoteHelper.doubleQuote(name) + ": " + StringQuoteHelper.doubleQuote(value) + " }";
        }
        return StringQuoteHelper.doubleQuote(name) + ": " + StringQuoteHelper.doubleQuote(value);
    }
}

