/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.view;

import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.view.GraphGeneratorSupport;
import org.apache.camel.view.NodeData;

@Deprecated
public class RouteDotGenerator
extends GraphGeneratorSupport {
    public RouteDotGenerator(String dir) {
        super(dir, ".dot");
    }

    protected void printRoutes(PrintWriter writer, Map<String, List<RouteDefinition>> map) {
        Set<Map.Entry<String, List<RouteDefinition>>> entries = map.entrySet();
        for (Map.Entry<String, List<RouteDefinition>> entry : entries) {
            String group = entry.getKey();
            this.printRoutes(writer, group, entry.getValue());
        }
    }

    protected void printRoutes(PrintWriter writer, String group, List<RouteDefinition> routes) {
        if (group != null) {
            writer.println("subgraph cluster_" + this.clusterCounter++ + " {");
            writer.println("label = \"" + group + "\";");
            writer.println("color = grey;");
            writer.println("style = \"dashed\";");
            writer.println("URL = \"" + group + ".html\";");
            writer.println();
        }
        for (RouteDefinition route : routes) {
            List<FromDefinition> inputs = route.getInputs();
            for (FromDefinition input : inputs) {
                this.printRoute(writer, route, input);
            }
            writer.println();
        }
        if (group != null) {
            writer.println("}");
            writer.println();
        }
    }

    protected void printRoute(PrintWriter writer, RouteDefinition route, FromDefinition input) {
        NodeData nodeData = this.getNodeData(input);
        this.printNode(writer, nodeData);
        NodeData from = nodeData;
        for (ProcessorDefinition<?> output : route.getOutputs()) {
            NodeData newData;
            from = newData = this.printNode(writer, from, output);
        }
    }

    protected NodeData printNode(PrintWriter writer, NodeData fromData, ProcessorDefinition<?> node) {
        List<ProcessorDefinition<?>> outputs;
        if (node instanceof MulticastDefinition) {
            List<ProcessorDefinition<?>> outputs2 = node.getOutputs();
            boolean isPipeline = this.isPipeline(node);
            for (ProcessorDefinition<?> output : outputs2) {
                NodeData out = this.printNode(writer, fromData, output);
                if (!isPipeline) continue;
                fromData = out;
            }
            return fromData;
        }
        NodeData toData = this.getNodeData(node);
        this.printNode(writer, toData);
        if (fromData != null) {
            writer.print(fromData.id);
            writer.print(" -> ");
            writer.print(toData.id);
            writer.println(" [");
            String label = fromData.edgeLabel;
            if (ObjectHelper.isNotEmpty(label)) {
                writer.println("label = \"" + label + "\"");
            }
            writer.println("];");
        }
        if ((outputs = toData.outputs) != null) {
            for (ProcessorDefinition<?> output : outputs) {
                NodeData newData = this.printNode(writer, toData, output);
                if (this.isMulticastNode(node)) continue;
                toData = newData;
            }
        }
        return toData;
    }

    protected void printNode(PrintWriter writer, NodeData data) {
        if (!data.nodeWritten) {
            String shape;
            String image;
            data.nodeWritten = true;
            writer.println();
            writer.print(data.id);
            writer.println(" [");
            writer.println("label = \"" + data.label + "\"");
            writer.println("tooltip = \"" + data.tooltop + "\"");
            if (data.url != null) {
                writer.println("URL = \"" + data.url + "\"");
            }
            if ((image = data.image) != null) {
                writer.println("shapefile = \"" + image + "\"");
                writer.println("peripheries=0");
            }
            if ((shape = data.shape) == null && image != null) {
                shape = "custom";
            }
            if (shape != null) {
                writer.println("shape = \"" + shape + "\"");
            }
            writer.println("];");
            writer.println();
        }
    }

    @Override
    protected void generateFile(PrintWriter writer, Map<String, List<RouteDefinition>> map) {
        writer.println("digraph CamelRoutes {");
        writer.println();
        writer.println("node [style = \"rounded,filled\", fillcolor = yellow, fontname=\"Helvetica-Oblique\"];");
        writer.println();
        this.printRoutes(writer, map);
        writer.println("}");
    }
}

