/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TransactionInProgressException;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.connection.SessionProxy;
import org.springframework.util.Assert;

public class TransactionAwareConnectionFactoryProxy
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory {
    private boolean synchedLocalTransactionAllowed = false;
    private ConnectionFactory targetConnectionFactory;

    public TransactionAwareConnectionFactoryProxy() {
    }

    public TransactionAwareConnectionFactoryProxy(ConnectionFactory targetConnectionFactory) {
        this.setTargetConnectionFactory(targetConnectionFactory);
    }

    public final void setTargetConnectionFactory(ConnectionFactory targetConnectionFactory) {
        Assert.notNull(targetConnectionFactory, "targetConnectionFactory must not be nul");
        this.targetConnectionFactory = targetConnectionFactory;
    }

    protected ConnectionFactory getTargetConnectionFactory() {
        return this.targetConnectionFactory;
    }

    public void setSynchedLocalTransactionAllowed(boolean synchedLocalTransactionAllowed) {
        this.synchedLocalTransactionAllowed = synchedLocalTransactionAllowed;
    }

    protected boolean isSynchedLocalTransactionAllowed() {
        return this.synchedLocalTransactionAllowed;
    }

    public Connection createConnection() throws JMSException {
        Connection targetConnection = this.targetConnectionFactory.createConnection();
        return this.getTransactionAwareConnectionProxy(targetConnection);
    }

    public Connection createConnection(String username, String password) throws JMSException {
        Connection targetConnection = this.targetConnectionFactory.createConnection(username, password);
        return this.getTransactionAwareConnectionProxy(targetConnection);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        if (!(this.targetConnectionFactory instanceof QueueConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is no QueueConnectionFactory");
        }
        QueueConnection targetConnection = ((QueueConnectionFactory)this.targetConnectionFactory).createQueueConnection();
        return (QueueConnection)this.getTransactionAwareConnectionProxy(targetConnection);
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        if (!(this.targetConnectionFactory instanceof QueueConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is no QueueConnectionFactory");
        }
        QueueConnection targetConnection = ((QueueConnectionFactory)this.targetConnectionFactory).createQueueConnection(username, password);
        return (QueueConnection)this.getTransactionAwareConnectionProxy(targetConnection);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        if (!(this.targetConnectionFactory instanceof TopicConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is no TopicConnectionFactory");
        }
        TopicConnection targetConnection = ((TopicConnectionFactory)this.targetConnectionFactory).createTopicConnection();
        return (TopicConnection)this.getTransactionAwareConnectionProxy(targetConnection);
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        if (!(this.targetConnectionFactory instanceof TopicConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is no TopicConnectionFactory");
        }
        TopicConnection targetConnection = ((TopicConnectionFactory)this.targetConnectionFactory).createTopicConnection(username, password);
        return (TopicConnection)this.getTransactionAwareConnectionProxy(targetConnection);
    }

    protected Connection getTransactionAwareConnectionProxy(Connection target) {
        ArrayList<Class<TopicConnection>> classes = new ArrayList<Class<TopicConnection>>(3);
        classes.add(Connection.class);
        if (target instanceof QueueConnection) {
            classes.add(QueueConnection.class);
        }
        if (target instanceof TopicConnection) {
            classes.add(TopicConnection.class);
        }
        return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), classes.toArray(new Class[classes.size()]), (InvocationHandler)new TransactionAwareConnectionInvocationHandler(target));
    }

    private static class CloseSuppressingSessionInvocationHandler
    implements InvocationHandler {
        private final Session target;

        public CloseSuppressingSessionInvocationHandler(Session target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("commit")) {
                throw new TransactionInProgressException("Commit call not allowed within a managed transaction");
            }
            if (method.getName().equals("rollback")) {
                throw new TransactionInProgressException("Rollback call not allowed within a managed transaction");
            }
            if (method.getName().equals("close")) {
                return null;
            }
            if (method.getName().equals("getTargetSession")) {
                return this.target;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private class TransactionAwareConnectionInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public TransactionAwareConnectionInvocationHandler(Connection target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Session session;
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (Session.class.equals(method.getReturnType()) ? (session = ConnectionFactoryUtils.getTransactionalSession(TransactionAwareConnectionFactoryProxy.this.getTargetConnectionFactory(), this.target, TransactionAwareConnectionFactoryProxy.this.isSynchedLocalTransactionAllowed())) != null : (QueueSession.class.equals(method.getReturnType()) ? (session = ConnectionFactoryUtils.getTransactionalQueueSession((QueueConnectionFactory)TransactionAwareConnectionFactoryProxy.this.getTargetConnectionFactory(), (QueueConnection)this.target, TransactionAwareConnectionFactoryProxy.this.isSynchedLocalTransactionAllowed())) != null : TopicSession.class.equals(method.getReturnType()) && (session = ConnectionFactoryUtils.getTransactionalTopicSession((TopicConnectionFactory)TransactionAwareConnectionFactoryProxy.this.getTargetConnectionFactory(), (TopicConnection)this.target, TransactionAwareConnectionFactoryProxy.this.isSynchedLocalTransactionAllowed())) != null)) {
                return this.getCloseSuppressingSessionProxy(session);
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        private Session getCloseSuppressingSessionProxy(Session target) {
            ArrayList<Class<TopicSession>> classes = new ArrayList<Class<TopicSession>>(3);
            classes.add(SessionProxy.class);
            if (target instanceof QueueSession) {
                classes.add(QueueSession.class);
            }
            if (target instanceof TopicSession) {
                classes.add(TopicSession.class);
            }
            return (Session)Proxy.newProxyInstance(SessionProxy.class.getClassLoader(), classes.toArray(new Class[classes.size()]), (InvocationHandler)new CloseSuppressingSessionInvocationHandler(target));
        }
    }
}

