/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.jta;

import com.ibm.wsspi.uow.UOWAction;
import com.ibm.wsspi.uow.UOWActionException;
import com.ibm.wsspi.uow.UOWException;
import com.ibm.wsspi.uow.UOWManager;
import com.ibm.wsspi.uow.UOWManagerFactory;
import java.util.List;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.InvalidTimeoutException;
import org.springframework.transaction.NestedTransactionNotSupportedException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.jta.JtaAfterCompletionSynchronization;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.jta.JtaTransactionObject;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.CallbackPreferringPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionSynchronizationUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSphereUowTransactionManager
extends JtaTransactionManager
implements CallbackPreferringPlatformTransactionManager {
    public static final String DEFAULT_UOW_MANAGER_NAME = "java:comp/websphere/UOWManager";
    private UOWManager uowManager;
    private String uowManagerName;

    public WebSphereUowTransactionManager() {
        this.setAutodetectTransactionManager(false);
    }

    public WebSphereUowTransactionManager(UOWManager uowManager) {
        this();
        this.uowManager = uowManager;
    }

    public void setUowManager(UOWManager uowManager) {
        this.uowManager = uowManager;
    }

    public void setUowManagerName(String uowManagerName) {
        this.uowManagerName = uowManagerName;
    }

    @Override
    public void afterPropertiesSet() throws TransactionSystemException {
        this.initUserTransactionAndTransactionManager();
        if (this.uowManager == null) {
            this.uowManager = this.uowManagerName != null ? this.lookupUowManager(this.uowManagerName) : this.lookupDefaultUowManager();
        }
    }

    protected UOWManager lookupUowManager(String uowManagerName) throws TransactionSystemException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Retrieving WebSphere UOWManager from JNDI location [" + uowManagerName + "]");
            }
            return this.getJndiTemplate().lookup(uowManagerName, UOWManager.class);
        }
        catch (NamingException ex) {
            throw new TransactionSystemException("WebSphere UOWManager is not available at JNDI location [" + uowManagerName + "]", ex);
        }
    }

    protected UOWManager lookupDefaultUowManager() throws TransactionSystemException {
        try {
            this.logger.debug("Retrieving WebSphere UOWManager from default JNDI location [java:comp/websphere/UOWManager]");
            return this.getJndiTemplate().lookup(DEFAULT_UOW_MANAGER_NAME, UOWManager.class);
        }
        catch (NamingException ex) {
            this.logger.debug("WebSphere UOWManager is not available at default JNDI location [java:comp/websphere/UOWManager] - falling back to UOWManagerFactory lookup");
            return UOWManagerFactory.getUOWManager();
        }
    }

    @Override
    protected void doRegisterAfterCompletionWithJtaTransaction(JtaTransactionObject txObject, List<TransactionSynchronization> synchronizations) {
        this.uowManager.registerInterposedSynchronization((Synchronization)new JtaAfterCompletionSynchronization(synchronizations));
    }

    @Override
    public boolean supportsResourceAdapterManagedTransactions() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T execute(TransactionDefinition definition, TransactionCallback<T> callback) throws TransactionException {
        T t;
        boolean newSynch;
        boolean joinTx;
        int uowType;
        block21: {
            int pb;
            block23: {
                if (definition == null) {
                    definition = new DefaultTransactionDefinition();
                }
                if (definition.getTimeout() < -1) {
                    throw new InvalidTimeoutException("Invalid transaction timeout", definition.getTimeout());
                }
                pb = definition.getPropagationBehavior();
                boolean existingTx = this.uowManager.getUOWStatus() != 5 && this.uowManager.getUOWType() != 0;
                uowType = 1;
                joinTx = false;
                newSynch = false;
                if (!existingTx) break block23;
                if (pb == 5) {
                    throw new IllegalTransactionStateException("Transaction propagation 'never' but existing transaction found");
                }
                if (pb == 6) {
                    throw new NestedTransactionNotSupportedException("Transaction propagation 'nested' not supported for WebSphere UOW transactions");
                }
                if (pb == 1 || pb == 0 || pb == 2) {
                    joinTx = true;
                    newSynch = this.getTransactionSynchronization() != 2;
                    break block21;
                } else if (pb == 4) {
                    uowType = 0;
                    newSynch = this.getTransactionSynchronization() == 0;
                    break block21;
                } else {
                    newSynch = this.getTransactionSynchronization() != 2;
                }
                break block21;
            }
            if (pb == 2) {
                throw new IllegalTransactionStateException("Transaction propagation 'mandatory' but no existing transaction found");
            }
            if (pb == 1 || pb == 4 || pb == 5) {
                uowType = 0;
                newSynch = this.getTransactionSynchronization() == 0;
            } else {
                newSynch = this.getTransactionSynchronization() != 2;
            }
        }
        boolean debug = this.logger.isDebugEnabled();
        if (debug) {
            this.logger.debug("Creating new transaction with name [" + definition.getName() + "]: " + definition);
        }
        AbstractPlatformTransactionManager.SuspendedResourcesHolder suspendedResources = !joinTx ? this.suspend(null) : null;
        try {
            try {
                if (definition.getTimeout() > -1) {
                    this.uowManager.setUOWTimeout(uowType, definition.getTimeout());
                }
                if (debug) {
                    this.logger.debug("Invoking WebSphere UOW action: type=" + uowType + ", join=" + joinTx);
                }
                UOWActionAdapter<T> action = new UOWActionAdapter<T>(definition, callback, uowType == 1, !joinTx, newSynch, debug);
                this.uowManager.runUnderUOW(uowType, joinTx, action);
                if (debug) {
                    this.logger.debug("Returned from WebSphere UOW action: type=" + uowType + ", join=" + joinTx);
                }
                t = action.getResult();
                Object var13_14 = null;
                if (suspendedResources == null) return t;
            }
            catch (UOWException ex) {
                throw new TransactionSystemException("UOWManager transaction processing failed", ex);
            }
            catch (UOWActionException ex) {
                throw new TransactionSystemException("UOWManager threw unexpected UOWActionException", ex);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (suspendedResources == null) throw throwable;
            this.resume(null, suspendedResources);
            throw throwable;
        }
        this.resume(null, suspendedResources);
        return t;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UOWActionAdapter<T>
    implements UOWAction,
    SmartTransactionObject {
        private final TransactionDefinition definition;
        private final TransactionCallback<T> callback;
        private final boolean actualTransaction;
        private final boolean newTransaction;
        private final boolean newSynchronization;
        private boolean debug;
        private T result;
        private Throwable exception;

        public UOWActionAdapter(TransactionDefinition definition, TransactionCallback<T> callback, boolean actualTransaction, boolean newTransaction, boolean newSynchronization, boolean debug) {
            this.definition = definition;
            this.callback = callback;
            this.actualTransaction = actualTransaction;
            this.newTransaction = newTransaction;
            this.newSynchronization = newSynchronization;
            this.debug = debug;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            DefaultTransactionStatus status2 = WebSphereUowTransactionManager.this.prepareTransactionStatus(this.definition, this.actualTransaction ? this : null, this.newTransaction, this.newSynchronization, this.debug, null);
            try {
                try {
                    this.result = this.callback.doInTransaction(status2);
                    WebSphereUowTransactionManager.this.triggerBeforeCommit(status2);
                }
                catch (Throwable ex) {
                    this.exception = ex;
                    WebSphereUowTransactionManager.this.uowManager.setRollbackOnly();
                    Object var4_3 = null;
                    if (status2.isLocalRollbackOnly()) {
                        if (status2.isDebug()) {
                            WebSphereUowTransactionManager.this.logger.debug("Transactional code has requested rollback");
                        }
                        WebSphereUowTransactionManager.this.uowManager.setRollbackOnly();
                    }
                    WebSphereUowTransactionManager.this.triggerBeforeCompletion(status2);
                    if (!status2.isNewSynchronization()) return;
                    List<TransactionSynchronization> synchronizations = TransactionSynchronizationManager.getSynchronizations();
                    TransactionSynchronizationManager.clear();
                    if (synchronizations.isEmpty()) return;
                    WebSphereUowTransactionManager.this.uowManager.registerInterposedSynchronization((Synchronization)new JtaAfterCompletionSynchronization(synchronizations));
                    return;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (status2.isLocalRollbackOnly()) {
                    if (status2.isDebug()) {
                        WebSphereUowTransactionManager.this.logger.debug("Transactional code has requested rollback");
                    }
                    WebSphereUowTransactionManager.this.uowManager.setRollbackOnly();
                }
                WebSphereUowTransactionManager.this.triggerBeforeCompletion(status2);
                if (!status2.isNewSynchronization()) throw throwable;
                List<TransactionSynchronization> synchronizations = TransactionSynchronizationManager.getSynchronizations();
                TransactionSynchronizationManager.clear();
                if (synchronizations.isEmpty()) throw throwable;
                WebSphereUowTransactionManager.this.uowManager.registerInterposedSynchronization((Synchronization)new JtaAfterCompletionSynchronization(synchronizations));
                throw throwable;
            }
            if (status2.isLocalRollbackOnly()) {
                if (status2.isDebug()) {
                    WebSphereUowTransactionManager.this.logger.debug("Transactional code has requested rollback");
                }
                WebSphereUowTransactionManager.this.uowManager.setRollbackOnly();
            }
            WebSphereUowTransactionManager.this.triggerBeforeCompletion(status2);
            if (!status2.isNewSynchronization()) return;
            List<TransactionSynchronization> synchronizations = TransactionSynchronizationManager.getSynchronizations();
            TransactionSynchronizationManager.clear();
            if (synchronizations.isEmpty()) return;
            WebSphereUowTransactionManager.this.uowManager.registerInterposedSynchronization((Synchronization)new JtaAfterCompletionSynchronization(synchronizations));
        }

        public T getResult() {
            if (this.exception != null) {
                ReflectionUtils.rethrowRuntimeException(this.exception);
            }
            return this.result;
        }

        @Override
        public boolean isRollbackOnly() {
            return WebSphereUowTransactionManager.this.uowManager.getRollbackOnly();
        }

        @Override
        public void flush() {
            TransactionSynchronizationUtils.triggerFlush();
        }
    }
}

