/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import java.net.InetAddress;
import java.net.URI;
import org.apache.activemq.transport.SocketConnectorFactory;
import org.apache.activemq.transport.TransportServerSupport;
import org.apache.activemq.util.InetAddressUtil;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;

public abstract class WebTransportServerSupport
extends TransportServerSupport {
    protected URI bindAddress;
    protected Server server;
    protected Connector connector;
    protected SocketConnectorFactory socketConnectorFactory;
    protected String host;

    public WebTransportServerSupport(URI location) {
        super(location);
    }

    private <T> void setConnectorProperty(String name, Class<T> type, T value) throws Exception {
        this.connector.getClass().getMethod("set" + name, type).invoke((Object)this.connector, value);
    }

    protected void createServer() {
        this.server = new Server();
        try {
            this.server.getClass().getMethod("setStopTimeout", Long.TYPE).invoke((Object)this.server, 500L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public URI bind() throws Exception {
        URI bind = this.getBindLocation();
        String bindHost = bind.getHost();
        bindHost = bindHost == null || bindHost.length() == 0 ? "localhost" : bindHost;
        InetAddress addr = InetAddress.getByName(bindHost);
        this.host = addr.getCanonicalHostName();
        this.setConnectorProperty("Host", String.class, this.host);
        this.setConnectorProperty("Port", Integer.TYPE, this.bindAddress.getPort());
        this.server.addConnector(this.connector);
        if (addr.isAnyLocalAddress()) {
            this.host = InetAddressUtil.getLocalHostName();
        }
        URI boundUri = new URI(bind.getScheme(), bind.getUserInfo(), this.host, this.bindAddress.getPort(), bind.getPath(), bind.getQuery(), bind.getFragment());
        this.setConnectURI(boundUri);
        return boundUri;
    }
}

