/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.generator;

import java.io.IOException;
import java.util.Set;
import org.apache.xbean.spring.generator.GeneratorPlugin;
import org.apache.xbean.spring.generator.LogFacade;
import org.apache.xbean.spring.generator.MappingLoader;
import org.apache.xbean.spring.generator.NamespaceMapping;

public class SchemaGenerator {
    private final MappingLoader mappingLoader;
    private final GeneratorPlugin[] plugins;
    private final LogFacade log;

    public SchemaGenerator(LogFacade log2, MappingLoader mappingLoader, GeneratorPlugin[] plugins) {
        this.log = log2;
        this.mappingLoader = mappingLoader;
        this.plugins = plugins;
    }

    public void generate() throws IOException {
        Set<NamespaceMapping> namespaces = this.mappingLoader.loadNamespaces();
        if (namespaces.isEmpty()) {
            this.log.log("Warning: no namespaces found!");
        }
        for (NamespaceMapping namespaceMapping : namespaces) {
            for (int i = 0; i < this.plugins.length; ++i) {
                GeneratorPlugin plugin = this.plugins[i];
                plugin.generate(namespaceMapping);
            }
        }
    }
}

