/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.core;

import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jms.InvalidDestinationException;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsMessageOperations;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.MessagingMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.core.AbstractMessagingTemplate;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.util.Assert;

public class JmsMessagingTemplate
extends AbstractMessagingTemplate<Destination>
implements JmsMessageOperations,
InitializingBean {
    private JmsTemplate jmsTemplate;
    private MessageConverter jmsMessageConverter = new MessagingMessageConverter();
    private String defaultDestinationName;

    public JmsMessagingTemplate() {
    }

    public JmsMessagingTemplate(ConnectionFactory connectionFactory) {
        this.jmsTemplate = new JmsTemplate(connectionFactory);
    }

    public JmsMessagingTemplate(JmsTemplate jmsTemplate) {
        Assert.notNull("JmsTemplate must not be null");
        this.jmsTemplate = jmsTemplate;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        if (this.jmsTemplate != null) {
            this.jmsTemplate.setConnectionFactory(connectionFactory);
        } else {
            this.jmsTemplate = new JmsTemplate(connectionFactory);
        }
    }

    public ConnectionFactory getConnectionFactory() {
        return this.jmsTemplate != null ? this.jmsTemplate.getConnectionFactory() : null;
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public JmsTemplate getJmsTemplate() {
        return this.jmsTemplate;
    }

    public void setJmsMessageConverter(MessageConverter jmsMessageConverter) {
        Assert.notNull(jmsMessageConverter, "MessageConverter must not be null");
        this.jmsMessageConverter = jmsMessageConverter;
    }

    public MessageConverter getJmsMessageConverter() {
        return this.jmsMessageConverter;
    }

    public void setDefaultDestinationName(String defaultDestinationName) {
        this.defaultDestinationName = defaultDestinationName;
    }

    public String getDefaultDestinationName() {
        return this.defaultDestinationName;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.notNull(this.getJmsTemplate(), "Property 'connectionFactory' or 'jmsTemplate' is required");
    }

    public void send(Message<?> message) {
        Destination defaultDestination = (Destination)this.getDefaultDestination();
        if (defaultDestination != null) {
            this.send(defaultDestination, message);
        } else {
            this.send(this.getRequiredDefaultDestinationName(), message);
        }
    }

    public void convertAndSend(Object payload) throws MessagingException {
        this.convertAndSend(payload, null);
    }

    public void convertAndSend(Object payload, MessagePostProcessor postProcessor) throws MessagingException {
        Destination defaultDestination = (Destination)this.getDefaultDestination();
        if (defaultDestination != null) {
            this.convertAndSend(defaultDestination, payload, postProcessor);
        } else {
            this.convertAndSend(this.getRequiredDefaultDestinationName(), payload, postProcessor);
        }
    }

    @Override
    public void send(String destinationName, Message<?> message) throws MessagingException {
        this.doSend(destinationName, message);
    }

    @Override
    public void convertAndSend(String destinationName, Object payload) throws MessagingException {
        this.convertAndSend(destinationName, payload, (Map<String, Object>)null);
    }

    @Override
    public void convertAndSend(String destinationName, Object payload, Map<String, Object> headers) throws MessagingException {
        this.convertAndSend(destinationName, payload, headers, null);
    }

    @Override
    public void convertAndSend(String destinationName, Object payload, MessagePostProcessor postProcessor) throws MessagingException {
        this.convertAndSend(destinationName, payload, null, postProcessor);
    }

    @Override
    public void convertAndSend(String destinationName, Object payload, Map<String, Object> headers, MessagePostProcessor postProcessor) throws MessagingException {
        Message message = this.doConvert(payload, headers, postProcessor);
        this.send(destinationName, message);
    }

    public Message<?> receive() {
        Destination defaultDestination = (Destination)this.getDefaultDestination();
        if (defaultDestination != null) {
            return this.receive(defaultDestination);
        }
        return this.receive(this.getRequiredDefaultDestinationName());
    }

    public <T> T receiveAndConvert(Class<T> targetClass) {
        Destination defaultDestination = (Destination)this.getDefaultDestination();
        if (defaultDestination != null) {
            return (T)this.receiveAndConvert(defaultDestination, targetClass);
        }
        return this.receiveAndConvert(this.getRequiredDefaultDestinationName(), targetClass);
    }

    @Override
    public Message<?> receive(String destinationName) throws MessagingException {
        return this.doReceive(destinationName);
    }

    @Override
    public <T> T receiveAndConvert(String destinationName, Class<T> targetClass) throws MessagingException {
        Message<?> message = this.doReceive(destinationName);
        if (message != null) {
            return (T)this.doConvert(message, targetClass);
        }
        return null;
    }

    public Message<?> sendAndReceive(Message<?> requestMessage) {
        Destination defaultDestination = (Destination)this.getDefaultDestination();
        if (defaultDestination != null) {
            return this.sendAndReceive(defaultDestination, requestMessage);
        }
        return this.sendAndReceive(this.getRequiredDefaultDestinationName(), requestMessage);
    }

    @Override
    public Message<?> sendAndReceive(String destinationName, Message<?> requestMessage) throws MessagingException {
        return this.doSendAndReceive(destinationName, requestMessage);
    }

    @Override
    public <T> T convertSendAndReceive(String destinationName, Object request, Class<T> targetClass) throws MessagingException {
        return this.convertSendAndReceive(destinationName, request, null, targetClass);
    }

    public <T> T convertSendAndReceive(Object request, Class<T> targetClass) {
        return this.convertSendAndReceive(request, targetClass, null);
    }

    @Override
    public <T> T convertSendAndReceive(String destinationName, Object request, Map<String, Object> headers, Class<T> targetClass) throws MessagingException {
        return this.convertSendAndReceive(destinationName, request, headers, targetClass, null);
    }

    public <T> T convertSendAndReceive(Object request, Class<T> targetClass, MessagePostProcessor postProcessor) {
        Destination defaultDestination = (Destination)this.getDefaultDestination();
        if (defaultDestination != null) {
            return (T)this.convertSendAndReceive(defaultDestination, request, targetClass, postProcessor);
        }
        return this.convertSendAndReceive(this.getRequiredDefaultDestinationName(), request, targetClass, postProcessor);
    }

    @Override
    public <T> T convertSendAndReceive(String destinationName, Object request, Class<T> targetClass, MessagePostProcessor requestPostProcessor) throws MessagingException {
        return this.convertSendAndReceive(destinationName, request, null, targetClass, requestPostProcessor);
    }

    @Override
    public <T> T convertSendAndReceive(String destinationName, Object request, Map<String, Object> headers, Class<T> targetClass, MessagePostProcessor postProcessor) {
        Message requestMessage = this.doConvert(request, headers, postProcessor);
        Message<?> replyMessage = this.sendAndReceive(destinationName, requestMessage);
        return (T)(replyMessage != null ? this.getMessageConverter().fromMessage(replyMessage, targetClass) : null);
    }

    protected void doSend(Destination destination, Message<?> message) {
        try {
            this.jmsTemplate.send(destination, (MessageCreator)this.createMessageCreator(message));
        }
        catch (JmsException ex) {
            throw this.convertJmsException(ex);
        }
    }

    protected void doSend(String destinationName, Message<?> message) {
        try {
            this.jmsTemplate.send(destinationName, (MessageCreator)this.createMessageCreator(message));
        }
        catch (JmsException ex) {
            throw this.convertJmsException(ex);
        }
    }

    protected Message<?> doReceive(Destination destination) {
        try {
            javax.jms.Message jmsMessage = this.jmsTemplate.receive(destination);
            return this.convertJmsMessage(jmsMessage);
        }
        catch (JmsException ex) {
            throw this.convertJmsException(ex);
        }
    }

    protected Message<?> doReceive(String destinationName) {
        try {
            javax.jms.Message jmsMessage = this.jmsTemplate.receive(destinationName);
            return this.convertJmsMessage(jmsMessage);
        }
        catch (JmsException ex) {
            throw this.convertJmsException(ex);
        }
    }

    protected Message<?> doSendAndReceive(Destination destination, Message<?> requestMessage) {
        try {
            javax.jms.Message jmsMessage = this.jmsTemplate.sendAndReceive(destination, (MessageCreator)this.createMessageCreator(requestMessage));
            return this.convertJmsMessage(jmsMessage);
        }
        catch (JmsException ex) {
            throw this.convertJmsException(ex);
        }
    }

    protected Message<?> doSendAndReceive(String destinationName, Message<?> requestMessage) {
        try {
            javax.jms.Message jmsMessage = this.jmsTemplate.sendAndReceive(destinationName, (MessageCreator)this.createMessageCreator(requestMessage));
            return this.convertJmsMessage(jmsMessage);
        }
        catch (JmsException ex) {
            throw this.convertJmsException(ex);
        }
    }

    private MessagingMessageCreator createMessageCreator(Message<?> message) {
        return new MessagingMessageCreator(message, this.getJmsMessageConverter());
    }

    protected String getRequiredDefaultDestinationName() {
        String name = this.getDefaultDestinationName();
        if (name == null) {
            throw new IllegalStateException("No 'defaultDestination' or 'defaultDestinationName' specified. Check configuration of JmsMessagingTemplate.");
        }
        return name;
    }

    protected Message<?> convertJmsMessage(javax.jms.Message message) {
        if (message == null) {
            return null;
        }
        try {
            return (Message)this.getJmsMessageConverter().fromMessage(message);
        }
        catch (Exception ex) {
            throw new MessageConversionException("Could not convert '" + message + "'", (Throwable)ex);
        }
    }

    protected MessagingException convertJmsException(JmsException ex) {
        if (ex instanceof org.springframework.jms.support.destination.DestinationResolutionException || ex instanceof InvalidDestinationException) {
            return new DestinationResolutionException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof org.springframework.jms.support.converter.MessageConversionException) {
            return new MessageConversionException(ex.getMessage(), (Throwable)ex);
        }
        return new MessagingException(ex.getMessage(), (Throwable)ex);
    }

    private static class MessagingMessageCreator
    implements MessageCreator {
        private final Message<?> message;
        private final MessageConverter messageConverter;

        public MessagingMessageCreator(Message<?> message, MessageConverter messageConverter) {
            this.message = message;
            this.messageConverter = messageConverter;
        }

        @Override
        public javax.jms.Message createMessage(Session session) throws JMSException {
            try {
                return this.messageConverter.toMessage(this.message, session);
            }
            catch (Exception ex) {
                throw new MessageConversionException("Could not convert '" + this.message + "'", (Throwable)ex);
            }
        }
    }
}

