/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.amqp.AmqpInactivityMonitor;
import org.apache.activemq.transport.amqp.AmqpProtocolConverter;
import org.apache.activemq.transport.amqp.AmqpProtocolDiscriminator;
import org.apache.activemq.transport.amqp.AmqpTransport;
import org.apache.activemq.transport.amqp.AmqpWireFormat;
import org.apache.activemq.transport.tcp.SslTransport;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpTransportFilter
extends TransportFilter
implements AmqpTransport {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpTransportFilter.class);
    static final Logger TRACE_BYTES = LoggerFactory.getLogger(AmqpTransportFilter.class.getPackage().getName() + ".BYTES");
    public static final Logger TRACE_FRAMES = LoggerFactory.getLogger(AmqpTransportFilter.class.getPackage().getName() + ".FRAMES");
    private AmqpProtocolConverter protocolConverter;
    private AmqpWireFormat wireFormat;
    private AmqpInactivityMonitor monitor;
    private boolean trace;
    private final ReentrantLock lock = new ReentrantLock();

    public AmqpTransportFilter(Transport next, WireFormat wireFormat, BrokerService brokerService) {
        super(next);
        this.protocolConverter = new AmqpProtocolDiscriminator(this, brokerService);
        if (wireFormat instanceof AmqpWireFormat) {
            this.wireFormat = (AmqpWireFormat)wireFormat;
        }
    }

    @Override
    public void start() throws Exception {
        if (this.monitor != null) {
            this.monitor.setAmqpTransport(this);
            this.monitor.startConnectionTimeoutChecker(this.getConnectAttemptTimeout());
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void oneway(Object o) throws IOException {
        try {
            Command command = (Command)o;
            this.lock.lock();
            try {
                this.protocolConverter.onActiveMQCommand(command);
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Exception e) {
            throw IOExceptionSupport.create(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onException(IOException error) {
        this.lock.lock();
        try {
            this.protocolConverter.onAMQPException(error);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void sendToActiveMQ(IOException error) {
        super.onException(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCommand(Object command) {
        try {
            if (this.trace) {
                TRACE_BYTES.trace("Received: \n{}", command);
            }
            this.lock.lock();
            try {
                this.protocolConverter.onAMQPData(command);
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    @Override
    public void sendToActiveMQ(Command command) {
        assert (this.lock.isHeldByCurrentThread());
        TransportListener l = this.transportListener;
        if (l != null) {
            l.onCommand(command);
        }
    }

    @Override
    public void sendToAmqp(Object command) throws IOException {
        Transport n;
        assert (this.lock.isHeldByCurrentThread());
        if (this.trace) {
            TRACE_BYTES.trace("Sending: \n{}", command);
        }
        if ((n = this.next) != null) {
            n.oneway(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long keepAlive() {
        long nextKeepAliveDelay = 0L;
        try {
            this.lock.lock();
            try {
                nextKeepAliveDelay = this.protocolConverter.keepAlive();
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
        return nextKeepAliveDelay;
    }

    @Override
    public X509Certificate[] getPeerCertificates() {
        if (this.next instanceof SslTransport) {
            X509Certificate[] peerCerts = ((SslTransport)this.next).getPeerCertificates();
            if (this.trace && peerCerts != null) {
                LOG.debug("Peer Identity has been verified\n");
            }
            return peerCerts;
        }
        return null;
    }

    @Override
    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
        this.protocolConverter.updateTracer();
    }

    @Override
    public AmqpWireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void handleException(IOException e) {
        super.onException(e);
    }

    @Override
    public String getTransformer() {
        return this.wireFormat.getTransformer();
    }

    public void setTransformer(String transformer) {
        this.wireFormat.setTransformer(transformer);
    }

    @Override
    public AmqpProtocolConverter getProtocolConverter() {
        return this.protocolConverter;
    }

    @Override
    public void setProtocolConverter(AmqpProtocolConverter protocolConverter) {
        this.protocolConverter = protocolConverter;
    }

    public void setProducerCredit(int producerCredit) {
        this.wireFormat.setProducerCredit(producerCredit);
    }

    public int getProducerCredit() {
        return this.wireFormat.getProducerCredit();
    }

    @Override
    public void setInactivityMonitor(AmqpInactivityMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public AmqpInactivityMonitor getInactivityMonitor() {
        return this.monitor;
    }

    @Override
    public boolean isUseInactivityMonitor() {
        return this.monitor != null;
    }

    public int getConnectAttemptTimeout() {
        return this.wireFormat.getConnectAttemptTimeout();
    }

    public void setConnectAttemptTimeout(int connectAttemptTimeout) {
        this.wireFormat.setConnectAttemptTimeout(connectAttemptTimeout);
    }

    public long getMaxFrameSize() {
        return this.wireFormat.getMaxFrameSize();
    }

    public void setMaxFrameSize(long maxFrameSize) {
        this.wireFormat.setMaxFrameSize(maxFrameSize);
    }
}

