/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.message;

import javax.jms.Message;
import org.apache.activemq.transport.amqp.message.ActiveMQJMSVendor;
import org.apache.activemq.transport.amqp.message.EncodedMessage;

public abstract class OutboundTransformer {
    protected final ActiveMQJMSVendor vendor;
    protected String prefixVendor;
    protected String prefixDeliveryAnnotations = "DA_";
    protected String prefixMessageAnnotations = "MA_";
    protected String prefixFooter = "FT_";
    protected String messageFormatKey;
    protected String nativeKey;
    protected String firstAcquirerKey;
    protected String prefixDeliveryAnnotationsKey;
    protected String prefixMessageAnnotationsKey;
    protected String contentTypeKey;
    protected String contentEncodingKey;
    protected String replyToGroupIDKey;
    protected String prefixFooterKey;

    public OutboundTransformer(ActiveMQJMSVendor vendor) {
        this.vendor = vendor;
        this.setPrefixVendor("JMS_AMQP_");
    }

    public abstract EncodedMessage transform(Message var1) throws Exception;

    public String getPrefixVendor() {
        return this.prefixVendor;
    }

    public void setPrefixVendor(String prefixVendor) {
        this.prefixVendor = prefixVendor;
        this.messageFormatKey = prefixVendor + "MESSAGE_FORMAT";
        this.nativeKey = prefixVendor + "NATIVE";
        this.firstAcquirerKey = prefixVendor + "FirstAcquirer";
        this.prefixDeliveryAnnotationsKey = prefixVendor + this.prefixDeliveryAnnotations;
        this.prefixMessageAnnotationsKey = prefixVendor + this.prefixMessageAnnotations;
        this.contentTypeKey = prefixVendor + "ContentType";
        this.contentEncodingKey = prefixVendor + "ContentEncoding";
        this.replyToGroupIDKey = prefixVendor + "ReplyToGroupID";
        this.prefixFooterKey = prefixVendor + this.prefixFooter;
    }

    public ActiveMQJMSVendor getVendor() {
        return this.vendor;
    }
}

