/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public class GenericApplicationListenerAdapter
implements GenericApplicationListener,
SmartApplicationListener {
    private final ApplicationListener<ApplicationEvent> delegate;
    private final ResolvableType declaredEventType;

    public GenericApplicationListenerAdapter(ApplicationListener<?> delegate) {
        Assert.notNull(delegate, "Delegate listener must not be null");
        this.delegate = delegate;
        this.declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(this.delegate);
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        this.delegate.onApplicationEvent(event);
    }

    @Override
    public boolean supportsEventType(ResolvableType eventType) {
        if (this.delegate instanceof SmartApplicationListener) {
            Class<?> eventClass = eventType.resolve();
            return eventClass != null && ((SmartApplicationListener)this.delegate).supportsEventType(eventClass);
        }
        return this.declaredEventType == null || this.declaredEventType.isAssignableFrom(eventType);
    }

    @Override
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return this.supportsEventType(ResolvableType.forClass(eventType));
    }

    @Override
    public boolean supportsSourceType(Class<?> sourceType) {
        return !(this.delegate instanceof SmartApplicationListener) || ((SmartApplicationListener)this.delegate).supportsSourceType(sourceType);
    }

    @Override
    public int getOrder() {
        return this.delegate instanceof Ordered ? ((Ordered)((Object)this.delegate)).getOrder() : Integer.MAX_VALUE;
    }

    static ResolvableType resolveDeclaredEventType(Class<?> listenerType) {
        ResolvableType resolvableType = ResolvableType.forClass(listenerType).as(ApplicationListener.class);
        return resolvableType.hasGenerics() ? resolvableType.getGeneric(new int[0]) : null;
    }

    private static ResolvableType resolveDeclaredEventType(ApplicationListener<ApplicationEvent> listener) {
        Class targetClass;
        ResolvableType declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(listener.getClass());
        if ((declaredEventType == null || declaredEventType.isAssignableFrom(ResolvableType.forClass(ApplicationEvent.class))) && (targetClass = AopUtils.getTargetClass(listener)) != listener.getClass()) {
            declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(targetClass);
        }
        return declaredEventType;
    }
}

