/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelUnitOfWorkException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.impl.DefaultSubUnitOfWork;
import org.apache.camel.impl.DefaultTracedRouteNodes;
import org.apache.camel.impl.MessageSupport;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.SubUnitOfWork;
import org.apache.camel.spi.SubUnitOfWorkCallback;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.SynchronizationVetoable;
import org.apache.camel.spi.TracedRouteNodes;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.UnitOfWorkHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUnitOfWork
implements UnitOfWork,
Service {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUnitOfWork.class);
    private UnitOfWork parent;
    private String id;
    private CamelContext context;
    private List<Synchronization> synchronizations;
    private Message originalInMessage;
    private final TracedRouteNodes tracedRouteNodes;
    private Set<Object> transactedBy;
    private final Stack<RouteContext> routeContextStack = new Stack();
    private Stack<DefaultSubUnitOfWork> subUnitOfWorks;
    private final transient Logger log;

    public DefaultUnitOfWork(Exchange exchange) {
        this(exchange, LOG);
    }

    protected DefaultUnitOfWork(Exchange exchange, Logger logger) {
        String breadcrumbId;
        this.log = logger;
        if (this.log.isTraceEnabled()) {
            this.log.trace("UnitOfWork created for ExchangeId: {} with {}", (Object)exchange.getExchangeId(), (Object)exchange);
        }
        this.tracedRouteNodes = new DefaultTracedRouteNodes();
        this.context = exchange.getContext();
        if (this.context.isAllowUseOriginalMessage().booleanValue()) {
            if (exchange.getIn().getClass().getName().equals("org.apache.camel.component.jms.JmsMessage")) {
                this.originalInMessage = new DefaultMessage();
                this.originalInMessage.setBody(exchange.getIn().getBody());
                this.originalInMessage.getHeaders().putAll(exchange.getIn().getHeaders());
            } else {
                this.originalInMessage = exchange.getIn().copy();
            }
            if (this.originalInMessage instanceof MessageSupport) {
                ((MessageSupport)this.originalInMessage).setExchange(exchange);
            }
        }
        if (exchange.getProperty("CamelCreatedTimestamp") == null) {
            exchange.setProperty("CamelCreatedTimestamp", new Date());
        }
        if (exchange.getContext().isUseBreadcrumb().booleanValue() && (breadcrumbId = exchange.getIn().getHeader("breadcrumbId", String.class)) == null) {
            breadcrumbId = exchange.getIn().getMessageId();
            exchange.getIn().setHeader("breadcrumbId", breadcrumbId);
        }
        if (exchange.getProperty("CamelExternalRedelivered") == null) {
            exchange.setProperty("CamelExternalRedelivered", exchange.isExternalRedelivered());
        }
        try {
            EventHelper.notifyExchangeCreated(exchange.getContext(), exchange);
        }
        catch (Throwable e) {
            this.log.warn("Exception occurred during event notification. This exception will be ignored.", e);
        }
        if (exchange.getContext() != null) {
            exchange.getContext().getInflightRepository().add(exchange);
        }
    }

    UnitOfWork newInstance(Exchange exchange) {
        return new DefaultUnitOfWork(exchange);
    }

    @Override
    public void setParentUnitOfWork(UnitOfWork parentUnitOfWork) {
        this.parent = parentUnitOfWork;
    }

    @Override
    public UnitOfWork createChildUnitOfWork(Exchange childExchange) {
        UnitOfWork answer = this.newInstance(childExchange);
        answer.setParentUnitOfWork(this);
        return answer;
    }

    @Override
    public void start() throws Exception {
        this.id = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        if (this.synchronizations != null) {
            this.synchronizations.clear();
        }
        if (this.tracedRouteNodes != null) {
            this.tracedRouteNodes.clear();
        }
        if (this.transactedBy != null) {
            this.transactedBy.clear();
        }
        Stack<RouteContext> stack = this.routeContextStack;
        synchronized (stack) {
            if (!this.routeContextStack.isEmpty()) {
                this.routeContextStack.clear();
            }
        }
        if (this.subUnitOfWorks != null) {
            this.subUnitOfWorks.clear();
        }
        this.originalInMessage = null;
        this.parent = null;
        this.id = null;
    }

    @Override
    public synchronized void addSynchronization(Synchronization synchronization) {
        if (this.synchronizations == null) {
            this.synchronizations = new ArrayList<Synchronization>();
        }
        this.log.trace("Adding synchronization {}", (Object)synchronization);
        this.synchronizations.add(synchronization);
    }

    @Override
    public synchronized void removeSynchronization(Synchronization synchronization) {
        if (this.synchronizations != null) {
            this.synchronizations.remove(synchronization);
        }
    }

    @Override
    public synchronized boolean containsSynchronization(Synchronization synchronization) {
        return this.synchronizations != null && this.synchronizations.contains(synchronization);
    }

    @Override
    public void handoverSynchronization(Exchange target) {
        this.handoverSynchronization(target, null);
    }

    @Override
    public void handoverSynchronization(Exchange target, Predicate<Synchronization> filter) {
        if (this.synchronizations == null || this.synchronizations.isEmpty()) {
            return;
        }
        Iterator<Synchronization> it = this.synchronizations.iterator();
        while (it.hasNext()) {
            Synchronization synchronization = it.next();
            boolean handover = true;
            if (synchronization instanceof SynchronizationVetoable) {
                SynchronizationVetoable veto = (SynchronizationVetoable)synchronization;
                handover = veto.allowHandover();
            }
            if (handover && (filter == null || filter.test(synchronization))) {
                this.log.trace("Handover synchronization {} to: {}", (Object)synchronization, (Object)target);
                target.addOnCompletion(synchronization);
                it.remove();
                continue;
            }
            this.log.trace("Handover not allow for synchronization {}", (Object)synchronization);
        }
    }

    @Override
    public void done(Exchange exchange) {
        this.log.trace("UnitOfWork done for ExchangeId: {} with {}", (Object)exchange.getExchangeId(), (Object)exchange);
        boolean failed = exchange.isFailed();
        UnitOfWorkHelper.doneSynchronizations(exchange, this.synchronizations, this.log);
        try {
            SubUnitOfWorkCallback uowCallback = this.getSubUnitOfWorkCallback();
            if (uowCallback != null) {
                uowCallback.onDone(exchange);
            }
        }
        catch (Throwable e) {
            this.log.warn("Exception occurred during savepoint onDone. This exception will be ignored.", e);
        }
        if (exchange.getContext() != null) {
            exchange.getContext().getInflightRepository().remove(exchange);
        }
        try {
            if (failed) {
                EventHelper.notifyExchangeFailed(exchange.getContext(), exchange);
            } else {
                EventHelper.notifyExchangeDone(exchange.getContext(), exchange);
            }
        }
        catch (Throwable e) {
            this.log.warn("Exception occurred during event notification. This exception will be ignored.", e);
        }
    }

    @Override
    public void beforeRoute(Exchange exchange, Route route) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("UnitOfWork beforeRoute: {} for ExchangeId: {} with {}", route.getId(), exchange.getExchangeId(), exchange);
        }
        UnitOfWorkHelper.beforeRouteSynchronizations(route, exchange, this.synchronizations, this.log);
    }

    @Override
    public void afterRoute(Exchange exchange, Route route) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("UnitOfWork afterRoute: {} for ExchangeId: {} with {}", route.getId(), exchange.getExchangeId(), exchange);
        }
        UnitOfWorkHelper.afterRouteSynchronizations(route, exchange, this.synchronizations, this.log);
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = this.context.getUuidGenerator().generateUuid();
        }
        return this.id;
    }

    @Override
    public Message getOriginalInMessage() {
        if (this.originalInMessage == null && !this.context.isAllowUseOriginalMessage().booleanValue()) {
            throw new IllegalStateException("AllowUseOriginalMessage is disabled. Cannot access the original message.");
        }
        return this.originalInMessage;
    }

    @Override
    public TracedRouteNodes getTracedRouteNodes() {
        return this.tracedRouteNodes;
    }

    @Override
    public boolean isTransacted() {
        return this.transactedBy != null && !this.transactedBy.isEmpty();
    }

    @Override
    public boolean isTransactedBy(Object key) {
        return this.getTransactedBy().contains(key);
    }

    @Override
    public void beginTransactedBy(Object key) {
        this.getTransactedBy().add(key);
    }

    @Override
    public void endTransactedBy(Object key) {
        this.getTransactedBy().remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RouteContext getRouteContext() {
        Stack<RouteContext> stack = this.routeContextStack;
        synchronized (stack) {
            if (this.routeContextStack.isEmpty()) {
                return null;
            }
            return this.routeContextStack.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushRouteContext(RouteContext routeContext) {
        Stack<RouteContext> stack = this.routeContextStack;
        synchronized (stack) {
            this.routeContextStack.add(routeContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RouteContext popRouteContext() {
        Stack<RouteContext> stack = this.routeContextStack;
        synchronized (stack) {
            if (this.routeContextStack.isEmpty()) {
                return null;
            }
            return this.routeContextStack.pop();
        }
    }

    @Override
    public AsyncCallback beforeProcess(Processor processor, Exchange exchange, AsyncCallback callback) {
        return callback;
    }

    @Override
    public void afterProcess(Processor processor, Exchange exchange, AsyncCallback callback, boolean doneSync) {
    }

    @Override
    public void beginSubUnitOfWork(Exchange exchange) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("beginSubUnitOfWork exchangeId: {}", (Object)exchange.getExchangeId());
        }
        if (this.subUnitOfWorks == null) {
            this.subUnitOfWorks = new Stack();
        }
        this.subUnitOfWorks.push(new DefaultSubUnitOfWork());
    }

    @Override
    public void endSubUnitOfWork(Exchange exchange) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("endSubUnitOfWork exchangeId: {}", (Object)exchange.getExchangeId());
        }
        if (this.subUnitOfWorks == null || this.subUnitOfWorks.isEmpty()) {
            return;
        }
        SubUnitOfWork subUoW = this.subUnitOfWorks.pop();
        if (subUoW.isFailed()) {
            List<Exception> list = subUoW.getExceptions();
            if (list != null) {
                Exception cause = list.size() == 1 ? list.get(0) : new CamelUnitOfWorkException(exchange, list);
                exchange.setException(cause);
            }
            exchange.setProperty("CamelRollbackOnly", true);
            exchange.setProperty("CamelUnitOfWorkExhausted", true);
            exchange.setProperty("CamelErrorHandlerHandled", null);
            exchange.setProperty("CamelFailureHandled", null);
            if (this.log.isTraceEnabled()) {
                this.log.trace("endSubUnitOfWork exchangeId: {} with {} caused exceptions.", (Object)exchange.getExchangeId(), (Object)(list != null ? list.size() : 0));
            }
        }
    }

    @Override
    public SubUnitOfWorkCallback getSubUnitOfWorkCallback() {
        if (this.parent != null) {
            return this.parent.getSubUnitOfWorkCallback();
        }
        if (this.subUnitOfWorks == null || this.subUnitOfWorks.isEmpty()) {
            return null;
        }
        return this.subUnitOfWorks.peek();
    }

    private Set<Object> getTransactedBy() {
        if (this.transactedBy == null) {
            this.transactedBy = new LinkedHashSet<Object>();
        }
        return this.transactedBy;
    }

    public String toString() {
        return "DefaultUnitOfWork";
    }
}

