/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.disk.page;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.activemq.store.kahadb.disk.page.Page;
import org.apache.activemq.store.kahadb.disk.page.PageFile;
import org.apache.activemq.store.kahadb.disk.util.DataByteArrayInputStream;
import org.apache.activemq.store.kahadb.disk.util.DataByteArrayOutputStream;
import org.apache.activemq.store.kahadb.disk.util.Marshaller;
import org.apache.activemq.store.kahadb.disk.util.Sequence;
import org.apache.activemq.store.kahadb.disk.util.SequenceSet;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOHelper;

public class Transaction
implements Iterable<Page> {
    private RandomAccessFile tmpFile;
    private File txFile;
    private long nextLocation = 0L;
    private final PageFile pageFile;
    private long writeTransactionId = -1L;
    private TreeMap<Long, PageFile.PageWrite> writes = new TreeMap();
    private final SequenceSet allocateList = new SequenceSet();
    private final SequenceSet freeList = new SequenceSet();
    private long maxTransactionSize = Long.getLong("maxKahaDBTxSize", 0xA00000L);
    private long size = 0L;

    Transaction(PageFile pageFile) {
        this.pageFile = pageFile;
    }

    public PageFile getPageFile() {
        return this.pageFile;
    }

    public <T> Page<T> allocate() throws IOException {
        return this.allocate(1);
    }

    public <T> Page<T> allocate(int count) throws IOException {
        Page rc = this.pageFile.allocate(count);
        this.allocateList.add(new Sequence(rc.getPageId(), rc.getPageId() + (long)count - 1L));
        return rc;
    }

    public void free(long pageId) throws IOException {
        this.free(this.load(pageId, null));
    }

    public void free(long pageId, int count) throws IOException {
        this.free(this.load(pageId, null), count);
    }

    public <T> void free(Page<T> page, int count) throws IOException {
        this.pageFile.assertLoaded();
        long offsetPage = page.getPageId();
        while (count-- > 0) {
            if (page == null) {
                page = this.load(offsetPage, null);
            }
            this.free(page);
            page = null;
            ++offsetPage;
        }
    }

    public <T> void free(Page<T> page) throws IOException {
        this.pageFile.assertLoaded();
        while (page != null) {
            if (page.getType() == 0) {
                return;
            }
            Page<T> next = null;
            if (page.getType() == 1) {
                next = this.load(page.getNext(), null);
            }
            page.makeFree(this.getWriteTransactionId());
            this.pageFile.addToCache(page.copy());
            DataByteArrayOutputStream out = new DataByteArrayOutputStream(this.pageFile.getPageSize());
            page.write(out);
            this.write(page, out.getData());
            this.freeList.add(page.getPageId());
            page = next;
        }
    }

    public <T> void store(Page<T> page, Marshaller<T> marshaller, boolean overflow) throws IOException {
        DataByteArrayOutputStream out = (DataByteArrayOutputStream)this.openOutputStream(page, overflow);
        if (marshaller != null) {
            marshaller.writePayload(page.get(), out);
        }
        out.close();
    }

    public OutputStream openOutputStream(Page page, final boolean overflow) throws IOException {
        this.pageFile.assertLoaded();
        final Page copy = page.copy();
        this.pageFile.addToCache(copy);
        DataByteArrayOutputStream out = new DataByteArrayOutputStream(this.pageFile.getPageSize() * 2){
            Page current;
            {
                super(size2);
                this.current = copy;
            }

            @Override
            protected void onWrite() throws IOException {
                int pageSize = Transaction.this.pageFile.getPageSize();
                if (this.pos >= pageSize) {
                    if (overflow) {
                        do {
                            Page next = this.current.getType() == 1 ? Transaction.this.load(this.current.getNext(), null) : Transaction.this.allocate();
                            next.txId = this.current.txId;
                            int oldPos = this.pos;
                            this.pos = 0;
                            this.current.makePagePart(next.getPageId(), Transaction.this.getWriteTransactionId());
                            this.current.write(this);
                            byte[] data = new byte[pageSize];
                            System.arraycopy(this.buf, 0, data, 0, pageSize);
                            Transaction.this.write(this.current, data);
                            Transaction.this.pageFile.addToCache(this.current);
                            this.pos = 0;
                            this.skip(21);
                            System.arraycopy(this.buf, pageSize, this.buf, this.pos, oldPos - pageSize);
                            this.pos += oldPos - pageSize;
                            this.current = next;
                        } while (this.pos > pageSize);
                    } else {
                        throw new PageOverflowIOException("Page overflow.");
                    }
                }
            }

            @Override
            public void close() throws IOException {
                super.close();
                if (this.current.getType() == 1) {
                    Transaction.this.free(this.current.getNext());
                }
                this.current.makePageEnd(this.pos, Transaction.this.getWriteTransactionId());
                Transaction.this.pageFile.addToCache(this.current);
                this.pos = 0;
                this.current.write(this);
                Transaction.this.write(this.current, this.buf);
            }
        };
        out.skip(21);
        return out;
    }

    public <T> Page<T> load(long pageId, Marshaller<T> marshaller) throws IOException {
        this.pageFile.assertLoaded();
        Page page = new Page(pageId);
        this.load(page, marshaller);
        return page;
    }

    public <T> void load(Page<T> page, Marshaller<T> marshaller) throws IOException {
        this.pageFile.assertLoaded();
        long pageId = page.getPageId();
        if (pageId < 0L) {
            throw new InvalidPageIOException("Page id is not valid", pageId);
        }
        PageFile.PageWrite update = this.writes.get(pageId);
        if (update != null) {
            page.copy(update.getPage());
            return;
        }
        Page t = this.pageFile.getFromCache(pageId);
        if (t != null) {
            page.copy(t);
            return;
        }
        if (marshaller != null) {
            InputStream is = this.openInputStream(page);
            DataInputStream dataIn = new DataInputStream(is);
            page.set(marshaller.readPayload(dataIn));
            is.close();
        } else {
            DataByteArrayInputStream in = new DataByteArrayInputStream(new byte[21]);
            this.pageFile.readPage(pageId, in.getRawData());
            page.read(in);
            page.set(null);
        }
        if (marshaller != null) {
            this.pageFile.addToCache(page);
        }
    }

    public InputStream openInputStream(final Page p) throws IOException {
        return new InputStream(){
            private ByteSequence chunk;
            private Page page;
            private int pageCount;
            private Page markPage;
            private ByteSequence markChunk;
            {
                this.chunk = new ByteSequence(new byte[Transaction.this.pageFile.getPageSize()]);
                this.page = this.readPage(p);
                this.pageCount = 1;
            }

            private Page readPage(Page page) throws IOException {
                Transaction.this.pageFile.readPage(page.getPageId(), this.chunk.getData());
                this.chunk.setOffset(0);
                this.chunk.setLength(Transaction.this.pageFile.getPageSize());
                DataByteArrayInputStream in = new DataByteArrayInputStream(this.chunk);
                page.read(in);
                this.chunk.setOffset(21);
                if (page.getType() == 2) {
                    this.chunk.setLength((int)page.getNext());
                }
                if (page.getType() == 0) {
                    throw new EOFException("Chunk stream does not exist, page: " + page.getPageId() + " is marked free");
                }
                return page;
            }

            @Override
            public int read() throws IOException {
                if (!this.atEOF()) {
                    return this.chunk.data[this.chunk.offset++] & 0xFF;
                }
                return -1;
            }

            private boolean atEOF() throws IOException {
                if (this.chunk.offset < this.chunk.length) {
                    return false;
                }
                if (this.page.getType() == 2) {
                    return true;
                }
                this.fill();
                return this.chunk.offset >= this.chunk.length;
            }

            private void fill() throws IOException {
                this.page = this.readPage(new Page(this.page.getNext()));
                ++this.pageCount;
            }

            @Override
            public int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (!this.atEOF()) {
                    int rc;
                    for (rc = 0; !this.atEOF() && rc < len; rc += len) {
                        if ((len = Math.min(len, this.chunk.length - this.chunk.offset)) <= 0) continue;
                        System.arraycopy(this.chunk.data, this.chunk.offset, b, off, len);
                        this.chunk.offset += len;
                    }
                    return rc;
                }
                return -1;
            }

            @Override
            public long skip(long len) throws IOException {
                if (this.atEOF()) {
                    int rc = 0;
                    while (!this.atEOF() && (long)rc < len) {
                        if ((len = Math.min(len, (long)(this.chunk.length - this.chunk.offset))) > 0L) {
                            this.chunk.offset = (int)((long)this.chunk.offset + len);
                        }
                        rc = (int)((long)rc + len);
                    }
                    return rc;
                }
                return -1L;
            }

            @Override
            public int available() {
                return this.chunk.length - this.chunk.offset;
            }

            @Override
            public boolean markSupported() {
                return true;
            }

            @Override
            public void mark(int markpos) {
                this.markPage = this.page;
                byte[] data = new byte[Transaction.this.pageFile.getPageSize()];
                System.arraycopy(this.chunk.getData(), 0, data, 0, Transaction.this.pageFile.getPageSize());
                this.markChunk = new ByteSequence(data, this.chunk.getOffset(), this.chunk.getLength());
            }

            @Override
            public void reset() {
                this.page = this.markPage;
                this.chunk = this.markChunk;
            }
        };
    }

    @Override
    public Iterator<Page> iterator() {
        return this.iterator(false);
    }

    public Iterator<Page> iterator(final boolean includeFreePages) {
        this.pageFile.assertLoaded();
        return new Iterator<Page>(){
            long nextId;
            Page nextPage;
            Page lastPage;

            private void findNextPage() {
                if (!Transaction.this.pageFile.isLoaded()) {
                    throw new IllegalStateException("Cannot iterate the pages when the page file is not loaded");
                }
                if (this.nextPage != null) {
                    return;
                }
                try {
                    while (this.nextId < Transaction.this.pageFile.getPageCount()) {
                        Page page = Transaction.this.load(this.nextId, null);
                        if (includeFreePages || page.getType() != 0) {
                            this.nextPage = page;
                            return;
                        }
                        ++this.nextId;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public boolean hasNext() {
                this.findNextPage();
                return this.nextPage != null;
            }

            @Override
            public Page next() {
                this.findNextPage();
                if (this.nextPage != null) {
                    this.lastPage = this.nextPage;
                    this.nextPage = null;
                    ++this.nextId;
                    return this.lastPage;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.lastPage == null) {
                    throw new IllegalStateException();
                }
                try {
                    Transaction.this.free(this.lastPage);
                    this.lastPage = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public void commit() throws IOException {
        if (this.writeTransactionId != -1L) {
            if (this.tmpFile != null) {
                this.tmpFile.close();
                this.pageFile.removeTmpFile(this.getTempFile());
                this.tmpFile = null;
                this.txFile = null;
            }
            this.pageFile.write(this.writes.entrySet());
            this.freePages(this.freeList);
            this.freeList.clear();
            this.allocateList.clear();
            this.writes.clear();
            this.writeTransactionId = -1L;
        } else {
            this.freePages(this.allocateList);
        }
        this.size = 0L;
    }

    public void rollback() throws IOException {
        if (this.writeTransactionId != -1L) {
            if (this.tmpFile != null) {
                this.tmpFile.close();
                this.pageFile.removeTmpFile(this.getTempFile());
                this.tmpFile = null;
                this.txFile = null;
            }
            this.freePages(this.allocateList);
            this.freeList.clear();
            this.allocateList.clear();
            this.writes.clear();
            this.writeTransactionId = -1L;
        } else {
            this.freePages(this.allocateList);
        }
        this.size = 0L;
    }

    private long getWriteTransactionId() {
        if (this.writeTransactionId == -1L) {
            this.writeTransactionId = this.pageFile.getNextWriteTransactionId();
        }
        return this.writeTransactionId;
    }

    protected File getTempFile() {
        if (this.txFile == null) {
            this.txFile = new File(this.getPageFile().getDirectory(), IOHelper.toFileSystemSafeName("tx-" + Long.toString(this.getWriteTransactionId()) + "-" + Long.toString(System.currentTimeMillis()) + ".tmp"));
        }
        return this.txFile;
    }

    private void write(Page page, byte[] data) throws IOException {
        PageFile.PageWrite write2;
        Long key = page.getPageId();
        this.size = this.writes.size() * this.pageFile.getPageSize();
        if (this.size > this.maxTransactionSize) {
            if (this.tmpFile == null) {
                this.tmpFile = new RandomAccessFile(this.getTempFile(), "rw");
            }
            long location = this.nextLocation;
            this.tmpFile.seek(this.nextLocation);
            this.tmpFile.write(data);
            this.nextLocation = location + (long)data.length;
            write2 = new PageFile.PageWrite(page, location, data.length, this.getTempFile());
        } else {
            write2 = new PageFile.PageWrite(page, data);
        }
        this.writes.put(key, write2);
    }

    private void freePages(SequenceSet list) throws RuntimeException {
        for (Sequence seq = (Sequence)list.getHead(); seq != null; seq = (Sequence)seq.getNext()) {
            seq.each(new Sequence.Closure<RuntimeException>(){

                @Override
                public void execute(long value) {
                    Transaction.this.pageFile.freePage(value);
                }
            });
        }
    }

    public boolean isReadOnly() {
        return this.writeTransactionId == -1L;
    }

    public <T extends Throwable> void execute(Closure<T> closure) throws T, IOException {
        boolean success = false;
        try {
            closure.execute(this);
            success = true;
        }
        finally {
            if (success) {
                this.commit();
            } else {
                this.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, T extends Throwable> R execute(CallableClosure<R, T> closure) throws T, IOException {
        boolean success = false;
        try {
            R rc = closure.execute(this);
            success = true;
            R r = rc;
            return r;
        }
        finally {
            if (success) {
                this.commit();
            } else {
                this.rollback();
            }
        }
    }

    public static interface CallableClosure<R, T extends Throwable> {
        public R execute(Transaction var1) throws T;
    }

    public static interface Closure<T extends Throwable> {
        public void execute(Transaction var1) throws T;
    }

    public class InvalidPageIOException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private final long page;

        public InvalidPageIOException(String message, long page) {
            super(message);
            this.page = page;
        }

        public long getPage() {
            return this.page;
        }
    }

    public class PageOverflowIOException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public PageOverflowIOException(String message) {
            super(message);
        }
    }
}

