/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceHelper.class);

    private ResourceHelper() {
    }

    public static String resolveOptionalExternalScript(CamelContext camelContext, String expression) {
        if (expression == null) {
            return null;
        }
        String external = expression;
        int newLines = StringHelper.countChar(expression, '\n');
        if (newLines > 1) {
            return expression;
        }
        if (external.startsWith("resource:") && ResourceHelper.hasScheme(external = external.substring(9))) {
            InputStream is = null;
            try {
                is = ResourceHelper.resolveMandatoryResourceAsInputStream(camelContext, external);
                expression = camelContext.getTypeConverter().convertTo(String.class, is);
            }
            catch (IOException e) {
                throw new RuntimeCamelException("Cannot load resource " + external, e);
            }
            finally {
                IOHelper.close((Closeable)is);
            }
        }
        return expression;
    }

    public static boolean hasScheme(String uri) {
        if (uri == null) {
            return false;
        }
        return uri.startsWith("file:") || uri.startsWith("classpath:") || uri.startsWith("http:");
    }

    public static String getScheme(String uri) {
        if (ResourceHelper.hasScheme(uri)) {
            return uri.substring(0, uri.indexOf(":") + 1);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InputStream resolveMandatoryResourceAsInputStream(CamelContext camelContext, String uri) throws IOException {
        InputStream is;
        if (uri.startsWith("ref:")) {
            String ref = uri.substring(4);
            String value = CamelContextHelper.mandatoryLookup(camelContext, ref, String.class);
            return new ByteArrayInputStream(value.getBytes());
        }
        if (uri.startsWith("bean:")) {
            String bean = uri.substring(5);
            if (bean.contains(".")) {
                String method = StringHelper.after(bean, ".");
                bean = StringHelper.before(bean, ".") + "?method=" + method;
            }
            DefaultExchange dummy = new DefaultExchange(camelContext);
            Object out = camelContext.resolveLanguage("bean").createExpression(bean).evaluate(dummy, Object.class);
            if (dummy.getException() != null) {
                IOException io = new IOException("Cannot find resource: " + uri + " from calling the bean");
                io.initCause(dummy.getException());
                throw io;
            }
            if (out == null) throw new IOException("Cannot find resource: " + uri + " from calling the bean");
            InputStream is2 = camelContext.getTypeConverter().tryConvertTo(InputStream.class, dummy, out);
            if (is2 != null) return is2;
            String text = camelContext.getTypeConverter().tryConvertTo(String.class, dummy, out);
            if (text != null) {
                return new ByteArrayInputStream(text.getBytes());
            }
        }
        if ((is = ResourceHelper.resolveResourceAsInputStream(camelContext.getClassResolver(), uri)) != null) return is;
        String resolvedName = ResourceHelper.resolveUriPath(uri);
        throw new FileNotFoundException("Cannot find resource: " + resolvedName + " in classpath for URI: " + uri);
    }

    @Deprecated
    public static InputStream resolveMandatoryResourceAsInputStream(ClassResolver classResolver, String uri) throws IOException {
        InputStream is = ResourceHelper.resolveResourceAsInputStream(classResolver, uri);
        if (is == null) {
            String resolvedName = ResourceHelper.resolveUriPath(uri);
            throw new FileNotFoundException("Cannot find resource: " + resolvedName + " in classpath for URI: " + uri);
        }
        return is;
    }

    public static InputStream resolveResourceAsInputStream(ClassResolver classResolver, String uri) throws IOException {
        if (uri.startsWith("file:")) {
            uri = ObjectHelper.after(uri, "file:");
            uri = ResourceHelper.tryDecodeUri(uri);
            LOG.trace("Loading resource: {} from file system", (Object)uri);
            return new FileInputStream(uri);
        }
        if (uri.startsWith("http:")) {
            URL url = new URL(uri);
            LOG.trace("Loading resource: {} from HTTP", (Object)uri);
            URLConnection con = url.openConnection();
            con.setUseCaches(false);
            try {
                return con.getInputStream();
            }
            catch (IOException e) {
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
                throw e;
            }
        }
        if (uri.startsWith("classpath:")) {
            uri = ObjectHelper.after(uri, "classpath:");
            uri = ResourceHelper.tryDecodeUri(uri);
        }
        String resolvedName = ResourceHelper.resolveUriPath(uri);
        LOG.trace("Loading resource: {} from classpath", (Object)resolvedName);
        return classResolver.loadResourceAsStream(resolvedName);
    }

    public static URL resolveMandatoryResourceAsUrl(ClassResolver classResolver, String uri) throws FileNotFoundException, MalformedURLException {
        URL url = ResourceHelper.resolveResourceAsUrl(classResolver, uri);
        if (url == null) {
            String resolvedName = ResourceHelper.resolveUriPath(uri);
            throw new FileNotFoundException("Cannot find resource: " + resolvedName + " in classpath for URI: " + uri);
        }
        return url;
    }

    public static URL resolveResourceAsUrl(ClassResolver classResolver, String uri) throws MalformedURLException {
        if (uri.startsWith("file:")) {
            String name = ObjectHelper.after(uri, "file:");
            uri = ResourceHelper.tryDecodeUri(uri);
            LOG.trace("Loading resource: {} from file system", (Object)uri);
            File file = new File(name);
            if (!file.exists()) {
                return null;
            }
            return new URL(uri);
        }
        if (uri.startsWith("http:")) {
            LOG.trace("Loading resource: {} from HTTP", (Object)uri);
            return new URL(uri);
        }
        if (uri.startsWith("classpath:")) {
            uri = ObjectHelper.after(uri, "classpath:");
            uri = ResourceHelper.tryDecodeUri(uri);
        }
        String resolvedName = ResourceHelper.resolveUriPath(uri);
        LOG.trace("Loading resource: {} from classpath", (Object)resolvedName);
        return classResolver.loadResourceAsURL(resolvedName);
    }

    public static boolean isHttpUri(String uri) {
        if (uri == null) {
            return false;
        }
        return uri.startsWith("http:") || uri.startsWith("https:");
    }

    public static String appendParameters(String uri, Map<String, Object> parameters) throws URISyntaxException {
        if (!parameters.isEmpty()) {
            String query = URISupport.createQueryString(parameters);
            URI u = new URI(uri);
            u = URISupport.createURIWithQuery(u, query);
            parameters.clear();
            return u.toString();
        }
        return uri;
    }

    private static String resolveUriPath(String name) {
        return FileUtil.compactPath(name, '/');
    }

    private static String tryDecodeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (Exception e) {
            LOG.trace("Error URL decoding uri using UTF-8 encoding: {}. This exception is ignored.", (Object)uri);
        }
        return uri;
    }
}

