/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class ExceptionFailureStatistics {
    private final Map<Class<?>, AtomicLong> counters = new HashMap();
    private final AtomicLong fallbackCounter = new AtomicLong();

    public void init(List<Class<?>> exceptions) {
        if (exceptions != null) {
            for (Class<?> exception : exceptions) {
                this.counters.put(exception, new AtomicLong());
            }
        }
    }

    public Iterator<Class<?>> getExceptions() {
        return this.counters.keySet().iterator();
    }

    public long getFailureCounter(Class<?> exception) {
        AtomicLong counter = this.counters.get(exception);
        if (counter != null) {
            return counter.get();
        }
        return this.fallbackCounter.get();
    }

    public void onHandledFailure(Exception exception) {
        Class<?> clazz = exception.getClass();
        AtomicLong counter = this.counters.get(clazz);
        if (counter != null) {
            counter.incrementAndGet();
        } else {
            this.fallbackCounter.incrementAndGet();
        }
    }

    public void reset() {
        for (AtomicLong counter : this.counters.values()) {
            counter.set(0L);
        }
        this.fallbackCounter.set(0L);
    }
}

