/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent;

import org.apache.camel.Exchange;
import org.apache.camel.spi.ExchangeIdempotentRepository;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdempotentOnCompletion
implements Synchronization {
    private static final Logger LOG = LoggerFactory.getLogger(IdempotentOnCompletion.class);
    private final IdempotentRepository<String> idempotentRepository;
    private final String messageId;
    private final boolean eager;
    private final boolean removeOnFailure;

    public IdempotentOnCompletion(IdempotentRepository<String> idempotentRepository, String messageId, boolean eager, boolean removeOnFailure) {
        this.idempotentRepository = idempotentRepository;
        this.messageId = messageId;
        this.eager = eager;
        this.removeOnFailure = removeOnFailure;
    }

    @Override
    public void onComplete(Exchange exchange) {
        if (ExchangeHelper.isFailureHandled(exchange)) {
            this.onFailedMessage(exchange, this.messageId);
        } else {
            this.onCompletedMessage(exchange, this.messageId);
        }
    }

    @Override
    public void onFailure(Exchange exchange) {
        this.onFailedMessage(exchange, this.messageId);
    }

    protected void onCompletedMessage(Exchange exchange, String messageId) {
        if (!this.eager) {
            if (this.idempotentRepository instanceof ExchangeIdempotentRepository) {
                ((ExchangeIdempotentRepository)this.idempotentRepository).add(exchange, messageId);
            } else {
                this.idempotentRepository.add(messageId);
            }
        }
        if (this.idempotentRepository instanceof ExchangeIdempotentRepository) {
            ((ExchangeIdempotentRepository)this.idempotentRepository).confirm(exchange, messageId);
        } else {
            this.idempotentRepository.confirm(messageId);
        }
    }

    protected void onFailedMessage(Exchange exchange, String messageId) {
        if (this.removeOnFailure) {
            if (this.idempotentRepository instanceof ExchangeIdempotentRepository) {
                ((ExchangeIdempotentRepository)this.idempotentRepository).remove(exchange, messageId);
            } else {
                this.idempotentRepository.remove(messageId);
            }
            LOG.debug("Removed from repository as exchange failed: {} with id: {}", (Object)exchange, (Object)messageId);
        }
    }

    public String toString() {
        return "IdempotentOnCompletion[" + this.messageId + ']';
    }
}

